/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.luck.picture.lib.PictureSelectorActivity;
import com.luck.picture.lib.R;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.tools.AttrsUtils;
import java.util.List;

public class PictureSelectorWeChatStyleActivity
extends PictureSelectorActivity {
    private TextView mPictureSendView;
    private RelativeLayout rlAlbum;

    @Override
    public int getResourceId() {
        return R.layout.picture_wechat_style_selector;
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.rlAlbum = (RelativeLayout)this.findViewById(R.id.rlAlbum);
        this.mPictureSendView = (TextView)this.findViewById(R.id.picture_send);
        this.mPictureSendView.setOnClickListener((View.OnClickListener)this);
        this.mPictureSendView.setText((CharSequence)this.getString(R.string.picture_send));
        this.mTvPicturePreview.setTextSize(16.0f);
        this.mCbOriginal.setTextSize(16.0f);
        boolean isChooseMode = this.config.selectionMode == 1 && this.config.isSingleDirectReturn;
        this.mPictureSendView.setVisibility(isChooseMode ? 8 : 0);
        if (this.rlAlbum.getLayoutParams() != null && this.rlAlbum.getLayoutParams() instanceof RelativeLayout.LayoutParams) {
            RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.rlAlbum.getLayoutParams();
            if (isChooseMode) {
                lp.addRule(14);
            } else {
                lp.addRule(1, R.id.picture_left_back);
            }
        }
    }

    @Override
    public void initPictureSelectorStyle() {
        if (this.config.style != null) {
            if (this.config.style.pictureRightDefaultBackgroundStyle != 0) {
                this.mPictureSendView.setBackgroundResource(this.config.style.pictureRightDefaultBackgroundStyle);
            } else {
                this.mPictureSendView.setBackgroundResource(R.drawable.picture_send_button_default_bg);
            }
            if (this.config.style.pictureBottomBgColor != 0) {
                this.mBottomLayout.setBackgroundColor(this.config.style.pictureBottomBgColor);
            } else {
                this.mBottomLayout.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_grey));
            }
            if (this.config.style.pictureRightDefaultTextColor != 0) {
                this.mPictureSendView.setTextColor(this.config.style.pictureRightDefaultTextColor);
            } else if (this.config.style.pictureCancelTextColor != 0) {
                this.mPictureSendView.setTextColor(this.config.style.pictureCancelTextColor);
            } else {
                this.mPictureSendView.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_53575e));
            }
            if (this.config.style.pictureRightTextSize != 0) {
                this.mPictureSendView.setTextSize((float)this.config.style.pictureRightTextSize);
            }
            if (this.config.style.pictureOriginalFontColor == 0) {
                this.mCbOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.picture_color_white));
            }
            if (this.config.isOriginalControl && this.config.style.pictureOriginalControlStyle == 0) {
                this.mCbOriginal.setButtonDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.picture_original_wechat_checkbox));
            }
            if (this.config.style.pictureContainerBackgroundColor != 0) {
                this.container.setBackgroundColor(this.config.style.pictureContainerBackgroundColor);
            }
            if (this.config.style.pictureWeChatTitleBackgroundStyle != 0) {
                this.rlAlbum.setBackgroundResource(this.config.style.pictureWeChatTitleBackgroundStyle);
            } else {
                this.rlAlbum.setBackgroundResource(R.drawable.picture_album_bg);
            }
            if (!TextUtils.isEmpty((CharSequence)this.config.style.pictureRightDefaultText)) {
                this.mPictureSendView.setText((CharSequence)this.config.style.pictureRightDefaultText);
            }
        } else {
            this.mPictureSendView.setBackgroundResource(R.drawable.picture_send_button_default_bg);
            this.rlAlbum.setBackgroundResource(R.drawable.picture_album_bg);
            this.mPictureSendView.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_53575e));
            int pictureBottomBgColor = AttrsUtils.getTypeValueColor(this.getContext(), R.attr.picture_bottom_bg);
            this.mBottomLayout.setBackgroundColor(pictureBottomBgColor != 0 ? pictureBottomBgColor : ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_grey));
            this.mCbOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.picture_color_white));
            Drawable drawable2 = ContextCompat.getDrawable((Context)this, (int)R.drawable.picture_icon_wechat_down);
            this.mIvArrow.setImageDrawable(drawable2);
            if (this.config.isOriginalControl) {
                this.mCbOriginal.setButtonDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.picture_original_wechat_checkbox));
            }
        }
        super.initPictureSelectorStyle();
        this.goneParentView();
    }

    private void goneParentView() {
        this.mTvPictureRight.setVisibility(8);
        this.mTvPictureImgNum.setVisibility(8);
        this.mTvPictureOk.setVisibility(8);
    }

    @Override
    protected void changeImageNumber(List<LocalMedia> selectImages) {
        boolean enable;
        if (this.mPictureSendView == null) {
            return;
        }
        int size = selectImages.size();
        boolean bl = enable = size != 0;
        if (enable) {
            this.mPictureSendView.setEnabled(true);
            this.mPictureSendView.setSelected(true);
            this.mPictureSendView.setText((CharSequence)(this.config.selectionMode == 1 ? (this.config.style != null && !TextUtils.isEmpty((CharSequence)this.config.style.pictureRightDefaultText) ? this.config.style.pictureRightDefaultText : this.getString(R.string.picture_send)) : this.getString(R.string.picture_send_num, new Object[]{size, this.config.maxSelectNum})));
            this.mTvPicturePreview.setEnabled(true);
            this.mTvPicturePreview.setSelected(true);
            if (this.config.style != null) {
                if (this.config.style.pictureRightBackgroundStyle != 0) {
                    this.mPictureSendView.setBackgroundResource(this.config.style.pictureRightBackgroundStyle);
                } else {
                    this.mPictureSendView.setBackgroundResource(R.drawable.picture_send_button_bg);
                }
                if (this.config.style.pictureRightSelectedTextColor != 0) {
                    this.mPictureSendView.setTextColor(this.config.style.pictureRightSelectedTextColor);
                } else {
                    this.mPictureSendView.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_white));
                }
                if (this.config.style.picturePreviewTextColor != 0) {
                    this.mTvPicturePreview.setTextColor(this.config.style.picturePreviewTextColor);
                } else {
                    this.mTvPicturePreview.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_white));
                }
                if (!TextUtils.isEmpty((CharSequence)this.config.style.picturePreviewText)) {
                    this.mTvPicturePreview.setText((CharSequence)this.config.style.picturePreviewText);
                } else {
                    this.mTvPicturePreview.setText((CharSequence)this.getString(R.string.picture_preview_num, new Object[]{size}));
                }
            } else {
                this.mPictureSendView.setBackgroundResource(R.drawable.picture_send_button_bg);
                this.mPictureSendView.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_white));
                this.mTvPicturePreview.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_white));
                this.mTvPicturePreview.setText((CharSequence)this.getString(R.string.picture_preview_num, new Object[]{size}));
            }
        } else {
            this.mPictureSendView.setEnabled(false);
            this.mPictureSendView.setSelected(false);
            this.mTvPicturePreview.setEnabled(false);
            this.mTvPicturePreview.setSelected(false);
            if (this.config.style != null) {
                if (this.config.style.pictureRightDefaultBackgroundStyle != 0) {
                    this.mPictureSendView.setBackgroundResource(this.config.style.pictureRightDefaultBackgroundStyle);
                } else {
                    this.mPictureSendView.setBackgroundResource(R.drawable.picture_send_button_default_bg);
                }
                if (this.config.style.pictureRightDefaultTextColor != 0) {
                    this.mPictureSendView.setTextColor(this.config.style.pictureRightDefaultTextColor);
                } else {
                    this.mPictureSendView.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_53575e));
                }
                if (this.config.style.pictureUnPreviewTextColor != 0) {
                    this.mTvPicturePreview.setTextColor(this.config.style.pictureUnPreviewTextColor);
                } else {
                    this.mTvPicturePreview.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_9b));
                }
                if (!TextUtils.isEmpty((CharSequence)this.config.style.pictureRightDefaultText)) {
                    this.mPictureSendView.setText((CharSequence)this.config.style.pictureRightDefaultText);
                } else {
                    this.mPictureSendView.setText((CharSequence)this.getString(R.string.picture_send));
                }
                if (!TextUtils.isEmpty((CharSequence)this.config.style.pictureUnPreviewText)) {
                    this.mTvPicturePreview.setText((CharSequence)this.config.style.pictureUnPreviewText);
                } else {
                    this.mTvPicturePreview.setText((CharSequence)this.getString(R.string.picture_preview));
                }
            } else {
                this.mPictureSendView.setBackgroundResource(R.drawable.picture_send_button_default_bg);
                this.mPictureSendView.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_53575e));
                this.mTvPicturePreview.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_9b));
                this.mTvPicturePreview.setText((CharSequence)this.getString(R.string.picture_preview));
                this.mPictureSendView.setText((CharSequence)this.getString(R.string.picture_send));
            }
        }
    }

    @Override
    public void onClick(View v) {
        super.onClick(v);
        int id2 = v.getId();
        if (id2 == R.id.picture_send) {
            if (this.folderWindow != null && this.folderWindow.isShowing()) {
                this.folderWindow.dismiss();
            } else {
                this.mTvPictureOk.performClick();
            }
        }
    }
}

