/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.PorterDuff;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.anim.OptAnimationLoader;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.tools.AnimUtils;
import com.luck.picture.lib.tools.DateUtils;
import com.luck.picture.lib.tools.MediaUtils;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.tools.StringUtils;
import com.luck.picture.lib.tools.ToastUtils;
import com.luck.picture.lib.tools.VoiceUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PictureImageGridAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private Context context;
    private boolean showCamera;
    private OnPhotoSelectChangedListener imageSelectChangedListener;
    private int maxSelectNum;
    private List<LocalMedia> images = new ArrayList<LocalMedia>();
    private List<LocalMedia> selectImages = new ArrayList<LocalMedia>();
    private boolean enablePreview;
    private int selectMode;
    private boolean enablePreviewVideo;
    private boolean enablePreviewAudio;
    private boolean is_checked_num;
    private boolean enableVoice;
    private Animation animation;
    private PictureSelectionConfig config;
    private int chooseMode;
    private boolean zoomAnim;
    private boolean isSingleDirectReturn;
    private boolean isGo;

    public PictureImageGridAdapter(Context context, PictureSelectionConfig config) {
        this.context = context;
        this.config = config;
        this.selectMode = config.selectionMode;
        this.showCamera = config.isCamera;
        this.maxSelectNum = config.maxSelectNum;
        this.enablePreview = config.enablePreview;
        this.enablePreviewVideo = config.enPreviewVideo;
        this.enablePreviewAudio = config.enablePreviewAudio;
        this.is_checked_num = config.checkNumMode;
        this.enableVoice = config.openClickSound;
        this.chooseMode = config.chooseMode;
        this.zoomAnim = config.zoomAnim;
        this.isSingleDirectReturn = config.isSingleDirectReturn;
        this.animation = OptAnimationLoader.loadAnimation(context, R.anim.picture_anim_modal_in);
    }

    public void setShowCamera(boolean showCamera) {
        this.showCamera = showCamera;
    }

    public void bindImagesData(List<LocalMedia> images) {
        this.images = images;
        this.notifyDataSetChanged();
    }

    public void bindSelectImages(List<LocalMedia> images) {
        ArrayList<LocalMedia> selection = new ArrayList<LocalMedia>();
        for (LocalMedia media : images) {
            selection.add(media);
        }
        this.selectImages = selection;
        if (!this.config.isSingleDirectReturn) {
            this.subSelectPosition();
            if (this.imageSelectChangedListener != null) {
                this.imageSelectChangedListener.onChange(this.selectImages);
            }
        }
    }

    public List<LocalMedia> getSelectedImages() {
        return this.selectImages == null ? new ArrayList() : this.selectImages;
    }

    public List<LocalMedia> getImages() {
        return this.images == null ? new ArrayList() : this.images;
    }

    public int getItemViewType(int position) {
        if (this.showCamera && position == 0) {
            return 1;
        }
        return 2;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 1) {
            View view = LayoutInflater.from((Context)this.context).inflate(R.layout.picture_item_camera, parent, false);
            return new HeaderViewHolder(view);
        }
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.picture_image_grid_item, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (this.getItemViewType(position) == 1) {
            HeaderViewHolder headerHolder = (HeaderViewHolder)holder;
            headerHolder.headerView.setOnClickListener(v -> {
                if (this.imageSelectChangedListener != null) {
                    this.imageSelectChangedListener.onTakePhoto();
                }
            });
        } else {
            ViewHolder contentHolder = (ViewHolder)holder;
            LocalMedia image = this.images.get(this.showCamera ? position - 1 : position);
            image.position = contentHolder.getAdapterPosition();
            String path = image.getPath();
            String mimeType = image.getMimeType();
            if (this.is_checked_num) {
                this.notifyCheckChanged(contentHolder, image);
            }
            this.selectImage(contentHolder, this.isSelected(image), false);
            boolean gif = PictureMimeType.isGif(mimeType);
            contentHolder.tvCheck.setVisibility(this.isSingleDirectReturn ? 8 : 0);
            contentHolder.btnCheck.setVisibility(this.isSingleDirectReturn ? 8 : 0);
            contentHolder.tvIsGif.setVisibility(gif ? 0 : 8);
            boolean eqImage = PictureMimeType.eqImage(image.getMimeType());
            if (eqImage) {
                boolean eqLongImg = MediaUtils.isLongImg(image);
                contentHolder.tvLongChart.setVisibility(eqLongImg ? 0 : 8);
            } else {
                contentHolder.tvLongChart.setVisibility(8);
            }
            contentHolder.tvDuration.setText((CharSequence)DateUtils.formatDurationTime(image.getDuration()));
            if (this.chooseMode == PictureMimeType.ofAudio()) {
                contentHolder.tvDuration.setVisibility(0);
                if (Build.VERSION.SDK_INT >= 17) {
                    contentHolder.tvDuration.setCompoundDrawablesRelativeWithIntrinsicBounds(R.drawable.picture_icon_audio, 0, 0, 0);
                }
                contentHolder.ivPicture.setImageResource(R.drawable.picture_audio_placeholder);
            } else {
                if (Build.VERSION.SDK_INT >= 17) {
                    contentHolder.tvDuration.setCompoundDrawablesRelativeWithIntrinsicBounds(R.drawable.picture_icon_video, 0, 0, 0);
                }
                contentHolder.tvDuration.setVisibility(PictureMimeType.eqVideo(mimeType) ? 0 : 8);
                if (this.config != null && this.config.imageEngine != null) {
                    this.config.imageEngine.loadGridImage(this.context, path, contentHolder.ivPicture);
                }
            }
            if (this.enablePreview || this.enablePreviewVideo || this.enablePreviewAudio) {
                contentHolder.btnCheck.setOnClickListener(v -> {
                    String newPath;
                    String string2 = newPath = SdkVersionUtils.checkedAndroid_Q() ? PictureFileUtils.getPath(this.context, Uri.parse((String)path)) : path;
                    if (!new File(newPath).exists()) {
                        ToastUtils.s(this.context, PictureMimeType.s(this.context, mimeType));
                        return;
                    }
                    this.changeCheckboxState(contentHolder, image);
                });
            }
            contentHolder.contentView.setOnClickListener(v -> {
                boolean eqResult;
                int index;
                String newPath;
                String string2 = newPath = SdkVersionUtils.checkedAndroid_Q() ? PictureFileUtils.getPath(this.context, Uri.parse((String)path)) : path;
                if (!new File(newPath).exists()) {
                    ToastUtils.s(this.context, PictureMimeType.s(this.context, mimeType));
                    return;
                }
                int n = index = this.showCamera ? position - 1 : position;
                if (index == -1) {
                    return;
                }
                boolean bl = eqResult = PictureMimeType.eqImage(mimeType) && this.enablePreview || PictureMimeType.eqVideo(mimeType) && (this.enablePreviewVideo || this.selectMode == 1) || PictureMimeType.eqAudio(mimeType) && (this.enablePreviewAudio || this.selectMode == 1);
                if (eqResult) {
                    this.imageSelectChangedListener.onPictureClick(image, index);
                } else {
                    this.changeCheckboxState(contentHolder, image);
                }
            });
        }
    }

    public int getItemCount() {
        return this.showCamera ? this.images.size() + 1 : this.images.size();
    }

    public boolean isSelected(LocalMedia image) {
        int size = this.selectImages.size();
        for (int i = 0; i < size; ++i) {
            LocalMedia media = this.selectImages.get(i);
            if (media == null || TextUtils.isEmpty((CharSequence)media.getPath()) || !media.getPath().equals(image.getPath())) continue;
            return true;
        }
        return false;
    }

    private void notifyCheckChanged(ViewHolder viewHolder, LocalMedia imageBean) {
        viewHolder.tvCheck.setText((CharSequence)"");
        int size = this.selectImages.size();
        for (int i = 0; i < size; ++i) {
            LocalMedia media = this.selectImages.get(i);
            if (!media.getPath().equals(imageBean.getPath())) continue;
            imageBean.setNum(media.getNum());
            media.setPosition(imageBean.getPosition());
            viewHolder.tvCheck.setText((CharSequence)String.valueOf(imageBean.getNum()));
        }
    }

    @SuppressLint(value={"StringFormatMatches"})
    private void changeCheckboxState(ViewHolder contentHolder, LocalMedia image) {
        boolean mimeTypeSame;
        String mimeType;
        boolean isChecked = contentHolder.tvCheck.isSelected();
        int size = this.selectImages.size();
        String string2 = mimeType = size > 0 ? this.selectImages.get(0).getMimeType() : "";
        if (!TextUtils.isEmpty((CharSequence)mimeType) && !(mimeTypeSame = PictureMimeType.isMimeTypeSame(mimeType, image.getMimeType()))) {
            ToastUtils.s(this.context, this.context.getString(R.string.picture_rule));
            return;
        }
        if (size >= this.maxSelectNum && !isChecked) {
            ToastUtils.s(this.context, StringUtils.getToastMsg(this.context, mimeType, this.config.maxSelectNum));
            return;
        }
        if (isChecked) {
            for (int i = 0; i < size; ++i) {
                LocalMedia media = this.selectImages.get(i);
                if (media == null || TextUtils.isEmpty((CharSequence)media.getPath()) || !media.getPath().equals(image.getPath())) continue;
                this.selectImages.remove(media);
                this.subSelectPosition();
                AnimUtils.disZoom((View)contentHolder.ivPicture, this.zoomAnim);
                break;
            }
        } else {
            if (this.selectMode == 1) {
                this.singleRadioMediaImage();
            }
            this.selectImages.add(image);
            image.setNum(this.selectImages.size());
            VoiceUtils.playVoice(this.context, this.enableVoice);
            AnimUtils.zoom((View)contentHolder.ivPicture, this.zoomAnim);
        }
        this.notifyItemChanged(contentHolder.getAdapterPosition());
        this.selectImage(contentHolder, !isChecked, true);
        if (this.imageSelectChangedListener != null) {
            this.imageSelectChangedListener.onChange(this.selectImages);
        }
    }

    private void singleRadioMediaImage() {
        if (this.selectImages != null && this.selectImages.size() > 0) {
            this.isGo = true;
            LocalMedia media = this.selectImages.get(0);
            this.notifyItemChanged(this.config.isCamera ? media.position : (this.isGo ? media.position : (media.position > 0 ? media.position - 1 : 0)));
            this.selectImages.clear();
        }
    }

    private void subSelectPosition() {
        if (this.is_checked_num) {
            int size = this.selectImages.size();
            int length = size;
            for (int index = 0; index < length; ++index) {
                LocalMedia media = this.selectImages.get(index);
                media.setNum(index + 1);
                this.notifyItemChanged(media.position);
            }
        }
    }

    public void selectImage(ViewHolder holder, boolean isChecked, boolean isAnim) {
        holder.tvCheck.setSelected(isChecked);
        if (isChecked) {
            if (isAnim && this.animation != null) {
                holder.tvCheck.startAnimation(this.animation);
            }
            holder.ivPicture.setColorFilter(ContextCompat.getColor((Context)this.context, (int)R.color.picture_color_80), PorterDuff.Mode.SRC_ATOP);
        } else {
            holder.ivPicture.setColorFilter(ContextCompat.getColor((Context)this.context, (int)R.color.picture_color_20), PorterDuff.Mode.SRC_ATOP);
        }
    }

    public void setOnPhotoSelectChangedListener(OnPhotoSelectChangedListener imageSelectChangedListener) {
        this.imageSelectChangedListener = imageSelectChangedListener;
    }

    public static interface OnPhotoSelectChangedListener {
        public void onTakePhoto();

        public void onChange(List<LocalMedia> var1);

        public void onPictureClick(LocalMedia var1, int var2);
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        ImageView ivPicture;
        TextView tvCheck;
        TextView tvDuration;
        TextView tvIsGif;
        TextView tvLongChart;
        View contentView;
        View btnCheck;

        public ViewHolder(View itemView) {
            super(itemView);
            this.contentView = itemView;
            this.ivPicture = (ImageView)itemView.findViewById(R.id.ivPicture);
            this.tvCheck = (TextView)itemView.findViewById(R.id.tvCheck);
            this.btnCheck = itemView.findViewById(R.id.btnCheck);
            this.tvDuration = (TextView)itemView.findViewById(R.id.tv_duration);
            this.tvIsGif = (TextView)itemView.findViewById(R.id.tv_isGif);
            this.tvLongChart = (TextView)itemView.findViewById(R.id.tv_long_chart);
            if (((PictureImageGridAdapter)PictureImageGridAdapter.this).config.style != null && ((PictureImageGridAdapter)PictureImageGridAdapter.this).config.style.pictureCheckedStyle != 0) {
                this.tvCheck.setBackgroundResource(((PictureImageGridAdapter)PictureImageGridAdapter.this).config.style.pictureCheckedStyle);
            }
        }
    }

    public class HeaderViewHolder
    extends RecyclerView.ViewHolder {
        View headerView;
        TextView tvCamera;

        public HeaderViewHolder(View itemView) {
            super(itemView);
            this.headerView = itemView;
            this.tvCamera = (TextView)itemView.findViewById(R.id.tvCamera);
            String title = PictureImageGridAdapter.this.chooseMode == PictureMimeType.ofAudio() ? PictureImageGridAdapter.this.context.getString(R.string.picture_tape) : PictureImageGridAdapter.this.context.getString(R.string.picture_take_picture);
            this.tvCamera.setText((CharSequence)title);
        }
    }
}

