/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import com.luck.picture.lib.PictureSelector;
import com.luck.picture.lib.R;
import com.luck.picture.lib.broadcast.BroadcastManager;
import com.luck.picture.lib.compress.Luban;
import com.luck.picture.lib.compress.OnCompressListener;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.dialog.PictureLoadingDialog;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.immersive.ImmersiveManage;
import com.luck.picture.lib.immersive.NavBarUtils;
import com.luck.picture.lib.language.LocaleTransform;
import com.luck.picture.lib.language.PictureLanguageUtils;
import com.luck.picture.lib.permissions.PermissionChecker;
import com.luck.picture.lib.tools.AndroidQTransformUtils;
import com.luck.picture.lib.tools.AttrsUtils;
import com.luck.picture.lib.tools.DateUtils;
import com.luck.picture.lib.tools.MediaUtils;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.tools.ToastUtils;
import com.yalantis.ucrop.UCrop;
import com.yalantis.ucrop.UCropMulti;
import com.yalantis.ucrop.model.CutInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class PictureBaseActivity
extends AppCompatActivity
implements Handler.Callback {
    private static final int MSG_CHOOSE_RESULT_SUCCESS = 200;
    private static final int MSG_ASY_COMPRESSION_RESULT_SUCCESS = 300;
    protected PictureSelectionConfig config;
    protected boolean openWhiteStatusBar;
    protected boolean numComplete;
    protected int colorPrimary;
    protected int colorPrimaryDark;
    protected String cameraPath;
    protected String originalPath;
    protected PictureLoadingDialog dialog;
    protected PictureLoadingDialog compressDialog;
    protected List<LocalMedia> selectionMedias;
    protected Handler mHandler;
    protected View container;

    public boolean isImmersive() {
        return true;
    }

    public boolean isRequestedOrientation() {
        return true;
    }

    public void immersive() {
        ImmersiveManage.immersiveAboveAPI23(this, this.colorPrimaryDark, this.colorPrimary, this.openWhiteStatusBar);
    }

    public abstract int getResourceId();

    protected void initWidgets() {
    }

    protected void initPictureSelectorStyle() {
    }

    protected void onCreate(Bundle savedInstanceState) {
        int layoutResID;
        if (savedInstanceState != null) {
            this.config = (PictureSelectionConfig)savedInstanceState.getParcelable("PictureSelectorConfig");
            this.cameraPath = savedInstanceState.getString("CameraPath");
            this.originalPath = savedInstanceState.getString("OriginalPath");
        } else {
            this.config = PictureSelectionConfig.getInstance();
        }
        this.setTheme(this.config.themeStyleId);
        super.onCreate(savedInstanceState);
        if (this.isRequestedOrientation()) {
            this.setNewRequestedOrientation();
        }
        this.mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
        this.initConfig();
        if (this.isImmersive()) {
            this.immersive();
        }
        if (this.config.style != null && this.config.style.pictureNavBarColor != 0) {
            NavBarUtils.setNavBarColor((Activity)this, this.config.style.pictureNavBarColor);
        }
        if ((layoutResID = this.getResourceId()) != 0) {
            this.setContentView(layoutResID);
        }
        this.initWidgets();
        this.initPictureSelectorStyle();
    }

    protected void setNewRequestedOrientation() {
        if (this.config != null) {
            this.setRequestedOrientation(this.config.requestedOrientation);
        }
    }

    protected Context getContext() {
        return this;
    }

    private void initConfig() {
        if (this.config.language >= 0) {
            PictureLanguageUtils.applyLanguage((Activity)this, LocaleTransform.getLanguage(this.config.language));
        } else {
            PictureLanguageUtils.setDefaultLanguage((Context)this);
        }
        List<Object> list = this.selectionMedias = this.config.selectionMedias == null ? new ArrayList() : this.config.selectionMedias;
        if (this.config.style != null) {
            this.openWhiteStatusBar = this.config.style.isChangeStatusBarFontColor;
            if (this.config.style.pictureTitleBarBackgroundColor != 0) {
                this.colorPrimary = this.config.style.pictureTitleBarBackgroundColor;
            }
            if (this.config.style.pictureStatusBarColor != 0) {
                this.colorPrimaryDark = this.config.style.pictureStatusBarColor;
            }
            this.numComplete = this.config.style.isOpenCompletedNumStyle;
            this.config.checkNumMode = this.config.style.isOpenCheckNumStyle;
        } else {
            this.openWhiteStatusBar = this.config.isChangeStatusBarFontColor;
            if (!this.openWhiteStatusBar) {
                this.openWhiteStatusBar = AttrsUtils.getTypeValueBoolean((Context)this, R.attr.picture_statusFontColor);
            }
            this.numComplete = this.config.isOpenStyleNumComplete;
            if (!this.numComplete) {
                this.numComplete = AttrsUtils.getTypeValueBoolean((Context)this, R.attr.picture_style_numComplete);
            }
            this.config.checkNumMode = this.config.isOpenStyleCheckNumMode;
            if (!this.config.checkNumMode) {
                this.config.checkNumMode = AttrsUtils.getTypeValueBoolean((Context)this, R.attr.picture_style_checkNumMode);
            }
            this.colorPrimary = this.config.titleBarBackgroundColor != 0 ? this.config.titleBarBackgroundColor : AttrsUtils.getTypeValueColor((Context)this, R.attr.colorPrimary);
            this.colorPrimaryDark = this.config.pictureStatusBarColor != 0 ? this.config.pictureStatusBarColor : AttrsUtils.getTypeValueColor((Context)this, R.attr.colorPrimaryDark);
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString("CameraPath", this.cameraPath);
        outState.putString("OriginalPath", this.originalPath);
        outState.putParcelable("PictureSelectorConfig", (Parcelable)this.config);
    }

    protected void showPleaseDialog() {
        if (!this.isFinishing()) {
            this.dismissDialog();
            this.dialog = new PictureLoadingDialog(this.getContext());
            this.dialog.show();
        }
    }

    protected void dismissDialog() {
        try {
            if (this.dialog != null && this.dialog.isShowing()) {
                this.dialog.dismiss();
                this.dialog = null;
            }
        }
        catch (Exception e) {
            this.dialog = null;
            e.printStackTrace();
        }
    }

    protected void showCompressDialog() {
        if (!this.isFinishing()) {
            this.dismissCompressDialog();
            this.compressDialog = new PictureLoadingDialog((Context)this);
            this.compressDialog.show();
        }
    }

    protected void dismissCompressDialog() {
        try {
            if (!this.isFinishing() && this.compressDialog != null && this.compressDialog.isShowing()) {
                this.compressDialog.dismiss();
                this.compressDialog = null;
            }
        }
        catch (Exception e) {
            this.compressDialog = null;
            e.printStackTrace();
        }
    }

    protected void compressImage(final List<LocalMedia> result) {
        this.showCompressDialog();
        if (this.config.synOrAsy) {
            AsyncTask.SERIAL_EXECUTOR.execute(() -> {
                try {
                    List<File> files = Luban.with(this.getContext()).loadMediaData(result).setTargetDir(this.config.compressSavePath).setCompressQuality(this.config.compressQuality).setFocusAlpha(this.config.focusAlpha).setRenameListener(filePath -> this.config.renameCompressFileName).ignoreBy(this.config.minimumCompressSize).get();
                    this.mHandler.sendMessage(this.mHandler.obtainMessage(300, (Object)new Object[]{result, files}));
                }
                catch (Exception e) {
                    BroadcastManager.getInstance(this.getApplicationContext()).action("com.luck.picture.lib.action.close.preview").broadcast();
                    this.onResult(result);
                    e.printStackTrace();
                }
            });
        } else {
            Luban.with((Context)this).loadMediaData(result).ignoreBy(this.config.minimumCompressSize).setCompressQuality(this.config.compressQuality).setTargetDir(this.config.compressSavePath).setFocusAlpha(this.config.focusAlpha).setRenameListener(filePath -> this.config.renameCompressFileName).setCompressListener(new OnCompressListener(){

                @Override
                public void onStart() {
                }

                @Override
                public void onSuccess(List<LocalMedia> list) {
                    BroadcastManager.getInstance(PictureBaseActivity.this.getApplicationContext()).action("com.luck.picture.lib.action.close.preview").broadcast();
                    PictureBaseActivity.this.onResult(list);
                }

                @Override
                public void onError(Throwable e) {
                    BroadcastManager.getInstance(PictureBaseActivity.this.getApplicationContext()).action("com.luck.picture.lib.action.close.preview").broadcast();
                    PictureBaseActivity.this.onResult(result);
                }
            }).launch();
        }
    }

    private void handleCompressCallBack(List<LocalMedia> images, List<File> files) {
        if (images == null || files == null) {
            this.closeActivity();
            return;
        }
        boolean isAndroidQ = SdkVersionUtils.checkedAndroid_Q();
        int size = images.size();
        if (files.size() == size) {
            int j = size;
            for (int i = 0; i < j; ++i) {
                File file = files.get(i);
                String path = file.getPath();
                LocalMedia image = images.get(i);
                boolean http = PictureMimeType.isHttp(path);
                boolean flag = !TextUtils.isEmpty((CharSequence)path) && http;
                image.setCompressed(!flag);
                image.setCompressPath(flag ? "" : path);
                if (!isAndroidQ) continue;
                image.setAndroidQToPath(path);
            }
        }
        BroadcastManager.getInstance(this.getApplicationContext()).action("com.luck.picture.lib.action.close.preview").broadcast();
        this.onResult(images);
    }

    protected void startCrop(String originalPath) {
        boolean isChangeStatusBarFontColor;
        UCrop.Options options = new UCrop.Options();
        int toolbarColor = 0;
        int statusColor = 0;
        int titleColor = 0;
        if (this.config.cropStyle != null) {
            if (this.config.cropStyle.cropTitleBarBackgroundColor != 0) {
                toolbarColor = this.config.cropStyle.cropTitleBarBackgroundColor;
            }
            if (this.config.cropStyle.cropStatusBarColorPrimaryDark != 0) {
                statusColor = this.config.cropStyle.cropStatusBarColorPrimaryDark;
            }
            if (this.config.cropStyle.cropTitleColor != 0) {
                titleColor = this.config.cropStyle.cropTitleColor;
            }
            isChangeStatusBarFontColor = this.config.cropStyle.isChangeStatusBarFontColor;
        } else {
            toolbarColor = this.config.cropTitleBarBackgroundColor != 0 ? this.config.cropTitleBarBackgroundColor : AttrsUtils.getTypeValueColor((Context)this, R.attr.picture_crop_toolbar_bg);
            statusColor = this.config.cropStatusBarColorPrimaryDark != 0 ? this.config.cropStatusBarColorPrimaryDark : AttrsUtils.getTypeValueColor((Context)this, R.attr.picture_crop_status_color);
            titleColor = this.config.cropTitleColor != 0 ? this.config.cropTitleColor : AttrsUtils.getTypeValueColor((Context)this, R.attr.picture_crop_title_color);
            isChangeStatusBarFontColor = this.config.isChangeStatusBarFontColor;
            if (!isChangeStatusBarFontColor) {
                isChangeStatusBarFontColor = AttrsUtils.getTypeValueBoolean((Context)this, R.attr.picture_statusFontColor);
            }
        }
        options.isOpenWhiteStatusBar(isChangeStatusBarFontColor);
        options.setToolbarColor(toolbarColor);
        options.setStatusBarColor(statusColor);
        options.setToolbarWidgetColor(titleColor);
        options.setCircleDimmedLayer(this.config.circleDimmedLayer);
        options.setShowCropFrame(this.config.showCropFrame);
        options.setShowCropGrid(this.config.showCropGrid);
        options.setDragFrameEnabled(this.config.isDragFrame);
        options.setScaleEnabled(this.config.scaleEnabled);
        options.setRotateEnabled(this.config.rotateEnabled);
        options.setCompressionQuality(this.config.cropCompressQuality);
        options.setHideBottomControls(this.config.hideBottomControls);
        options.setFreeStyleCropEnabled(this.config.freeStyleCropEnabled);
        options.setCropExitAnimation(this.config.windowAnimationStyle != null ? this.config.windowAnimationStyle.activityCropExitAnimation : 0);
        options.setNavBarColor(this.config.cropStyle != null ? this.config.cropStyle.cropNavBarColor : 0);
        boolean isHttp = PictureMimeType.isHttp(originalPath);
        boolean isAndroidQ = SdkVersionUtils.checkedAndroid_Q();
        String imgType = isAndroidQ ? PictureMimeType.getLastImgSuffix(PictureMimeType.getMimeType(this.getContext(), Uri.parse((String)originalPath))) : PictureMimeType.getLastImgType(originalPath);
        Uri uri = isHttp || isAndroidQ ? Uri.parse((String)originalPath) : Uri.fromFile((File)new File(originalPath));
        File file = new File(PictureFileUtils.getDiskCacheDir((Context)this), TextUtils.isEmpty((CharSequence)this.config.renameCropFileName) ? DateUtils.getCreateFileName("IMG_") + imgType : this.config.renameCropFileName);
        UCrop.of((Uri)uri, (Uri)Uri.fromFile((File)file)).withAspectRatio((float)this.config.aspect_ratio_x, (float)this.config.aspect_ratio_y).withMaxResultSize(this.config.cropWidth, this.config.cropHeight).withOptions(options).startAnimation((Activity)this, this.config.windowAnimationStyle != null ? this.config.windowAnimationStyle.activityCropEnterAnimation : 0);
    }

    protected void startCrop(ArrayList<CutInfo> list) {
        boolean isChangeStatusBarFontColor;
        if (list == null || list.size() == 0) {
            ToastUtils.s((Context)this, this.getString(R.string.picture_not_crop_data));
            return;
        }
        UCropMulti.Options options = new UCropMulti.Options();
        int toolbarColor = 0;
        int statusColor = 0;
        int titleColor = 0;
        if (this.config.cropStyle != null) {
            if (this.config.cropStyle.cropTitleBarBackgroundColor != 0) {
                toolbarColor = this.config.cropStyle.cropTitleBarBackgroundColor;
            }
            if (this.config.cropStyle.cropStatusBarColorPrimaryDark != 0) {
                statusColor = this.config.cropStyle.cropStatusBarColorPrimaryDark;
            }
            if (this.config.cropStyle.cropTitleColor != 0) {
                titleColor = this.config.cropStyle.cropTitleColor;
            }
            isChangeStatusBarFontColor = this.config.cropStyle.isChangeStatusBarFontColor;
        } else {
            toolbarColor = this.config.cropTitleBarBackgroundColor != 0 ? this.config.cropTitleBarBackgroundColor : AttrsUtils.getTypeValueColor((Context)this, R.attr.picture_crop_toolbar_bg);
            statusColor = this.config.cropStatusBarColorPrimaryDark != 0 ? this.config.cropStatusBarColorPrimaryDark : AttrsUtils.getTypeValueColor((Context)this, R.attr.picture_crop_status_color);
            titleColor = this.config.cropTitleColor != 0 ? this.config.cropTitleColor : AttrsUtils.getTypeValueColor((Context)this, R.attr.picture_crop_title_color);
            isChangeStatusBarFontColor = this.config.isChangeStatusBarFontColor;
            if (!isChangeStatusBarFontColor) {
                isChangeStatusBarFontColor = AttrsUtils.getTypeValueBoolean((Context)this, R.attr.picture_statusFontColor);
            }
        }
        options.isOpenWhiteStatusBar(isChangeStatusBarFontColor);
        options.setToolbarColor(toolbarColor);
        options.setStatusBarColor(statusColor);
        options.setToolbarWidgetColor(titleColor);
        options.setCircleDimmedLayer(this.config.circleDimmedLayer);
        options.setShowCropFrame(this.config.showCropFrame);
        options.setDragFrameEnabled(this.config.isDragFrame);
        options.setShowCropGrid(this.config.showCropGrid);
        options.setScaleEnabled(this.config.scaleEnabled);
        options.setRotateEnabled(this.config.rotateEnabled);
        options.setHideBottomControls(this.config.hideBottomControls);
        options.setCompressionQuality(this.config.cropCompressQuality);
        options.setCutListData(list);
        options.setFreeStyleCropEnabled(this.config.freeStyleCropEnabled);
        options.setCropExitAnimation(this.config.windowAnimationStyle != null ? this.config.windowAnimationStyle.activityCropExitAnimation : 0);
        options.setNavBarColor(this.config.cropStyle != null ? this.config.cropStyle.cropNavBarColor : 0);
        String path = list.size() > 0 ? list.get(0).getPath() : "";
        boolean isAndroidQ = SdkVersionUtils.checkedAndroid_Q();
        boolean isHttp = PictureMimeType.isHttp(path);
        String imgType = isAndroidQ ? PictureMimeType.getLastImgSuffix(PictureMimeType.getMimeType(this.getContext(), Uri.parse((String)path))) : PictureMimeType.getLastImgType(path);
        Uri uri = isHttp || isAndroidQ ? Uri.parse((String)path) : Uri.fromFile((File)new File(path));
        File file = new File(PictureFileUtils.getDiskCacheDir((Context)this), TextUtils.isEmpty((CharSequence)this.config.renameCropFileName) ? DateUtils.getCreateFileName("IMG_") + imgType : this.config.renameCropFileName);
        UCropMulti.of((Uri)uri, (Uri)Uri.fromFile((File)file)).withAspectRatio((float)this.config.aspect_ratio_x, (float)this.config.aspect_ratio_y).withMaxResultSize(this.config.cropWidth, this.config.cropHeight).withOptions(options).startAnimation((Activity)this, this.config.windowAnimationStyle != null ? this.config.windowAnimationStyle.activityCropEnterAnimation : 0);
    }

    protected void handlerResult(List<LocalMedia> result) {
        if (this.config.isCompress && !this.config.isCheckOriginalImage) {
            this.compressImage(result);
        } else {
            this.onResult(result);
        }
    }

    protected void createNewFolder(List<LocalMediaFolder> folders) {
        if (folders.size() == 0) {
            LocalMediaFolder newFolder = new LocalMediaFolder();
            String folderName = this.config.chooseMode == PictureMimeType.ofAudio() ? this.getString(R.string.picture_all_audio) : this.getString(R.string.picture_camera_roll);
            newFolder.setName(folderName);
            newFolder.setFirstImagePath("");
            folders.add(newFolder);
        }
    }

    protected LocalMediaFolder getImageFolder(String path, List<LocalMediaFolder> imageFolders) {
        File imageFile = new File(path);
        File folderFile = imageFile.getParentFile();
        for (LocalMediaFolder folder : imageFolders) {
            if (!folder.getName().equals(folderFile.getName())) continue;
            return folder;
        }
        LocalMediaFolder newFolder = new LocalMediaFolder();
        newFolder.setName(folderFile.getName());
        newFolder.setFirstImagePath(path);
        imageFolders.add(newFolder);
        return newFolder;
    }

    protected void onResult(List<LocalMedia> images) {
        boolean isAndroidQ = SdkVersionUtils.checkedAndroid_Q();
        boolean isVideo = PictureMimeType.eqVideo(images != null && images.size() > 0 ? images.get(0).getMimeType() : "");
        if (isAndroidQ && !isVideo) {
            this.showCompressDialog();
        }
        if (isAndroidQ && this.config.isAndroidQTransform) {
            this.onResultToAndroidAsy(images);
        } else {
            this.dismissCompressDialog();
            if (this.config.camera && this.config.selectionMode == 2 && this.selectionMedias != null) {
                images.addAll(images.size() > 0 ? images.size() - 1 : 0, this.selectionMedias);
            }
            if (this.config.isCheckOriginalImage) {
                int size = images.size();
                for (int i = 0; i < size; ++i) {
                    LocalMedia media = images.get(i);
                    media.setOriginal(true);
                    media.setOriginalPath(media.getPath());
                }
            }
            Intent intent = PictureSelector.putIntentResult(images);
            this.setResult(-1, intent);
            this.closeActivity();
        }
    }

    private void onResultToAndroidAsy(List<LocalMedia> images) {
        AsyncTask.SERIAL_EXECUTOR.execute(() -> {
            int size = images.size();
            for (int i = 0; i < size; ++i) {
                boolean isCopyAndroidQToPath;
                LocalMedia media = (LocalMedia)images.get(i);
                if (media == null || TextUtils.isEmpty((CharSequence)media.getPath())) continue;
                boolean bl = isCopyAndroidQToPath = !media.isCut() && !media.isCompressed() && TextUtils.isEmpty((CharSequence)media.getAndroidQToPath());
                if (isCopyAndroidQToPath) {
                    media.setAndroidQToPath(this.getPathToAndroidQ(media));
                    if (!this.config.isCheckOriginalImage) continue;
                    media.setOriginal(true);
                    media.setOriginalPath(media.getAndroidQToPath());
                    continue;
                }
                if (media.isCut() && media.isCompressed()) {
                    media.setAndroidQToPath(media.getCompressPath());
                    continue;
                }
                if (!this.config.isCheckOriginalImage) continue;
                media.setOriginal(true);
                media.setOriginalPath(media.getAndroidQToPath());
            }
            this.mHandler.sendMessage(this.mHandler.obtainMessage(200, (Object)images));
        });
    }

    private String getPathToAndroidQ(LocalMedia media) {
        if (PictureMimeType.eqVideo(media.getMimeType())) {
            return AndroidQTransformUtils.parseVideoPathToAndroidQ(this.getApplicationContext(), media.getPath(), this.config.cameraFileName, media.getMimeType());
        }
        if (PictureMimeType.eqAudio(media.getMimeType())) {
            return AndroidQTransformUtils.parseAudioPathToAndroidQ(this.getApplicationContext(), media.getPath(), this.config.cameraFileName, media.getMimeType());
        }
        return AndroidQTransformUtils.parseImagePathToAndroidQ(this.getApplicationContext(), media.getPath(), this.config.cameraFileName, media.getMimeType());
    }

    protected void closeActivity() {
        this.finish();
        if (this.config.camera) {
            this.overridePendingTransition(0, R.anim.picture_anim_fade_out);
        } else {
            this.overridePendingTransition(0, this.config.windowAnimationStyle != null && this.config.windowAnimationStyle.activityExitAnimation != 0 ? this.config.windowAnimationStyle.activityExitAnimation : R.anim.picture_anim_exit);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.dismissCompressDialog();
        this.dismissDialog();
    }

    @Deprecated
    protected void removeImage(int id, boolean eqVideo) {
        try {
            ContentResolver cr = this.getContentResolver();
            Uri uri = eqVideo ? MediaStore.Video.Media.EXTERNAL_CONTENT_URI : MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            String selection = eqVideo ? "_id=?" : "_id=?";
            cr.delete(uri, selection, new String[]{Long.toString(id)});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String getAudioPath(Intent data) {
        boolean compare_SDK_19;
        boolean bl = compare_SDK_19 = Build.VERSION.SDK_INT <= 19;
        if (data != null && this.config.chooseMode == PictureMimeType.ofAudio()) {
            try {
                Uri uri = data.getData();
                String audioPath = compare_SDK_19 ? uri.getPath() : this.getAudioFilePathFromUri(uri);
                return audioPath;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    protected String getAudioFilePathFromUri(Uri uri) {
        String path = "";
        try {
            Cursor cursor = this.getContentResolver().query(uri, null, null, null, null);
            cursor.moveToFirst();
            int index = cursor.getColumnIndex("_data");
            path = cursor.getString(index);
            cursor.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return path;
    }

    protected void startOpenCamera() {
        Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (cameraIntent.resolveActivity(this.getPackageManager()) != null) {
            Uri imageUri;
            if (SdkVersionUtils.checkedAndroid_Q()) {
                imageUri = MediaUtils.createImageUri(this.getApplicationContext());
                if (imageUri != null) {
                    this.cameraPath = imageUri.toString();
                }
            } else {
                int chooseMode = this.config.chooseMode == 0 ? 1 : this.config.chooseMode;
                File cameraFile = PictureFileUtils.createCameraFile(this.getApplicationContext(), chooseMode, this.config.cameraFileName, this.config.suffixType);
                this.cameraPath = cameraFile.getAbsolutePath();
                imageUri = PictureFileUtils.parUri((Context)this, cameraFile);
            }
            cameraIntent.putExtra("output", (Parcelable)imageUri);
            this.startActivityForResult(cameraIntent, 909);
        }
    }

    protected void startOpenCameraVideo() {
        Intent cameraIntent = new Intent("android.media.action.VIDEO_CAPTURE");
        if (cameraIntent.resolveActivity(this.getPackageManager()) != null) {
            Uri imageUri;
            if (SdkVersionUtils.checkedAndroid_Q()) {
                imageUri = MediaUtils.createVideoUri(this.getApplicationContext());
                if (imageUri != null) {
                    this.cameraPath = imageUri.toString();
                }
            } else {
                int chooseMode = this.config.chooseMode == 0 ? 2 : this.config.chooseMode;
                File cameraFile = PictureFileUtils.createCameraFile(this.getApplicationContext(), chooseMode, this.config.cameraFileName, this.config.suffixType);
                this.cameraPath = cameraFile.getAbsolutePath();
                imageUri = PictureFileUtils.parUri((Context)this, cameraFile);
            }
            cameraIntent.putExtra("output", (Parcelable)imageUri);
            cameraIntent.putExtra("android.intent.extra.durationLimit", this.config.recordVideoSecond);
            cameraIntent.putExtra("android.intent.extra.videoQuality", this.config.videoQuality);
            this.startActivityForResult(cameraIntent, 909);
        }
    }

    public void startOpenCameraAudio() {
        if (PermissionChecker.checkSelfPermission((Context)this, "android.permission.RECORD_AUDIO")) {
            Intent cameraIntent = new Intent("android.provider.MediaStore.RECORD_SOUND");
            if (cameraIntent.resolveActivity(this.getPackageManager()) != null) {
                this.startActivityForResult(cameraIntent, 909);
            }
        } else {
            PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.RECORD_AUDIO"}, 3);
        }
    }

    protected void multiCropHandleResult(Intent data) {
        ArrayList<LocalMedia> medias = new ArrayList<LocalMedia>();
        List mCuts = UCropMulti.getOutput((Intent)data);
        int size = mCuts.size();
        boolean isAndroidQ = SdkVersionUtils.checkedAndroid_Q();
        for (int i = 0; i < size; ++i) {
            CutInfo c = (CutInfo)mCuts.get(i);
            LocalMedia media = new LocalMedia();
            media.setCut(!TextUtils.isEmpty((CharSequence)c.getCutPath()));
            media.setPath(c.getPath());
            media.setCutPath(c.getCutPath());
            media.setMimeType(c.getMimeType());
            media.setWidth(c.getImageWidth());
            media.setHeight(c.getImageHeight());
            media.setSize(new File(TextUtils.isEmpty((CharSequence)c.getCutPath()) ? c.getPath() : c.getCutPath()).length());
            media.setChooseModel(this.config.chooseMode);
            if (isAndroidQ) {
                media.setAndroidQToPath(c.getCutPath());
            }
            medias.add(media);
        }
        this.handlerResult(medias);
    }

    public boolean handleMessage(@NonNull Message msg) {
        switch (msg.what) {
            case 200: {
                List images = (List)msg.obj;
                this.dismissCompressDialog();
                if (images == null) break;
                if (this.config.camera && this.config.selectionMode == 2 && this.selectionMedias != null) {
                    images.addAll(images.size() > 0 ? images.size() - 1 : 0, this.selectionMedias);
                }
                Intent intent = PictureSelector.putIntentResult(images);
                this.setResult(-1, intent);
                this.closeActivity();
                break;
            }
            case 300: {
                Object[] objects;
                if (msg.obj == null || !(msg.obj instanceof Object[]) || (objects = (Object[])msg.obj).length <= 0) break;
                List result = (List)objects[0];
                List files = (List)objects[1];
                this.handleCompressCallBack(result, files);
            }
        }
        return false;
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 3: {
                if (grantResults[0] == 0) {
                    Intent cameraIntent = new Intent("android.provider.MediaStore.RECORD_SOUND");
                    if (cameraIntent.resolveActivity(this.getPackageManager()) == null) break;
                    this.startActivityForResult(cameraIntent, 909);
                    break;
                }
                ToastUtils.s(this.getContext(), this.getString(R.string.picture_audio));
            }
        }
    }
}

