/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.model;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.provider.MediaStore;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.tools.MediaUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class LocalMediaLoader
implements Handler.Callback {
    private static final int MSG_QUERY_MEDIA_SUCCESS = 0;
    private static final Uri QUERY_URI = MediaStore.Files.getContentUri((String)"external");
    private static final String ORDER_BY = "_id DESC";
    private static final String NOT_GIF = "!='image/gif'";
    private static final int AUDIO_DURATION = 500;
    private Context mContext;
    private boolean isAndroidQ;
    private PictureSelectionConfig config;
    private Handler mHandler;
    private static final long FILE_SIZE_UNIT = 0x100000L;
    private static final String[] PROJECTION = new String[]{"_id", "_data", "mime_type", "width", "height", "duration", "_size", "bucket_display_name"};
    private static final String SELECTION = "media_type=? AND _size>0";
    private static final String SELECTION_NOT_GIF = "media_type=? AND _size>0 AND mime_type!='image/gif'";
    private static final String SELECTION_SPECIFIED_FORMAT = "media_type=? AND _size>0 AND mime_type";
    private static final String[] SELECTION_ALL_ARGS = new String[]{String.valueOf(1), String.valueOf(3)};
    private LocalMediaLoadListener mCompleteListener;

    private static String getSelectionArgsForSingleMediaCondition(String time_condition) {
        return "media_type=? AND _size>0 AND " + time_condition;
    }

    private static String getSelectionArgsForSingleMediaCondition() {
        return SELECTION;
    }

    private static String getSelectionArgsForAllMediaCondition(String time_condition, boolean isGif) {
        String condition = "(media_type=?" + (isGif ? "" : " AND mime_type!='image/gif'") + " OR " + "media_type=? AND " + time_condition + ") AND " + "_size" + ">0";
        return condition;
    }

    private static String[] getSelectionArgsForSingleMediaType(int mediaType) {
        return new String[]{String.valueOf(mediaType)};
    }

    public LocalMediaLoader(Context context, PictureSelectionConfig config) {
        this.mContext = context.getApplicationContext();
        this.isAndroidQ = SdkVersionUtils.checkedAndroid_Q();
        this.config = config;
        this.mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
    }

    public void loadAllMedia() {
        AsyncTask.SERIAL_EXECUTOR.execute(() -> {
            Cursor data = this.mContext.getContentResolver().query(QUERY_URI, PROJECTION, this.getSelection(), this.getSelectionArgs(), ORDER_BY);
            try {
                if (data != null) {
                    ArrayList<LocalMediaFolder> imageFolders = new ArrayList<LocalMediaFolder>();
                    LocalMediaFolder allImageFolder = new LocalMediaFolder();
                    ArrayList<LocalMedia> latelyImages = new ArrayList<LocalMedia>();
                    int count = data.getCount();
                    if (count > 0) {
                        data.moveToFirst();
                        do {
                            long id2 = data.getLong(data.getColumnIndexOrThrow(PROJECTION[0]));
                            String path = this.isAndroidQ ? this.getRealPathAndroid_Q(id2) : data.getString(data.getColumnIndexOrThrow(PROJECTION[1]));
                            String mimeType = data.getString(data.getColumnIndexOrThrow(PROJECTION[2]));
                            int width = data.getInt(data.getColumnIndexOrThrow(PROJECTION[3]));
                            int height = data.getInt(data.getColumnIndexOrThrow(PROJECTION[4]));
                            long duration = data.getLong(data.getColumnIndexOrThrow(PROJECTION[5]));
                            long size = data.getLong(data.getColumnIndexOrThrow(PROJECTION[6]));
                            String folderName = data.getString(data.getColumnIndexOrThrow(PROJECTION[7]));
                            if (this.config.filterFileSize > 0 && size > (long)this.config.filterFileSize * 0x100000L) continue;
                            if (PictureMimeType.eqVideo(mimeType)) {
                                if (duration == 0L) {
                                    duration = MediaUtils.extractDuration(this.mContext, this.isAndroidQ, path);
                                }
                                if (width == 0 && height == 0) {
                                    int[] newSize = this.isAndroidQ ? MediaUtils.getLocalVideoSizeToAndroidQ(this.mContext, path) : MediaUtils.getLocalVideoSize(path);
                                    width = newSize[0];
                                    height = newSize[1];
                                }
                                if (this.config.videoMinSecond > 0 && duration < (long)this.config.videoMinSecond || this.config.videoMaxSecond > 0 && duration > (long)this.config.videoMaxSecond || duration == 0L || size <= 0L) continue;
                            }
                            LocalMedia image = new LocalMedia(path, duration, this.config.chooseMode, mimeType, width, height, size);
                            LocalMediaFolder folder = this.getImageFolder(path, folderName, imageFolders);
                            List<LocalMedia> images = folder.getImages();
                            images.add(image);
                            folder.setImageNum(folder.getImageNum() + 1);
                            latelyImages.add(image);
                            int imageNum = allImageFolder.getImageNum();
                            allImageFolder.setImageNum(imageNum + 1);
                        } while (data.moveToNext());
                        if (latelyImages.size() > 0) {
                            this.sortFolder(imageFolders);
                            imageFolders.add(0, allImageFolder);
                            allImageFolder.setFirstImagePath(((LocalMedia)latelyImages.get(0)).getPath());
                            String title = this.config.chooseMode == PictureMimeType.ofAudio() ? this.mContext.getString(R.string.picture_all_audio) : this.mContext.getString(R.string.picture_camera_roll);
                            allImageFolder.setName(title);
                            allImageFolder.setOfAllType(this.config.chooseMode);
                            allImageFolder.setCameraFolder(true);
                            allImageFolder.setImages(latelyImages);
                        }
                    }
                    this.mHandler.sendMessage(this.mHandler.obtainMessage(0, imageFolders));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private String getSelection() {
        switch (this.config.chooseMode) {
            case 0: {
                return LocalMediaLoader.getSelectionArgsForAllMediaCondition(this.getDurationCondition(0L, 0L), this.config.isGif);
            }
            case 1: {
                if (!TextUtils.isEmpty((CharSequence)this.config.specifiedFormat)) {
                    return "media_type=? AND _size>0 AND mime_type='" + this.config.specifiedFormat + "'";
                }
                return this.config.isGif ? SELECTION : SELECTION_NOT_GIF;
            }
            case 2: {
                if (!TextUtils.isEmpty((CharSequence)this.config.specifiedFormat)) {
                    return "media_type=? AND _size>0 AND mime_type='" + this.config.specifiedFormat + "'";
                }
                return LocalMediaLoader.getSelectionArgsForSingleMediaCondition();
            }
            case 3: {
                if (!TextUtils.isEmpty((CharSequence)this.config.specifiedFormat)) {
                    return "media_type=? AND _size>0 AND mime_type='" + this.config.specifiedFormat + "'";
                }
                return LocalMediaLoader.getSelectionArgsForSingleMediaCondition(this.getDurationCondition(0L, 500L));
            }
        }
        return null;
    }

    private String[] getSelectionArgs() {
        switch (this.config.chooseMode) {
            case 0: {
                return SELECTION_ALL_ARGS;
            }
            case 1: {
                String[] MEDIA_TYPE_IMAGE = LocalMediaLoader.getSelectionArgsForSingleMediaType(1);
                return MEDIA_TYPE_IMAGE;
            }
            case 2: {
                return LocalMediaLoader.getSelectionArgsForSingleMediaType(3);
            }
            case 3: {
                String[] MEDIA_TYPE_AUDIO = LocalMediaLoader.getSelectionArgsForSingleMediaType(2);
                return MEDIA_TYPE_AUDIO;
            }
        }
        return null;
    }

    private void sortFolder(List<LocalMediaFolder> imageFolders) {
        Collections.sort(imageFolders, (lhs, rhs) -> {
            int rsize;
            if (lhs.getImages() == null || rhs.getImages() == null) {
                return 0;
            }
            int lsize = lhs.getImageNum();
            return lsize == (rsize = rhs.getImageNum()) ? 0 : (lsize < rsize ? 1 : -1);
        });
    }

    private String getRealPathAndroid_Q(long id2) {
        return QUERY_URI.buildUpon().appendPath(String.valueOf(id2)).build().toString();
    }

    private LocalMediaFolder getImageFolder(String path, String folderName, List<LocalMediaFolder> imageFolders) {
        if (!this.config.isFallbackVersion) {
            for (LocalMediaFolder folder : imageFolders) {
                String name = folder.getName();
                if (TextUtils.isEmpty((CharSequence)name) || !name.equals(folderName)) continue;
                return folder;
            }
            LocalMediaFolder newFolder = new LocalMediaFolder();
            newFolder.setName(folderName);
            newFolder.setFirstImagePath(path);
            imageFolders.add(newFolder);
            return newFolder;
        }
        File imageFile = new File(path);
        File folderFile = imageFile.getParentFile();
        for (LocalMediaFolder folder : imageFolders) {
            String name = folder.getName();
            if (TextUtils.isEmpty((CharSequence)name) || !name.equals(folderFile.getName())) continue;
            return folder;
        }
        LocalMediaFolder newFolder = new LocalMediaFolder();
        newFolder.setName(folderFile.getName());
        newFolder.setFirstImagePath(path);
        imageFolders.add(newFolder);
        return newFolder;
    }

    private String getDurationCondition(long exMaxLimit, long exMinLimit) {
        long maxS;
        long l = maxS = this.config.videoMaxSecond == 0 ? Long.MAX_VALUE : (long)this.config.videoMaxSecond;
        if (exMaxLimit != 0L) {
            maxS = Math.min(maxS, exMaxLimit);
        }
        return String.format(Locale.CHINA, "%d <%s duration and duration <= %d", Math.max(exMinLimit, (long)this.config.videoMinSecond), Math.max(exMinLimit, (long)this.config.videoMinSecond) == 0L ? "" : "=", maxS);
    }

    public boolean handleMessage(@NonNull Message msg) {
        if (this.mCompleteListener == null) {
            return false;
        }
        switch (msg.what) {
            case 0: {
                this.mCompleteListener.loadComplete((List)msg.obj);
            }
        }
        return false;
    }

    public void setCompleteListener(LocalMediaLoadListener mCompleteListener) {
        this.mCompleteListener = mCompleteListener;
    }

    public static interface LocalMediaLoadListener {
        public void loadComplete(List<LocalMediaFolder> var1);
    }
}

