/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SimpleItemAnimator;
import com.luck.picture.lib.PictureBaseActivity;
import com.luck.picture.lib.PictureSelector;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.PictureAlbumDirectoryAdapter;
import com.luck.picture.lib.adapter.PictureImageGridAdapter;
import com.luck.picture.lib.broadcast.BroadcastManager;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.decoration.GridSpacingItemDecoration;
import com.luck.picture.lib.dialog.PictureCustomDialog;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.model.LocalMediaLoader;
import com.luck.picture.lib.observable.ImagesObservable;
import com.luck.picture.lib.permissions.PermissionChecker;
import com.luck.picture.lib.tools.AttrsUtils;
import com.luck.picture.lib.tools.DateUtils;
import com.luck.picture.lib.tools.DoubleUtils;
import com.luck.picture.lib.tools.JumpUtils;
import com.luck.picture.lib.tools.MediaUtils;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.ScreenUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.tools.StringUtils;
import com.luck.picture.lib.tools.ToastUtils;
import com.luck.picture.lib.widget.FolderPopWindow;
import com.luck.picture.lib.widget.PhotoPopupWindow;
import com.yalantis.ucrop.UCrop;
import com.yalantis.ucrop.model.CutInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PictureSelectorActivity
extends PictureBaseActivity
implements View.OnClickListener,
PictureAlbumDirectoryAdapter.OnItemClickListener,
PictureImageGridAdapter.OnPhotoSelectChangedListener,
PhotoPopupWindow.OnItemClickListener {
    protected static final int SHOW_DIALOG = 0;
    protected static final int DISMISS_DIALOG = 1;
    protected ImageView mIvPictureLeftBack;
    protected ImageView mIvArrow;
    protected View titleViewBg;
    protected TextView mTvPictureTitle;
    protected TextView mTvPictureRight;
    protected TextView mTvPictureOk;
    protected TextView mTvEmpty;
    protected TextView mTvPictureImgNum;
    protected TextView mTvPicturePreview;
    protected TextView mTvPlayPause;
    protected TextView mTvStop;
    protected TextView mTvQuit;
    protected TextView mTvMusicStatus;
    protected TextView mTvMusicTotal;
    protected TextView mTvMusicTime;
    protected RecyclerView mPictureRecycler;
    protected RelativeLayout mBottomLayout;
    protected PictureImageGridAdapter adapter;
    protected List<LocalMedia> images = new ArrayList<LocalMedia>();
    protected List<LocalMediaFolder> foldersList = new ArrayList<LocalMediaFolder>();
    protected FolderPopWindow folderWindow;
    protected Animation animation = null;
    protected boolean anim = false;
    protected PhotoPopupWindow popupWindow;
    protected LocalMediaLoader mediaLoader;
    protected MediaPlayer mediaPlayer;
    protected SeekBar musicSeekBar;
    protected boolean isPlayAudio = false;
    protected PictureCustomDialog audioDialog;
    protected CheckBox mCbOriginal;
    protected int audioH;
    protected boolean isFirstEnterActivity = false;
    @SuppressLint(value={"HandlerLeak"})
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 0: {
                    PictureSelectorActivity.this.showPleaseDialog();
                    break;
                }
                case 1: {
                    PictureSelectorActivity.this.dismissDialog();
                    break;
                }
            }
        }
    };
    public Handler handler = new Handler();
    public Runnable runnable = new Runnable(){

        @Override
        public void run() {
            try {
                if (PictureSelectorActivity.this.mediaPlayer != null) {
                    PictureSelectorActivity.this.mTvMusicTime.setText((CharSequence)DateUtils.formatDurationTime(PictureSelectorActivity.this.mediaPlayer.getCurrentPosition()));
                    PictureSelectorActivity.this.musicSeekBar.setProgress(PictureSelectorActivity.this.mediaPlayer.getCurrentPosition());
                    PictureSelectorActivity.this.musicSeekBar.setMax(PictureSelectorActivity.this.mediaPlayer.getDuration());
                    PictureSelectorActivity.this.mTvMusicTotal.setText((CharSequence)DateUtils.formatDurationTime(PictureSelectorActivity.this.mediaPlayer.getDuration()));
                    if (PictureSelectorActivity.this.handler != null) {
                        PictureSelectorActivity.this.handler.postDelayed(PictureSelectorActivity.this.runnable, 200L);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private BroadcastReceiver commonBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action;
            switch (action = intent.getAction()) {
                case "com.luck.picture.lib.action.selected.data": {
                    Bundle extras = intent.getExtras();
                    if (extras == null) break;
                    ArrayList selectImages = extras.getParcelableArrayList("selectImages");
                    int position = extras.getInt("position");
                    PictureSelectorActivity.this.anim = true;
                    PictureSelectorActivity.this.adapter.bindSelectImages(selectImages);
                    PictureSelectorActivity.this.adapter.notifyItemChanged(position);
                    break;
                }
                case "com.luck.picture.lib.action.preview.compression": {
                    ArrayList selectImages;
                    Bundle extras = intent.getExtras();
                    if (extras == null || (selectImages = extras.getParcelableArrayList("selectImages")).size() <= 0) break;
                    String mimeType = ((LocalMedia)selectImages.get(0)).getMimeType();
                    if (PictureSelectorActivity.this.config.isCompress && PictureMimeType.eqImage(mimeType) && !PictureSelectorActivity.this.config.isCheckOriginalImage) {
                        PictureSelectorActivity.this.compressImage(selectImages);
                        break;
                    }
                    PictureSelectorActivity.this.onResult(selectImages);
                    break;
                }
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        BroadcastManager.getInstance((Context)this).registerReceiver(this.commonBroadcastReceiver, "com.luck.picture.lib.action.selected.data", "com.luck.picture.lib.action.preview.compression");
    }

    protected void onRestoreInstanceState(@NonNull Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        if (savedInstanceState != null) {
            this.selectionMedias = PictureSelector.obtainSelectorList(savedInstanceState);
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.mCbOriginal != null && this.config != null) {
            this.mCbOriginal.setChecked(this.config.isCheckOriginalImage);
        }
    }

    @Override
    public int getResourceId() {
        return R.layout.picture_selector;
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.container = this.findViewById(R.id.container);
        this.titleViewBg = this.findViewById(R.id.titleViewBg);
        this.mIvPictureLeftBack = (ImageView)this.findViewById(R.id.picture_left_back);
        this.mTvPictureTitle = (TextView)this.findViewById(R.id.picture_title);
        this.mTvPictureRight = (TextView)this.findViewById(R.id.picture_right);
        this.mTvPictureOk = (TextView)this.findViewById(R.id.picture_tv_ok);
        this.mCbOriginal = (CheckBox)this.findViewById(R.id.cb_original);
        this.mIvArrow = (ImageView)this.findViewById(R.id.ivArrow);
        this.mTvPicturePreview = (TextView)this.findViewById(R.id.picture_id_preview);
        this.mTvPictureImgNum = (TextView)this.findViewById(R.id.picture_tv_img_num);
        this.mPictureRecycler = (RecyclerView)this.findViewById(R.id.picture_recycler);
        this.mBottomLayout = (RelativeLayout)this.findViewById(R.id.rl_bottom);
        this.mTvEmpty = (TextView)this.findViewById(R.id.tv_empty);
        this.isNumComplete(this.numComplete);
        if (this.config.chooseMode == PictureMimeType.ofAll()) {
            this.popupWindow = new PhotoPopupWindow((Context)this);
            this.popupWindow.setOnItemClickListener(this);
        }
        this.mTvPicturePreview.setOnClickListener((View.OnClickListener)this);
        if (this.config.chooseMode == PictureMimeType.ofAudio()) {
            this.mTvPicturePreview.setVisibility(8);
            this.audioH = ScreenUtils.getScreenHeight(this.getContext()) + ScreenUtils.getStatusBarHeight(this.getContext());
        } else {
            this.mTvPicturePreview.setVisibility(this.config.chooseMode == PictureMimeType.ofVideo() ? 8 : 0);
        }
        this.mBottomLayout.setVisibility(this.config.selectionMode == 1 && this.config.isSingleDirectReturn ? 8 : 0);
        this.mIvPictureLeftBack.setOnClickListener((View.OnClickListener)this);
        this.mTvPictureRight.setOnClickListener((View.OnClickListener)this);
        this.mTvPictureOk.setOnClickListener((View.OnClickListener)this);
        this.mTvPictureImgNum.setOnClickListener((View.OnClickListener)this);
        this.mTvPictureTitle.setOnClickListener((View.OnClickListener)this);
        String title = this.config.chooseMode == PictureMimeType.ofAudio() ? this.getString(R.string.picture_all_audio) : this.getString(R.string.picture_camera_roll);
        this.mTvPictureTitle.setText((CharSequence)title);
        this.folderWindow = new FolderPopWindow((Context)this, this.config);
        this.folderWindow.setArrowImageView(this.mIvArrow);
        this.folderWindow.setOnItemClickListener(this);
        this.mPictureRecycler.setHasFixedSize(true);
        this.mPictureRecycler.addItemDecoration((RecyclerView.ItemDecoration)new GridSpacingItemDecoration(this.config.imageSpanCount, ScreenUtils.dip2px((Context)this, 2.0f), false));
        this.mPictureRecycler.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.getContext(), this.config.imageSpanCount));
        ((SimpleItemAnimator)this.mPictureRecycler.getItemAnimator()).setSupportsChangeAnimations(false);
        if (this.config.isFallbackVersion2) {
            this.loadAllMediaData();
        }
        this.mTvEmpty.setText((CharSequence)(this.config.chooseMode == PictureMimeType.ofAudio() ? this.getString(R.string.picture_audio_empty) : this.getString(R.string.picture_empty)));
        StringUtils.tempTextFont(this.mTvEmpty, this.config.chooseMode);
        this.adapter = new PictureImageGridAdapter(this.getContext(), this.config);
        this.adapter.setOnPhotoSelectChangedListener(this);
        this.adapter.bindSelectImages(this.selectionMedias);
        this.mPictureRecycler.setAdapter((RecyclerView.Adapter)this.adapter);
        this.mCbOriginal.setVisibility(this.config.isOriginalControl ? 0 : 8);
        this.mCbOriginal.setOnCheckedChangeListener((buttonView, isChecked) -> {
            this.config.isCheckOriginalImage = isChecked;
        });
    }

    public void onEnterAnimationComplete() {
        super.onEnterAnimationComplete();
        if (!this.config.isFallbackVersion2 && !this.isFirstEnterActivity) {
            this.loadAllMediaData();
            this.isFirstEnterActivity = true;
        }
    }

    private void loadAllMediaData() {
        if (PermissionChecker.checkSelfPermission((Context)this, "android.permission.READ_EXTERNAL_STORAGE") && PermissionChecker.checkSelfPermission((Context)this, "android.permission.WRITE_EXTERNAL_STORAGE")) {
            this.mHandler.sendEmptyMessage(0);
            this.readLocalMedia();
        } else {
            PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"}, 1);
        }
    }

    @Override
    public void initPictureSelectorStyle() {
        if (this.config.style != null) {
            if (this.config.style.pictureTitleDownResId != 0) {
                Drawable drawable2 = ContextCompat.getDrawable((Context)this, (int)this.config.style.pictureTitleDownResId);
                this.mIvArrow.setImageDrawable(drawable2);
            }
            if (this.config.style.pictureTitleTextColor != 0) {
                this.mTvPictureTitle.setTextColor(this.config.style.pictureTitleTextColor);
            }
            if (this.config.style.pictureRightDefaultTextColor != 0) {
                this.mTvPictureRight.setTextColor(this.config.style.pictureRightDefaultTextColor);
            } else if (this.config.style.pictureCancelTextColor != 0) {
                this.mTvPictureRight.setTextColor(this.config.style.pictureCancelTextColor);
            }
            if (this.config.style.pictureLeftBackIcon != 0) {
                this.mIvPictureLeftBack.setImageResource(this.config.style.pictureLeftBackIcon);
            }
            if (this.config.style.pictureUnPreviewTextColor != 0) {
                this.mTvPicturePreview.setTextColor(this.config.style.pictureUnPreviewTextColor);
            }
            if (this.config.style.pictureCheckNumBgStyle != 0) {
                this.mTvPictureImgNum.setBackgroundResource(this.config.style.pictureCheckNumBgStyle);
            }
            if (this.config.style.pictureUnCompleteTextColor != 0) {
                this.mTvPictureOk.setTextColor(this.config.style.pictureUnCompleteTextColor);
            }
            if (this.config.style.pictureBottomBgColor != 0) {
                this.mBottomLayout.setBackgroundColor(this.config.style.pictureBottomBgColor);
            }
            if (this.config.style.pictureContainerBackgroundColor != 0) {
                this.container.setBackgroundColor(this.config.style.pictureContainerBackgroundColor);
            }
        } else {
            int pictureBottomBgColor;
            if (this.config.downResId != 0) {
                Drawable drawable3 = ContextCompat.getDrawable((Context)this, (int)this.config.downResId);
                this.mIvArrow.setImageDrawable(drawable3);
            }
            if ((pictureBottomBgColor = AttrsUtils.getTypeValueColor(this.getContext(), R.attr.picture_bottom_bg)) != 0) {
                this.mBottomLayout.setBackgroundColor(pictureBottomBgColor);
            }
        }
        this.titleViewBg.setBackgroundColor(this.colorPrimary);
        if (this.config.isOriginalControl) {
            if (this.config.style != null && this.config.style.pictureOriginalControlStyle != 0) {
                this.mCbOriginal.setButtonDrawable(this.config.style.pictureOriginalControlStyle);
            } else {
                this.mCbOriginal.setButtonDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.picture_original_checkbox));
            }
            if (this.config.style != null && this.config.style.pictureOriginalFontColor != 0) {
                this.mCbOriginal.setTextColor(this.config.style.pictureOriginalFontColor);
            } else {
                this.mCbOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.picture_color_53575e));
            }
        }
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.adapter != null) {
            List<LocalMedia> selectedImages = this.adapter.getSelectedImages();
            PictureSelector.saveSelectorList(outState, selectedImages);
        }
    }

    private void isNumComplete(boolean numComplete) {
        this.mTvPictureOk.setText((CharSequence)(numComplete ? this.getString(R.string.picture_done_front_num, new Object[]{0, this.config.selectionMode == 1 ? 1 : this.config.maxSelectNum}) : this.getString(R.string.picture_please_select)));
        if (!numComplete) {
            this.animation = AnimationUtils.loadAnimation((Context)this, (int)R.anim.picture_anim_modal_in);
        }
        this.animation = numComplete ? null : AnimationUtils.loadAnimation((Context)this, (int)R.anim.picture_anim_modal_in);
    }

    protected void readLocalMedia() {
        if (this.mediaLoader == null) {
            this.mediaLoader = new LocalMediaLoader((Context)this, this.config);
        }
        this.mediaLoader.loadAllMedia();
        this.mediaLoader.setCompleteListener(folders -> {
            if (folders.size() > 0) {
                this.foldersList = folders;
                LocalMediaFolder folder = (LocalMediaFolder)folders.get(0);
                folder.setChecked(true);
                List<LocalMedia> localImg = folder.getImages();
                int size = this.images.size();
                if (localImg.size() >= size) {
                    this.images = localImg;
                    this.folderWindow.bindFolder(folders);
                }
            }
            if (this.adapter != null && this.images != null) {
                this.adapter.bindImagesData(this.images);
                this.mTvEmpty.setVisibility(this.images.size() > 0 ? 4 : 0);
            }
            this.mHandler.sendEmptyMessage(1);
        });
    }

    public void startCamera() {
        if (!DoubleUtils.isFastDoubleClick()) {
            switch (this.config.chooseMode) {
                case 0: {
                    if (this.popupWindow != null) {
                        if (this.popupWindow.isShowing()) {
                            this.popupWindow.dismiss();
                        }
                        this.popupWindow.showAsDropDown((View)this.mTvPictureTitle);
                        break;
                    }
                    this.startOpenCamera();
                    break;
                }
                case 1: {
                    this.startOpenCamera();
                    break;
                }
                case 2: {
                    this.startOpenCameraVideo();
                    break;
                }
                case 3: {
                    this.startOpenCameraAudio();
                    break;
                }
            }
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.picture_left_back || id2 == R.id.picture_right) {
            if (this.folderWindow != null && this.folderWindow.isShowing()) {
                this.folderWindow.dismiss();
            } else {
                this.closeActivity();
            }
        }
        if (id2 == R.id.picture_title) {
            if (this.folderWindow.isShowing()) {
                this.folderWindow.dismiss();
            } else if (this.images != null && this.images.size() > 0) {
                this.folderWindow.showAsDropDown(this.titleViewBg);
                if (!this.config.isSingleDirectReturn) {
                    List<LocalMedia> selectedImages = this.adapter.getSelectedImages();
                    this.folderWindow.notifyDataCheckedStatus(selectedImages);
                }
            }
        }
        if (id2 == R.id.picture_id_preview) {
            this.onPreview();
        }
        if (id2 == R.id.picture_tv_ok || id2 == R.id.picture_tv_img_num) {
            this.onComplete();
        }
    }

    private void onPreview() {
        List<LocalMedia> selectedImages = this.adapter.getSelectedImages();
        ArrayList<LocalMedia> medias = new ArrayList<LocalMedia>();
        int size = selectedImages.size();
        for (int i = 0; i < size; ++i) {
            LocalMedia media = selectedImages.get(i);
            medias.add(media);
        }
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList("previewSelectList", medias);
        bundle.putParcelableArrayList("selectList", (ArrayList)selectedImages);
        bundle.putBoolean("bottom_preview", true);
        JumpUtils.startPicturePreviewActivity(this.getContext(), this.config.isWeChatStyle, bundle, this.config.selectionMode == 1 ? 69 : 609);
        this.overridePendingTransition(this.config.windowAnimationStyle != null && this.config.windowAnimationStyle.activityPreviewEnterAnimation != 0 ? this.config.windowAnimationStyle.activityPreviewEnterAnimation : R.anim.picture_anim_enter, R.anim.picture_anim_fade_in);
    }

    private void onComplete() {
        List<LocalMedia> images = this.adapter.getSelectedImages();
        LocalMedia image = images.size() > 0 ? images.get(0) : null;
        String mimeType = image != null ? image.getMimeType() : "";
        int size = images.size();
        boolean eqImg = PictureMimeType.eqImage(mimeType);
        if (this.config.minSelectNum > 0 && this.config.selectionMode == 2 && size < this.config.minSelectNum) {
            String str = eqImg ? this.getString(R.string.picture_min_img_num, new Object[]{this.config.minSelectNum}) : this.getString(R.string.picture_min_video_num, new Object[]{this.config.minSelectNum});
            ToastUtils.s(this.getContext(), str);
            return;
        }
        if (this.config.isCheckOriginalImage) {
            this.onResult(images);
            return;
        }
        if (this.config.enableCrop && eqImg) {
            if (this.config.selectionMode == 1) {
                this.originalPath = image.getPath();
                this.startCrop(this.originalPath);
            } else {
                ArrayList<CutInfo> cuts = new ArrayList<CutInfo>();
                int count = images.size();
                for (int i = 0; i < count; ++i) {
                    LocalMedia media = images.get(i);
                    if (media == null || TextUtils.isEmpty((CharSequence)media.getPath())) continue;
                    CutInfo cutInfo = new CutInfo();
                    cutInfo.setPath(media.getPath());
                    cutInfo.setImageWidth(media.getWidth());
                    cutInfo.setImageHeight(media.getHeight());
                    cutInfo.setMimeType(media.getMimeType());
                    cuts.add(cutInfo);
                }
                this.startCrop(cuts);
            }
        } else if (this.config.isCompress && eqImg) {
            this.compressImage(images);
        } else {
            this.onResult(images);
        }
    }

    private void audioDialog(String path) {
        this.audioDialog = new PictureCustomDialog(this.getContext(), -1, this.audioH, R.layout.picture_audio_dialog, R.style.Picture_Theme_Dialog);
        this.audioDialog.getWindow().setWindowAnimations(R.style.Picture_Theme_Dialog_AudioStyle);
        this.mTvMusicStatus = (TextView)this.audioDialog.findViewById(R.id.tv_musicStatus);
        this.mTvMusicTime = (TextView)this.audioDialog.findViewById(R.id.tv_musicTime);
        this.musicSeekBar = (SeekBar)this.audioDialog.findViewById(R.id.musicSeekBar);
        this.mTvMusicTotal = (TextView)this.audioDialog.findViewById(R.id.tv_musicTotal);
        this.mTvPlayPause = (TextView)this.audioDialog.findViewById(R.id.tv_PlayPause);
        this.mTvStop = (TextView)this.audioDialog.findViewById(R.id.tv_Stop);
        this.mTvQuit = (TextView)this.audioDialog.findViewById(R.id.tv_Quit);
        if (this.handler != null) {
            this.handler.postDelayed(() -> this.initPlayer(path), 30L);
        }
        this.mTvPlayPause.setOnClickListener((View.OnClickListener)new audioOnClick(path));
        this.mTvStop.setOnClickListener((View.OnClickListener)new audioOnClick(path));
        this.mTvQuit.setOnClickListener((View.OnClickListener)new audioOnClick(path));
        this.musicSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (fromUser) {
                    PictureSelectorActivity.this.mediaPlayer.seekTo(progress);
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        this.audioDialog.setOnDismissListener(dialog -> {
            if (this.handler != null) {
                this.handler.removeCallbacks(this.runnable);
            }
            new Handler().postDelayed(() -> this.stop(path), 30L);
            try {
                if (this.audioDialog != null && this.audioDialog.isShowing()) {
                    this.audioDialog.dismiss();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        if (this.handler != null) {
            this.handler.post(this.runnable);
        }
        this.audioDialog.show();
    }

    private void initPlayer(String path) {
        this.mediaPlayer = new MediaPlayer();
        try {
            this.mediaPlayer.setDataSource(path);
            this.mediaPlayer.prepare();
            this.mediaPlayer.setLooping(true);
            this.playAudio();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void playAudio() {
        String ppStr;
        if (this.mediaPlayer != null) {
            this.musicSeekBar.setProgress(this.mediaPlayer.getCurrentPosition());
            this.musicSeekBar.setMax(this.mediaPlayer.getDuration());
        }
        if ((ppStr = this.mTvPlayPause.getText().toString()).equals(this.getString(R.string.picture_play_audio))) {
            this.mTvPlayPause.setText((CharSequence)this.getString(R.string.picture_pause_audio));
            this.mTvMusicStatus.setText((CharSequence)this.getString(R.string.picture_play_audio));
            this.playOrPause();
        } else {
            this.mTvPlayPause.setText((CharSequence)this.getString(R.string.picture_play_audio));
            this.mTvMusicStatus.setText((CharSequence)this.getString(R.string.picture_pause_audio));
            this.playOrPause();
        }
        if (!this.isPlayAudio) {
            if (this.handler != null) {
                this.handler.post(this.runnable);
            }
            this.isPlayAudio = true;
        }
    }

    public void stop(String path) {
        if (this.mediaPlayer != null) {
            try {
                this.mediaPlayer.stop();
                this.mediaPlayer.reset();
                this.mediaPlayer.setDataSource(path);
                this.mediaPlayer.prepare();
                this.mediaPlayer.seekTo(0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void playOrPause() {
        try {
            if (this.mediaPlayer != null) {
                if (this.mediaPlayer.isPlaying()) {
                    this.mediaPlayer.pause();
                } else {
                    this.mediaPlayer.start();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onItemClick(boolean isCameraFolder, String folderName, List<LocalMedia> images) {
        boolean camera = this.config.isCamera ? isCameraFolder : false;
        this.adapter.setShowCamera(camera);
        this.mTvPictureTitle.setText((CharSequence)folderName);
        this.folderWindow.dismiss();
        this.adapter.bindImagesData(images);
        this.mPictureRecycler.smoothScrollToPosition(0);
    }

    @Override
    public void onTakePhoto() {
        if (PermissionChecker.checkSelfPermission((Context)this, "android.permission.CAMERA")) {
            this.startCamera();
        } else {
            PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.CAMERA"}, 2);
        }
    }

    @Override
    public void onChange(List<LocalMedia> selectImages) {
        this.changeImageNumber(selectImages);
    }

    @Override
    public void onPictureClick(LocalMedia media, int position) {
        if (this.config.selectionMode == 1 && this.config.isSingleDirectReturn) {
            ArrayList<LocalMedia> list = new ArrayList<LocalMedia>();
            list.add(media);
            if (this.config.enableCrop && !this.config.isCheckOriginalImage) {
                this.adapter.bindSelectImages(list);
                this.startCrop(media.getPath());
            } else {
                this.handlerResult(list);
            }
        } else {
            List<LocalMedia> images = this.adapter.getImages();
            this.startPreview(images, position);
        }
    }

    public void startPreview(List<LocalMedia> previewImages, int position) {
        LocalMedia media = previewImages.get(position);
        String mimeType = media.getMimeType();
        Bundle bundle = new Bundle();
        ArrayList<LocalMedia> result = new ArrayList<LocalMedia>();
        if (PictureMimeType.eqVideo(mimeType)) {
            if (this.config.selectionMode == 1) {
                result.add(media);
                this.onResult(result);
            } else {
                bundle.putString("video_path", media.getPath());
                JumpUtils.startPictureVideoPlayActivity(this.getContext(), bundle);
            }
        } else if (PictureMimeType.eqAudio(mimeType)) {
            if (this.config.selectionMode == 1) {
                result.add(media);
                this.onResult(result);
            } else {
                this.audioDialog(media.getPath());
            }
        } else {
            List<LocalMedia> selectedImages = this.adapter.getSelectedImages();
            ImagesObservable.getInstance().savePreviewMediaData(new ArrayList<LocalMedia>(previewImages));
            bundle.putParcelableArrayList("selectList", (ArrayList)selectedImages);
            bundle.putInt("position", position);
            JumpUtils.startPicturePreviewActivity(this.getContext(), this.config.isWeChatStyle, bundle, this.config.selectionMode == 1 ? 69 : 609);
            this.overridePendingTransition(this.config.windowAnimationStyle != null && this.config.windowAnimationStyle.activityPreviewEnterAnimation != 0 ? this.config.windowAnimationStyle.activityPreviewEnterAnimation : R.anim.picture_anim_enter, R.anim.picture_anim_fade_in);
        }
    }

    protected void changeImageNumber(List<LocalMedia> selectImages) {
        boolean enable;
        String mimeType;
        String string2 = mimeType = selectImages.size() > 0 ? selectImages.get(0).getMimeType() : "";
        if (this.config.chooseMode == PictureMimeType.ofAudio()) {
            this.mTvPicturePreview.setVisibility(8);
        } else {
            boolean isVideo = PictureMimeType.eqVideo(mimeType);
            boolean eqVideo = this.config.chooseMode == 2;
            this.mTvPicturePreview.setVisibility(isVideo || eqVideo ? 8 : 0);
            this.mCbOriginal.setVisibility(isVideo || eqVideo ? 8 : (this.config.isOriginalControl ? 0 : 8));
            this.config.isCheckOriginalImage = isVideo || eqVideo ? false : this.config.isCheckOriginalImage;
            this.mCbOriginal.setChecked(this.config.isCheckOriginalImage);
        }
        boolean bl = enable = selectImages.size() != 0;
        if (enable) {
            this.mTvPictureOk.setEnabled(true);
            this.mTvPictureOk.setSelected(true);
            if (this.config.style != null && this.config.style.pictureCompleteTextColor != 0) {
                this.mTvPictureOk.setTextColor(this.config.style.pictureCompleteTextColor);
            }
            this.mTvPicturePreview.setEnabled(true);
            this.mTvPicturePreview.setSelected(true);
            if (this.config.style != null && this.config.style.picturePreviewTextColor != 0) {
                this.mTvPicturePreview.setTextColor(this.config.style.picturePreviewTextColor);
            }
            this.mTvPicturePreview.setText((CharSequence)this.getString(R.string.picture_preview_num, new Object[]{selectImages.size()}));
            if (this.numComplete) {
                this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_done_front_num, new Object[]{selectImages.size(), this.config.selectionMode == 1 ? 1 : this.config.maxSelectNum}));
            } else {
                if (!this.anim) {
                    this.mTvPictureImgNum.startAnimation(this.animation);
                }
                this.mTvPictureImgNum.setVisibility(0);
                this.mTvPictureImgNum.setText((CharSequence)String.valueOf(selectImages.size()));
                this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_completed));
                this.anim = false;
            }
        } else {
            this.mTvPictureOk.setEnabled(false);
            this.mTvPictureOk.setSelected(false);
            if (this.config.style != null && this.config.style.pictureUnCompleteTextColor != 0) {
                this.mTvPictureOk.setTextColor(this.config.style.pictureUnCompleteTextColor);
            }
            this.mTvPicturePreview.setEnabled(false);
            this.mTvPicturePreview.setSelected(false);
            if (this.config.style != null && this.config.style.pictureUnPreviewTextColor != 0) {
                this.mTvPicturePreview.setTextColor(this.config.style.pictureUnPreviewTextColor);
            }
            this.mTvPicturePreview.setText((CharSequence)this.getString(R.string.picture_preview));
            if (this.numComplete) {
                this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_done_front_num, new Object[]{0, this.config.selectionMode == 1 ? 1 : this.config.maxSelectNum}));
            } else {
                this.mTvPictureImgNum.setVisibility(4);
                this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_please_select));
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1) {
            switch (requestCode) {
                case 69: {
                    this.singleCropHandleResult(data);
                    break;
                }
                case 609: {
                    this.multiCropHandleResult(data);
                    break;
                }
                case 909: {
                    this.requestCamera(data);
                    break;
                }
            }
        } else if (resultCode == 96) {
            Throwable throwable = (Throwable)data.getSerializableExtra("com.yalantis.ucrop.Error");
            ToastUtils.s(this.getContext(), throwable.getMessage());
        }
    }

    private void cameraHandleResult(LocalMedia media, String mimeType) {
        if (this.config.isCheckOriginalImage) {
            ArrayList<LocalMedia> result = new ArrayList<LocalMedia>();
            result.add(media);
            this.onResult(result);
            return;
        }
        boolean eqImg = PictureMimeType.eqImage(mimeType);
        if (this.config.enableCrop && eqImg) {
            this.originalPath = this.cameraPath;
            this.startCrop(this.cameraPath);
        } else if (this.config.isCompress && eqImg) {
            ArrayList<LocalMedia> result = new ArrayList<LocalMedia>();
            result.add(media);
            this.compressImage(result);
            this.images.add(0, media);
            this.adapter.bindSelectImages(result);
            this.adapter.notifyDataSetChanged();
        } else {
            ArrayList<LocalMedia> result = new ArrayList<LocalMedia>();
            result.add(media);
            this.onResult(result);
        }
    }

    private void requestCamera(Intent data) {
        String mimeType = null;
        long duration = 0L;
        boolean isAndroidQ = SdkVersionUtils.checkedAndroid_Q();
        if (this.config.chooseMode == PictureMimeType.ofAudio()) {
            this.cameraPath = this.getAudioPath(data);
            if (TextUtils.isEmpty((CharSequence)this.cameraPath)) {
                return;
            }
            mimeType = "audio/mpeg";
            duration = isAndroidQ ? MediaUtils.extractDuration(this.getContext(), true, this.cameraPath) : MediaUtils.extractDuration(this.getContext(), false, this.cameraPath);
        }
        if (TextUtils.isEmpty((CharSequence)this.cameraPath) || new File(this.cameraPath) == null) {
            return;
        }
        long size = 0L;
        int[] newSize = new int[2];
        File file = new File(this.cameraPath);
        if (!isAndroidQ) {
            this.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.fromFile((File)file)));
        }
        LocalMedia media = new LocalMedia();
        if (this.config.chooseMode != PictureMimeType.ofAudio()) {
            if (isAndroidQ) {
                String path = PictureFileUtils.getPath(this.getApplicationContext(), Uri.parse((String)this.cameraPath));
                File f = new File(path);
                size = f.length();
                mimeType = PictureMimeType.fileToType(f);
                if (PictureMimeType.eqImage(mimeType)) {
                    int degree = PictureFileUtils.readPictureDegree((Context)this, this.cameraPath);
                    String rotateImagePath = PictureFileUtils.rotateImageToAndroidQ((Context)this, degree, this.cameraPath, this.config.cameraFileName);
                    media.setAndroidQToPath(rotateImagePath);
                    newSize = MediaUtils.getLocalImageSizeToAndroidQ((Context)this, this.cameraPath);
                } else {
                    newSize = MediaUtils.getLocalVideoSize((Context)this, Uri.parse((String)this.cameraPath));
                    duration = MediaUtils.extractDuration(this.getContext(), true, this.cameraPath);
                }
            } else {
                mimeType = PictureMimeType.fileToType(file);
                size = new File(this.cameraPath).length();
                if (PictureMimeType.eqImage(mimeType)) {
                    int degree = PictureFileUtils.readPictureDegree((Context)this, this.cameraPath);
                    PictureFileUtils.rotateImage(degree, this.cameraPath);
                    newSize = MediaUtils.getLocalImageWidthOrHeight(this.cameraPath);
                } else {
                    newSize = MediaUtils.getLocalVideoSize(this.cameraPath);
                    duration = MediaUtils.extractDuration(this.getContext(), false, this.cameraPath);
                }
            }
            boolean isMimeType = PictureMimeType.eqImage(mimeType);
            int lastImageId = MediaUtils.getLastImageId(this.getContext(), isMimeType);
            if (lastImageId != -1) {
                this.removeImage(lastImageId, isMimeType);
            }
        }
        media.setDuration(duration);
        media.setWidth(newSize[0]);
        media.setHeight(newSize[1]);
        media.setPath(this.cameraPath);
        media.setMimeType(mimeType);
        media.setSize(size);
        media.setChooseModel(this.config.chooseMode);
        if (this.adapter != null) {
            boolean mimeTypeSame;
            if (this.config.selectionMode == 1) {
                if (this.config.isSingleDirectReturn) {
                    this.cameraHandleResult(media, mimeType);
                } else {
                    this.images.add(0, media);
                    List<LocalMedia> selectedImages = this.adapter.getSelectedImages();
                    mimeType = selectedImages.size() > 0 ? selectedImages.get(0).getMimeType() : "";
                    mimeTypeSame = PictureMimeType.isMimeTypeSame(mimeType, media.getMimeType());
                    if (mimeTypeSame || selectedImages.size() == 0) {
                        this.singleRadioMediaImage();
                        selectedImages.add(media);
                        this.adapter.bindSelectImages(selectedImages);
                    }
                }
            } else {
                this.images.add(0, media);
                List<LocalMedia> selectedImages = this.adapter.getSelectedImages();
                if (selectedImages.size() < this.config.maxSelectNum) {
                    mimeType = selectedImages.size() > 0 ? selectedImages.get(0).getMimeType() : "";
                    mimeTypeSame = PictureMimeType.isMimeTypeSame(mimeType, media.getMimeType());
                    if ((mimeTypeSame || selectedImages.size() == 0) && selectedImages.size() < this.config.maxSelectNum) {
                        selectedImages.add(media);
                        this.adapter.bindSelectImages(selectedImages);
                    }
                } else {
                    ToastUtils.s((Context)this, StringUtils.getToastMsg((Context)this, mimeType, this.config.maxSelectNum));
                }
            }
            this.adapter.notifyDataSetChanged();
            this.manualSaveFolder(media);
            this.mTvEmpty.setVisibility(this.images.size() > 0 ? 4 : 0);
        }
    }

    private void singleCropHandleResult(Intent data) {
        ArrayList<LocalMedia> medias = new ArrayList<LocalMedia>();
        Uri resultUri = UCrop.getOutput((Intent)data);
        String cutPath = resultUri.getPath();
        if (this.adapter != null) {
            LocalMedia media;
            List<LocalMedia> mediaList = this.adapter.getSelectedImages();
            LocalMedia localMedia = media = mediaList != null && mediaList.size() > 0 ? mediaList.get(0) : null;
            if (media != null) {
                this.originalPath = media.getPath();
                media.setCutPath(cutPath);
                media.setSize(new File(cutPath).length());
                media.setChooseModel(this.config.chooseMode);
                media.setCut(true);
                if (SdkVersionUtils.checkedAndroid_Q()) {
                    media.setAndroidQToPath(cutPath);
                }
                medias.add(media);
                this.handlerResult(medias);
            }
        }
    }

    private void singleRadioMediaImage() {
        List<LocalMedia> selectImages = this.adapter.getSelectedImages();
        if (selectImages != null && selectImages.size() > 0) {
            selectImages.clear();
        }
    }

    private void manualSaveFolder(LocalMedia media) {
        try {
            LocalMediaFolder cameraFolder;
            this.createNewFolder(this.foldersList);
            LocalMediaFolder folder = this.getImageFolder(media.getPath(), this.foldersList);
            LocalMediaFolder localMediaFolder = cameraFolder = this.foldersList.size() > 0 ? this.foldersList.get(0) : null;
            if (cameraFolder != null && folder != null) {
                cameraFolder.setFirstImagePath(media.getPath());
                cameraFolder.setImages(this.images);
                cameraFolder.setImageNum(cameraFolder.getImageNum() + 1);
                int num = folder.getImageNum() + 1;
                folder.setImageNum(num);
                folder.getImages().add(0, media);
                folder.setFirstImagePath(this.cameraPath);
                this.folderWindow.bindFolder(this.foldersList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.closeActivity();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.commonBroadcastReceiver != null) {
            BroadcastManager.getInstance((Context)this).unregisterReceiver(this.commonBroadcastReceiver, "com.luck.picture.lib.action.selected.data", "com.luck.picture.lib.action.preview.compression");
        }
        if (this.animation != null) {
            this.animation.cancel();
            this.animation = null;
        }
        if (this.mediaPlayer != null && this.handler != null) {
            this.handler.removeCallbacks(this.runnable);
            this.mediaPlayer.release();
            this.mediaPlayer = null;
        }
    }

    @Override
    public void onItemClick(int position) {
        switch (position) {
            case 0: {
                this.startOpenCamera();
                break;
            }
            case 1: {
                this.startOpenCameraVideo();
                break;
            }
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 1: {
                if (grantResults[0] == 0) {
                    this.mHandler.sendEmptyMessage(0);
                    this.readLocalMedia();
                    break;
                }
                ToastUtils.s(this.getContext(), this.getString(R.string.picture_jurisdiction));
                this.onBackPressed();
                break;
            }
            case 2: {
                if (grantResults[0] == 0) {
                    this.onTakePhoto();
                    break;
                }
                ToastUtils.s(this.getContext(), this.getString(R.string.picture_camera));
            }
        }
    }

    public class audioOnClick
    implements View.OnClickListener {
        private String path;

        public audioOnClick(String path) {
            this.path = path;
        }

        public void onClick(View v) {
            int id2 = v.getId();
            if (id2 == R.id.tv_PlayPause) {
                PictureSelectorActivity.this.playAudio();
            }
            if (id2 == R.id.tv_Stop) {
                PictureSelectorActivity.this.mTvMusicStatus.setText((CharSequence)PictureSelectorActivity.this.getString(R.string.picture_stop_audio));
                PictureSelectorActivity.this.mTvPlayPause.setText((CharSequence)PictureSelectorActivity.this.getString(R.string.picture_play_audio));
                PictureSelectorActivity.this.stop(this.path);
            }
            if (id2 == R.id.tv_Quit && PictureSelectorActivity.this.handler != null) {
                PictureSelectorActivity.this.handler.postDelayed(() -> PictureSelectorActivity.this.stop(this.path), 30L);
                try {
                    if (PictureSelectorActivity.this.audioDialog != null && PictureSelectorActivity.this.audioDialog.isShowing()) {
                        PictureSelectorActivity.this.audioDialog.dismiss();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                PictureSelectorActivity.this.handler.removeCallbacks(PictureSelectorActivity.this.runnable);
            }
        }
    }
}

