/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.widget;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.PictureAlbumDirectoryAdapter;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.tools.AttrsUtils;
import com.luck.picture.lib.tools.ScreenUtils;
import java.util.List;

public class FolderPopWindow
extends PopupWindow
implements View.OnClickListener {
    private Context context;
    private View window;
    private RecyclerView recyclerView;
    private PictureAlbumDirectoryAdapter adapter;
    private Animation animationIn;
    private Animation animationOut;
    private boolean isDismiss = false;
    private LinearLayout id_ll_root;
    private TextView titleView;
    private Drawable drawableUp;
    private Drawable drawableDown;
    private int chooseMode;
    private PictureSelectionConfig config;
    private int maxHeight;

    public FolderPopWindow(Context context, PictureSelectionConfig config) {
        this.context = context;
        this.config = config;
        this.chooseMode = config.chooseMode;
        this.window = LayoutInflater.from((Context)context).inflate(R.layout.picture_window_folder, null);
        this.setContentView(this.window);
        this.setWidth(ScreenUtils.getScreenWidth(context));
        this.setHeight(ScreenUtils.getScreenHeight(context));
        this.setAnimationStyle(R.style.PictureThemeWindowStyle);
        this.setFocusable(true);
        this.setOutsideTouchable(true);
        this.update();
        this.setBackgroundDrawable((Drawable)new ColorDrawable(Color.argb((int)123, (int)0, (int)0, (int)0)));
        if (config.style != null) {
            if (config.style.pictureTitleUpResId != 0) {
                this.drawableUp = ContextCompat.getDrawable((Context)context, (int)config.style.pictureTitleUpResId);
            }
            if (config.style.pictureTitleDownResId != 0) {
                this.drawableDown = ContextCompat.getDrawable((Context)context, (int)config.style.pictureTitleDownResId);
            }
        } else {
            this.drawableUp = config.upResId != 0 ? ContextCompat.getDrawable((Context)context, (int)config.upResId) : AttrsUtils.getTypeValueDrawable(context, R.attr.picture_arrow_up_icon);
            this.drawableDown = config.downResId != 0 ? ContextCompat.getDrawable((Context)context, (int)config.downResId) : AttrsUtils.getTypeValueDrawable(context, R.attr.picture_arrow_down_icon);
        }
        this.animationIn = AnimationUtils.loadAnimation((Context)context, (int)R.anim.picture_anim_album_show);
        this.animationOut = AnimationUtils.loadAnimation((Context)context, (int)R.anim.picture_anim_album_dismiss);
        this.maxHeight = (int)((double)ScreenUtils.getScreenHeight(context) * 0.6);
        this.initView();
    }

    public void initView() {
        this.id_ll_root = (LinearLayout)this.window.findViewById(R.id.id_ll_root);
        this.adapter = new PictureAlbumDirectoryAdapter(this.context, this.config);
        this.recyclerView = (RecyclerView)this.window.findViewById(R.id.folder_list);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.context));
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.id_ll_root.setOnClickListener((View.OnClickListener)this);
    }

    public void bindFolder(List<LocalMediaFolder> folders) {
        this.adapter.setChooseMode(this.chooseMode);
        this.adapter.bindFolderData(folders);
        ViewGroup.LayoutParams lp = this.recyclerView.getLayoutParams();
        lp.height = folders != null && folders.size() > 8 ? this.maxHeight : -2;
    }

    public void setTitleView(TextView titleView) {
        this.titleView = titleView;
    }

    public void showAsDropDown(View anchor) {
        try {
            if (Build.VERSION.SDK_INT >= 24) {
                Rect rect = new Rect();
                anchor.getGlobalVisibleRect(rect);
                int h = anchor.getResources().getDisplayMetrics().heightPixels - rect.bottom;
                this.setHeight(h);
            }
            super.showAsDropDown(anchor);
            this.isDismiss = false;
            this.recyclerView.startAnimation(this.animationIn);
            if (Build.VERSION.SDK_INT >= 17) {
                this.titleView.setCompoundDrawablesRelativeWithIntrinsicBounds(null, null, this.drawableUp, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOnItemClickListener(PictureAlbumDirectoryAdapter.OnItemClickListener onItemClickListener) {
        this.adapter.setOnItemClickListener(onItemClickListener);
    }

    public void dismiss() {
        if (this.isDismiss) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 17) {
            this.titleView.setCompoundDrawablesRelativeWithIntrinsicBounds(null, null, this.drawableDown, null);
        }
        this.isDismiss = true;
        this.recyclerView.startAnimation(this.animationOut);
        this.dismiss();
        this.animationOut.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                FolderPopWindow.this.isDismiss = false;
                if (Build.VERSION.SDK_INT <= 16) {
                    FolderPopWindow.this.dismiss4Pop();
                } else {
                    FolderPopWindow.super.dismiss();
                }
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
    }

    private void dismiss4Pop() {
        new Handler().post(() -> FolderPopWindow.super.dismiss());
    }

    public void notifyDataCheckedStatus(List<LocalMedia> medias) {
        try {
            List<LocalMediaFolder> folders = this.adapter.getFolderData();
            for (LocalMediaFolder folder : folders) {
                folder.setCheckedNum(0);
            }
            if (medias.size() > 0) {
                for (LocalMediaFolder folder : folders) {
                    int num = 0;
                    List<LocalMedia> images = folder.getImages();
                    for (LocalMedia media : images) {
                        String path = media.getPath();
                        for (LocalMedia m : medias) {
                            if (!path.equals(m.getPath())) continue;
                            folder.setCheckedNum(++num);
                        }
                    }
                }
            }
            this.adapter.bindFolderData(folders);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.id_ll_root) {
            this.dismiss();
        }
    }
}

