/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.tools;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import android.text.TextUtils;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.tools.ValueOf;

public class MediaUtils {
    public static Uri createImagePathUri(Context context, String fileName) {
        Uri[] imageFilePath = new Uri[]{null};
        String status = Environment.getExternalStorageState();
        String time = String.valueOf(System.currentTimeMillis());
        String imageName = TextUtils.isEmpty((CharSequence)fileName) ? time : fileName;
        ContentValues values = new ContentValues(3);
        values.put("_display_name", imageName);
        values.put("datetaken", time);
        values.put("mime_type", "image/jpeg");
        imageFilePath[0] = status.equals("mounted") ? context.getContentResolver().insert(MediaStore.Files.getContentUri((String)"external"), values) : context.getContentResolver().insert(MediaStore.Files.getContentUri((String)"internal"), values);
        return imageFilePath[0];
    }

    public static Uri createImageVideoUri(Context context, String fileName) {
        Uri[] imageFilePath = new Uri[]{null};
        String status = Environment.getExternalStorageState();
        String time = String.valueOf(System.currentTimeMillis());
        String imageName = TextUtils.isEmpty((CharSequence)fileName) ? time : fileName;
        ContentValues values = new ContentValues(3);
        values.put("_display_name", imageName);
        values.put("datetaken", time);
        values.put("mime_type", "video/mp4");
        imageFilePath[0] = status.equals("mounted") ? context.getContentResolver().insert(MediaStore.Files.getContentUri((String)"external"), values) : context.getContentResolver().insert(MediaStore.Files.getContentUri((String)"internal"), values);
        return imageFilePath[0];
    }

    public static long extractDuration(Context context, boolean isAndroidQ, String path) {
        return isAndroidQ ? MediaUtils.getLocalDuration(context, Uri.parse((String)path)) : MediaUtils.getLocalDuration(path);
    }

    public static boolean isLongImg(LocalMedia media) {
        if (null != media) {
            int h;
            int width = media.getWidth();
            int height = media.getHeight();
            return height > (h = width * 3);
        }
        return false;
    }

    private static long getLocalDuration(Context context, Uri uri) {
        try {
            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            mmr.setDataSource(context, uri);
            return Long.parseLong(mmr.extractMetadata(9));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    private static long getLocalDuration(String path) {
        try {
            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            mmr.setDataSource(path);
            return Long.parseLong(mmr.extractMetadata(9));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static int[] getLocalVideoWidthOrHeightToAndroidQ(Context context, String videoPath) {
        int[] wh = new int[2];
        try {
            Cursor query = null;
            if (Build.VERSION.SDK_INT >= 26) {
                query = context.getApplicationContext().getContentResolver().query(Uri.parse((String)videoPath), null, null, null);
            }
            if (query != null) {
                query.moveToFirst();
                wh[0] = query.getInt(query.getColumnIndexOrThrow("width"));
                wh[1] = query.getInt(query.getColumnIndexOrThrow("height"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return wh;
    }

    public static int[] getLocalVideoWidthOrHeight(String videoPath) {
        int[] wh = new int[2];
        try {
            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            mmr.setDataSource(videoPath);
            wh[0] = ValueOf.toInt(mmr.extractMetadata(18));
            wh[1] = ValueOf.toInt(mmr.extractMetadata(19));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return wh;
    }
}

