/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SimpleItemAnimator;
import com.luck.picture.lib.PictureBaseActivity;
import com.luck.picture.lib.PictureSelector;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.PictureAlbumDirectoryAdapter;
import com.luck.picture.lib.adapter.PictureImageGridAdapter;
import com.luck.picture.lib.broadcast.BroadcastManager;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.decoration.GridSpacingItemDecoration;
import com.luck.picture.lib.dialog.PictureCustomDialog;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.model.LocalMediaLoader;
import com.luck.picture.lib.observable.ImagesObservable;
import com.luck.picture.lib.permissions.PermissionChecker;
import com.luck.picture.lib.tools.DateUtils;
import com.luck.picture.lib.tools.DoubleUtils;
import com.luck.picture.lib.tools.JumpUtils;
import com.luck.picture.lib.tools.MediaUtils;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.ScreenUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.tools.StringUtils;
import com.luck.picture.lib.tools.ToastUtils;
import com.luck.picture.lib.widget.FolderPopWindow;
import com.luck.picture.lib.widget.PhotoPopupWindow;
import com.yalantis.ucrop.UCrop;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PictureSelectorActivity
extends PictureBaseActivity
implements View.OnClickListener,
PictureAlbumDirectoryAdapter.OnItemClickListener,
PictureImageGridAdapter.OnPhotoSelectChangedListener,
PhotoPopupWindow.OnItemClickListener {
    private static final int SHOW_DIALOG = 0;
    private static final int DISMISS_DIALOG = 1;
    private ImageView mIvPictureLeftBack;
    private View titleViewBg;
    private TextView mTvPictureTitle;
    private TextView mTvPictureRight;
    private TextView mTvPictureOk;
    private TextView mTvEmpty;
    private TextView mTvPictureImgNum;
    private TextView mTvPicturePreview;
    private TextView mTvPlayPause;
    private TextView mTvStop;
    private TextView mTvQuit;
    private TextView mTvMusicStatus;
    private TextView mTvMusicTotal;
    private TextView mTvMusicTime;
    private RecyclerView mPictureRecycler;
    private RelativeLayout mBottomLayout;
    private PictureImageGridAdapter adapter;
    private List<LocalMedia> images = new ArrayList<LocalMedia>();
    private List<LocalMediaFolder> foldersList = new ArrayList<LocalMediaFolder>();
    private FolderPopWindow folderWindow;
    private Animation animation = null;
    private boolean anim = false;
    private PhotoPopupWindow popupWindow;
    private LocalMediaLoader mediaLoader;
    private MediaPlayer mediaPlayer;
    private SeekBar musicSeekBar;
    private boolean isPlayAudio = false;
    private PictureCustomDialog audioDialog;
    private int audioH;
    @SuppressLint(value={"HandlerLeak"})
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 0: {
                    PictureSelectorActivity.this.showPleaseDialog();
                    break;
                }
                case 1: {
                    PictureSelectorActivity.this.dismissDialog();
                    break;
                }
            }
        }
    };
    public Handler handler = new Handler();
    public Runnable runnable = new Runnable(){

        @Override
        public void run() {
            try {
                if (PictureSelectorActivity.this.mediaPlayer != null) {
                    PictureSelectorActivity.this.mTvMusicTime.setText((CharSequence)DateUtils.formatDurationTime(PictureSelectorActivity.this.mediaPlayer.getCurrentPosition()));
                    PictureSelectorActivity.this.musicSeekBar.setProgress(PictureSelectorActivity.this.mediaPlayer.getCurrentPosition());
                    PictureSelectorActivity.this.musicSeekBar.setMax(PictureSelectorActivity.this.mediaPlayer.getDuration());
                    PictureSelectorActivity.this.mTvMusicTotal.setText((CharSequence)DateUtils.formatDurationTime(PictureSelectorActivity.this.mediaPlayer.getDuration()));
                    if (PictureSelectorActivity.this.handler != null) {
                        PictureSelectorActivity.this.handler.postDelayed(PictureSelectorActivity.this.runnable, 200L);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private BroadcastReceiver commonBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action;
            switch (action = intent.getAction()) {
                case "com.luck.picture.lib.action.selected.data": {
                    Bundle extras = intent.getExtras();
                    if (extras == null) break;
                    ArrayList selectImages = extras.getParcelableArrayList("selectImages");
                    int position = extras.getInt("position");
                    PictureSelectorActivity.this.anim = true;
                    PictureSelectorActivity.this.adapter.bindSelectImages(selectImages);
                    PictureSelectorActivity.this.adapter.notifyItemChanged(position);
                    break;
                }
                case "com.luck.picture.lib.action.preview.compression": {
                    ArrayList selectImages;
                    Bundle extras = intent.getExtras();
                    if (extras == null || (selectImages = extras.getParcelableArrayList("selectImages")).size() <= 0) break;
                    String mimeType = ((LocalMedia)selectImages.get(0)).getMimeType();
                    if (PictureSelectorActivity.this.config.isCompress && PictureMimeType.eqImage(mimeType)) {
                        PictureSelectorActivity.this.compressImage(selectImages);
                        break;
                    }
                    PictureSelectorActivity.this.onResult(selectImages);
                    break;
                }
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.picture_selector);
        BroadcastManager.getInstance((Context)this).registerReceiver(this.commonBroadcastReceiver, "com.luck.picture.lib.action.selected.data", "com.luck.picture.lib.action.preview.compression");
        this.initView(savedInstanceState);
        this.initPictureSelectorStyle();
    }

    private void initView(Bundle savedInstanceState) {
        this.titleViewBg = this.findViewById(R.id.titleViewBg);
        this.mIvPictureLeftBack = (ImageView)this.findViewById(R.id.picture_left_back);
        this.mTvPictureTitle = (TextView)this.findViewById(R.id.picture_title);
        this.mTvPictureRight = (TextView)this.findViewById(R.id.picture_right);
        this.mTvPictureOk = (TextView)this.findViewById(R.id.picture_tv_ok);
        this.mTvPicturePreview = (TextView)this.findViewById(R.id.picture_id_preview);
        this.mTvPictureImgNum = (TextView)this.findViewById(R.id.picture_tv_img_num);
        this.mPictureRecycler = (RecyclerView)this.findViewById(R.id.picture_recycler);
        this.mBottomLayout = (RelativeLayout)this.findViewById(R.id.rl_bottom);
        this.mTvEmpty = (TextView)this.findViewById(R.id.tv_empty);
        this.isNumComplete(this.numComplete);
        if (this.config.chooseMode == PictureMimeType.ofAll()) {
            this.popupWindow = new PhotoPopupWindow((Context)this);
            this.popupWindow.setOnItemClickListener(this);
        }
        this.mTvPicturePreview.setOnClickListener((View.OnClickListener)this);
        if (this.config.chooseMode == PictureMimeType.ofAudio()) {
            this.mTvPicturePreview.setVisibility(8);
            this.audioH = ScreenUtils.getScreenHeight(this.mContext) + ScreenUtils.getStatusBarHeight(this.mContext);
        } else {
            this.mTvPicturePreview.setVisibility(this.config.chooseMode == PictureMimeType.ofVideo() ? 8 : 0);
        }
        this.mBottomLayout.setVisibility(this.config.selectionMode == 1 && this.config.isSingleDirectReturn ? 8 : 0);
        this.mIvPictureLeftBack.setOnClickListener((View.OnClickListener)this);
        this.mTvPictureRight.setOnClickListener((View.OnClickListener)this);
        this.mTvPictureOk.setOnClickListener((View.OnClickListener)this);
        this.mTvPictureImgNum.setOnClickListener((View.OnClickListener)this);
        this.mTvPictureTitle.setOnClickListener((View.OnClickListener)this);
        String title = this.config.chooseMode == PictureMimeType.ofAudio() ? this.getString(R.string.picture_all_audio) : this.getString(R.string.picture_camera_roll);
        this.mTvPictureTitle.setText((CharSequence)title);
        this.folderWindow = new FolderPopWindow((Context)this, this.config);
        this.folderWindow.setTitleView(this.mTvPictureTitle);
        this.folderWindow.setOnItemClickListener(this);
        this.mPictureRecycler.setHasFixedSize(true);
        this.mPictureRecycler.addItemDecoration((RecyclerView.ItemDecoration)new GridSpacingItemDecoration(this.config.imageSpanCount, ScreenUtils.dip2px((Context)this, 2.0f), false));
        this.mPictureRecycler.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager((Context)this, this.config.imageSpanCount));
        ((SimpleItemAnimator)this.mPictureRecycler.getItemAnimator()).setSupportsChangeAnimations(false);
        this.mediaLoader = new LocalMediaLoader((Context)this, this.config);
        if (PermissionChecker.checkSelfPermission((Context)this, "android.permission.READ_EXTERNAL_STORAGE") && PermissionChecker.checkSelfPermission((Context)this, "android.permission.WRITE_EXTERNAL_STORAGE")) {
            this.mHandler.sendEmptyMessage(0);
            this.readLocalMedia();
        } else {
            PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"}, 1);
        }
        this.mTvEmpty.setText((CharSequence)(this.config.chooseMode == PictureMimeType.ofAudio() ? this.getString(R.string.picture_audio_empty) : this.getString(R.string.picture_empty)));
        StringUtils.tempTextFont(this.mTvEmpty, this.config.chooseMode);
        if (savedInstanceState != null) {
            this.selectionMedias = PictureSelector.obtainSelectorList(savedInstanceState);
        }
        this.adapter = new PictureImageGridAdapter(this.mContext, this.config);
        this.adapter.setOnPhotoSelectChangedListener(this);
        this.adapter.bindSelectImages(this.selectionMedias);
        this.mPictureRecycler.setAdapter((RecyclerView.Adapter)this.adapter);
        String titleText = this.mTvPictureTitle.getText().toString().trim();
        if (this.config.isCamera) {
            this.config.isCamera = StringUtils.isCamera(titleText);
        }
    }

    private void initPictureSelectorStyle() {
        if (this.config.style != null) {
            if (Build.VERSION.SDK_INT >= 17) {
                Drawable drawable2 = ContextCompat.getDrawable((Context)this, (int)this.config.style.pictureTitleDownResId);
                this.mTvPictureTitle.setCompoundDrawablesRelativeWithIntrinsicBounds(null, null, drawable2, null);
            }
            if (this.config.style.pictureTitleTextColor != 0) {
                this.mTvPictureTitle.setTextColor(this.config.style.pictureTitleTextColor);
            }
            if (this.config.style.pictureCancelTextColor != 0) {
                this.mTvPictureRight.setTextColor(this.config.style.pictureCancelTextColor);
            }
            if (this.config.style.pictureLeftBackIcon != 0) {
                this.mIvPictureLeftBack.setImageResource(this.config.style.pictureLeftBackIcon);
            }
            if (this.config.style.pictureUnPreviewTextColor != 0) {
                this.mTvPicturePreview.setTextColor(this.config.style.pictureUnPreviewTextColor);
            }
            if (this.config.style.pictureCheckNumBgStyle != 0) {
                this.mTvPictureImgNum.setBackgroundResource(this.config.style.pictureCheckNumBgStyle);
            }
            if (this.config.style.pictureUnCompleteTextColor != 0) {
                this.mTvPictureOk.setTextColor(this.config.style.pictureUnCompleteTextColor);
            }
            if (this.config.style.pictureBottomBgColor != 0) {
                this.mBottomLayout.setBackgroundColor(this.config.style.pictureBottomBgColor);
            }
        } else if (this.config.downResId != 0) {
            Drawable drawable3 = ContextCompat.getDrawable((Context)this, (int)this.config.downResId);
            if (Build.VERSION.SDK_INT >= 17) {
                this.mTvPictureTitle.setCompoundDrawablesRelativeWithIntrinsicBounds(null, null, drawable3, null);
            }
        }
        this.titleViewBg.setBackgroundColor(this.colorPrimary);
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.adapter != null) {
            List<LocalMedia> selectedImages = this.adapter.getSelectedImages();
            PictureSelector.saveSelectorList(outState, selectedImages);
        }
    }

    private void isNumComplete(boolean numComplete) {
        this.mTvPictureOk.setText((CharSequence)(numComplete ? this.getString(R.string.picture_done_front_num, new Object[]{0, this.config.selectionMode == 1 ? 1 : this.config.maxSelectNum}) : this.getString(R.string.picture_please_select)));
        if (!numComplete) {
            this.animation = AnimationUtils.loadAnimation((Context)this, (int)R.anim.picture_anim_modal_in);
        }
        this.animation = numComplete ? null : AnimationUtils.loadAnimation((Context)this, (int)R.anim.picture_anim_modal_in);
    }

    protected void readLocalMedia() {
        this.mediaLoader.loadAllMedia();
        this.mediaLoader.setCompleteListener(folders -> {
            if (folders.size() > 0) {
                this.foldersList = folders;
                LocalMediaFolder folder = (LocalMediaFolder)folders.get(0);
                folder.setChecked(true);
                List<LocalMedia> localImg = folder.getImages();
                if (localImg.size() >= this.images.size()) {
                    this.images = localImg;
                    this.folderWindow.bindFolder(folders);
                }
            }
            if (this.adapter != null) {
                if (this.images == null) {
                    this.images = new ArrayList<LocalMedia>();
                }
                this.adapter.bindImagesData(this.images);
                this.mTvEmpty.setVisibility(this.images.size() > 0 ? 4 : 0);
            }
            this.mHandler.sendEmptyMessage(1);
        });
    }

    public void startCamera() {
        if (!DoubleUtils.isFastDoubleClick()) {
            switch (this.config.chooseMode) {
                case 0: {
                    if (this.popupWindow != null) {
                        if (this.popupWindow.isShowing()) {
                            this.popupWindow.dismiss();
                        }
                        this.popupWindow.showAsDropDown((View)this.mTvPictureTitle);
                        break;
                    }
                    this.startOpenCamera();
                    break;
                }
                case 1: {
                    this.startOpenCamera();
                    break;
                }
                case 2: {
                    this.startOpenCameraVideo();
                    break;
                }
                case 3: {
                    this.startOpenCameraAudio();
                    break;
                }
            }
        }
    }

    public void onClick(View v) {
        List<LocalMedia> selectedImages;
        int id2 = v.getId();
        if (id2 == R.id.picture_left_back || id2 == R.id.picture_right) {
            if (this.folderWindow.isShowing()) {
                this.folderWindow.dismiss();
            } else {
                this.closeActivity();
            }
        }
        if (id2 == R.id.picture_title) {
            if (this.folderWindow.isShowing()) {
                this.folderWindow.dismiss();
            } else if (this.images != null && this.images.size() > 0) {
                this.folderWindow.showAsDropDown((View)this.mTvPictureTitle);
                selectedImages = this.adapter.getSelectedImages();
                this.folderWindow.notifyDataCheckedStatus(selectedImages);
            }
        }
        if (id2 == R.id.picture_id_preview) {
            selectedImages = this.adapter.getSelectedImages();
            ArrayList<LocalMedia> medias = new ArrayList<LocalMedia>();
            for (LocalMedia media : selectedImages) {
                medias.add(media);
            }
            Bundle bundle = new Bundle();
            bundle.putParcelableArrayList("previewSelectList", medias);
            bundle.putParcelableArrayList("selectList", (ArrayList)selectedImages);
            bundle.putBoolean("bottom_preview", true);
            JumpUtils.startPicturePreviewActivity(this.mContext, bundle, this.config.selectionMode == 1 ? 69 : 609);
            this.overridePendingTransition(R.anim.picture_anim_a5, 0);
        }
        if (id2 == R.id.picture_tv_ok || id2 == R.id.picture_tv_img_num) {
            List<LocalMedia> images = this.adapter.getSelectedImages();
            LocalMedia image = images.size() > 0 ? images.get(0) : null;
            String mimeType = image != null ? image.getMimeType() : "";
            int size = images.size();
            boolean eqImg = PictureMimeType.eqImage(mimeType);
            if (this.config.minSelectNum > 0 && this.config.selectionMode == 2 && size < this.config.minSelectNum) {
                String str = eqImg ? this.getString(R.string.picture_min_img_num, new Object[]{this.config.minSelectNum}) : this.getString(R.string.picture_min_video_num, new Object[]{this.config.minSelectNum});
                ToastUtils.s(this.mContext, str);
                return;
            }
            if (this.config.enableCrop && eqImg) {
                if (this.config.selectionMode == 1) {
                    this.originalPath = image.getPath();
                    this.startCrop(this.originalPath);
                } else {
                    ArrayList<String> medias = new ArrayList<String>();
                    for (LocalMedia media : images) {
                        medias.add(media.getPath());
                    }
                    this.startCrop(medias);
                }
            } else if (this.config.isCompress && eqImg) {
                this.compressImage(images);
            } else {
                this.onResult(images);
            }
        }
    }

    private void audioDialog(String path) {
        this.audioDialog = new PictureCustomDialog(this.mContext, -1, this.audioH, R.layout.picture_audio_dialog, R.style.Picture_Theme_Dialog);
        this.audioDialog.getWindow().setWindowAnimations(R.style.Picture_Theme_Dialog_AudioStyle);
        this.mTvMusicStatus = (TextView)this.audioDialog.findViewById(R.id.tv_musicStatus);
        this.mTvMusicTime = (TextView)this.audioDialog.findViewById(R.id.tv_musicTime);
        this.musicSeekBar = (SeekBar)this.audioDialog.findViewById(R.id.musicSeekBar);
        this.mTvMusicTotal = (TextView)this.audioDialog.findViewById(R.id.tv_musicTotal);
        this.mTvPlayPause = (TextView)this.audioDialog.findViewById(R.id.tv_PlayPause);
        this.mTvStop = (TextView)this.audioDialog.findViewById(R.id.tv_Stop);
        this.mTvQuit = (TextView)this.audioDialog.findViewById(R.id.tv_Quit);
        if (this.handler != null) {
            this.handler.postDelayed(() -> this.initPlayer(path), 30L);
        }
        this.mTvPlayPause.setOnClickListener((View.OnClickListener)new audioOnClick(path));
        this.mTvStop.setOnClickListener((View.OnClickListener)new audioOnClick(path));
        this.mTvQuit.setOnClickListener((View.OnClickListener)new audioOnClick(path));
        this.musicSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (fromUser) {
                    PictureSelectorActivity.this.mediaPlayer.seekTo(progress);
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        this.audioDialog.setOnDismissListener(dialog -> {
            if (this.handler != null) {
                this.handler.removeCallbacks(this.runnable);
            }
            new Handler().postDelayed(() -> this.stop(path), 30L);
            try {
                if (this.audioDialog != null && this.audioDialog.isShowing()) {
                    this.audioDialog.dismiss();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        if (this.handler != null) {
            this.handler.post(this.runnable);
        }
        this.audioDialog.show();
    }

    private void initPlayer(String path) {
        this.mediaPlayer = new MediaPlayer();
        try {
            this.mediaPlayer.setDataSource(path);
            this.mediaPlayer.prepare();
            this.mediaPlayer.setLooping(true);
            this.playAudio();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void playAudio() {
        String ppStr;
        if (this.mediaPlayer != null) {
            this.musicSeekBar.setProgress(this.mediaPlayer.getCurrentPosition());
            this.musicSeekBar.setMax(this.mediaPlayer.getDuration());
        }
        if ((ppStr = this.mTvPlayPause.getText().toString()).equals(this.getString(R.string.picture_play_audio))) {
            this.mTvPlayPause.setText((CharSequence)this.getString(R.string.picture_pause_audio));
            this.mTvMusicStatus.setText((CharSequence)this.getString(R.string.picture_play_audio));
            this.playOrPause();
        } else {
            this.mTvPlayPause.setText((CharSequence)this.getString(R.string.picture_play_audio));
            this.mTvMusicStatus.setText((CharSequence)this.getString(R.string.picture_pause_audio));
            this.playOrPause();
        }
        if (!this.isPlayAudio) {
            if (this.handler != null) {
                this.handler.post(this.runnable);
            }
            this.isPlayAudio = true;
        }
    }

    public void stop(String path) {
        if (this.mediaPlayer != null) {
            try {
                this.mediaPlayer.stop();
                this.mediaPlayer.reset();
                this.mediaPlayer.setDataSource(path);
                this.mediaPlayer.prepare();
                this.mediaPlayer.seekTo(0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void playOrPause() {
        try {
            if (this.mediaPlayer != null) {
                if (this.mediaPlayer.isPlaying()) {
                    this.mediaPlayer.pause();
                } else {
                    this.mediaPlayer.start();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onItemClick(String folderName, List<LocalMedia> images) {
        boolean camera = StringUtils.isCamera(folderName);
        camera = this.config.isCamera ? camera : false;
        this.adapter.setShowCamera(camera);
        this.mTvPictureTitle.setText((CharSequence)folderName);
        this.adapter.bindImagesData(images);
        this.folderWindow.dismiss();
        this.mPictureRecycler.smoothScrollToPosition(0);
    }

    @Override
    public void onTakePhoto() {
        if (PermissionChecker.checkSelfPermission((Context)this, "android.permission.CAMERA")) {
            this.startCamera();
        } else {
            PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.CAMERA"}, 2);
        }
    }

    @Override
    public void onChange(List<LocalMedia> selectImages) {
        this.changeImageNumber(selectImages);
    }

    @Override
    public void onPictureClick(LocalMedia media, int position) {
        if (this.config.selectionMode == 1 && this.config.isSingleDirectReturn) {
            ArrayList<LocalMedia> list = new ArrayList<LocalMedia>();
            list.add(media);
            if (this.config.enableCrop) {
                this.adapter.bindSelectImages(list);
                this.startCrop(media.getPath());
            } else {
                this.handlerResult(list);
            }
        } else {
            List<LocalMedia> images = this.adapter.getImages();
            this.startPreview(images, position);
        }
    }

    public void startPreview(List<LocalMedia> previewImages, int position) {
        LocalMedia media = previewImages.get(position);
        String mimeType = media.getMimeType();
        Bundle bundle = new Bundle();
        ArrayList<LocalMedia> result = new ArrayList<LocalMedia>();
        if (PictureMimeType.eqVideo(mimeType)) {
            if (this.config.selectionMode == 1) {
                result.add(media);
                this.onResult(result);
            } else {
                bundle.putString("video_path", media.getPath());
                JumpUtils.startPictureVideoPlayActivity(this.mContext, bundle);
            }
        } else if (PictureMimeType.eqAudio(mimeType)) {
            if (this.config.selectionMode == 1) {
                result.add(media);
                this.onResult(result);
            } else {
                this.audioDialog(media.getPath());
            }
        } else {
            List<LocalMedia> selectedImages = this.adapter.getSelectedImages();
            ImagesObservable.getInstance().savePreviewMediaData(new ArrayList<LocalMedia>(previewImages));
            bundle.putParcelableArrayList("selectList", (ArrayList)selectedImages);
            bundle.putInt("position", position);
            JumpUtils.startPicturePreviewActivity(this.mContext, bundle, this.config.selectionMode == 1 ? 69 : 609);
            this.overridePendingTransition(R.anim.picture_anim_a5, 0);
        }
    }

    public void changeImageNumber(List<LocalMedia> selectImages) {
        boolean enable;
        String mimeType;
        String string2 = mimeType = selectImages.size() > 0 ? selectImages.get(0).getMimeType() : "";
        if (this.config.chooseMode == PictureMimeType.ofAudio()) {
            this.mTvPicturePreview.setVisibility(8);
        } else {
            boolean isVideo = PictureMimeType.eqVideo(mimeType);
            boolean eqVideo = this.config.chooseMode == 2;
            this.mTvPicturePreview.setVisibility(isVideo || eqVideo ? 8 : 0);
        }
        boolean bl = enable = selectImages.size() != 0;
        if (enable) {
            this.mTvPictureOk.setEnabled(true);
            this.mTvPictureOk.setSelected(true);
            if (this.config.style != null && this.config.style.pictureCompleteTextColor != 0) {
                this.mTvPictureOk.setTextColor(this.config.style.pictureCompleteTextColor);
            }
            this.mTvPicturePreview.setEnabled(true);
            this.mTvPicturePreview.setSelected(true);
            if (this.config.style != null && this.config.style.picturePreviewTextColor != 0) {
                this.mTvPicturePreview.setTextColor(this.config.style.picturePreviewTextColor);
            }
            if (this.numComplete) {
                this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_done_front_num, new Object[]{selectImages.size(), this.config.selectionMode == 1 ? 1 : this.config.maxSelectNum}));
            } else {
                if (!this.anim) {
                    this.mTvPictureImgNum.startAnimation(this.animation);
                }
                this.mTvPictureImgNum.setVisibility(0);
                this.mTvPictureImgNum.setText((CharSequence)String.valueOf(selectImages.size()));
                this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_completed));
                this.anim = false;
            }
        } else {
            this.mTvPictureOk.setEnabled(false);
            this.mTvPictureOk.setSelected(false);
            if (this.config.style != null && this.config.style.pictureUnCompleteTextColor != 0) {
                this.mTvPictureOk.setTextColor(this.config.style.pictureUnCompleteTextColor);
            }
            this.mTvPicturePreview.setEnabled(false);
            this.mTvPicturePreview.setSelected(false);
            if (this.config.style != null && this.config.style.pictureUnPreviewTextColor != 0) {
                this.mTvPicturePreview.setTextColor(this.config.style.pictureUnPreviewTextColor);
            }
            if (this.numComplete) {
                this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_done_front_num, new Object[]{0, this.config.selectionMode == 1 ? 1 : this.config.maxSelectNum}));
            } else {
                this.mTvPictureImgNum.setVisibility(4);
                this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_please_select));
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1) {
            switch (requestCode) {
                case 69: {
                    this.singleCropHandleResult(data);
                    break;
                }
                case 609: {
                    this.multiCropHandleResult(data);
                    break;
                }
                case 909: {
                    this.requestCamera(data);
                    break;
                }
            }
        } else if (resultCode == 96) {
            Throwable throwable = (Throwable)data.getSerializableExtra("com.yalantis.ucrop.Error");
            ToastUtils.s(this.mContext, throwable.getMessage());
        }
    }

    private void cameraHandleResult(List<LocalMedia> medias, LocalMedia media, String mimeType) {
        boolean eqImg = PictureMimeType.eqImage(mimeType);
        if (this.config.enableCrop && eqImg) {
            this.originalPath = this.cameraPath;
            this.startCrop(this.cameraPath);
        } else if (this.config.isCompress && eqImg) {
            medias.add(media);
            this.compressImage(medias);
            if (this.adapter != null) {
                this.images.add(0, media);
                this.adapter.notifyDataSetChanged();
            }
        } else {
            medias.add(media);
            this.onResult(medias);
        }
    }

    private void requestCamera(Intent data) {
        int lastImageId;
        String mimeType;
        long size;
        File file;
        ArrayList<LocalMedia> medias = new ArrayList<LocalMedia>();
        if (this.config.chooseMode == PictureMimeType.ofAudio()) {
            this.cameraPath = this.getAudioPath(data);
        }
        if ((file = new File(this.cameraPath)) == null) {
            return;
        }
        Uri uri = SdkVersionUtils.checkedAndroid_Q() ? Uri.parse((String)this.cameraPath) : Uri.fromFile((File)file);
        this.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", uri));
        boolean isAndroidQ = SdkVersionUtils.checkedAndroid_Q();
        if (isAndroidQ) {
            String path = PictureFileUtils.getPath(this.getApplicationContext(), Uri.parse((String)this.cameraPath));
            File f = new File(path);
            size = f.length();
            mimeType = PictureMimeType.fileToType(f);
        } else {
            mimeType = PictureMimeType.fileToType(file);
            size = new File(this.cameraPath).length();
        }
        if (this.config.chooseMode != PictureMimeType.ofAudio()) {
            int degree = PictureFileUtils.readPictureDegree(file.getAbsolutePath());
            this.rotateImage(degree, file);
        }
        LocalMedia media = new LocalMedia();
        media.setPath(this.cameraPath);
        boolean eqVideo = PictureMimeType.eqVideo(mimeType);
        mimeType = this.config.chooseMode == PictureMimeType.ofAudio() ? "audio/mpeg" : (eqVideo ? (isAndroidQ ? PictureMimeType.getMimeType(this.mContext, Uri.parse((String)this.cameraPath)) : PictureMimeType.getVideoMimeType(this.cameraPath)) : (isAndroidQ ? PictureMimeType.getMimeType(this.mContext, Uri.parse((String)this.cameraPath)) : PictureMimeType.getImageMimeType(this.cameraPath)));
        long duration = MediaUtils.extractDuration(this.mContext, isAndroidQ, this.cameraPath);
        media.setMimeType(mimeType);
        media.setDuration(duration);
        media.setSize(size);
        media.setChooseModel(this.config.chooseMode);
        if (this.config.selectionMode == 1 && this.config.isSingleDirectReturn) {
            if (this.adapter != null) {
                medias.add(media);
                this.adapter.bindSelectImages(medias);
                this.cameraHandleResult(medias, media, mimeType);
            }
        } else {
            this.images.add(0, media);
            if (this.adapter != null) {
                boolean mimeTypeSame;
                List<LocalMedia> selectedImages = this.adapter.getSelectedImages();
                if (selectedImages.size() < this.config.maxSelectNum && ((mimeTypeSame = PictureMimeType.isMimeTypeSame(mimeType = selectedImages.size() > 0 ? selectedImages.get(0).getMimeType() : "", media.getMimeType())) || selectedImages.size() == 0) && selectedImages.size() < this.config.maxSelectNum) {
                    if (this.config.selectionMode == 1) {
                        this.singleRadioMediaImage();
                    }
                    selectedImages.add(media);
                    this.adapter.bindSelectImages(selectedImages);
                }
                this.adapter.notifyDataSetChanged();
            }
        }
        if (this.adapter != null) {
            this.manualSaveFolder(media);
            this.mTvEmpty.setVisibility(this.images.size() > 0 ? 4 : 0);
        }
        if (this.config.chooseMode != PictureMimeType.ofAudio() && (lastImageId = this.getLastImageId(eqVideo)) != -1) {
            this.removeImage(lastImageId, eqVideo);
        }
    }

    private void singleCropHandleResult(Intent data) {
        ArrayList<LocalMedia> medias = new ArrayList<LocalMedia>();
        Uri resultUri = UCrop.getOutput((Intent)data);
        String cutPath = resultUri.getPath();
        if (this.adapter != null) {
            LocalMedia media;
            List<LocalMedia> mediaList = this.adapter.getSelectedImages();
            LocalMedia localMedia = media = mediaList != null && mediaList.size() > 0 ? mediaList.get(0) : null;
            if (media != null) {
                this.originalPath = media.getPath();
                media.setCutPath(cutPath);
                media.setSize(new File(cutPath).length());
                media.setChooseModel(this.config.chooseMode);
                media.setCut(true);
                String mimeType = PictureMimeType.getImageMimeType(cutPath);
                media.setMimeType(mimeType);
                if (SdkVersionUtils.checkedAndroid_Q()) {
                    media.setAndroidQToPath(cutPath);
                }
                medias.add(media);
                this.handlerResult(medias);
            }
        }
    }

    private void singleRadioMediaImage() {
        List<LocalMedia> selectImages;
        if (this.adapter != null && (selectImages = this.adapter.getSelectedImages()) != null && selectImages.size() > 0) {
            selectImages.clear();
        }
    }

    private void manualSaveFolder(LocalMedia media) {
        try {
            LocalMediaFolder cameraFolder;
            this.createNewFolder(this.foldersList);
            LocalMediaFolder folder = this.getImageFolder(media.getPath(), this.foldersList);
            LocalMediaFolder localMediaFolder = cameraFolder = this.foldersList.size() > 0 ? this.foldersList.get(0) : null;
            if (cameraFolder != null && folder != null) {
                cameraFolder.setFirstImagePath(media.getPath());
                cameraFolder.setImages(this.images);
                cameraFolder.setImageNum(cameraFolder.getImageNum() + 1);
                int num = folder.getImageNum() + 1;
                folder.setImageNum(num);
                folder.getImages().add(0, media);
                folder.setFirstImagePath(this.cameraPath);
                this.folderWindow.bindFolder(this.foldersList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.closeActivity();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.commonBroadcastReceiver != null) {
            BroadcastManager.getInstance((Context)this).unregisterReceiver(this.commonBroadcastReceiver, "com.luck.picture.lib.action.selected.data", "com.luck.picture.lib.action.preview.compression");
        }
        if (this.animation != null) {
            this.animation.cancel();
            this.animation = null;
        }
        if (this.mediaPlayer != null && this.handler != null) {
            this.handler.removeCallbacks(this.runnable);
            this.mediaPlayer.release();
            this.mediaPlayer = null;
        }
    }

    @Override
    public void onItemClick(int position) {
        switch (position) {
            case 0: {
                this.startOpenCamera();
                break;
            }
            case 1: {
                this.startOpenCameraVideo();
                break;
            }
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 1: {
                for (int i = 0; i < grantResults.length; ++i) {
                    if (grantResults[i] == 0) {
                        this.mHandler.sendEmptyMessage(0);
                        this.readLocalMedia();
                        continue;
                    }
                    ToastUtils.s(this.mContext, this.getString(R.string.picture_jurisdiction));
                    this.onBackPressed();
                }
                break;
            }
            case 2: {
                if (grantResults[0] == 0) {
                    this.onTakePhoto();
                    break;
                }
                ToastUtils.s(this.mContext, this.getString(R.string.picture_camera));
            }
        }
    }

    public class audioOnClick
    implements View.OnClickListener {
        private String path;

        public audioOnClick(String path) {
            this.path = path;
        }

        public void onClick(View v) {
            int id2 = v.getId();
            if (id2 == R.id.tv_PlayPause) {
                PictureSelectorActivity.this.playAudio();
            }
            if (id2 == R.id.tv_Stop) {
                PictureSelectorActivity.this.mTvMusicStatus.setText((CharSequence)PictureSelectorActivity.this.getString(R.string.picture_stop_audio));
                PictureSelectorActivity.this.mTvPlayPause.setText((CharSequence)PictureSelectorActivity.this.getString(R.string.picture_play_audio));
                PictureSelectorActivity.this.stop(this.path);
            }
            if (id2 == R.id.tv_Quit && PictureSelectorActivity.this.handler != null) {
                PictureSelectorActivity.this.handler.postDelayed(() -> PictureSelectorActivity.this.stop(this.path), 30L);
                try {
                    if (PictureSelectorActivity.this.audioDialog != null && PictureSelectorActivity.this.audioDialog.isShowing()) {
                        PictureSelectorActivity.this.audioDialog.dismiss();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                PictureSelectorActivity.this.handler.removeCallbacks(PictureSelectorActivity.this.runnable);
            }
        }
    }
}

