/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.media.MediaPlayer;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.widget.SeekBar;
import android.widget.TextView;
import com.luck.picture.lib.PictureBaseActivity;
import com.luck.picture.lib.R;
import com.luck.picture.lib.tools.DateUtils;

@Deprecated
public class PicturePlayAudioActivity
extends PictureBaseActivity
implements View.OnClickListener {
    private String audio_path;
    private MediaPlayer mediaPlayer;
    private SeekBar musicSeekBar;
    private boolean isPlayAudio = false;
    private TextView tv_PlayPause;
    private TextView tv_Stop;
    private TextView tv_Quit;
    private TextView tv_musicStatus;
    private TextView tv_musicTotal;
    private TextView tv_musicTime;
    public Handler handler = new Handler();
    public Runnable runnable = new Runnable(){

        @Override
        public void run() {
            try {
                if (PicturePlayAudioActivity.this.mediaPlayer != null) {
                    PicturePlayAudioActivity.this.tv_musicTime.setText((CharSequence)DateUtils.formatDurationTime(PicturePlayAudioActivity.this.mediaPlayer.getCurrentPosition()));
                    PicturePlayAudioActivity.this.musicSeekBar.setProgress(PicturePlayAudioActivity.this.mediaPlayer.getCurrentPosition());
                    PicturePlayAudioActivity.this.musicSeekBar.setMax(PicturePlayAudioActivity.this.mediaPlayer.getDuration());
                    PicturePlayAudioActivity.this.tv_musicTotal.setText((CharSequence)DateUtils.formatDurationTime(PicturePlayAudioActivity.this.mediaPlayer.getDuration()));
                    PicturePlayAudioActivity.this.handler.postDelayed(PicturePlayAudioActivity.this.runnable, 200L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        this.getWindow().setFlags(1024, 1024);
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_picture_play_audio);
        this.audio_path = this.getIntent().getStringExtra("audio_path");
        this.tv_musicStatus = (TextView)this.findViewById(R.id.tv_musicStatus);
        this.tv_musicTime = (TextView)this.findViewById(R.id.tv_musicTime);
        this.musicSeekBar = (SeekBar)this.findViewById(R.id.musicSeekBar);
        this.tv_musicTotal = (TextView)this.findViewById(R.id.tv_musicTotal);
        this.tv_PlayPause = (TextView)this.findViewById(R.id.tv_PlayPause);
        this.tv_Stop = (TextView)this.findViewById(R.id.tv_Stop);
        this.tv_Quit = (TextView)this.findViewById(R.id.tv_Quit);
        this.handler.postDelayed(() -> this.initPlayer(this.audio_path), 30L);
        this.tv_PlayPause.setOnClickListener((View.OnClickListener)this);
        this.tv_Stop.setOnClickListener((View.OnClickListener)this);
        this.tv_Quit.setOnClickListener((View.OnClickListener)this);
        this.musicSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (fromUser) {
                    PicturePlayAudioActivity.this.mediaPlayer.seekTo(progress);
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
    }

    private void initPlayer(String path) {
        this.mediaPlayer = new MediaPlayer();
        try {
            this.mediaPlayer.setDataSource(path);
            this.mediaPlayer.prepare();
            this.mediaPlayer.setLooping(true);
            this.playAudio();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.tv_PlayPause) {
            this.playAudio();
        }
        if (i == R.id.tv_Stop) {
            this.tv_musicStatus.setText((CharSequence)this.getString(R.string.picture_stop_audio));
            this.tv_PlayPause.setText((CharSequence)this.getString(R.string.picture_play_audio));
            this.stop(this.audio_path);
        }
        if (i == R.id.tv_Quit) {
            this.handler.removeCallbacks(this.runnable);
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    PicturePlayAudioActivity.this.stop(PicturePlayAudioActivity.this.audio_path);
                }
            }, 30L);
            try {
                this.closeActivity();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void playAudio() {
        String ppStr;
        if (this.mediaPlayer != null) {
            this.musicSeekBar.setProgress(this.mediaPlayer.getCurrentPosition());
            this.musicSeekBar.setMax(this.mediaPlayer.getDuration());
        }
        if ((ppStr = this.tv_PlayPause.getText().toString()).equals(this.getString(R.string.picture_play_audio))) {
            this.tv_PlayPause.setText((CharSequence)this.getString(R.string.picture_pause_audio));
            this.tv_musicStatus.setText((CharSequence)this.getString(R.string.picture_play_audio));
            this.playOrPause();
        } else {
            this.tv_PlayPause.setText((CharSequence)this.getString(R.string.picture_play_audio));
            this.tv_musicStatus.setText((CharSequence)this.getString(R.string.picture_pause_audio));
            this.playOrPause();
        }
        if (!this.isPlayAudio) {
            this.handler.post(this.runnable);
            this.isPlayAudio = true;
        }
    }

    public void stop(String path) {
        if (this.mediaPlayer != null) {
            try {
                this.mediaPlayer.stop();
                this.mediaPlayer.reset();
                this.mediaPlayer.setDataSource(path);
                this.mediaPlayer.prepare();
                this.mediaPlayer.seekTo(0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void playOrPause() {
        try {
            if (this.mediaPlayer != null) {
                if (this.mediaPlayer.isPlaying()) {
                    this.mediaPlayer.pause();
                } else {
                    this.mediaPlayer.start();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.closeActivity();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.mediaPlayer != null && this.handler != null) {
            this.handler.removeCallbacks(this.runnable);
            this.mediaPlayer.release();
            this.mediaPlayer = null;
        }
    }
}

