/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.content.Context;
import android.content.ContextWrapper;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.MediaController;
import android.widget.VideoView;
import com.luck.picture.lib.PictureBaseActivity;
import com.luck.picture.lib.R;

public class PictureVideoPlayActivity
extends PictureBaseActivity
implements MediaPlayer.OnErrorListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnCompletionListener,
View.OnClickListener {
    private String video_path = "";
    private ImageView picture_left_back;
    private MediaController mMediaController;
    private VideoView mVideoView;
    private ImageView iv_play;
    private int mPositionWhenPaused = -1;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        this.getWindow().addFlags(0x4000000);
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.picture_activity_video_play);
        this.video_path = this.getIntent().getStringExtra("video_path");
        this.picture_left_back = (ImageView)this.findViewById(R.id.picture_left_back);
        this.mVideoView = (VideoView)this.findViewById(R.id.video_view);
        this.mVideoView.setBackgroundColor(-16777216);
        this.iv_play = (ImageView)this.findViewById(R.id.iv_play);
        this.mMediaController = new MediaController((Context)this);
        this.mVideoView.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        this.mVideoView.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
        this.mVideoView.setMediaController(this.mMediaController);
        this.picture_left_back.setOnClickListener((View.OnClickListener)this);
        this.iv_play.setOnClickListener((View.OnClickListener)this);
    }

    public void onStart() {
        this.mVideoView.setVideoPath(this.video_path);
        this.mVideoView.start();
        super.onStart();
    }

    public void onPause() {
        this.mPositionWhenPaused = this.mVideoView.getCurrentPosition();
        this.mVideoView.stopPlayback();
        super.onPause();
    }

    @Override
    protected void onDestroy() {
        this.mMediaController = null;
        this.mVideoView = null;
        this.iv_play = null;
        super.onDestroy();
    }

    public void onResume() {
        if (this.mPositionWhenPaused >= 0) {
            this.mVideoView.seekTo(this.mPositionWhenPaused);
            this.mPositionWhenPaused = -1;
        }
        super.onResume();
    }

    public boolean onError(MediaPlayer player, int arg1, int arg2) {
        return false;
    }

    public void onCompletion(MediaPlayer mp) {
        if (null != this.iv_play) {
            this.iv_play.setVisibility(0);
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.picture_left_back) {
            this.finish();
        } else if (id2 == R.id.iv_play) {
            this.mVideoView.start();
            this.iv_play.setVisibility(4);
        }
    }

    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext((Context)new ContextWrapper(newBase){

            public Object getSystemService(String name) {
                if ("audio".equals(name)) {
                    return this.getApplicationContext().getSystemService(name);
                }
                return super.getSystemService(name);
            }
        });
    }

    public void onPrepared(MediaPlayer mp) {
        mp.setOnInfoListener((mp1, what, extra) -> {
            if (what == 3) {
                this.mVideoView.setBackgroundColor(0);
                return true;
            }
            return false;
        });
    }
}

