/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentActivity;
import com.luck.picture.lib.PictureSelector;
import com.luck.picture.lib.R;
import com.luck.picture.lib.compress.Luban;
import com.luck.picture.lib.compress.OnCompressListener;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.dialog.PictureDialog;
import com.luck.picture.lib.entity.EventEntity;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.immersive.ImmersiveManage;
import com.luck.picture.lib.permissions.RxPermissions;
import com.luck.picture.lib.rxbus2.RxBus;
import com.luck.picture.lib.rxbus2.RxUtils;
import com.luck.picture.lib.tools.AndroidQTransformUtils;
import com.luck.picture.lib.tools.DateUtils;
import com.luck.picture.lib.tools.DoubleUtils;
import com.luck.picture.lib.tools.MediaUtils;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.tools.ToastUtils;
import com.yalantis.ucrop.UCrop;
import com.yalantis.ucrop.UCropMulti;
import com.yalantis.ucrop.model.CutInfo;
import io.reactivex.Flowable;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PictureBaseActivity
extends FragmentActivity {
    protected Context mContext;
    protected PictureSelectionConfig config;
    protected boolean openWhiteStatusBar;
    protected boolean numComplete;
    protected int colorPrimary;
    protected int colorPrimaryDark;
    protected String cameraPath;
    protected String outputCameraPath;
    protected String originalPath;
    protected PictureDialog dialog;
    protected PictureDialog compressDialog;
    protected List<LocalMedia> selectionMedias;
    protected RxPermissions rxPermissions;

    public boolean isImmersive() {
        return this.config == null || !this.config.isCamera;
    }

    public void immersive() {
        ImmersiveManage.immersiveAboveAPI23((Activity)this, this.colorPrimaryDark, this.colorPrimary, this.openWhiteStatusBar);
    }

    protected void onCreate(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            this.config = (PictureSelectionConfig)savedInstanceState.getParcelable("PictureSelectorConfig");
            this.cameraPath = savedInstanceState.getString("CameraPath");
            this.originalPath = savedInstanceState.getString("OriginalPath");
        } else {
            this.config = PictureSelectionConfig.getInstance();
        }
        int themeStyleId = this.config.themeStyleId;
        this.setTheme(themeStyleId);
        super.onCreate(savedInstanceState);
        this.mContext = this;
        this.rxPermissions = new RxPermissions(this);
        this.initConfig();
        if (this.isImmersive()) {
            this.immersive();
        }
    }

    private void initConfig() {
        this.outputCameraPath = this.config.outputCameraPath;
        this.openWhiteStatusBar = this.config.isChangeStatusBarFontColor;
        this.numComplete = this.config.isOpenStyleNumComplete;
        this.config.checkNumMode = this.config.isOpenStyleCheckNumMode;
        this.colorPrimary = this.config.titleBarBackgroundColor <= 0 ? ContextCompat.getColor((Context)this, (int)R.color.bar_grey) : ContextCompat.getColor((Context)this, (int)this.config.titleBarBackgroundColor);
        this.colorPrimaryDark = this.config.statusBarColorPrimaryDark <= 0 ? ContextCompat.getColor((Context)this, (int)R.color.bar_grey) : ContextCompat.getColor((Context)this, (int)this.config.statusBarColorPrimaryDark);
        this.selectionMedias = this.config.selectionMedias;
        if (this.selectionMedias == null) {
            this.selectionMedias = new ArrayList<LocalMedia>();
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString("CameraPath", this.cameraPath);
        outState.putString("OriginalPath", this.originalPath);
        outState.putParcelable("PictureSelectorConfig", (Parcelable)this.config);
    }

    protected void startActivity(Class clz, Bundle bundle) {
        if (!DoubleUtils.isFastDoubleClick()) {
            Intent intent = new Intent();
            intent.setClass((Context)this, clz);
            intent.putExtras(bundle);
            this.startActivity(intent);
        }
    }

    protected void startActivity(Class clz, Bundle bundle, int requestCode) {
        if (!DoubleUtils.isFastDoubleClick()) {
            Intent intent = new Intent();
            intent.setClass((Context)this, clz);
            intent.putExtras(bundle);
            this.startActivityForResult(intent, requestCode);
        }
    }

    protected void showPleaseDialog() {
        if (!this.isFinishing()) {
            this.dismissDialog();
            this.dialog = new PictureDialog((Context)this);
            this.dialog.show();
        }
    }

    protected void dismissDialog() {
        try {
            if (this.dialog != null && this.dialog.isShowing()) {
                this.dialog.dismiss();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void showCompressDialog() {
        if (!this.isFinishing()) {
            this.dismissCompressDialog();
            this.compressDialog = new PictureDialog((Context)this);
            this.compressDialog.show();
        }
    }

    protected void dismissCompressDialog() {
        try {
            if (!this.isFinishing() && this.compressDialog != null && this.compressDialog.isShowing()) {
                this.compressDialog.dismiss();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void compressImage(final List<LocalMedia> result) {
        this.showCompressDialog();
        if (this.config.synOrAsy) {
            Flowable.just(result).observeOn(Schedulers.io()).map(list -> {
                List<File> files = Luban.with(this.mContext).loadMediaData((List<LocalMedia>)list, this.config.cameraFileName).setTargetDir(this.config.compressSavePath).setCompressQuality(this.config.compressQuality).ignoreBy(this.config.minimumCompressSize).get();
                if (files == null) {
                    files = new ArrayList<File>();
                }
                return files;
            }).observeOn(AndroidSchedulers.mainThread()).subscribe(files -> this.handleCompressCallBack(result, (List<File>)files));
        } else {
            Luban.with((Context)this).loadMediaData(result, this.config.cameraFileName).ignoreBy(this.config.minimumCompressSize).setCompressQuality(this.config.compressQuality).setTargetDir(this.config.compressSavePath).setCompressListener(new OnCompressListener(){

                @Override
                public void onStart() {
                }

                @Override
                public void onSuccess(List<LocalMedia> list) {
                    RxBus.getDefault().post(new EventEntity(2770));
                    PictureBaseActivity.this.onResult(list);
                }

                @Override
                public void onError(Throwable e) {
                    RxBus.getDefault().post(new EventEntity(2770));
                    PictureBaseActivity.this.onResult(result);
                }
            }).launch();
        }
    }

    private void handleCompressCallBack(List<LocalMedia> images, List<File> files) {
        if (files.size() == images.size()) {
            int j = images.size();
            for (int i = 0; i < j; ++i) {
                String path = files.get(i).getPath();
                LocalMedia image = images.get(i);
                boolean http = PictureMimeType.isHttp(path);
                boolean eqTrue = !TextUtils.isEmpty((CharSequence)path) && http;
                image.setCompressed(!eqTrue);
                image.setCompressPath(eqTrue ? "" : path);
            }
        }
        RxBus.getDefault().post(new EventEntity(2770));
        this.onResult(images);
    }

    protected void startCrop(String originalPath) {
        UCrop.Options options = new UCrop.Options();
        int toolbarColor = this.config.cropTitleBarBackgroundColor <= 0 ? ContextCompat.getColor((Context)this, (int)R.color.bar_grey) : ContextCompat.getColor((Context)this, (int)this.config.cropTitleBarBackgroundColor);
        int statusColor = this.config.cropStatusBarColorPrimaryDark <= 0 ? ContextCompat.getColor((Context)this, (int)R.color.bar_grey) : ContextCompat.getColor((Context)this, (int)this.config.cropStatusBarColorPrimaryDark);
        int titleColor = this.config.cropTitleColor <= 0 ? ContextCompat.getColor((Context)this, (int)R.color.white) : ContextCompat.getColor((Context)this, (int)this.config.cropTitleColor);
        options.setToolbarColor(toolbarColor);
        options.setStatusBarColor(statusColor);
        options.setToolbarWidgetColor(titleColor);
        options.setCircleDimmedLayer(this.config.circleDimmedLayer);
        options.setShowCropFrame(this.config.showCropFrame);
        options.setShowCropGrid(this.config.showCropGrid);
        options.setDragFrameEnabled(this.config.isDragFrame);
        options.setScaleEnabled(this.config.scaleEnabled);
        options.setRotateEnabled(this.config.rotateEnabled);
        options.setCompressionQuality(this.config.cropCompressQuality);
        options.setHideBottomControls(this.config.hideBottomControls);
        options.setFreeStyleCropEnabled(this.config.freeStyleCropEnabled);
        boolean isHttp = PictureMimeType.isHttp(originalPath);
        boolean isAndroidQ = SdkVersionUtils.checkedAndroid_Q();
        String imgType = isAndroidQ ? PictureMimeType.getLastImgSuffix(PictureMimeType.getMimeType(this.mContext, Uri.parse((String)originalPath))) : PictureMimeType.getLastImgType(originalPath);
        Uri uri = isHttp || isAndroidQ ? Uri.parse((String)originalPath) : Uri.fromFile((File)new File(originalPath));
        File file = new File(PictureFileUtils.getDiskCacheDir((Context)this), TextUtils.isEmpty((CharSequence)this.config.cameraFileName) ? System.currentTimeMillis() + imgType : this.config.cameraFileName + imgType);
        UCrop.of((Uri)uri, (Uri)Uri.fromFile((File)file)).withAspectRatio((float)this.config.aspect_ratio_x, (float)this.config.aspect_ratio_y).withMaxResultSize(this.config.cropWidth, this.config.cropHeight).withOptions(options).start((Activity)this);
    }

    protected void startCrop(ArrayList<String> list) {
        UCropMulti.Options options = new UCropMulti.Options();
        int toolbarColor = this.config.cropTitleBarBackgroundColor <= 0 ? ContextCompat.getColor((Context)this, (int)R.color.bar_grey) : ContextCompat.getColor((Context)this, (int)this.config.cropTitleBarBackgroundColor);
        int statusColor = this.config.cropStatusBarColorPrimaryDark <= 0 ? ContextCompat.getColor((Context)this, (int)R.color.bar_grey) : ContextCompat.getColor((Context)this, (int)this.config.cropStatusBarColorPrimaryDark);
        int titleColor = this.config.cropTitleColor <= 0 ? ContextCompat.getColor((Context)this, (int)R.color.white) : ContextCompat.getColor((Context)this, (int)this.config.cropTitleColor);
        options.setToolbarColor(toolbarColor);
        options.setStatusBarColor(statusColor);
        options.setToolbarWidgetColor(titleColor);
        options.setCircleDimmedLayer(this.config.circleDimmedLayer);
        options.setShowCropFrame(this.config.showCropFrame);
        options.setDragFrameEnabled(this.config.isDragFrame);
        options.setShowCropGrid(this.config.showCropGrid);
        options.setScaleEnabled(this.config.scaleEnabled);
        options.setRotateEnabled(this.config.rotateEnabled);
        options.setHideBottomControls(this.config.hideBottomControls);
        options.setCompressionQuality(this.config.cropCompressQuality);
        options.setCutListData(list);
        options.setFreeStyleCropEnabled(this.config.freeStyleCropEnabled);
        String path = list.size() > 0 ? list.get(0) : "";
        boolean isAndroidQ = SdkVersionUtils.checkedAndroid_Q();
        boolean isHttp = PictureMimeType.isHttp(path);
        String imgType = isAndroidQ ? PictureMimeType.getLastImgSuffix(PictureMimeType.getMimeType(this.mContext, Uri.parse((String)path))) : PictureMimeType.getLastImgType(path);
        Uri uri = isHttp || isAndroidQ ? Uri.parse((String)path) : Uri.fromFile((File)new File(path));
        File file = new File(PictureFileUtils.getDiskCacheDir((Context)this), TextUtils.isEmpty((CharSequence)this.config.cameraFileName) ? System.currentTimeMillis() + imgType : this.config.cameraFileName + imgType);
        UCropMulti.of((Uri)uri, (Uri)Uri.fromFile((File)file)).withAspectRatio((float)this.config.aspect_ratio_x, (float)this.config.aspect_ratio_y).withMaxResultSize(this.config.cropWidth, this.config.cropHeight).withOptions(options).start((Activity)this);
    }

    protected void rotateImage(int degree, File file) {
        if (degree > 0) {
            try {
                BitmapFactory.Options opts = new BitmapFactory.Options();
                opts.inSampleSize = 2;
                Bitmap bitmap = BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)opts);
                Bitmap bmp = PictureFileUtils.rotaingImageView(degree, bitmap);
                PictureFileUtils.saveBitmapFile(bmp, file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void handlerResult(List<LocalMedia> result) {
        if (this.config.isCompress) {
            this.compressImage(result);
        } else {
            this.onResult(result);
        }
    }

    protected void createNewFolder(List<LocalMediaFolder> folders) {
        if (folders.size() == 0) {
            LocalMediaFolder newFolder = new LocalMediaFolder();
            String folderName = this.config.chooseMode == PictureMimeType.ofAudio() ? this.getString(R.string.picture_all_audio) : this.getString(R.string.picture_camera_roll);
            newFolder.setName(folderName);
            newFolder.setPath("");
            newFolder.setFirstImagePath("");
            folders.add(newFolder);
        }
    }

    protected LocalMediaFolder getImageFolder(String path, List<LocalMediaFolder> imageFolders) {
        File imageFile = new File(path);
        File folderFile = imageFile.getParentFile();
        for (LocalMediaFolder folder : imageFolders) {
            if (!folder.getName().equals(folderFile.getName())) continue;
            return folder;
        }
        LocalMediaFolder newFolder = new LocalMediaFolder();
        newFolder.setName(folderFile.getName());
        newFolder.setPath(folderFile.getAbsolutePath());
        newFolder.setFirstImagePath(path);
        imageFolders.add(newFolder);
        return newFolder;
    }

    protected void onResult(final List<LocalMedia> images) {
        final boolean androidQ = SdkVersionUtils.checkedAndroid_Q();
        final boolean isVideo = PictureMimeType.isVideo(images != null && images.size() > 0 ? images.get(0).getMimeType() : "");
        if (androidQ && !isVideo) {
            this.showCompressDialog();
        }
        RxUtils.io(new RxUtils.RxSimpleTask<List<LocalMedia>>(){

            @Override
            @NonNull
            public List<LocalMedia> doSth(Object ... objects) {
                if (androidQ) {
                    int size = images.size();
                    for (int i = 0; i < size; ++i) {
                        LocalMedia media = (LocalMedia)images.get(i);
                        if (media == null || TextUtils.isEmpty((CharSequence)media.getPath())) continue;
                        if (media.isCompressed()) {
                            media.setAndroidQToPath(media.getCompressPath());
                            continue;
                        }
                        if (media.isCut()) {
                            media.setAndroidQToPath(media.getCutPath());
                            continue;
                        }
                        String path = isVideo ? AndroidQTransformUtils.parseVideoPathToAndroidQ(PictureBaseActivity.this.getApplicationContext(), media.getPath(), PictureBaseActivity.this.config.cameraFileName, media.getMimeType()) : (PictureBaseActivity.this.config.chooseMode == PictureMimeType.ofAudio() ? AndroidQTransformUtils.parseAudioPathToAndroidQ(PictureBaseActivity.this.getApplicationContext(), media.getPath(), PictureBaseActivity.this.config.cameraFileName, media.getMimeType()) : AndroidQTransformUtils.parseImagePathToAndroidQ(PictureBaseActivity.this.getApplicationContext(), media.getPath(), PictureBaseActivity.this.config.cameraFileName, media.getMimeType()));
                        media.setAndroidQToPath(path);
                    }
                    return images;
                }
                return images;
            }

            @Override
            public void onNext(List<LocalMedia> mediaList) {
                super.onNext(mediaList);
                PictureBaseActivity.this.dismissCompressDialog();
                if (PictureBaseActivity.this.config.camera && PictureBaseActivity.this.config.selectionMode == 2 && PictureBaseActivity.this.selectionMedias != null) {
                    mediaList.addAll(mediaList.size() > 0 ? mediaList.size() - 1 : 0, PictureBaseActivity.this.selectionMedias);
                }
                Intent intent = PictureSelector.putIntentResult(mediaList);
                PictureBaseActivity.this.setResult(-1, intent);
                PictureBaseActivity.this.closeActivity();
            }
        });
    }

    protected void closeActivity() {
        this.finish();
        if (this.config.camera) {
            this.overridePendingTransition(0, R.anim.fade_out);
        } else {
            this.overridePendingTransition(0, R.anim.a3);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.dismissCompressDialog();
        this.dismissDialog();
    }

    protected int getLastImageId(boolean eqVideo) {
        try {
            String absolutePath = PictureFileUtils.getDCIMCameraPath((Context)this);
            String ORDER_BY = "_id DESC";
            String selection = eqVideo ? "_data like ?" : "_data like ?";
            String[] selectionArgs = new String[]{absolutePath + "%"};
            Cursor imageCursor = this.getContentResolver().query(eqVideo ? MediaStore.Video.Media.EXTERNAL_CONTENT_URI : MediaStore.Images.Media.EXTERNAL_CONTENT_URI, null, selection, selectionArgs, ORDER_BY);
            if (imageCursor.moveToFirst()) {
                int id = imageCursor.getInt(eqVideo ? imageCursor.getColumnIndex("_id") : imageCursor.getColumnIndex("_id"));
                long date = imageCursor.getLong(eqVideo ? imageCursor.getColumnIndex("duration") : imageCursor.getColumnIndex("date_added"));
                int duration = DateUtils.dateDiffer(date);
                imageCursor.close();
                return duration <= 30 ? id : -1;
            }
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    protected void removeImage(int id, boolean eqVideo) {
        try {
            ContentResolver cr = this.getContentResolver();
            Uri uri = eqVideo ? MediaStore.Video.Media.EXTERNAL_CONTENT_URI : MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            String selection = eqVideo ? "_id=?" : "_id=?";
            cr.delete(uri, selection, new String[]{Long.toString(id)});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String getAudioPath(Intent data) {
        boolean compare_SDK_19;
        boolean bl = compare_SDK_19 = Build.VERSION.SDK_INT <= 19;
        if (data != null && this.config.chooseMode == PictureMimeType.ofAudio()) {
            try {
                Uri uri = data.getData();
                String audioPath = compare_SDK_19 ? uri.getPath() : this.getAudioFilePathFromUri(uri);
                return audioPath;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    protected String getAudioFilePathFromUri(Uri uri) {
        String path = "";
        try {
            Cursor cursor = this.getContentResolver().query(uri, null, null, null, null);
            cursor.moveToFirst();
            int index = cursor.getColumnIndex("_data");
            path = cursor.getString(index);
            cursor.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return path;
    }

    protected void startOpenCamera() {
        Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (cameraIntent.resolveActivity(this.getPackageManager()) != null) {
            Uri imageUri;
            if (SdkVersionUtils.checkedAndroid_Q()) {
                imageUri = MediaUtils.createImagePathUri(this.getApplicationContext(), this.config.cameraFileName);
                this.cameraPath = imageUri.toString();
            } else {
                int type = this.config.chooseMode == 0 ? 1 : this.config.chooseMode;
                File cameraFile = PictureFileUtils.createCameraFile(this.getApplicationContext(), type, this.config.cameraFileName, this.config.suffixType);
                this.cameraPath = cameraFile.getAbsolutePath();
                imageUri = PictureFileUtils.parUri((Context)this, cameraFile);
            }
            cameraIntent.putExtra("output", (Parcelable)imageUri);
            this.startActivityForResult(cameraIntent, 909);
        }
    }

    protected void startOpenCameraVideo() {
        Intent cameraIntent = new Intent("android.media.action.VIDEO_CAPTURE");
        if (cameraIntent.resolveActivity(this.getPackageManager()) != null) {
            Uri imageUri;
            if (SdkVersionUtils.checkedAndroid_Q()) {
                imageUri = MediaUtils.createImageVideoUri(this.getApplicationContext(), this.config.cameraFileName);
                this.cameraPath = imageUri.toString();
            } else {
                File cameraFile = PictureFileUtils.createCameraFile(this.getApplicationContext(), this.config.chooseMode == 0 ? 2 : this.config.chooseMode, this.config.cameraFileName, this.config.suffixType);
                this.cameraPath = cameraFile.getAbsolutePath();
                imageUri = PictureFileUtils.parUri((Context)this, cameraFile);
            }
            cameraIntent.putExtra("output", (Parcelable)imageUri);
            cameraIntent.putExtra("android.intent.extra.durationLimit", this.config.recordVideoSecond);
            cameraIntent.putExtra("android.intent.extra.videoQuality", this.config.videoQuality);
            this.startActivityForResult(cameraIntent, 909);
        }
    }

    public void startOpenCameraAudio() {
        if (this.rxPermissions == null) {
            this.rxPermissions = new RxPermissions(this);
        }
        this.rxPermissions.request("android.permission.RECORD_AUDIO").subscribe((Observer)new Observer<Boolean>(){

            public void onSubscribe(Disposable d) {
            }

            public void onNext(Boolean aBoolean) {
                if (aBoolean.booleanValue()) {
                    Intent cameraIntent = new Intent("android.provider.MediaStore.RECORD_SOUND");
                    if (cameraIntent.resolveActivity(PictureBaseActivity.this.getPackageManager()) != null) {
                        PictureBaseActivity.this.startActivityForResult(cameraIntent, 909);
                    }
                } else {
                    ToastUtils.s(PictureBaseActivity.this.mContext, PictureBaseActivity.this.getString(R.string.picture_audio));
                }
            }

            public void onError(Throwable e) {
            }

            public void onComplete() {
            }
        });
    }

    protected void multiCropHandleResult(Intent data) {
        ArrayList<LocalMedia> medias = new ArrayList<LocalMedia>();
        List mCuts = UCropMulti.getOutput((Intent)data);
        for (CutInfo c : mCuts) {
            LocalMedia media = new LocalMedia();
            String imageType = PictureMimeType.getImageMimeType(c.getCutPath());
            media.setCut(!TextUtils.isEmpty((CharSequence)c.getCutPath()));
            media.setPath(c.getPath());
            media.setCutPath(c.getCutPath());
            media.setMimeType(imageType);
            media.setWidth(c.getImageWidth());
            media.setHeight(c.getImageHeight());
            media.setSize(new File(TextUtils.isEmpty((CharSequence)c.getCutPath()) ? c.getPath() : c.getCutPath()).length());
            if (SdkVersionUtils.checkedAndroid_Q()) {
                media.setAndroidQToPath(c.getCutPath());
            }
            media.setChooseModel(this.config.chooseMode);
            medias.add(media);
        }
        this.handlerResult(medias);
    }
}

