/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.anim;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.util.AttributeSet;
import android.util.Xml;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.RotateAnimation;
import android.view.animation.ScaleAnimation;
import android.view.animation.TranslateAnimation;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class OptAnimationLoader {
    public static Animation loadAnimation(Context context, int id2) throws Resources.NotFoundException {
        try (XmlResourceParser parser = null;){
            parser = context.getResources().getAnimation(id2);
            Animation animation = OptAnimationLoader.createAnimationFromXml(context, (XmlPullParser)parser);
            return animation;
        }
    }

    private static Animation createAnimationFromXml(Context c, XmlPullParser parser) throws XmlPullParserException, IOException {
        return OptAnimationLoader.createAnimationFromXml(c, parser, null, Xml.asAttributeSet((XmlPullParser)parser));
    }

    private static Animation createAnimationFromXml(Context c, XmlPullParser parser, AnimationSet parent, AttributeSet attrs) throws XmlPullParserException, IOException {
        int type;
        AnimationSet anim2 = null;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            String name = parser.getName();
            if (name.equals("set")) {
                anim2 = new AnimationSet(c, attrs);
                OptAnimationLoader.createAnimationFromXml(c, parser, anim2, attrs);
            } else if (name.equals("alpha")) {
                anim2 = new AlphaAnimation(c, attrs);
            } else if (name.equals("scale")) {
                anim2 = new ScaleAnimation(c, attrs);
            } else if (name.equals("rotate")) {
                anim2 = new RotateAnimation(c, attrs);
            } else if (name.equals("translate")) {
                anim2 = new TranslateAnimation(c, attrs);
            } else {
                try {
                    anim2 = (Animation)Class.forName(name).getConstructor(Context.class, AttributeSet.class).newInstance(c, attrs);
                }
                catch (Exception te) {
                    throw new RuntimeException("Unknown animation name: " + parser.getName() + " error:" + te.getMessage());
                }
            }
            if (parent == null) continue;
            parent.addAnimation((Animation)anim2);
        }
        return anim2;
    }
}

