/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.core.content.FileProvider;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SimpleItemAnimator;
import com.luck.picture.lib.PictureBaseActivity;
import com.luck.picture.lib.PicturePreviewActivity;
import com.luck.picture.lib.PictureSelector;
import com.luck.picture.lib.PictureVideoPlayActivity;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.PictureAlbumDirectoryAdapter;
import com.luck.picture.lib.adapter.PictureImageGridAdapter;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.decoration.GridSpacingItemDecoration;
import com.luck.picture.lib.dialog.CustomDialog;
import com.luck.picture.lib.entity.EventEntity;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.model.LocalMediaLoader;
import com.luck.picture.lib.observable.ImagesObservable;
import com.luck.picture.lib.permissions.RxPermissions;
import com.luck.picture.lib.rxbus2.RxBus;
import com.luck.picture.lib.rxbus2.Subscribe;
import com.luck.picture.lib.rxbus2.ThreadMode;
import com.luck.picture.lib.tools.DateUtils;
import com.luck.picture.lib.tools.DoubleUtils;
import com.luck.picture.lib.tools.MediaUtils;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.ScreenUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.tools.StringUtils;
import com.luck.picture.lib.tools.ToastUtils;
import com.luck.picture.lib.widget.FolderPopWindow;
import com.luck.picture.lib.widget.PhotoPopupWindow;
import com.yalantis.ucrop.UCrop;
import com.yalantis.ucrop.UCropMulti;
import com.yalantis.ucrop.model.CutInfo;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PictureSelectorActivity
extends PictureBaseActivity
implements View.OnClickListener,
PictureAlbumDirectoryAdapter.OnItemClickListener,
PictureImageGridAdapter.OnPhotoSelectChangedListener,
PhotoPopupWindow.OnItemClickListener {
    private static final String TAG = PictureSelectorActivity.class.getSimpleName();
    private static final int SHOW_DIALOG = 0;
    private static final int DISMISS_DIALOG = 1;
    private ImageView mIvPictureLeftBack;
    private TextView mTvPictureTitle;
    private TextView mTvPictureRight;
    private TextView mTvPictureOk;
    private TextView mTvEmpty;
    private TextView mTvPictureImgNum;
    private TextView mTvPicturePreview;
    private TextView mTvPlayPause;
    private TextView mTvStop;
    private TextView mTvQuit;
    private TextView mTvMusicStatus;
    private TextView mTvMusicTotal;
    private TextView mTvMusicTime;
    private RelativeLayout mRlPictureTitle;
    private LinearLayout mOkLayout;
    private RecyclerView mPictureRecycler;
    private RelativeLayout mBottomLayout;
    private PictureImageGridAdapter adapter;
    private List<LocalMedia> images = new ArrayList<LocalMedia>();
    private List<LocalMediaFolder> foldersList = new ArrayList<LocalMediaFolder>();
    private FolderPopWindow folderWindow;
    private Animation animation = null;
    private boolean anim = false;
    private RxPermissions rxPermissions;
    private PhotoPopupWindow popupWindow;
    private LocalMediaLoader mediaLoader;
    private MediaPlayer mediaPlayer;
    private SeekBar musicSeekBar;
    private boolean isPlayAudio = false;
    private CustomDialog audioDialog;
    private int audioH;
    @SuppressLint(value={"HandlerLeak"})
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 0: {
                    PictureSelectorActivity.this.showPleaseDialog();
                    break;
                }
                case 1: {
                    PictureSelectorActivity.this.dismissDialog();
                    break;
                }
            }
        }
    };
    public Handler handler = new Handler();
    public Runnable runnable = new Runnable(){

        @Override
        public void run() {
            try {
                if (PictureSelectorActivity.this.mediaPlayer != null) {
                    PictureSelectorActivity.this.mTvMusicTime.setText((CharSequence)DateUtils.formatDurationTime(PictureSelectorActivity.this.mediaPlayer.getCurrentPosition()));
                    PictureSelectorActivity.this.musicSeekBar.setProgress(PictureSelectorActivity.this.mediaPlayer.getCurrentPosition());
                    PictureSelectorActivity.this.musicSeekBar.setMax(PictureSelectorActivity.this.mediaPlayer.getDuration());
                    PictureSelectorActivity.this.mTvMusicTotal.setText((CharSequence)DateUtils.formatDurationTime(PictureSelectorActivity.this.mediaPlayer.getDuration()));
                    PictureSelectorActivity.this.handler.postDelayed(PictureSelectorActivity.this.runnable, 200L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void eventBus(EventEntity obj) {
        switch (obj.what) {
            case 2774: {
                List<LocalMedia> selectImages = obj.medias;
                this.anim = selectImages.size() > 0;
                int position = obj.position;
                this.adapter.bindSelectImages(selectImages);
                this.adapter.notifyItemChanged(position);
                break;
            }
            case 2771: {
                List<LocalMedia> medias = obj.medias;
                if (medias.size() <= 0) break;
                String mimeType = medias.get(0).getMimeType();
                if (this.config.isCompress && mimeType.startsWith("image")) {
                    this.compressImage(medias);
                    break;
                }
                this.onResult(medias);
                break;
            }
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (!RxBus.getDefault().isRegistered(this)) {
            RxBus.getDefault().register(this);
        }
        this.rxPermissions = new RxPermissions(this);
        if (this.config.camera) {
            if (savedInstanceState == null) {
                this.rxPermissions.request("android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE").subscribe((Observer)new Observer<Boolean>(){

                    public void onSubscribe(Disposable d) {
                    }

                    public void onNext(Boolean aBoolean) {
                        if (aBoolean.booleanValue()) {
                            PictureSelectorActivity.this.onTakePhoto();
                        } else {
                            ToastUtils.s(PictureSelectorActivity.this.mContext, PictureSelectorActivity.this.getString(R.string.picture_camera));
                            PictureSelectorActivity.this.closeActivity();
                        }
                    }

                    public void onError(Throwable e) {
                    }

                    public void onComplete() {
                    }
                });
            }
            this.getWindow().setFlags(1024, 1024);
            this.setContentView(R.layout.picture_empty);
        } else {
            this.setContentView(R.layout.picture_selector);
            this.initView(savedInstanceState);
        }
    }

    private void initView(Bundle savedInstanceState) {
        this.mRlPictureTitle = (RelativeLayout)this.findViewById(R.id.rl_picture_title);
        this.mIvPictureLeftBack = (ImageView)this.findViewById(R.id.picture_left_back);
        this.mTvPictureTitle = (TextView)this.findViewById(R.id.picture_title);
        this.mTvPictureRight = (TextView)this.findViewById(R.id.picture_right);
        this.mTvPictureOk = (TextView)this.findViewById(R.id.picture_tv_ok);
        this.mTvPicturePreview = (TextView)this.findViewById(R.id.picture_id_preview);
        this.mTvPictureImgNum = (TextView)this.findViewById(R.id.picture_tv_img_num);
        this.mPictureRecycler = (RecyclerView)this.findViewById(R.id.picture_recycler);
        this.mBottomLayout = (RelativeLayout)this.findViewById(R.id.rl_bottom);
        this.mOkLayout = (LinearLayout)this.findViewById(R.id.id_ll_ok);
        this.mTvEmpty = (TextView)this.findViewById(R.id.tv_empty);
        this.isNumComplete(this.numComplete);
        if (this.config.chooseMode == PictureMimeType.ofAll()) {
            this.popupWindow = new PhotoPopupWindow((Context)this);
            this.popupWindow.setOnItemClickListener(this);
        }
        this.mTvPicturePreview.setOnClickListener((View.OnClickListener)this);
        if (this.config.chooseMode == PictureMimeType.ofAudio()) {
            this.mTvPicturePreview.setVisibility(8);
            this.audioH = ScreenUtils.getScreenHeight(this.mContext) + ScreenUtils.getStatusBarHeight(this.mContext);
        } else {
            this.mTvPicturePreview.setVisibility(this.config.chooseMode == PictureMimeType.ofVideo() ? 8 : 0);
        }
        this.mBottomLayout.setVisibility(this.config.selectionMode == 1 && this.config.isSingleDirectReturn ? 8 : 0);
        this.mIvPictureLeftBack.setOnClickListener((View.OnClickListener)this);
        this.mTvPictureRight.setOnClickListener((View.OnClickListener)this);
        this.mOkLayout.setOnClickListener((View.OnClickListener)this);
        this.mTvPictureTitle.setOnClickListener((View.OnClickListener)this);
        String title = this.config.chooseMode == PictureMimeType.ofAudio() ? this.getString(R.string.picture_all_audio) : this.getString(R.string.picture_camera_roll);
        this.mTvPictureTitle.setText((CharSequence)title);
        this.folderWindow = new FolderPopWindow((Context)this, this.config.chooseMode, this.config);
        this.folderWindow.setPictureTitleView(this.mTvPictureTitle);
        this.folderWindow.setOnItemClickListener(this);
        this.mPictureRecycler.setHasFixedSize(true);
        this.mPictureRecycler.addItemDecoration((RecyclerView.ItemDecoration)new GridSpacingItemDecoration(this.config.imageSpanCount, ScreenUtils.dip2px((Context)this, 2.0f), false));
        this.mPictureRecycler.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager((Context)this, this.config.imageSpanCount));
        ((SimpleItemAnimator)this.mPictureRecycler.getItemAnimator()).setSupportsChangeAnimations(false);
        this.mediaLoader = new LocalMediaLoader((Context)this, this.config);
        this.rxPermissions.request("android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE").subscribe((Observer)new Observer<Boolean>(){

            public void onSubscribe(Disposable d) {
            }

            public void onNext(Boolean aBoolean) {
                if (aBoolean.booleanValue()) {
                    PictureSelectorActivity.this.mHandler.sendEmptyMessage(0);
                    PictureSelectorActivity.this.readLocalMedia();
                } else {
                    ToastUtils.s(PictureSelectorActivity.this.mContext, PictureSelectorActivity.this.getString(R.string.picture_jurisdiction));
                }
            }

            public void onError(Throwable e) {
            }

            public void onComplete() {
            }
        });
        this.mTvEmpty.setText((CharSequence)(this.config.chooseMode == PictureMimeType.ofAudio() ? this.getString(R.string.picture_audio_empty) : this.getString(R.string.picture_empty)));
        StringUtils.tempTextFont(this.mTvEmpty, this.config.chooseMode);
        if (savedInstanceState != null) {
            this.selectionMedias = PictureSelector.obtainSelectorList(savedInstanceState);
        }
        this.adapter = new PictureImageGridAdapter(this.mContext, this.config);
        this.adapter.setOnPhotoSelectChangedListener(this);
        this.adapter.bindSelectImages(this.selectionMedias);
        this.mPictureRecycler.setAdapter((RecyclerView.Adapter)this.adapter);
        String titleText = this.mTvPictureTitle.getText().toString().trim();
        if (this.config.isCamera) {
            this.config.isCamera = StringUtils.isCamera(titleText);
        }
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.adapter != null) {
            List<LocalMedia> selectedImages = this.adapter.getSelectedImages();
            PictureSelector.saveSelectorList(outState, selectedImages);
        }
    }

    private void isNumComplete(boolean numComplete) {
        this.mTvPictureOk.setText((CharSequence)(numComplete ? this.getString(R.string.picture_done_front_num, new Object[]{0, this.config.selectionMode == 1 ? 1 : this.config.maxSelectNum}) : this.getString(R.string.picture_please_select)));
        if (!numComplete) {
            this.animation = AnimationUtils.loadAnimation((Context)this, (int)R.anim.modal_in);
        }
        this.animation = numComplete ? null : AnimationUtils.loadAnimation((Context)this, (int)R.anim.modal_in);
    }

    protected void readLocalMedia() {
        this.mediaLoader.loadAllMedia(folders -> {
            if (folders.size() > 0) {
                this.foldersList = folders;
                LocalMediaFolder folder = (LocalMediaFolder)folders.get(0);
                folder.setChecked(true);
                List<LocalMedia> localImg = folder.getImages();
                if (localImg.size() >= this.images.size()) {
                    this.images = localImg;
                    this.folderWindow.bindFolder(folders);
                }
            }
            if (this.adapter != null) {
                if (this.images == null) {
                    this.images = new ArrayList<LocalMedia>();
                }
                this.adapter.bindImagesData(this.images);
                this.mTvEmpty.setVisibility(this.images.size() > 0 ? 4 : 0);
            }
            this.mHandler.sendEmptyMessage(1);
        });
    }

    public void startCamera() {
        if (!DoubleUtils.isFastDoubleClick() || this.config.camera) {
            switch (this.config.chooseMode) {
                case 0: {
                    if (this.popupWindow != null) {
                        if (this.popupWindow.isShowing()) {
                            this.popupWindow.dismiss();
                        }
                        this.popupWindow.showAsDropDown((View)this.mRlPictureTitle);
                        break;
                    }
                    this.startOpenCamera();
                    break;
                }
                case 1: {
                    this.startOpenCamera();
                    break;
                }
                case 2: {
                    this.startOpenCameraVideo();
                    break;
                }
                case 3: {
                    this.startOpenCameraAudio();
                    break;
                }
            }
        }
    }

    public void startOpenCamera() {
        Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (cameraIntent.resolveActivity(this.getPackageManager()) != null) {
            Uri imageUri;
            if (SdkVersionUtils.checkedAndroid_Q()) {
                imageUri = MediaUtils.createImagePathUri(this.getApplicationContext(), this.config.cameraFileName);
                this.cameraPath = imageUri.toString();
            } else {
                int type = this.config.chooseMode == 0 ? 1 : this.config.chooseMode;
                File cameraFile = PictureFileUtils.createCameraFile(this.getApplicationContext(), type, this.config.cameraFileName, this.config.suffixType);
                this.cameraPath = cameraFile.getAbsolutePath();
                imageUri = this.parUri(cameraFile);
            }
            cameraIntent.putExtra("output", (Parcelable)imageUri);
            this.startActivityForResult(cameraIntent, 909);
        }
    }

    public void startOpenCameraVideo() {
        Intent cameraIntent = new Intent("android.media.action.VIDEO_CAPTURE");
        if (cameraIntent.resolveActivity(this.getPackageManager()) != null) {
            Uri imageUri;
            if (SdkVersionUtils.checkedAndroid_Q()) {
                imageUri = MediaUtils.createImageVideoUri(this.getApplicationContext(), this.config.cameraFileName);
                this.cameraPath = imageUri.toString();
            } else {
                File cameraFile = PictureFileUtils.createCameraFile(this.getApplicationContext(), this.config.chooseMode == 0 ? 2 : this.config.chooseMode, this.config.cameraFileName, this.config.suffixType);
                this.cameraPath = cameraFile.getAbsolutePath();
                imageUri = this.parUri(cameraFile);
            }
            cameraIntent.putExtra("output", (Parcelable)imageUri);
            cameraIntent.putExtra("android.intent.extra.durationLimit", this.config.recordVideoSecond);
            cameraIntent.putExtra("android.intent.extra.videoQuality", this.config.videoQuality);
            this.startActivityForResult(cameraIntent, 909);
        }
    }

    public void startOpenCameraAudio() {
        this.rxPermissions.request("android.permission.RECORD_AUDIO").subscribe((Observer)new Observer<Boolean>(){

            public void onSubscribe(Disposable d) {
            }

            public void onNext(Boolean aBoolean) {
                if (aBoolean.booleanValue()) {
                    Intent cameraIntent = new Intent("android.provider.MediaStore.RECORD_SOUND");
                    if (cameraIntent.resolveActivity(PictureSelectorActivity.this.getPackageManager()) != null) {
                        PictureSelectorActivity.this.startActivityForResult(cameraIntent, 909);
                    }
                } else {
                    ToastUtils.s(PictureSelectorActivity.this.mContext, PictureSelectorActivity.this.getString(R.string.picture_audio));
                }
            }

            public void onError(Throwable e) {
            }

            public void onComplete() {
            }
        });
    }

    private Uri parUri(File cameraFile) {
        String authority = this.getPackageName() + ".provider";
        Uri imageUri = Build.VERSION.SDK_INT > 23 ? FileProvider.getUriForFile((Context)this.mContext, (String)authority, (File)cameraFile) : Uri.fromFile((File)cameraFile);
        return imageUri;
    }

    public void onClick(View v) {
        List<LocalMedia> selectedImages;
        int id2 = v.getId();
        if (id2 == R.id.picture_left_back || id2 == R.id.picture_right) {
            if (this.folderWindow.isShowing()) {
                this.folderWindow.dismiss();
            } else {
                this.closeActivity();
            }
        }
        if (id2 == R.id.picture_title) {
            if (this.folderWindow.isShowing()) {
                this.folderWindow.dismiss();
            } else if (this.images != null && this.images.size() > 0) {
                this.folderWindow.showAsDropDown((View)this.mRlPictureTitle);
                selectedImages = this.adapter.getSelectedImages();
                this.folderWindow.notifyDataCheckedStatus(selectedImages);
            }
        }
        if (id2 == R.id.picture_id_preview) {
            selectedImages = this.adapter.getSelectedImages();
            ArrayList<LocalMedia> medias = new ArrayList<LocalMedia>();
            for (LocalMedia media : selectedImages) {
                medias.add(media);
            }
            Bundle bundle = new Bundle();
            bundle.putSerializable("previewSelectList", (Serializable)medias);
            bundle.putSerializable("selectList", (Serializable)((Object)selectedImages));
            bundle.putBoolean("bottom_preview", true);
            this.startActivity(PicturePreviewActivity.class, bundle, this.config.selectionMode == 1 ? 69 : 609);
            this.overridePendingTransition(R.anim.a5, 0);
        }
        if (id2 == R.id.id_ll_ok) {
            List<LocalMedia> images = this.adapter.getSelectedImages();
            LocalMedia image = images.size() > 0 ? images.get(0) : null;
            String mimeType = image != null ? image.getMimeType() : "";
            int size = images.size();
            boolean eqImg = mimeType.startsWith("image");
            if (this.config.minSelectNum > 0 && this.config.selectionMode == 2 && size < this.config.minSelectNum) {
                String str = eqImg ? this.getString(R.string.picture_min_img_num, new Object[]{this.config.minSelectNum}) : this.getString(R.string.picture_min_video_num, new Object[]{this.config.minSelectNum});
                ToastUtils.s(this.mContext, str);
                return;
            }
            if (this.config.enableCrop && eqImg) {
                if (this.config.selectionMode == 1) {
                    this.originalPath = image.getPath();
                    this.startCrop(this.originalPath);
                } else {
                    ArrayList<String> medias = new ArrayList<String>();
                    for (LocalMedia media : images) {
                        medias.add(media.getPath());
                    }
                    this.startCrop(medias);
                }
            } else if (this.config.isCompress && eqImg) {
                this.compressImage(images);
            } else {
                this.onResult(images);
            }
        }
    }

    private void audioDialog(String path) {
        this.audioDialog = new CustomDialog(this.mContext, -1, this.audioH, R.layout.picture_audio_dialog, R.style.Theme_dialog);
        this.audioDialog.getWindow().setWindowAnimations(R.style.Dialog_Audio_StyleAnim);
        this.mTvMusicStatus = (TextView)this.audioDialog.findViewById(R.id.tv_musicStatus);
        this.mTvMusicTime = (TextView)this.audioDialog.findViewById(R.id.tv_musicTime);
        this.musicSeekBar = (SeekBar)this.audioDialog.findViewById(R.id.musicSeekBar);
        this.mTvMusicTotal = (TextView)this.audioDialog.findViewById(R.id.tv_musicTotal);
        this.mTvPlayPause = (TextView)this.audioDialog.findViewById(R.id.tv_PlayPause);
        this.mTvStop = (TextView)this.audioDialog.findViewById(R.id.tv_Stop);
        this.mTvQuit = (TextView)this.audioDialog.findViewById(R.id.tv_Quit);
        this.handler.postDelayed(() -> this.initPlayer(path), 30L);
        this.mTvPlayPause.setOnClickListener((View.OnClickListener)new audioOnClick(path));
        this.mTvStop.setOnClickListener((View.OnClickListener)new audioOnClick(path));
        this.mTvQuit.setOnClickListener((View.OnClickListener)new audioOnClick(path));
        this.musicSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (fromUser) {
                    PictureSelectorActivity.this.mediaPlayer.seekTo(progress);
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        this.audioDialog.setOnDismissListener(dialog -> {
            this.handler.removeCallbacks(this.runnable);
            new Handler().postDelayed(() -> this.stop(path), 30L);
            try {
                if (this.audioDialog != null && this.audioDialog.isShowing()) {
                    this.audioDialog.dismiss();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.handler.post(this.runnable);
        this.audioDialog.show();
    }

    private void initPlayer(String path) {
        this.mediaPlayer = new MediaPlayer();
        try {
            this.mediaPlayer.setDataSource(path);
            this.mediaPlayer.prepare();
            this.mediaPlayer.setLooping(true);
            this.playAudio();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void playAudio() {
        String ppStr;
        if (this.mediaPlayer != null) {
            this.musicSeekBar.setProgress(this.mediaPlayer.getCurrentPosition());
            this.musicSeekBar.setMax(this.mediaPlayer.getDuration());
        }
        if ((ppStr = this.mTvPlayPause.getText().toString()).equals(this.getString(R.string.picture_play_audio))) {
            this.mTvPlayPause.setText((CharSequence)this.getString(R.string.picture_pause_audio));
            this.mTvMusicStatus.setText((CharSequence)this.getString(R.string.picture_play_audio));
            this.playOrPause();
        } else {
            this.mTvPlayPause.setText((CharSequence)this.getString(R.string.picture_play_audio));
            this.mTvMusicStatus.setText((CharSequence)this.getString(R.string.picture_pause_audio));
            this.playOrPause();
        }
        if (!this.isPlayAudio) {
            this.handler.post(this.runnable);
            this.isPlayAudio = true;
        }
    }

    public void stop(String path) {
        if (this.mediaPlayer != null) {
            try {
                this.mediaPlayer.stop();
                this.mediaPlayer.reset();
                this.mediaPlayer.setDataSource(path);
                this.mediaPlayer.prepare();
                this.mediaPlayer.seekTo(0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void playOrPause() {
        try {
            if (this.mediaPlayer != null) {
                if (this.mediaPlayer.isPlaying()) {
                    this.mediaPlayer.pause();
                } else {
                    this.mediaPlayer.start();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onItemClick(String folderName, List<LocalMedia> images) {
        boolean camera = StringUtils.isCamera(folderName);
        camera = this.config.isCamera ? camera : false;
        this.adapter.setShowCamera(camera);
        this.mTvPictureTitle.setText((CharSequence)folderName);
        this.adapter.bindImagesData(images);
        this.folderWindow.dismiss();
    }

    @Override
    public void onTakePhoto() {
        this.rxPermissions.request("android.permission.CAMERA").subscribe((Observer)new Observer<Boolean>(){

            public void onSubscribe(Disposable d) {
            }

            public void onNext(Boolean aBoolean) {
                if (aBoolean.booleanValue()) {
                    PictureSelectorActivity.this.startCamera();
                } else {
                    ToastUtils.s(PictureSelectorActivity.this.mContext, PictureSelectorActivity.this.getString(R.string.picture_camera));
                    if (PictureSelectorActivity.this.config.camera) {
                        PictureSelectorActivity.this.closeActivity();
                    }
                }
            }

            public void onError(Throwable e) {
            }

            public void onComplete() {
            }
        });
    }

    @Override
    public void onChange(List<LocalMedia> selectImages) {
        this.changeImageNumber(selectImages);
    }

    @Override
    public void onPictureClick(LocalMedia media, int position) {
        if (this.config.selectionMode == 1 && this.config.isSingleDirectReturn) {
            ArrayList<LocalMedia> list = new ArrayList<LocalMedia>();
            list.add(media);
            if (this.config.enableCrop) {
                this.adapter.bindSelectImages(list);
                this.startCrop(media.getPath());
            } else {
                this.handlerResult(list);
            }
        } else {
            List<LocalMedia> images = this.adapter.getImages();
            this.startPreview(images, position);
        }
    }

    public void startPreview(List<LocalMedia> previewImages, int position) {
        LocalMedia media = previewImages.get(position);
        String mimeType = media.getMimeType();
        Bundle bundle = new Bundle();
        ArrayList<LocalMedia> result = new ArrayList<LocalMedia>();
        int mediaType = PictureMimeType.isPictureType(mimeType);
        switch (mediaType) {
            case 1: {
                List<LocalMedia> selectedImages = this.adapter.getSelectedImages();
                ImagesObservable.getInstance().saveLocalMedia(previewImages);
                bundle.putSerializable("selectList", (Serializable)((Object)selectedImages));
                bundle.putInt("position", position);
                this.startActivity(PicturePreviewActivity.class, bundle, this.config.selectionMode == 1 ? 69 : 609);
                this.overridePendingTransition(R.anim.a5, 0);
                break;
            }
            case 2: {
                if (this.config.selectionMode == 1) {
                    result.add(media);
                    this.onResult(result);
                    break;
                }
                bundle.putString("video_path", media.getPath());
                this.startActivity(PictureVideoPlayActivity.class, bundle);
                break;
            }
            case 3: {
                if (this.config.selectionMode == 1) {
                    result.add(media);
                    this.onResult(result);
                    break;
                }
                this.audioDialog(media.getPath());
                break;
            }
        }
    }

    public void changeImageNumber(List<LocalMedia> selectImages) {
        boolean enable;
        String mimeType;
        String string2 = mimeType = selectImages.size() > 0 ? selectImages.get(0).getMimeType() : "";
        if (this.config.chooseMode == PictureMimeType.ofAudio()) {
            this.mTvPicturePreview.setVisibility(8);
        } else {
            boolean isVideo = PictureMimeType.isVideo(mimeType);
            boolean eqVideo = this.config.chooseMode == 2;
            this.mTvPicturePreview.setVisibility(isVideo || eqVideo ? 8 : 0);
        }
        boolean bl = enable = selectImages.size() != 0;
        if (enable) {
            this.mOkLayout.setEnabled(true);
            this.mTvPicturePreview.setEnabled(true);
            this.mTvPicturePreview.setSelected(true);
            this.mTvPictureOk.setSelected(true);
            if (this.numComplete) {
                this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_done_front_num, new Object[]{selectImages.size(), this.config.selectionMode == 1 ? 1 : this.config.maxSelectNum}));
            } else {
                if (!this.anim) {
                    this.mTvPictureImgNum.startAnimation(this.animation);
                }
                this.mTvPictureImgNum.setVisibility(0);
                this.mTvPictureImgNum.setText((CharSequence)String.valueOf(selectImages.size()));
                this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_completed));
                this.anim = false;
            }
        } else {
            this.mOkLayout.setEnabled(false);
            this.mTvPicturePreview.setEnabled(false);
            this.mTvPicturePreview.setSelected(false);
            this.mTvPictureOk.setSelected(false);
            if (this.numComplete) {
                this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_done_front_num, new Object[]{0, this.config.selectionMode == 1 ? 1 : this.config.maxSelectNum}));
            } else {
                this.mTvPictureImgNum.setVisibility(4);
                this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_please_select));
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1) {
            switch (requestCode) {
                case 69: {
                    this.singleCropHandleResult(data);
                    break;
                }
                case 609: {
                    this.multiCropHandleResult(data);
                    break;
                }
                case 909: {
                    this.requestCamera(data);
                    break;
                }
            }
        } else if (resultCode == 0) {
            if (this.config.camera) {
                this.closeActivity();
            }
        } else if (resultCode == 96) {
            Throwable throwable = (Throwable)data.getSerializableExtra("com.yalantis.ucrop.Error");
            ToastUtils.s(this.mContext, throwable.getMessage());
        }
    }

    private void cameraHandleResult(List<LocalMedia> medias, LocalMedia media, String toType) {
        boolean eqImg = toType.startsWith("image");
        if (this.config.enableCrop && eqImg) {
            this.originalPath = this.cameraPath;
            this.startCrop(this.cameraPath);
        } else if (this.config.isCompress && eqImg) {
            medias.add(media);
            this.compressImage(medias);
            if (this.adapter != null) {
                this.images.add(0, media);
                this.adapter.notifyDataSetChanged();
            }
        } else {
            medias.add(media);
            this.onResult(medias);
        }
    }

    private void requestCamera(Intent data) {
        int lastImageId;
        String toType;
        long size;
        File file;
        ArrayList<LocalMedia> medias = new ArrayList<LocalMedia>();
        if (this.config.chooseMode == PictureMimeType.ofAudio()) {
            this.cameraPath = this.getAudioPath(data);
        }
        if ((file = new File(this.cameraPath)) == null) {
            return;
        }
        this.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.fromFile((File)file)));
        boolean isAndroidQ = SdkVersionUtils.checkedAndroid_Q();
        if (isAndroidQ) {
            String path = PictureFileUtils.getPath(this.getApplicationContext(), Uri.parse((String)this.cameraPath));
            File f = new File(path);
            size = f.length();
            toType = PictureMimeType.fileToType(f);
        } else {
            toType = PictureMimeType.fileToType(file);
            size = new File(this.cameraPath).length();
        }
        if (this.config.chooseMode != PictureMimeType.ofAudio()) {
            int degree = PictureFileUtils.readPictureDegree(file.getAbsolutePath());
            this.rotateImage(degree, file);
        }
        LocalMedia media = new LocalMedia();
        media.setPath(this.cameraPath);
        boolean eqVideo = toType.startsWith("video");
        String mimeType = this.config.chooseMode == PictureMimeType.ofAudio() ? "audio/mpeg" : (eqVideo ? (isAndroidQ ? PictureMimeType.getMimeType(this.mContext, Uri.parse((String)this.cameraPath)) : PictureMimeType.getVideoMimeType(this.cameraPath)) : (isAndroidQ ? PictureMimeType.getMimeType(this.mContext, Uri.parse((String)this.cameraPath)) : PictureMimeType.getImageMimeType(this.cameraPath)));
        long duration = MediaUtils.extractDuration(this.mContext, isAndroidQ, this.cameraPath);
        media.setMimeType(mimeType);
        media.setDuration(duration);
        media.setSize(size);
        media.setChooseModel(this.config.chooseMode);
        if (this.config.camera) {
            this.cameraHandleResult(medias, media, toType);
        } else if (this.config.selectionMode == 1 && this.config.isSingleDirectReturn) {
            if (this.adapter != null) {
                medias.add(media);
                this.adapter.bindSelectImages(medias);
                this.cameraHandleResult(medias, media, toType);
            }
        } else {
            this.images.add(0, media);
            if (this.adapter != null) {
                boolean toEqual;
                List<LocalMedia> selectedImages = this.adapter.getSelectedImages();
                if (selectedImages.size() < this.config.maxSelectNum && ((toEqual = PictureMimeType.mimeToEqual(mimeType = selectedImages.size() > 0 ? selectedImages.get(0).getMimeType() : "", media.getMimeType())) || selectedImages.size() == 0) && selectedImages.size() < this.config.maxSelectNum) {
                    if (this.config.selectionMode == 1) {
                        this.singleRadioMediaImage();
                    }
                    selectedImages.add(media);
                    this.adapter.bindSelectImages(selectedImages);
                }
                this.adapter.notifyDataSetChanged();
            }
        }
        if (this.adapter != null) {
            this.manualSaveFolder(media);
            this.mTvEmpty.setVisibility(this.images.size() > 0 ? 4 : 0);
        }
        if (this.config.chooseMode != PictureMimeType.ofAudio() && (lastImageId = this.getLastImageId(eqVideo)) != -1) {
            this.removeImage(lastImageId, eqVideo);
        }
    }

    private void singleCropHandleResult(Intent data) {
        ArrayList<LocalMedia> medias = new ArrayList<LocalMedia>();
        Uri resultUri = UCrop.getOutput((Intent)data);
        String cutPath = resultUri.getPath();
        if (this.adapter != null) {
            LocalMedia media;
            List<LocalMedia> mediaList = this.adapter.getSelectedImages();
            LocalMedia localMedia = media = mediaList != null && mediaList.size() > 0 ? mediaList.get(0) : null;
            if (media != null) {
                this.originalPath = media.getPath();
                media.setCutPath(cutPath);
                media.setSize(new File(cutPath).length());
                media.setChooseModel(this.config.chooseMode);
                media.setCut(true);
                String mimeType = PictureMimeType.getImageMimeType(cutPath);
                media.setMimeType(mimeType);
                if (SdkVersionUtils.checkedAndroid_Q()) {
                    media.setAndroidQToPath(cutPath);
                }
                medias.add(media);
                this.handlerResult(medias);
            }
        } else if (this.config.camera) {
            LocalMedia media = new LocalMedia(this.cameraPath, 0L, false, this.config.isCamera ? 1 : 0, 0, this.config.chooseMode);
            media.setCut(true);
            media.setCutPath(cutPath);
            String mimeType = PictureMimeType.getImageMimeType(cutPath);
            media.setMimeType(mimeType);
            medias.add(media);
            this.handlerResult(medias);
        }
    }

    private void multiCropHandleResult(Intent data) {
        ArrayList<LocalMedia> medias = new ArrayList<LocalMedia>();
        List mCuts = UCropMulti.getOutput((Intent)data);
        for (CutInfo c : mCuts) {
            LocalMedia media = new LocalMedia();
            String imageType = PictureMimeType.getImageMimeType(c.getCutPath());
            media.setCut(!TextUtils.isEmpty((CharSequence)c.getCutPath()));
            media.setPath(c.getPath());
            media.setCutPath(c.getCutPath());
            media.setMimeType(imageType);
            media.setWidth(c.getImageWidth());
            media.setHeight(c.getImageHeight());
            media.setSize(new File(TextUtils.isEmpty((CharSequence)c.getCutPath()) ? c.getPath() : c.getCutPath()).length());
            if (SdkVersionUtils.checkedAndroid_Q()) {
                media.setAndroidQToPath(c.getCutPath());
            }
            media.setChooseModel(this.config.chooseMode);
            medias.add(media);
        }
        this.handlerResult(medias);
    }

    private void singleRadioMediaImage() {
        List<LocalMedia> selectImages;
        if (this.adapter != null && (selectImages = this.adapter.getSelectedImages()) != null && selectImages.size() > 0) {
            selectImages.clear();
        }
    }

    private void manualSaveFolder(LocalMedia media) {
        try {
            LocalMediaFolder cameraFolder;
            this.createNewFolder(this.foldersList);
            LocalMediaFolder folder = this.getImageFolder(media.getPath(), this.foldersList);
            LocalMediaFolder localMediaFolder = cameraFolder = this.foldersList.size() > 0 ? this.foldersList.get(0) : null;
            if (cameraFolder != null && folder != null) {
                cameraFolder.setFirstImagePath(media.getPath());
                cameraFolder.setImages(this.images);
                cameraFolder.setImageNum(cameraFolder.getImageNum() + 1);
                int num = folder.getImageNum() + 1;
                folder.setImageNum(num);
                folder.getImages().add(0, media);
                folder.setFirstImagePath(this.cameraPath);
                this.folderWindow.bindFolder(this.foldersList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.closeActivity();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (RxBus.getDefault().isRegistered(this)) {
            RxBus.getDefault().unregister(this);
        }
        ImagesObservable.getInstance().clearLocalMedia();
        if (this.animation != null) {
            this.animation.cancel();
            this.animation = null;
        }
        if (this.mediaPlayer != null && this.handler != null) {
            this.handler.removeCallbacks(this.runnable);
            this.mediaPlayer.release();
            this.mediaPlayer = null;
        }
    }

    @Override
    public void onItemClick(int position) {
        switch (position) {
            case 0: {
                this.startOpenCamera();
                break;
            }
            case 1: {
                this.startOpenCameraVideo();
                break;
            }
        }
    }

    public class audioOnClick
    implements View.OnClickListener {
        private String path;

        public audioOnClick(String path) {
            this.path = path;
        }

        public void onClick(View v) {
            int id2 = v.getId();
            if (id2 == R.id.tv_PlayPause) {
                PictureSelectorActivity.this.playAudio();
            }
            if (id2 == R.id.tv_Stop) {
                PictureSelectorActivity.this.mTvMusicStatus.setText((CharSequence)PictureSelectorActivity.this.getString(R.string.picture_stop_audio));
                PictureSelectorActivity.this.mTvPlayPause.setText((CharSequence)PictureSelectorActivity.this.getString(R.string.picture_play_audio));
                PictureSelectorActivity.this.stop(this.path);
            }
            if (id2 == R.id.tv_Quit) {
                PictureSelectorActivity.this.handler.removeCallbacks(PictureSelectorActivity.this.runnable);
                new Handler().postDelayed(() -> PictureSelectorActivity.this.stop(this.path), 30L);
                try {
                    if (PictureSelectorActivity.this.audioDialog != null && PictureSelectorActivity.this.audioDialog.isShowing()) {
                        PictureSelectorActivity.this.audioDialog.dismiss();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

