/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.luck.picture.lib.PictureBaseActivity;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.dialog.CustomDialog;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.permissions.RxPermissions;
import com.luck.picture.lib.photoview.PhotoView;
import com.luck.picture.lib.tools.MediaUtils;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.ScreenUtils;
import com.luck.picture.lib.tools.ToastUtils;
import com.luck.picture.lib.widget.PreviewViewPager;
import com.luck.picture.lib.widget.longimage.ImageSource;
import com.luck.picture.lib.widget.longimage.ImageViewState;
import com.luck.picture.lib.widget.longimage.SubsamplingScaleImageView;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class PictureExternalPreviewActivity
extends PictureBaseActivity
implements View.OnClickListener {
    private ImageButton left_back;
    private TextView tv_title;
    private PreviewViewPager viewPager;
    private List<LocalMedia> images = new ArrayList<LocalMedia>();
    private int position = 0;
    @Deprecated
    private String directory_path;
    private SimpleFragmentAdapter adapter;
    private LayoutInflater inflater;
    private RxPermissions rxPermissions;
    private loadDataThread loadDataThread;
    private Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 200: {
                    String path = (String)msg.obj;
                    ToastUtils.s(PictureExternalPreviewActivity.this.mContext, PictureExternalPreviewActivity.this.getString(R.string.picture_save_success) + "\n" + path);
                    PictureExternalPreviewActivity.this.dismissDialog();
                }
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.picture_activity_external_preview);
        this.inflater = LayoutInflater.from((Context)this);
        this.tv_title = (TextView)this.findViewById(R.id.picture_title);
        this.left_back = (ImageButton)this.findViewById(R.id.left_back);
        this.viewPager = (PreviewViewPager)this.findViewById(R.id.preview_pager);
        this.position = this.getIntent().getIntExtra("position", 0);
        this.directory_path = this.getIntent().getStringExtra("directory_path");
        this.images = (List)((Object)this.getIntent().getSerializableExtra("previewSelectList"));
        this.left_back.setOnClickListener((View.OnClickListener)this);
        this.initViewPageAdapterData();
    }

    private void initViewPageAdapterData() {
        this.tv_title.setText((CharSequence)(this.position + 1 + "/" + this.images.size()));
        this.adapter = new SimpleFragmentAdapter();
        this.viewPager.setAdapter(this.adapter);
        this.viewPager.setCurrentItem(this.position);
        this.viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                PictureExternalPreviewActivity.this.tv_title.setText((CharSequence)(position + 1 + "/" + PictureExternalPreviewActivity.this.images.size()));
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    public void onClick(View v) {
        this.finish();
        this.overridePendingTransition(0, R.anim.a3);
    }

    private void displayLongPic(Bitmap bmp, SubsamplingScaleImageView longImg) {
        longImg.setQuickScaleEnabled(true);
        longImg.setZoomEnabled(true);
        longImg.setPanEnabled(true);
        longImg.setDoubleTapZoomDuration(100);
        longImg.setMinimumScaleType(2);
        longImg.setDoubleTapZoomDpi(2);
        longImg.setImage(ImageSource.cachedBitmap(bmp), new ImageViewState(0.0f, new PointF(0.0f, 0.0f), 0));
    }

    private void showDownLoadDialog(String path) {
        CustomDialog dialog = new CustomDialog((Context)this, ScreenUtils.getScreenWidth((Context)this) * 3 / 4, ScreenUtils.getScreenHeight((Context)this) / 4, R.layout.picture_wind_base_dialog_xml, R.style.Theme_dialog);
        Button btn_cancel = (Button)dialog.findViewById(R.id.btn_cancel);
        Button btn_commit = (Button)dialog.findViewById(R.id.btn_commit);
        TextView tv_title = (TextView)dialog.findViewById(R.id.tv_title);
        TextView tv_content = (TextView)dialog.findViewById(R.id.tv_content);
        tv_title.setText((CharSequence)this.getString(R.string.picture_prompt));
        tv_content.setText((CharSequence)this.getString(R.string.picture_prompt_content));
        btn_cancel.setOnClickListener(view -> dialog.dismiss());
        btn_commit.setOnClickListener(view -> {
            this.showPleaseDialog();
            boolean isHttp = PictureMimeType.isHttp(path);
            if (isHttp) {
                this.loadDataThread = new loadDataThread(path);
                this.loadDataThread.start();
            } else {
                try {
                    String dirPath = PictureFileUtils.createDir((Context)this, System.currentTimeMillis() + ".png");
                    PictureFileUtils.copyFile(path, dirPath);
                    ToastUtils.s(this.mContext, this.getString(R.string.picture_save_success) + "\n" + dirPath);
                    this.dismissDialog();
                }
                catch (IOException e) {
                    ToastUtils.s(this.mContext, this.getString(R.string.picture_save_error) + "\n" + e.getMessage());
                    this.dismissDialog();
                    e.printStackTrace();
                }
            }
            dialog.dismiss();
        });
        dialog.show();
    }

    public void showLoadingImage(String urlPath) {
        try {
            int read;
            URL u = new URL(urlPath);
            String path = PictureFileUtils.createDir((Context)this, System.currentTimeMillis() + ".png");
            byte[] buffer = new byte[8192];
            int ava = 0;
            long start = System.currentTimeMillis();
            BufferedInputStream bin = new BufferedInputStream(u.openStream());
            BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(path));
            while ((read = bin.read(buffer)) > -1) {
                bout.write(buffer, 0, read);
                long l = (long)(ava += read) / (System.currentTimeMillis() - start);
            }
            bout.flush();
            bout.close();
            Message message = this.handler.obtainMessage();
            message.what = 200;
            message.obj = path;
            this.handler.sendMessage(message);
        }
        catch (IOException e) {
            ToastUtils.s(this.mContext, this.getString(R.string.picture_save_error) + "\n" + e.getMessage());
            e.printStackTrace();
        }
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.finish();
        this.overridePendingTransition(0, R.anim.a3);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.loadDataThread != null) {
            this.handler.removeCallbacks((Runnable)this.loadDataThread);
            this.loadDataThread = null;
        }
    }

    public class loadDataThread
    extends Thread {
        private String path;

        public loadDataThread(String path) {
            this.path = path;
        }

        @Override
        public void run() {
            try {
                PictureExternalPreviewActivity.this.showLoadingImage(this.path);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class SimpleFragmentAdapter
    extends PagerAdapter {
        public int getCount() {
            return PictureExternalPreviewActivity.this.images.size();
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            container.removeView((View)object);
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == object;
        }

        public Object instantiateItem(ViewGroup container, int position) {
            View contentView = PictureExternalPreviewActivity.this.inflater.inflate(R.layout.picture_image_preview, container, false);
            final PhotoView imageView = (PhotoView)contentView.findViewById(R.id.preview_image);
            final SubsamplingScaleImageView longImg = (SubsamplingScaleImageView)contentView.findViewById(R.id.longImg);
            LocalMedia media = (LocalMedia)PictureExternalPreviewActivity.this.images.get(position);
            if (media != null) {
                String mimeType = media.getMimeType();
                final String path = media.isCut() && !media.isCompressed() ? media.getCutPath() : (media.isCompressed() || media.isCut() && media.isCompressed() ? media.getCompressPath() : media.getPath());
                boolean isHttp = PictureMimeType.isHttp(path);
                if (isHttp) {
                    PictureExternalPreviewActivity.this.showPleaseDialog();
                }
                boolean isGif = PictureMimeType.isGif(mimeType);
                final boolean eqLongImg = MediaUtils.isLongImg(media);
                imageView.setVisibility(eqLongImg && !isGif ? 8 : 0);
                longImg.setVisibility(eqLongImg && !isGif ? 0 : 8);
                if (isGif && !media.isCompressed()) {
                    RequestOptions gifOptions = (RequestOptions)((RequestOptions)((RequestOptions)new RequestOptions().override(480, 800)).priority(Priority.HIGH)).diskCacheStrategy(DiskCacheStrategy.NONE);
                    Glide.with((FragmentActivity)PictureExternalPreviewActivity.this).asGif().apply((BaseRequestOptions)gifOptions).load(path).listener((RequestListener)new RequestListener<GifDrawable>(){

                        public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<GifDrawable> target, boolean isFirstResource) {
                            PictureExternalPreviewActivity.this.dismissDialog();
                            return false;
                        }

                        public boolean onResourceReady(GifDrawable resource, Object model, Target<GifDrawable> target, DataSource dataSource, boolean isFirstResource) {
                            PictureExternalPreviewActivity.this.dismissDialog();
                            return false;
                        }
                    }).into((ImageView)imageView);
                } else {
                    RequestOptions options = (RequestOptions)new RequestOptions().diskCacheStrategy(DiskCacheStrategy.ALL);
                    Glide.with((FragmentActivity)PictureExternalPreviewActivity.this).asBitmap().load(path).apply((BaseRequestOptions)options).into((Target)new SimpleTarget<Bitmap>(480, 800){

                        public void onLoadFailed(@Nullable Drawable errorDrawable) {
                            super.onLoadFailed(errorDrawable);
                            PictureExternalPreviewActivity.this.dismissDialog();
                        }

                        public void onResourceReady(Bitmap resource, Transition<? super Bitmap> transition) {
                            PictureExternalPreviewActivity.this.dismissDialog();
                            if (eqLongImg) {
                                PictureExternalPreviewActivity.this.displayLongPic(resource, longImg);
                            } else {
                                imageView.setImageBitmap(resource);
                            }
                        }
                    });
                }
                imageView.setOnViewTapListener((view, x, y) -> {
                    PictureExternalPreviewActivity.this.finish();
                    PictureExternalPreviewActivity.this.overridePendingTransition(0, R.anim.a3);
                });
                longImg.setOnClickListener(v -> {
                    PictureExternalPreviewActivity.this.finish();
                    PictureExternalPreviewActivity.this.overridePendingTransition(0, R.anim.a3);
                });
                imageView.setOnLongClickListener(v -> {
                    if (PictureExternalPreviewActivity.this.rxPermissions == null) {
                        PictureExternalPreviewActivity.this.rxPermissions = new RxPermissions(PictureExternalPreviewActivity.this);
                    }
                    PictureExternalPreviewActivity.this.rxPermissions.request("android.permission.WRITE_EXTERNAL_STORAGE").subscribe((Observer)new Observer<Boolean>(){

                        public void onSubscribe(Disposable d) {
                        }

                        public void onNext(Boolean aBoolean) {
                            if (aBoolean.booleanValue()) {
                                PictureExternalPreviewActivity.this.showDownLoadDialog(path);
                            } else {
                                ToastUtils.s(PictureExternalPreviewActivity.this.mContext, PictureExternalPreviewActivity.this.getString(R.string.picture_jurisdiction));
                            }
                        }

                        public void onError(Throwable e) {
                        }

                        public void onComplete() {
                        }
                    });
                    return true;
                });
            }
            container.addView(contentView, 0);
            return contentView;
        }
    }
}

