/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.tools;

import android.content.ContentValues;
import android.content.Context;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Environment;
import android.provider.MediaStore;
import android.text.TextUtils;
import com.luck.picture.lib.entity.LocalMedia;
import java.io.File;

public class MediaUtils {
    public static Uri createImagePathUri(Context context, String fileName) {
        Uri[] imageFilePath = new Uri[]{null};
        String status = Environment.getExternalStorageState();
        String time = String.valueOf(System.currentTimeMillis());
        String imageName = TextUtils.isEmpty((CharSequence)fileName) ? time : fileName;
        ContentValues values = new ContentValues(3);
        values.put("_display_name", imageName);
        values.put("datetaken", time);
        values.put("mime_type", "image/jpeg");
        imageFilePath[0] = status.equals("mounted") ? context.getContentResolver().insert(MediaStore.Files.getContentUri((String)"external"), values) : context.getContentResolver().insert(MediaStore.Files.getContentUri((String)"internal"), values);
        return imageFilePath[0];
    }

    public static Uri createImageVideoUri(Context context, String fileName) {
        Uri[] imageFilePath = new Uri[]{null};
        String status = Environment.getExternalStorageState();
        String time = String.valueOf(System.currentTimeMillis());
        String imageName = TextUtils.isEmpty((CharSequence)fileName) ? time : fileName;
        ContentValues values = new ContentValues(3);
        values.put("_display_name", imageName);
        values.put("datetaken", time);
        values.put("mime_type", "video/mp4");
        imageFilePath[0] = status.equals("mounted") ? context.getContentResolver().insert(MediaStore.Files.getContentUri((String)"external"), values) : context.getContentResolver().insert(MediaStore.Files.getContentUri((String)"internal"), values);
        return imageFilePath[0];
    }

    public static long extractDuration(Context context, boolean isAndroidQ, String path) {
        return isAndroidQ ? MediaUtils.getLocalDuration(context, Uri.parse((String)path)) : new File(path).length();
    }

    public static boolean isLongImg(LocalMedia media) {
        if (null != media) {
            int h;
            int width = media.getWidth();
            int height = media.getHeight();
            return height > (h = width * 3);
        }
        return false;
    }

    private static long getLocalDuration(Context context, Uri uri) {
        try {
            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            mmr.setDataSource(context, uri);
            return Long.parseLong(mmr.extractMetadata(9));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }
}

