/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.viewpager.widget.PagerAdapter;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.luck.picture.lib.PictureVideoPlayActivity;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.photoview.OnViewTapListener;
import com.luck.picture.lib.photoview.PhotoView;
import com.luck.picture.lib.tools.MediaUtils;
import com.luck.picture.lib.widget.longimage.ImageSource;
import com.luck.picture.lib.widget.longimage.ImageViewState;
import com.luck.picture.lib.widget.longimage.SubsamplingScaleImageView;
import java.util.List;

public class SimpleFragmentAdapter
extends PagerAdapter {
    private List<LocalMedia> images;
    private Context mContext;
    private OnCallBackActivity onBackPressed;

    public SimpleFragmentAdapter(List<LocalMedia> images, Context context, OnCallBackActivity onBackPressed) {
        this.images = images;
        this.mContext = context;
        this.onBackPressed = onBackPressed;
    }

    public int getCount() {
        if (this.images != null) {
            return this.images.size();
        }
        return 0;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public Object instantiateItem(ViewGroup container, int position) {
        View contentView = LayoutInflater.from((Context)container.getContext()).inflate(R.layout.picture_image_preview, container, false);
        final PhotoView imageView = (PhotoView)contentView.findViewById(R.id.preview_image);
        final SubsamplingScaleImageView longImg = (SubsamplingScaleImageView)contentView.findViewById(R.id.longImg);
        ImageView iv_play = (ImageView)contentView.findViewById(R.id.iv_play);
        LocalMedia media = this.images.get(position);
        if (media != null) {
            String mimeType = media.getMimeType();
            boolean eqVideo = mimeType.startsWith("video");
            iv_play.setVisibility(eqVideo ? 0 : 8);
            final String path = media.isCut() && !media.isCompressed() ? media.getCutPath() : (media.isCompressed() || media.isCut() && media.isCompressed() ? media.getCompressPath() : media.getPath());
            boolean isGif = PictureMimeType.isGif(mimeType);
            final boolean eqLongImg = MediaUtils.isLongImg(media);
            imageView.setVisibility(eqLongImg && !isGif ? 8 : 0);
            longImg.setVisibility(eqLongImg && !isGif ? 0 : 8);
            if (isGif && !media.isCompressed()) {
                RequestOptions gifOptions = (RequestOptions)((RequestOptions)((RequestOptions)new RequestOptions().override(480, 800)).priority(Priority.HIGH)).diskCacheStrategy(DiskCacheStrategy.NONE);
                Glide.with((Context)contentView.getContext()).asGif().load(path).apply((BaseRequestOptions)gifOptions).into((ImageView)imageView);
            } else {
                RequestOptions options = (RequestOptions)new RequestOptions().diskCacheStrategy(DiskCacheStrategy.ALL);
                Glide.with((Context)contentView.getContext()).asBitmap().load(path).apply((BaseRequestOptions)options).into((Target)new SimpleTarget<Bitmap>(480, 800){

                    public void onResourceReady(Bitmap resource, Transition<? super Bitmap> transition) {
                        if (eqLongImg) {
                            SimpleFragmentAdapter.this.displayLongPic(resource, longImg);
                        } else {
                            imageView.setImageBitmap(resource);
                        }
                    }
                });
            }
            imageView.setOnViewTapListener(new OnViewTapListener(){

                @Override
                public void onViewTap(View view, float x, float y) {
                    if (SimpleFragmentAdapter.this.onBackPressed != null) {
                        SimpleFragmentAdapter.this.onBackPressed.onActivityBackPressed();
                    }
                }
            });
            longImg.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (SimpleFragmentAdapter.this.onBackPressed != null) {
                        SimpleFragmentAdapter.this.onBackPressed.onActivityBackPressed();
                    }
                }
            });
            iv_play.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Intent intent = new Intent();
                    Bundle bundle = new Bundle();
                    bundle.putString("video_path", path);
                    intent.putExtras(bundle);
                    intent.setClass(SimpleFragmentAdapter.this.mContext, PictureVideoPlayActivity.class);
                    SimpleFragmentAdapter.this.mContext.startActivity(intent);
                }
            });
        }
        container.addView(contentView, 0);
        return contentView;
    }

    private void displayLongPic(Bitmap bmp, SubsamplingScaleImageView longImg) {
        longImg.setQuickScaleEnabled(true);
        longImg.setZoomEnabled(true);
        longImg.setPanEnabled(true);
        longImg.setDoubleTapZoomDuration(100);
        longImg.setMinimumScaleType(2);
        longImg.setDoubleTapZoomDpi(2);
        longImg.setImage(ImageSource.cachedBitmap(bmp), new ImageViewState(0.0f, new PointF(0.0f, 0.0f), 0));
    }

    public static interface OnCallBackActivity {
        public void onActivityBackPressed();
    }
}

