/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.dialog;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.dialog.PictureIndeterminate;

public class PictureSpinView
extends ImageView
implements PictureIndeterminate {
    private float mRotateDegrees;
    private int mFrameTime;
    private boolean mNeedToUpdateView;
    private Runnable mUpdateViewRunnable;

    public PictureSpinView(Context context) {
        super(context);
        this.init();
    }

    public PictureSpinView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.setImageResource(R.drawable.ic_picture_progress_);
        this.mFrameTime = 83;
        this.mUpdateViewRunnable = new Runnable(){

            @Override
            public void run() {
                PictureSpinView.this.mRotateDegrees = PictureSpinView.this.mRotateDegrees + 30.0f;
                PictureSpinView.this.mRotateDegrees = PictureSpinView.this.mRotateDegrees < 360.0f ? PictureSpinView.this.mRotateDegrees : PictureSpinView.this.mRotateDegrees - 360.0f;
                PictureSpinView.this.invalidate();
                if (PictureSpinView.this.mNeedToUpdateView) {
                    PictureSpinView.this.postDelayed(this, PictureSpinView.this.mFrameTime);
                }
            }
        };
    }

    @Override
    public void setAnimationSpeed(float scale) {
        this.mFrameTime = (int)(83.0f / scale);
    }

    protected void onDraw(Canvas canvas) {
        canvas.rotate(this.mRotateDegrees, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        super.onDraw(canvas);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mNeedToUpdateView = true;
        this.post(this.mUpdateViewRunnable);
    }

    protected void onDetachedFromWindow() {
        this.mNeedToUpdateView = false;
        super.onDetachedFromWindow();
    }
}

