/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.graphics.drawable.RoundedBitmapDrawable;
import androidx.core.graphics.drawable.RoundedBitmapDrawableFactory;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.BitmapImageViewTarget;
import com.bumptech.glide.request.target.Target;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import java.util.ArrayList;
import java.util.List;

public class PictureAlbumDirectoryAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private Context mContext;
    private List<LocalMediaFolder> folders = new ArrayList<LocalMediaFolder>();
    private int mimeType;
    private OnItemClickListener onItemClickListener;

    public PictureAlbumDirectoryAdapter(Context mContext) {
        this.mContext = mContext;
    }

    public void bindFolderData(List<LocalMediaFolder> folders) {
        this.folders = folders;
        this.notifyDataSetChanged();
    }

    public void setMimeType(int mimeType) {
        this.mimeType = mimeType;
    }

    public List<LocalMediaFolder> getFolderData() {
        if (this.folders == null) {
            this.folders = new ArrayList<LocalMediaFolder>();
        }
        return this.folders;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.picture_album_folder_item, parent, false);
        return new ViewHolder(itemView);
    }

    public void onBindViewHolder(final ViewHolder holder, int position) {
        LocalMediaFolder folder = this.folders.get(position);
        String name = folder.getName();
        int imageNum = folder.getImageNum();
        String imagePath = folder.getFirstImagePath();
        boolean isChecked = folder.isChecked();
        int checkedNum = folder.getCheckedNum();
        holder.tvSign.setVisibility(checkedNum > 0 ? 0 : 4);
        holder.itemView.setSelected(isChecked);
        if (this.mimeType == PictureMimeType.ofAudio()) {
            holder.ivFirstImage.setImageResource(R.drawable.audio_placeholder);
        } else {
            RequestOptions options = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)new RequestOptions().placeholder(R.drawable.ic_placeholder)).centerCrop()).sizeMultiplier(0.5f)).diskCacheStrategy(DiskCacheStrategy.ALL)).override(160, 160);
            Glide.with((Context)holder.itemView.getContext()).asBitmap().load(imagePath).apply((BaseRequestOptions)options).into((Target)new BitmapImageViewTarget(holder.ivFirstImage){

                protected void setResource(Bitmap resource) {
                    RoundedBitmapDrawable circularBitmapDrawable = RoundedBitmapDrawableFactory.create((Resources)PictureAlbumDirectoryAdapter.this.mContext.getResources(), (Bitmap)resource);
                    circularBitmapDrawable.setCornerRadius(8.0f);
                    holder.ivFirstImage.setImageDrawable((Drawable)circularBitmapDrawable);
                }
            });
        }
        holder.imageNum.setText((CharSequence)("(" + imageNum + ")"));
        holder.tvFolderName.setText((CharSequence)name);
        holder.itemView.setOnClickListener(view -> {
            if (this.onItemClickListener != null) {
                for (LocalMediaFolder mediaFolder : this.folders) {
                    mediaFolder.setChecked(false);
                }
                folder.setChecked(true);
                this.notifyDataSetChanged();
                this.onItemClickListener.onItemClick(folder.getName(), folder.getImages());
            }
        });
    }

    public int getItemCount() {
        return this.folders.size();
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public static interface OnItemClickListener {
        public void onItemClick(String var1, List<LocalMedia> var2);
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        ImageView ivFirstImage;
        TextView tvFolderName;
        TextView imageNum;
        TextView tvSign;

        public ViewHolder(View itemView) {
            super(itemView);
            this.ivFirstImage = (ImageView)itemView.findViewById(R.id.first_image);
            this.tvFolderName = (TextView)itemView.findViewById(R.id.tv_folder_name);
            this.imageNum = (TextView)itemView.findViewById(R.id.image_num);
            this.tvSign = (TextView)itemView.findViewById(R.id.tv_sign);
        }
    }
}

