/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.immersive;

import android.os.Build;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class RomUtils {
    public static boolean isLightStatusBarAvailable() {
        return RomUtils.isMIUIV6OrAbove() || RomUtils.isFlymeV4OrAbove() || RomUtils.isAndroidMOrAbove();
    }

    public static int getLightStatusBarAvailableRomType() {
        if (RomUtils.isMIUIV6OrAbove()) {
            return 1;
        }
        if (RomUtils.isFlymeV4OrAbove()) {
            return 2;
        }
        if (RomUtils.isAndroid5OrAbove()) {
            return 3;
        }
        return 4;
    }

    private static boolean isFlymeV4OrAbove() {
        String displayId = Build.DISPLAY;
        if (!TextUtils.isEmpty((CharSequence)displayId) && displayId.contains("Flyme")) {
            String[] displayIdArray;
            for (String temp : displayIdArray = displayId.split(" ")) {
                if (!temp.matches("^[4-9]\\.(\\d+\\.)+\\S*")) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isMIUIV6OrAbove() {
        String miuiVersionCodeStr = RomUtils.getSystemProperty("ro.miui.ui.version.code");
        if (!TextUtils.isEmpty((CharSequence)miuiVersionCodeStr)) {
            try {
                int miuiVersionCode = Integer.parseInt(miuiVersionCodeStr);
                if (miuiVersionCode >= 4) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static int getMIUIVersionCode() {
        String miuiVersionCodeStr = RomUtils.getSystemProperty("ro.miui.ui.version.code");
        int miuiVersionCode = 0;
        if (!TextUtils.isEmpty((CharSequence)miuiVersionCodeStr)) {
            try {
                miuiVersionCode = Integer.parseInt(miuiVersionCodeStr);
                return miuiVersionCode;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return miuiVersionCode;
    }

    private static boolean isAndroidMOrAbove() {
        return Build.VERSION.SDK_INT >= 23;
    }

    private static boolean isAndroid5OrAbove() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public static int getMiuiVersion() {
        String version = RomUtils.getSystemProperty("ro.miui.ui.version.name");
        if (version != null) {
            try {
                return Integer.parseInt(version.substring(1));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSystemProperty(String propName) {
        String line;
        BufferedReader input = null;
        try {
            Process p = Runtime.getRuntime().exec("getprop " + propName);
            input = new BufferedReader(new InputStreamReader(p.getInputStream()), 1024);
            line = input.readLine();
            input.close();
        }
        catch (IOException ex) {
            String string2 = null;
            return string2;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        return line;
    }

    public class AvailableRomType {
        public static final int MIUI = 1;
        public static final int FLYME = 2;
        public static final int ANDROID_NATIVE = 3;
        public static final int NA = 4;
    }
}

