/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.luck.picture.lib.R;
import com.luck.picture.lib.anim.OptAnimationLoader;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.tools.DateUtils;
import com.luck.picture.lib.tools.StringUtils;
import com.luck.picture.lib.tools.VoiceUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PictureImageGridAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final int DURATION = 450;
    private Context context;
    private boolean showCamera = true;
    private OnPhotoSelectChangedListener imageSelectChangedListener;
    private int maxSelectNum;
    private List<LocalMedia> images = new ArrayList<LocalMedia>();
    private List<LocalMedia> selectImages = new ArrayList<LocalMedia>();
    private boolean enablePreview;
    private int selectMode = 2;
    private boolean enablePreviewVideo = false;
    private boolean enablePreviewAudio = false;
    private boolean is_checked_num;
    private boolean enableVoice;
    private int overrideWidth;
    private int overrideHeight;
    private float sizeMultiplier;
    private Animation animation;
    private PictureSelectionConfig config;
    private int mimeType;
    private boolean zoomAnim;
    private boolean isGo;

    public PictureImageGridAdapter(Context context, PictureSelectionConfig config) {
        this.context = context;
        this.config = config;
        this.selectMode = config.selectionMode;
        this.showCamera = config.isCamera;
        this.maxSelectNum = config.maxSelectNum;
        this.enablePreview = config.enablePreview;
        this.enablePreviewVideo = config.enPreviewVideo;
        this.enablePreviewAudio = config.enablePreviewAudio;
        this.is_checked_num = config.checkNumMode;
        this.overrideWidth = config.overrideWidth;
        this.overrideHeight = config.overrideHeight;
        this.enableVoice = config.openClickSound;
        this.sizeMultiplier = config.sizeMultiplier;
        this.mimeType = config.mimeType;
        this.zoomAnim = config.zoomAnim;
        this.animation = OptAnimationLoader.loadAnimation(context, R.anim.modal_in);
    }

    public void setShowCamera(boolean showCamera) {
        this.showCamera = showCamera;
    }

    public void bindImagesData(List<LocalMedia> images) {
        this.images = images;
        this.notifyDataSetChanged();
    }

    public void bindSelectImages(List<LocalMedia> images) {
        ArrayList<LocalMedia> selection = new ArrayList<LocalMedia>();
        for (LocalMedia media : images) {
            selection.add(media);
        }
        this.selectImages = selection;
        this.subSelectPosition();
        if (this.imageSelectChangedListener != null) {
            this.imageSelectChangedListener.onChange(this.selectImages);
        }
    }

    public List<LocalMedia> getSelectedImages() {
        if (this.selectImages == null) {
            this.selectImages = new ArrayList<LocalMedia>();
        }
        return this.selectImages;
    }

    public List<LocalMedia> getImages() {
        if (this.images == null) {
            this.images = new ArrayList<LocalMedia>();
        }
        return this.images;
    }

    public int getItemViewType(int position) {
        if (this.showCamera && position == 0) {
            return 1;
        }
        return 2;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 1) {
            View view = LayoutInflater.from((Context)this.context).inflate(R.layout.picture_item_camera, parent, false);
            return new HeaderViewHolder(view);
        }
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.picture_image_grid_item, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, final int position) {
        if (this.getItemViewType(position) == 1) {
            HeaderViewHolder headerHolder = (HeaderViewHolder)holder;
            headerHolder.headerView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (PictureImageGridAdapter.this.imageSelectChangedListener != null) {
                        PictureImageGridAdapter.this.imageSelectChangedListener.onTakePhoto();
                    }
                }
            });
        } else {
            Drawable drawable2;
            final ViewHolder contentHolder = (ViewHolder)holder;
            final LocalMedia image = this.images.get(this.showCamera ? position - 1 : position);
            image.position = contentHolder.getAdapterPosition();
            final String path = image.getPath();
            String pictureType = image.getPictureType();
            if (this.is_checked_num) {
                this.notifyCheckChanged(contentHolder, image);
            }
            this.selectImage(contentHolder, this.isSelected(image), false);
            final int mediaMimeType = PictureMimeType.isPictureType(pictureType);
            boolean gif = PictureMimeType.isGif(pictureType);
            contentHolder.tv_isGif.setVisibility(gif ? 0 : 8);
            if (this.mimeType == PictureMimeType.ofAudio()) {
                contentHolder.tv_duration.setVisibility(0);
                drawable2 = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.picture_audio);
                StringUtils.modifyTextViewDrawable(contentHolder.tv_duration, drawable2, 0);
            } else {
                drawable2 = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.video_icon);
                StringUtils.modifyTextViewDrawable(contentHolder.tv_duration, drawable2, 0);
                contentHolder.tv_duration.setVisibility(mediaMimeType == 2 ? 0 : 8);
            }
            boolean eqLongImg = PictureMimeType.isLongImg(image);
            contentHolder.tv_long_chart.setVisibility(eqLongImg ? 0 : 8);
            long duration = image.getDuration();
            contentHolder.tv_duration.setText((CharSequence)DateUtils.timeParse(duration));
            if (this.mimeType == PictureMimeType.ofAudio()) {
                contentHolder.iv_picture.setImageResource(R.drawable.audio_placeholder);
            } else {
                RequestOptions options = new RequestOptions();
                if (this.overrideWidth <= 0 && this.overrideHeight <= 0) {
                    options.sizeMultiplier(this.sizeMultiplier);
                } else {
                    options.override(this.overrideWidth, this.overrideHeight);
                }
                options.diskCacheStrategy(DiskCacheStrategy.ALL);
                options.centerCrop();
                options.placeholder(R.drawable.image_placeholder);
                Glide.with((Context)this.context).asBitmap().load(path).apply(options).into(contentHolder.iv_picture);
            }
            if (this.enablePreview || this.enablePreviewVideo || this.enablePreviewAudio) {
                contentHolder.ll_check.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (!new File(path).exists()) {
                            Toast.makeText((Context)PictureImageGridAdapter.this.context.getApplicationContext(), (CharSequence)PictureImageGridAdapter.this.context.getString(R.string.picture_error), (int)1).show();
                            return;
                        }
                        PictureImageGridAdapter.this.changeCheckboxState(contentHolder, image);
                    }
                });
            }
            contentHolder.contentView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    boolean eqResult;
                    if (!new File(path).exists()) {
                        Toast.makeText((Context)PictureImageGridAdapter.this.context.getApplicationContext(), (CharSequence)PictureImageGridAdapter.this.context.getString(R.string.picture_error), (int)1).show();
                        return;
                    }
                    int index = PictureImageGridAdapter.this.showCamera ? position - 1 : position;
                    boolean bl = eqResult = mediaMimeType == 1 && PictureImageGridAdapter.this.enablePreview || mediaMimeType == 2 && (PictureImageGridAdapter.this.enablePreviewVideo || PictureImageGridAdapter.this.selectMode == 1) || mediaMimeType == 3 && (PictureImageGridAdapter.this.enablePreviewAudio || PictureImageGridAdapter.this.selectMode == 1);
                    if (eqResult) {
                        PictureImageGridAdapter.this.imageSelectChangedListener.onPictureClick(image, index);
                    } else {
                        PictureImageGridAdapter.this.changeCheckboxState(contentHolder, image);
                    }
                }
            });
        }
    }

    public int getItemCount() {
        return this.showCamera ? this.images.size() + 1 : this.images.size();
    }

    public boolean isSelected(LocalMedia image) {
        for (LocalMedia media : this.selectImages) {
            if (!media.getPath().equals(image.getPath())) continue;
            return true;
        }
        return false;
    }

    private void notifyCheckChanged(ViewHolder viewHolder, LocalMedia imageBean) {
        viewHolder.check.setText((CharSequence)"");
        for (LocalMedia media : this.selectImages) {
            if (!media.getPath().equals(imageBean.getPath())) continue;
            imageBean.setNum(media.getNum());
            media.setPosition(imageBean.getPosition());
            viewHolder.check.setText((CharSequence)String.valueOf(imageBean.getNum()));
        }
    }

    private void changeCheckboxState(ViewHolder contentHolder, LocalMedia image) {
        boolean toEqual;
        String pictureType;
        boolean isChecked = contentHolder.check.isSelected();
        String string2 = pictureType = this.selectImages.size() > 0 ? this.selectImages.get(0).getPictureType() : "";
        if (!TextUtils.isEmpty((CharSequence)pictureType) && !(toEqual = PictureMimeType.mimeToEqual(pictureType, image.getPictureType()))) {
            Toast.makeText((Context)this.context.getApplicationContext(), (CharSequence)this.context.getString(R.string.picture_rule), (int)1).show();
            return;
        }
        if (this.selectImages.size() >= this.maxSelectNum && !isChecked) {
            boolean eqImg = pictureType.startsWith("image");
            String str = eqImg ? this.context.getString(R.string.picture_message_max_num, new Object[]{this.maxSelectNum}) : this.context.getString(R.string.picture_message_video_max_num, new Object[]{this.maxSelectNum});
            Toast.makeText((Context)this.context.getApplicationContext(), (CharSequence)str, (int)1).show();
            return;
        }
        if (isChecked) {
            for (LocalMedia media : this.selectImages) {
                if (!media.getPath().equals(image.getPath())) continue;
                this.selectImages.remove(media);
                this.subSelectPosition();
                this.disZoom(contentHolder.iv_picture);
                break;
            }
        } else {
            if (this.selectMode == 1) {
                this.singleRadioMediaImage();
            }
            this.selectImages.add(image);
            image.setNum(this.selectImages.size());
            VoiceUtils.playVoice(this.context, this.enableVoice);
            this.zoom(contentHolder.iv_picture);
        }
        this.notifyItemChanged(contentHolder.getAdapterPosition());
        this.selectImage(contentHolder, !isChecked, true);
        if (this.imageSelectChangedListener != null) {
            this.imageSelectChangedListener.onChange(this.selectImages);
        }
    }

    private void singleRadioMediaImage() {
        if (this.selectImages != null && this.selectImages.size() > 0) {
            LocalMedia media = this.selectImages.get(0);
            this.notifyItemChanged(this.config.isCamera ? media.position : (this.isGo ? media.position : (media.position > 0 ? media.position - 1 : 0)));
            this.selectImages.clear();
            this.isGo = true;
        }
    }

    private void subSelectPosition() {
        if (this.is_checked_num) {
            int size = this.selectImages.size();
            int length = size;
            for (int index = 0; index < length; ++index) {
                LocalMedia media = this.selectImages.get(index);
                media.setNum(index + 1);
                this.notifyItemChanged(media.position);
            }
        }
    }

    public void selectImage(ViewHolder holder, boolean isChecked, boolean isAnim) {
        holder.check.setSelected(isChecked);
        if (isChecked) {
            if (isAnim && this.animation != null) {
                holder.check.startAnimation(this.animation);
            }
            holder.iv_picture.setColorFilter(ContextCompat.getColor((Context)this.context, (int)R.color.image_overlay_true), PorterDuff.Mode.SRC_ATOP);
        } else {
            holder.iv_picture.setColorFilter(ContextCompat.getColor((Context)this.context, (int)R.color.image_overlay_false), PorterDuff.Mode.SRC_ATOP);
        }
    }

    public void setOnPhotoSelectChangedListener(OnPhotoSelectChangedListener imageSelectChangedListener) {
        this.imageSelectChangedListener = imageSelectChangedListener;
    }

    private void zoom(ImageView iv_img) {
        if (this.zoomAnim) {
            AnimatorSet set = new AnimatorSet();
            set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)iv_img, (String)"scaleX", (float[])new float[]{1.0f, 1.12f}), ObjectAnimator.ofFloat((Object)iv_img, (String)"scaleY", (float[])new float[]{1.0f, 1.12f})});
            set.setDuration(450L);
            set.start();
        }
    }

    private void disZoom(ImageView iv_img) {
        if (this.zoomAnim) {
            AnimatorSet set = new AnimatorSet();
            set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)iv_img, (String)"scaleX", (float[])new float[]{1.12f, 1.0f}), ObjectAnimator.ofFloat((Object)iv_img, (String)"scaleY", (float[])new float[]{1.12f, 1.0f})});
            set.setDuration(450L);
            set.start();
        }
    }

    public static interface OnPhotoSelectChangedListener {
        public void onTakePhoto();

        public void onChange(List<LocalMedia> var1);

        public void onPictureClick(LocalMedia var1, int var2);
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        ImageView iv_picture;
        TextView check;
        TextView tv_duration;
        TextView tv_isGif;
        TextView tv_long_chart;
        View contentView;
        LinearLayout ll_check;

        public ViewHolder(View itemView) {
            super(itemView);
            this.contentView = itemView;
            this.iv_picture = (ImageView)itemView.findViewById(R.id.iv_picture);
            this.check = (TextView)itemView.findViewById(R.id.check);
            this.ll_check = (LinearLayout)itemView.findViewById(R.id.ll_check);
            this.tv_duration = (TextView)itemView.findViewById(R.id.tv_duration);
            this.tv_isGif = (TextView)itemView.findViewById(R.id.tv_isGif);
            this.tv_long_chart = (TextView)itemView.findViewById(R.id.tv_long_chart);
        }
    }

    public class HeaderViewHolder
    extends RecyclerView.ViewHolder {
        View headerView;
        TextView tv_title_camera;

        public HeaderViewHolder(View itemView) {
            super(itemView);
            this.headerView = itemView;
            this.tv_title_camera = (TextView)itemView.findViewById(R.id.tv_title_camera);
            String title = PictureImageGridAdapter.this.mimeType == PictureMimeType.ofAudio() ? PictureImageGridAdapter.this.context.getString(R.string.picture_tape) : PictureImageGridAdapter.this.context.getString(R.string.picture_take_picture);
            this.tv_title_camera.setText((CharSequence)title);
        }
    }
}

