/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.widget;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.luck.picture.lib.R;

public class PhotoPopupWindow
extends PopupWindow
implements View.OnClickListener {
    private TextView picture_tv_photo;
    private TextView picture_tv_video;
    private TextView picture_tv_cancel;
    private LinearLayout ll_root;
    private FrameLayout fl_content;
    private Animation animationIn;
    private Animation animationOut;
    private boolean isDismiss = false;
    private OnItemClickListener onItemClickListener;

    public PhotoPopupWindow(Context context) {
        super(context);
        View inflate = LayoutInflater.from((Context)context).inflate(R.layout.picture_camera_pop_layout, null);
        this.setWidth(-1);
        this.setHeight(-1);
        this.setBackgroundDrawable((Drawable)new ColorDrawable());
        this.setFocusable(true);
        this.setOutsideTouchable(true);
        this.update();
        this.setBackgroundDrawable((Drawable)new ColorDrawable());
        this.setContentView(inflate);
        this.animationIn = AnimationUtils.loadAnimation((Context)context, (int)R.anim.up_in);
        this.animationOut = AnimationUtils.loadAnimation((Context)context, (int)R.anim.down_out);
        this.ll_root = (LinearLayout)inflate.findViewById(R.id.ll_root);
        this.fl_content = (FrameLayout)inflate.findViewById(R.id.fl_content);
        this.picture_tv_photo = (TextView)inflate.findViewById(R.id.picture_tv_photo);
        this.picture_tv_cancel = (TextView)inflate.findViewById(R.id.picture_tv_cancel);
        this.picture_tv_video = (TextView)inflate.findViewById(R.id.picture_tv_video);
        this.picture_tv_video.setOnClickListener((View.OnClickListener)this);
        this.picture_tv_cancel.setOnClickListener((View.OnClickListener)this);
        this.picture_tv_photo.setOnClickListener((View.OnClickListener)this);
        this.fl_content.setOnClickListener((View.OnClickListener)this);
    }

    public void showAsDropDown(View parent) {
        try {
            if (Build.VERSION.SDK_INT >= 24) {
                int[] location = new int[2];
                parent.getLocationOnScreen(location);
                int x = location[0];
                int y = location[1] + parent.getHeight();
                this.showAtLocation(parent, 80, x, y);
            } else {
                this.showAtLocation(parent, 80, 0, 0);
            }
            this.isDismiss = false;
            this.ll_root.startAnimation(this.animationIn);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dismiss() {
        if (this.isDismiss) {
            return;
        }
        this.isDismiss = true;
        this.ll_root.startAnimation(this.animationOut);
        this.dismiss();
        this.animationOut.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                PhotoPopupWindow.this.isDismiss = false;
                if (Build.VERSION.SDK_INT <= 16) {
                    PhotoPopupWindow.this.dismiss4Pop();
                } else {
                    PhotoPopupWindow.super.dismiss();
                }
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
    }

    private void dismiss4Pop() {
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                PhotoPopupWindow.super.dismiss();
            }
        });
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.picture_tv_photo && this.onItemClickListener != null) {
            this.onItemClickListener.onItemClick(0);
            PhotoPopupWindow.super.dismiss();
        }
        if (id2 == R.id.picture_tv_video && this.onItemClickListener != null) {
            this.onItemClickListener.onItemClick(1);
            PhotoPopupWindow.super.dismiss();
        }
        this.dismiss();
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public static interface OnItemClickListener {
        public void onItemClick(int var1);
    }
}

