/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.tools;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

public class ToolbarUtil {
    private static final int DEFAULT_STATUS_BAR_ALPHA = 15;

    public static void setColor(Activity activity, int color2, int statusBarAlpha) {
        if (Build.VERSION.SDK_INT >= 21) {
            activity.getWindow().addFlags(Integer.MIN_VALUE);
            activity.getWindow().clearFlags(0x4000000);
            activity.getWindow().setStatusBarColor(ToolbarUtil.calculateStatusColor(color2, statusBarAlpha));
        } else if (Build.VERSION.SDK_INT >= 19) {
            activity.getWindow().addFlags(0x4000000);
            View statusView = ToolbarUtil.createStatusBarView(activity, color2, statusBarAlpha);
            ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
            decorView.addView(statusView);
            ToolbarUtil.setRootView(activity);
        }
    }

    private static void setRootView(Activity activity) {
        ViewGroup rootView = (ViewGroup)((ViewGroup)activity.findViewById(0x1020002)).getChildAt(0);
        if (rootView != null) {
            rootView.setFitsSystemWindows(true);
            rootView.setClipToPadding(true);
        }
    }

    private static View createStatusBarView(Activity activity, int color2, int alpha) {
        View statusBarView = new View((Context)activity);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, ToolbarUtil.getStatusBarHeight((Context)activity));
        statusBarView.setLayoutParams((ViewGroup.LayoutParams)params);
        statusBarView.setBackgroundColor(ToolbarUtil.calculateStatusColor(color2, alpha));
        return statusBarView;
    }

    public static int getStatusBarHeight(Context context) {
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        return context.getResources().getDimensionPixelSize(resourceId);
    }

    private static int calculateStatusColor(int color2, int alpha) {
        float a = 1.0f - (float)alpha / 255.0f;
        int red = color2 >> 16 & 0xFF;
        int green = color2 >> 8 & 0xFF;
        int blue = color2 & 0xFF;
        red = (int)((double)((float)red * a) + 0.5);
        green = (int)((double)((float)green * a) + 0.5);
        blue = (int)((double)((float)blue * a) + 0.5);
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    public static void setColor(Activity activity, int color2) {
        ToolbarUtil.setColor(activity, color2, 15);
    }

    public static void setColorNoTranslucent(Activity activity, int color2) {
        ToolbarUtil.setColor(activity, color2, 0);
    }
}

