/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.tools;

import android.annotation.SuppressLint;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class PictureFileUtils {
    private static String DEFAULT_CACHE_DIR = "picture_cache";
    public static final String POSTFIX = ".JPEG";
    public static final String POST_VIDEO = ".mp4";
    public static final String POST_AUDIO = ".mp3";
    public static final String APP_NAME = "PictureSelector";
    public static final String CAMERA_PATH = "/PictureSelector/CameraImage/";
    public static final String CAMERA_AUDIO_PATH = "/PictureSelector/CameraAudio/";
    public static final String CROP_PATH = "/PictureSelector/CropImage/";
    static final String TAG = "PictureFileUtils";

    public static File createCameraFile(Context context, int type, String outputCameraPath, String format) {
        String path = type == 3 ? (!TextUtils.isEmpty((CharSequence)outputCameraPath) ? outputCameraPath : CAMERA_AUDIO_PATH) : (!TextUtils.isEmpty((CharSequence)outputCameraPath) ? outputCameraPath : CAMERA_PATH);
        return type == 3 ? PictureFileUtils.createMediaFile(context, path, type, format) : PictureFileUtils.createMediaFile(context, path, type, format);
    }

    public static File createCropFile(Context context, int type, String format) {
        return PictureFileUtils.createMediaFile(context, CROP_PATH, type, format);
    }

    private static File createMediaFile(Context context, String parentPath, int type, String format) {
        String state = Environment.getExternalStorageState();
        File rootDir = state.equals("mounted") ? Environment.getExternalStorageDirectory() : context.getCacheDir();
        File folderDir = new File(rootDir.getAbsolutePath() + parentPath);
        if (folderDir.exists() || folderDir.mkdirs()) {
            // empty if block
        }
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.CHINA).format(new Date());
        String fileName = "PictureSelector_" + timeStamp + "";
        File tmpFile = null;
        switch (type) {
            case 1: {
                String suffixType = TextUtils.isEmpty((CharSequence)format) ? POSTFIX : format;
                tmpFile = new File(folderDir, fileName + suffixType);
                break;
            }
            case 2: {
                tmpFile = new File(folderDir, fileName + POST_VIDEO);
                break;
            }
            case 3: {
                tmpFile = new File(folderDir, fileName + POST_AUDIO);
            }
        }
        return tmpFile;
    }

    private PictureFileUtils() {
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int column_index = cursor.getColumnIndexOrThrow("_data");
                String string2 = cursor.getString(column_index);
                return string2;
            }
        }
        catch (IllegalArgumentException ex) {
            Log.i((String)TAG, (String)String.format(Locale.getDefault(), "getDataColumn: _data - [%s]", ex.getMessage()));
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    public static File getPhotoCacheDir(Context context, File file) {
        File cacheDir = context.getCacheDir();
        String file_name = file.getName();
        if (cacheDir != null) {
            File mCacheDir = new File(cacheDir, DEFAULT_CACHE_DIR);
            if (!(mCacheDir.mkdirs() || mCacheDir.exists() && mCacheDir.isDirectory())) {
                return file;
            }
            String fileName = "";
            fileName = file_name.endsWith(".webp") ? System.currentTimeMillis() + ".webp" : System.currentTimeMillis() + ".png";
            return new File(mCacheDir, fileName);
        }
        if (Log.isLoggable((String)TAG, (int)6)) {
            Log.e((String)TAG, (String)"default disk cache dir is null");
        }
        return file;
    }

    @SuppressLint(value={"NewApi"})
    public static String getPath(Context context, Uri uri) {
        boolean isKitKat;
        boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
        if (isKitKat && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (PictureFileUtils.isExternalStorageDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    return Environment.getExternalStorageDirectory() + "/" + split[1];
                }
            } else {
                if (PictureFileUtils.isDownloadsDocument(uri)) {
                    String id2 = DocumentsContract.getDocumentId((Uri)uri);
                    Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id2));
                    return PictureFileUtils.getDataColumn(context, contentUri, null, null);
                }
                if (PictureFileUtils.isMediaDocument(uri)) {
                    String docId = DocumentsContract.getDocumentId((Uri)uri);
                    String[] split = docId.split(":");
                    String type = split[0];
                    Uri contentUri = null;
                    if ("image".equals(type)) {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(type)) {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(type)) {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return PictureFileUtils.getDataColumn(context, contentUri, "_id=?", selectionArgs);
                }
            }
        } else {
            if ("content".equalsIgnoreCase(uri.getScheme())) {
                if (PictureFileUtils.isGooglePhotosUri(uri)) {
                    return uri.getLastPathSegment();
                }
                return PictureFileUtils.getDataColumn(context, uri, null, null);
            }
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return uri.getPath();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(@NonNull String pathFrom, @NonNull String pathTo) throws IOException {
        if (pathFrom.equalsIgnoreCase(pathTo)) {
            return;
        }
        AbstractInterruptibleChannel outputChannel = null;
        AbstractInterruptibleChannel inputChannel = null;
        try {
            inputChannel = new FileInputStream(new File(pathFrom)).getChannel();
            outputChannel = new FileOutputStream(new File(pathTo)).getChannel();
            ((FileChannel)inputChannel).transferTo(0L, ((FileChannel)inputChannel).size(), (WritableByteChannel)((Object)outputChannel));
            inputChannel.close();
        }
        finally {
            if (inputChannel != null) {
                inputChannel.close();
            }
            if (outputChannel != null) {
                outputChannel.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyAudioFile(@NonNull String pathFrom, @NonNull String pathTo) throws IOException {
        if (pathFrom.equalsIgnoreCase(pathTo)) {
            return;
        }
        AbstractInterruptibleChannel outputChannel = null;
        AbstractInterruptibleChannel inputChannel = null;
        try {
            inputChannel = new FileInputStream(new File(pathFrom)).getChannel();
            outputChannel = new FileOutputStream(new File(pathTo)).getChannel();
            ((FileChannel)inputChannel).transferTo(0L, ((FileChannel)inputChannel).size(), (WritableByteChannel)((Object)outputChannel));
            inputChannel.close();
        }
        finally {
            if (inputChannel != null) {
                inputChannel.close();
            }
            if (outputChannel != null) {
                outputChannel.close();
            }
            PictureFileUtils.deleteFile(pathFrom);
        }
    }

    public static int readPictureDegree(String path) {
        int degree = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return degree;
    }

    public static Bitmap rotaingImageView(int angle, Bitmap bitmap) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)angle);
        System.out.println("angle2=" + angle);
        Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        return resizedBitmap;
    }

    public static void saveBitmapFile(Bitmap bitmap, File file) {
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bos);
            bos.flush();
            bos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Bitmap toRoundBitmap(Bitmap bitmap) {
        float dst_bottom;
        float dst_right;
        float dst_top;
        float dst_left;
        float bottom;
        float right;
        float top;
        float left;
        float roundPx;
        int height;
        int width = bitmap.getWidth();
        if (width <= (height = bitmap.getHeight())) {
            roundPx = width / 2;
            left = 0.0f;
            top = 0.0f;
            right = width;
            bottom = width;
            height = width;
            dst_left = 0.0f;
            dst_top = 0.0f;
            dst_right = width;
            dst_bottom = width;
        } else {
            float clip;
            roundPx = height / 2;
            left = clip = (float)((width - height) / 2);
            right = (float)width - clip;
            top = 0.0f;
            bottom = height;
            width = height;
            dst_left = 0.0f;
            dst_top = 0.0f;
            dst_right = height;
            dst_bottom = height;
        }
        Bitmap output = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        Paint paint = new Paint();
        Rect src = new Rect((int)left, (int)top, (int)right, (int)bottom);
        Rect dst = new Rect((int)dst_left, (int)dst_top, (int)dst_right, (int)dst_bottom);
        RectF rectF = new RectF(dst);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        canvas.drawRoundRect(rectF, roundPx, roundPx, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, src, dst, paint);
        return output;
    }

    public static String createDir(Context context, String filename, String directory_path) {
        String state = Environment.getExternalStorageState();
        File rootDir = state.equals("mounted") ? Environment.getExternalStorageDirectory() : context.getCacheDir();
        File path = null;
        path = !TextUtils.isEmpty((CharSequence)directory_path) ? new File(rootDir.getAbsolutePath() + directory_path) : new File(rootDir.getAbsolutePath() + "/PictureSelector");
        if (!path.exists()) {
            path.mkdirs();
        }
        return path + "/" + filename;
    }

    public static int isDamage(String path) {
        BitmapFactory.Options options = null;
        if (options == null) {
            options = new BitmapFactory.Options();
        }
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        if (options.mCancel || options.outWidth == -1 || options.outHeight == -1) {
            return -1;
        }
        return 0;
    }

    public static List<String> getDirFiles(String dir) {
        File scanner5Directory = new File(dir);
        ArrayList<String> list = new ArrayList<String>();
        if (scanner5Directory.isDirectory()) {
            for (File file : scanner5Directory.listFiles()) {
                String path = file.getAbsolutePath();
                if (!path.endsWith(".jpg") && !path.endsWith(".jpeg") && !path.endsWith(".png") && !path.endsWith(".gif") && !path.endsWith(".webp")) continue;
                list.add(path);
            }
        }
        return list;
    }

    public static String getDCIMCameraPath() {
        String absolutePath;
        try {
            absolutePath = "%" + Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM).getAbsolutePath() + "/Camera";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        return absolutePath;
    }

    public static void deleteCacheDirFile(Context mContext) {
        File[] files;
        File cutDir = mContext.getCacheDir();
        File compressDir = new File(mContext.getCacheDir() + "/picture_cache");
        File lubanDir = new File(mContext.getCacheDir() + "/luban_disk_cache");
        if (cutDir != null) {
            for (File file : files = cutDir.listFiles()) {
                if (!file.isFile()) continue;
                file.delete();
            }
        }
        if (compressDir != null && (files = compressDir.listFiles()) != null) {
            for (File file : files) {
                if (!file.isFile()) continue;
                file.delete();
            }
        }
        if (lubanDir != null && (files = lubanDir.listFiles()) != null) {
            for (File file : files) {
                if (!file.isFile()) continue;
                file.delete();
            }
        }
    }

    public static void deleteExternalCacheDirFile(Context mContext) {
        File[] files;
        File cutDir = mContext.getExternalCacheDir();
        File compressDir = new File(mContext.getExternalCacheDir() + "/picture_cache");
        File lubanDir = new File(mContext.getExternalCacheDir() + "/luban_disk_cache");
        if (cutDir != null) {
            for (File file : files = cutDir.listFiles()) {
                if (!file.isFile()) continue;
                file.delete();
            }
        }
        if (compressDir != null && (files = compressDir.listFiles()) != null) {
            for (File file : files) {
                if (!file.isFile()) continue;
                file.delete();
            }
        }
        if (lubanDir != null && (files = lubanDir.listFiles()) != null) {
            for (File file : files) {
                if (!file.isFile()) continue;
                file.delete();
            }
        }
    }

    public static void deleteFile(String path) {
        try {
            File file;
            if (!TextUtils.isEmpty((CharSequence)path) && (file = new File(path)) != null) {
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getDiskCacheDir(Context context) {
        String cachePath = null;
        cachePath = "mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable() ? context.getExternalCacheDir().getPath() : context.getCacheDir().getPath();
        return cachePath;
    }
}

