/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.permissions;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.luck.picture.lib.permissions.Permission;
import com.luck.picture.lib.permissions.RxPermissionsFragment;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.functions.Function;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayList;
import java.util.List;

public class RxPermissions {
    public static final String TAG = "RxPermissions";
    public static final Object TRIGGER = new Object();
    public RxPermissionsFragment mRxPermissionsFragment;

    public RxPermissions(@NonNull Activity activity) {
        this.mRxPermissionsFragment = this.getRxPermissionsFragment(activity);
    }

    private RxPermissionsFragment getRxPermissionsFragment(Activity activity) {
        RxPermissionsFragment rxPermissionsFragment = null;
        try {
            boolean isNewInstance;
            rxPermissionsFragment = this.findRxPermissionsFragment(activity);
            boolean bl = isNewInstance = rxPermissionsFragment == null;
            if (isNewInstance) {
                rxPermissionsFragment = new RxPermissionsFragment();
                FragmentManager fragmentManager = activity.getFragmentManager();
                fragmentManager.beginTransaction().add((Fragment)rxPermissionsFragment, TAG).commitAllowingStateLoss();
                fragmentManager.executePendingTransactions();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rxPermissionsFragment;
    }

    private RxPermissionsFragment findRxPermissionsFragment(Activity activity) {
        return (RxPermissionsFragment)activity.getFragmentManager().findFragmentByTag(TAG);
    }

    public void setLogging(boolean logging) {
        this.mRxPermissionsFragment.setLogging(logging);
    }

    public <T> ObservableTransformer<T, Boolean> ensure(final String ... permissions) {
        return new ObservableTransformer<T, Boolean>(){

            public ObservableSource<Boolean> apply(Observable<T> o) {
                return RxPermissions.this.request(o, permissions).buffer(permissions.length).flatMap((Function)new Function<List<Permission>, ObservableSource<Boolean>>(){

                    public ObservableSource<Boolean> apply(List<Permission> permissions) throws Exception {
                        if (permissions.isEmpty()) {
                            return Observable.empty();
                        }
                        for (Permission p : permissions) {
                            if (p.granted) continue;
                            return Observable.just((Object)false);
                        }
                        return Observable.just((Object)true);
                    }
                });
            }
        };
    }

    public <T> ObservableTransformer<T, Permission> ensureEach(final String ... permissions) {
        return new ObservableTransformer<T, Permission>(){

            public ObservableSource<Permission> apply(Observable<T> o) {
                return RxPermissions.this.request(o, permissions);
            }
        };
    }

    public Observable<Boolean> request(String ... permissions) {
        return Observable.just((Object)TRIGGER).compose(this.ensure(permissions));
    }

    public Observable<Permission> requestEach(String ... permissions) {
        return Observable.just((Object)TRIGGER).compose(this.ensureEach(permissions));
    }

    private Observable<Permission> request(Observable<?> trigger, final String ... permissions) {
        if (permissions == null || permissions.length == 0) {
            throw new IllegalArgumentException("RxPermissions.request/requestEach requires at least one input permission");
        }
        return this.oneOf(trigger, this.pending(permissions)).flatMap((Function)new Function<Object, Observable<Permission>>(){

            public Observable<Permission> apply(Object o) throws Exception {
                return RxPermissions.this.requestImplementation(permissions);
            }
        });
    }

    private Observable<?> pending(String ... permissions) {
        for (String p : permissions) {
            if (this.mRxPermissionsFragment.containsByPermission(p)) continue;
            return Observable.empty();
        }
        return Observable.just((Object)TRIGGER);
    }

    private Observable<?> oneOf(Observable<?> trigger, Observable<?> pending) {
        if (trigger == null) {
            return Observable.just((Object)TRIGGER);
        }
        return Observable.merge(trigger, pending);
    }

    @TargetApi(value=23)
    private Observable<Permission> requestImplementation(String ... permissions) {
        ArrayList<Object> list = new ArrayList<Object>(permissions.length);
        ArrayList<String> unrequestedPermissions = new ArrayList<String>();
        for (String permission2 : permissions) {
            this.mRxPermissionsFragment.log("Requesting permission " + permission2);
            if (this.isGranted(permission2)) {
                list.add(Observable.just((Object)new Permission(permission2, true, false)));
                continue;
            }
            if (this.isRevoked(permission2)) {
                list.add(Observable.just((Object)new Permission(permission2, false, false)));
                continue;
            }
            PublishSubject subject = this.mRxPermissionsFragment.getSubjectByPermission(permission2);
            if (subject == null) {
                unrequestedPermissions.add(permission2);
                subject = PublishSubject.create();
                this.mRxPermissionsFragment.setSubjectForPermission(permission2, (PublishSubject<Permission>)subject);
            }
            list.add(subject);
        }
        if (!unrequestedPermissions.isEmpty()) {
            String[] unrequestedPermissionsArray = unrequestedPermissions.toArray(new String[unrequestedPermissions.size()]);
            this.requestPermissionsFromFragment(unrequestedPermissionsArray);
        }
        return Observable.concat((ObservableSource)Observable.fromIterable(list));
    }

    public Observable<Boolean> shouldShowRequestPermissionRationale(Activity activity, String ... permissions) {
        if (!this.isMarshmallow()) {
            return Observable.just((Object)false);
        }
        return Observable.just((Object)this.shouldShowRequestPermissionRationaleImplementation(activity, permissions));
    }

    @TargetApi(value=23)
    private boolean shouldShowRequestPermissionRationaleImplementation(Activity activity, String ... permissions) {
        for (String p : permissions) {
            if (this.isGranted(p) || activity.shouldShowRequestPermissionRationale(p)) continue;
            return false;
        }
        return true;
    }

    @TargetApi(value=23)
    void requestPermissionsFromFragment(String[] permissions) {
        this.mRxPermissionsFragment.log("requestPermissionsFromFragment " + TextUtils.join((CharSequence)", ", (Object[])permissions));
        this.mRxPermissionsFragment.requestPermissions(permissions);
    }

    public boolean isGranted(String permission2) {
        return !this.isMarshmallow() || this.mRxPermissionsFragment.isGranted(permission2);
    }

    public boolean isRevoked(String permission2) {
        return this.isMarshmallow() && this.mRxPermissionsFragment.isRevoked(permission2);
    }

    boolean isMarshmallow() {
        return Build.VERSION.SDK_INT >= 23;
    }

    void onRequestPermissionsResult(String[] permissions, int[] grantResults) {
        this.mRxPermissionsFragment.onRequestPermissionsResult(permissions, grantResults, new boolean[permissions.length]);
    }
}

