/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.observable;

import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.observable.ObserverListener;
import com.luck.picture.lib.observable.SubjectListener;
import java.util.ArrayList;
import java.util.List;

public class ImagesObservable
implements SubjectListener {
    private List<ObserverListener> observers = new ArrayList<ObserverListener>();
    private List<LocalMediaFolder> folders = new ArrayList<LocalMediaFolder>();
    private List<LocalMedia> medias = new ArrayList<LocalMedia>();
    private List<LocalMedia> selectedImages = new ArrayList<LocalMedia>();
    private static ImagesObservable sObserver;

    private ImagesObservable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImagesObservable getInstance() {
        if (sObserver != null) return sObserver;
        Class<ImagesObservable> clazz = ImagesObservable.class;
        synchronized (ImagesObservable.class) {
            if (sObserver != null) return sObserver;
            sObserver = new ImagesObservable();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sObserver;
        }
    }

    public void saveLocalFolders(List<LocalMediaFolder> list) {
        if (list != null) {
            this.folders = list;
        }
    }

    public void saveLocalMedia(List<LocalMedia> list) {
        this.medias = list;
    }

    public List<LocalMedia> readLocalMedias() {
        if (this.medias == null) {
            this.medias = new ArrayList<LocalMedia>();
        }
        return this.medias;
    }

    public List<LocalMediaFolder> readLocalFolders() {
        if (this.folders == null) {
            this.folders = new ArrayList<LocalMediaFolder>();
        }
        return this.folders;
    }

    public List<LocalMedia> readSelectLocalMedias() {
        return this.selectedImages;
    }

    public void clearLocalFolders() {
        if (this.folders != null) {
            this.folders.clear();
        }
    }

    public void clearLocalMedia() {
        if (this.medias != null) {
            this.medias.clear();
        }
    }

    public void clearSelectedLocalMedia() {
        if (this.selectedImages != null) {
            this.selectedImages.clear();
        }
    }

    @Override
    public void add(ObserverListener observerListener) {
        this.observers.add(observerListener);
    }

    @Override
    public void remove(ObserverListener observerListener) {
        if (this.observers.contains(observerListener)) {
            this.observers.remove(observerListener);
        }
    }
}

