/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.compress;

import android.text.TextUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

class Checker {
    private static List<String> format = new ArrayList<String>();
    private static final String JPG = "jpg";
    private static final String JPEG = "jpeg";
    private static final String PNG = "png";
    private static final String WEBP = "webp";
    private static final String GIF = "gif";
    private static final String BMP = "bmp";

    Checker() {
    }

    static boolean isImage(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        String suffix = path.substring(path.lastIndexOf(".") + 1, path.length());
        return format.contains(suffix.toLowerCase());
    }

    static boolean isJPG(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        String suffix = path.substring(path.lastIndexOf("."), path.length()).toLowerCase();
        return suffix.contains(JPG) || suffix.contains(JPEG);
    }

    static String checkSuffix(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return ".jpg";
        }
        return path.substring(path.lastIndexOf("."), path.length());
    }

    static boolean isNeedCompress(int leastCompressSize, String path) {
        if (leastCompressSize > 0) {
            File source = new File(path);
            if (!source.exists()) {
                return false;
            }
            if (source.length() <= (long)(leastCompressSize << 10)) {
                return false;
            }
        }
        return true;
    }

    static {
        format.add(JPG);
        format.add(JPEG);
        format.add(PNG);
        format.add(WEBP);
        format.add(GIF);
        format.add(BMP);
    }
}

