/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.support.v4.content.FileProvider;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SimpleItemAnimator;
import android.util.Log;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import com.luck.picture.lib.PictureBaseActivity;
import com.luck.picture.lib.PicturePreviewActivity;
import com.luck.picture.lib.PictureSelector;
import com.luck.picture.lib.PictureVideoPlayActivity;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.PictureAlbumDirectoryAdapter;
import com.luck.picture.lib.adapter.PictureImageGridAdapter;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.decoration.GridSpacingItemDecoration;
import com.luck.picture.lib.dialog.CustomDialog;
import com.luck.picture.lib.entity.EventEntity;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.model.LocalMediaLoader;
import com.luck.picture.lib.observable.ImagesObservable;
import com.luck.picture.lib.permissions.RxPermissions;
import com.luck.picture.lib.rxbus2.RxBus;
import com.luck.picture.lib.rxbus2.Subscribe;
import com.luck.picture.lib.rxbus2.ThreadMode;
import com.luck.picture.lib.tools.DateUtils;
import com.luck.picture.lib.tools.DoubleUtils;
import com.luck.picture.lib.tools.LightStatusBarUtils;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.ScreenUtils;
import com.luck.picture.lib.tools.StringUtils;
import com.luck.picture.lib.widget.FolderPopWindow;
import com.luck.picture.lib.widget.PhotoPopupWindow;
import com.yalantis.ucrop.UCrop;
import com.yalantis.ucrop.UCropMulti;
import com.yalantis.ucrop.model.CutInfo;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PictureSelectorActivity
extends PictureBaseActivity
implements View.OnClickListener,
PictureAlbumDirectoryAdapter.OnItemClickListener,
PictureImageGridAdapter.OnPhotoSelectChangedListener,
PhotoPopupWindow.OnItemClickListener {
    private static final String TAG = PictureSelectorActivity.class.getSimpleName();
    private static final int SHOW_DIALOG = 0;
    private static final int DISMISS_DIALOG = 1;
    private static final int STATUSBAR = 2;
    private ImageView picture_left_back;
    private TextView picture_title;
    private TextView picture_right;
    private TextView picture_tv_ok;
    private TextView tv_empty;
    private TextView picture_tv_img_num;
    private TextView picture_id_preview;
    private TextView tv_PlayPause;
    private TextView tv_Stop;
    private TextView tv_Quit;
    private TextView tv_musicStatus;
    private TextView tv_musicTotal;
    private TextView tv_musicTime;
    private RelativeLayout rl_picture_title;
    private RelativeLayout rl_bottom;
    private LinearLayout id_ll_ok;
    private RecyclerView picture_recycler;
    private PictureImageGridAdapter adapter;
    private List<LocalMedia> images = new ArrayList<LocalMedia>();
    private List<LocalMediaFolder> foldersList = new ArrayList<LocalMediaFolder>();
    private FolderPopWindow folderWindow;
    private Animation animation = null;
    private boolean anim = false;
    private RxPermissions rxPermissions;
    private PhotoPopupWindow popupWindow;
    private LocalMediaLoader mediaLoader;
    private MediaPlayer mediaPlayer;
    private SeekBar musicSeekBar;
    private boolean isPlayAudio = false;
    private CustomDialog audioDialog;
    private int audioH;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 0: {
                    PictureSelectorActivity.this.showPleaseDialog();
                    break;
                }
                case 1: {
                    PictureSelectorActivity.this.dismissDialog();
                    break;
                }
                case 2: {
                    LightStatusBarUtils.setLightStatusBar((Activity)PictureSelectorActivity.this, PictureSelectorActivity.this.statusFont);
                }
            }
        }
    };
    public Handler handler = new Handler();
    public Runnable runnable = new Runnable(){

        @Override
        public void run() {
            try {
                if (PictureSelectorActivity.this.mediaPlayer != null) {
                    PictureSelectorActivity.this.tv_musicTime.setText((CharSequence)DateUtils.timeParse(PictureSelectorActivity.this.mediaPlayer.getCurrentPosition()));
                    PictureSelectorActivity.this.musicSeekBar.setProgress(PictureSelectorActivity.this.mediaPlayer.getCurrentPosition());
                    PictureSelectorActivity.this.musicSeekBar.setMax(PictureSelectorActivity.this.mediaPlayer.getDuration());
                    PictureSelectorActivity.this.tv_musicTotal.setText((CharSequence)DateUtils.timeParse(PictureSelectorActivity.this.mediaPlayer.getDuration()));
                    PictureSelectorActivity.this.handler.postDelayed(PictureSelectorActivity.this.runnable, 200L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void eventBus(EventEntity obj) {
        switch (obj.what) {
            case 2774: {
                List<LocalMedia> selectImages = obj.medias;
                this.anim = selectImages.size() > 0;
                int position = obj.position;
                Log.i((String)"\u5237\u65b0\u4e0b\u6807:", (String)String.valueOf(position));
                this.adapter.bindSelectImages(selectImages);
                this.adapter.notifyItemChanged(position);
                break;
            }
            case 2771: {
                List<LocalMedia> medias = obj.medias;
                if (medias.size() <= 0) break;
                String pictureType = medias.get(0).getPictureType();
                if (this.config.isCompress && pictureType.startsWith("image")) {
                    this.compressImage(medias);
                    break;
                }
                this.onResult(medias);
            }
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (!RxBus.getDefault().isRegistered(this)) {
            RxBus.getDefault().register(this);
        }
        this.rxPermissions = new RxPermissions((Activity)this);
        this.mHandler.sendEmptyMessage(2);
        if (this.config.camera) {
            this.setTheme(R.style.activity_Theme_Transparent);
            if (savedInstanceState == null) {
                this.rxPermissions.request("android.permission.READ_EXTERNAL_STORAGE").subscribe((Observer)new Observer<Boolean>(){

                    public void onSubscribe(Disposable d) {
                    }

                    public void onNext(Boolean aBoolean) {
                        if (aBoolean.booleanValue()) {
                            PictureSelectorActivity.this.onTakePhoto();
                        } else {
                            PictureSelectorActivity.this.showToast(PictureSelectorActivity.this.getString(R.string.picture_camera));
                            PictureSelectorActivity.this.closeActivity();
                        }
                    }

                    public void onError(Throwable e) {
                    }

                    public void onComplete() {
                    }
                });
            }
            this.getWindow().setFlags(1024, 1024);
            this.setContentView(R.layout.picture_empty);
        } else {
            this.setContentView(R.layout.picture_selector);
            this.initView(savedInstanceState);
        }
    }

    private void initView(Bundle savedInstanceState) {
        this.rl_picture_title = (RelativeLayout)this.findViewById(R.id.rl_picture_title);
        this.picture_left_back = (ImageView)this.findViewById(R.id.picture_left_back);
        this.picture_title = (TextView)this.findViewById(R.id.picture_title);
        this.picture_right = (TextView)this.findViewById(R.id.picture_right);
        this.picture_tv_ok = (TextView)this.findViewById(R.id.picture_tv_ok);
        this.picture_id_preview = (TextView)this.findViewById(R.id.picture_id_preview);
        this.picture_tv_img_num = (TextView)this.findViewById(R.id.picture_tv_img_num);
        this.picture_recycler = (RecyclerView)this.findViewById(R.id.picture_recycler);
        this.rl_bottom = (RelativeLayout)this.findViewById(R.id.rl_bottom);
        this.id_ll_ok = (LinearLayout)this.findViewById(R.id.id_ll_ok);
        this.tv_empty = (TextView)this.findViewById(R.id.tv_empty);
        this.isNumComplete(this.numComplete);
        if (this.config.mimeType == PictureMimeType.ofAll()) {
            this.popupWindow = new PhotoPopupWindow((Context)this);
            this.popupWindow.setOnItemClickListener(this);
        }
        this.picture_id_preview.setOnClickListener((View.OnClickListener)this);
        if (this.config.mimeType == PictureMimeType.ofAudio()) {
            this.picture_id_preview.setVisibility(8);
            this.audioH = ScreenUtils.getScreenHeight(this.mContext) + ScreenUtils.getStatusBarHeight(this.mContext);
        } else {
            this.picture_id_preview.setVisibility(this.config.mimeType == 2 ? 8 : 0);
        }
        this.picture_left_back.setOnClickListener((View.OnClickListener)this);
        this.picture_right.setOnClickListener((View.OnClickListener)this);
        this.id_ll_ok.setOnClickListener((View.OnClickListener)this);
        this.picture_title.setOnClickListener((View.OnClickListener)this);
        String title = this.config.mimeType == PictureMimeType.ofAudio() ? this.getString(R.string.picture_all_audio) : this.getString(R.string.picture_camera_roll);
        this.picture_title.setText((CharSequence)title);
        this.folderWindow = new FolderPopWindow((Context)this, this.config.mimeType);
        this.folderWindow.setPictureTitleView(this.picture_title);
        this.folderWindow.setOnItemClickListener(this);
        this.picture_recycler.setHasFixedSize(true);
        this.picture_recycler.addItemDecoration((RecyclerView.ItemDecoration)new GridSpacingItemDecoration(this.config.imageSpanCount, ScreenUtils.dip2px((Context)this, 2.0f), false));
        this.picture_recycler.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager((Context)this, this.config.imageSpanCount));
        ((SimpleItemAnimator)this.picture_recycler.getItemAnimator()).setSupportsChangeAnimations(false);
        this.mediaLoader = new LocalMediaLoader(this, this.config.mimeType, this.config.isGif, this.config.videoMaxSecond, this.config.videoMinSecond);
        this.rxPermissions.request("android.permission.READ_EXTERNAL_STORAGE").subscribe((Observer)new Observer<Boolean>(){

            public void onSubscribe(Disposable d) {
            }

            public void onNext(Boolean aBoolean) {
                if (aBoolean.booleanValue()) {
                    PictureSelectorActivity.this.mHandler.sendEmptyMessage(0);
                    PictureSelectorActivity.this.readLocalMedia();
                } else {
                    PictureSelectorActivity.this.showToast(PictureSelectorActivity.this.getString(R.string.picture_jurisdiction));
                }
            }

            public void onError(Throwable e) {
            }

            public void onComplete() {
            }
        });
        this.tv_empty.setText((CharSequence)(this.config.mimeType == PictureMimeType.ofAudio() ? this.getString(R.string.picture_audio_empty) : this.getString(R.string.picture_empty)));
        StringUtils.tempTextFont(this.tv_empty, this.config.mimeType);
        if (savedInstanceState != null) {
            this.selectionMedias = PictureSelector.obtainSelectorList(savedInstanceState);
        }
        this.adapter = new PictureImageGridAdapter(this.mContext, this.config);
        this.adapter.setOnPhotoSelectChangedListener(this);
        this.adapter.bindSelectImages(this.selectionMedias);
        this.picture_recycler.setAdapter((RecyclerView.Adapter)this.adapter);
        String titleText = this.picture_title.getText().toString().trim();
        if (this.config.isCamera) {
            this.config.isCamera = StringUtils.isCamera(titleText);
        }
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.adapter != null) {
            List<LocalMedia> selectedImages = this.adapter.getSelectedImages();
            PictureSelector.saveSelectorList(outState, selectedImages);
        }
    }

    private void isNumComplete(boolean numComplete) {
        this.picture_tv_ok.setText((CharSequence)(numComplete ? this.getString(R.string.picture_done_front_num, new Object[]{0, this.config.selectionMode == 1 ? 1 : this.config.maxSelectNum}) : this.getString(R.string.picture_please_select)));
        if (!numComplete) {
            this.animation = AnimationUtils.loadAnimation((Context)this, (int)R.anim.modal_in);
        }
        this.animation = numComplete ? null : AnimationUtils.loadAnimation((Context)this, (int)R.anim.modal_in);
    }

    protected void readLocalMedia() {
        this.mediaLoader.loadAllMedia(new LocalMediaLoader.LocalMediaLoadListener(){

            @Override
            public void loadComplete(List<LocalMediaFolder> folders) {
                if (folders.size() > 0) {
                    PictureSelectorActivity.this.foldersList = folders;
                    LocalMediaFolder folder = folders.get(0);
                    folder.setChecked(true);
                    List<LocalMedia> localImg = folder.getImages();
                    if (localImg.size() >= PictureSelectorActivity.this.images.size()) {
                        PictureSelectorActivity.this.images = localImg;
                        PictureSelectorActivity.this.folderWindow.bindFolder(folders);
                    }
                }
                if (PictureSelectorActivity.this.adapter != null) {
                    if (PictureSelectorActivity.this.images == null) {
                        PictureSelectorActivity.this.images = new ArrayList();
                    }
                    PictureSelectorActivity.this.adapter.bindImagesData(PictureSelectorActivity.this.images);
                    PictureSelectorActivity.this.tv_empty.setVisibility(PictureSelectorActivity.this.images.size() > 0 ? 4 : 0);
                }
                PictureSelectorActivity.this.mHandler.sendEmptyMessage(1);
            }
        });
    }

    public void startCamera() {
        if (!DoubleUtils.isFastDoubleClick() || this.config.camera) {
            switch (this.config.mimeType) {
                case 0: {
                    if (this.popupWindow != null) {
                        if (this.popupWindow.isShowing()) {
                            this.popupWindow.dismiss();
                        }
                        this.popupWindow.showAsDropDown((View)this.rl_picture_title);
                        break;
                    }
                    this.startOpenCamera();
                    break;
                }
                case 1: {
                    this.startOpenCamera();
                    break;
                }
                case 2: {
                    this.startOpenCameraVideo();
                    break;
                }
                case 3: {
                    this.startOpenCameraAudio();
                }
            }
        }
    }

    public void startOpenCamera() {
        Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (cameraIntent.resolveActivity(this.getPackageManager()) != null) {
            int type = this.config.mimeType == 0 ? 1 : this.config.mimeType;
            File cameraFile = PictureFileUtils.createCameraFile((Context)this, type, this.outputCameraPath, this.config.suffixType);
            this.cameraPath = cameraFile.getAbsolutePath();
            Uri imageUri = this.parUri(cameraFile);
            cameraIntent.putExtra("output", (Parcelable)imageUri);
            this.startActivityForResult(cameraIntent, 909);
        }
    }

    public void startOpenCameraVideo() {
        Intent cameraIntent = new Intent("android.media.action.VIDEO_CAPTURE");
        if (cameraIntent.resolveActivity(this.getPackageManager()) != null) {
            File cameraFile = PictureFileUtils.createCameraFile((Context)this, this.config.mimeType == 0 ? 2 : this.config.mimeType, this.outputCameraPath, this.config.suffixType);
            this.cameraPath = cameraFile.getAbsolutePath();
            Uri imageUri = this.parUri(cameraFile);
            cameraIntent.putExtra("output", (Parcelable)imageUri);
            cameraIntent.putExtra("android.intent.extra.durationLimit", this.config.recordVideoSecond);
            cameraIntent.putExtra("android.intent.extra.videoQuality", this.config.videoQuality);
            this.startActivityForResult(cameraIntent, 909);
        }
    }

    public void startOpenCameraAudio() {
        this.rxPermissions.request("android.permission.RECORD_AUDIO").subscribe((Observer)new Observer<Boolean>(){

            public void onSubscribe(Disposable d) {
            }

            public void onNext(Boolean aBoolean) {
                if (aBoolean.booleanValue()) {
                    Intent cameraIntent = new Intent("android.provider.MediaStore.RECORD_SOUND");
                    if (cameraIntent.resolveActivity(PictureSelectorActivity.this.getPackageManager()) != null) {
                        File cameraFile = PictureFileUtils.createCameraFile((Context)PictureSelectorActivity.this, PictureSelectorActivity.this.config.mimeType, PictureSelectorActivity.this.outputCameraPath, PictureSelectorActivity.this.config.suffixType);
                        PictureSelectorActivity.this.cameraPath = cameraFile.getAbsolutePath();
                        Uri imageUri = PictureSelectorActivity.this.parUri(cameraFile);
                        cameraIntent.putExtra("output", (Parcelable)imageUri);
                        PictureSelectorActivity.this.startActivityForResult(cameraIntent, 909);
                    }
                } else {
                    PictureSelectorActivity.this.showToast(PictureSelectorActivity.this.getString(R.string.picture_audio));
                }
            }

            public void onError(Throwable e) {
            }

            public void onComplete() {
            }
        });
    }

    private Uri parUri(File cameraFile) {
        String authority = this.getPackageName() + ".provider";
        Uri imageUri = Build.VERSION.SDK_INT > 23 ? FileProvider.getUriForFile((Context)this.mContext, (String)authority, (File)cameraFile) : Uri.fromFile((File)cameraFile);
        return imageUri;
    }

    public void onClick(View v) {
        List<LocalMedia> selectedImages;
        int id2 = v.getId();
        if (id2 == R.id.picture_left_back || id2 == R.id.picture_right) {
            if (this.folderWindow.isShowing()) {
                this.folderWindow.dismiss();
            } else {
                this.closeActivity();
            }
        }
        if (id2 == R.id.picture_title) {
            if (this.folderWindow.isShowing()) {
                this.folderWindow.dismiss();
            } else if (this.images != null && this.images.size() > 0) {
                this.folderWindow.showAsDropDown((View)this.rl_picture_title);
                selectedImages = this.adapter.getSelectedImages();
                this.folderWindow.notifyDataCheckedStatus(selectedImages);
            }
        }
        if (id2 == R.id.picture_id_preview) {
            selectedImages = this.adapter.getSelectedImages();
            ArrayList<LocalMedia> medias = new ArrayList<LocalMedia>();
            for (LocalMedia media : selectedImages) {
                medias.add(media);
            }
            Bundle bundle = new Bundle();
            bundle.putSerializable("previewSelectList", (Serializable)medias);
            bundle.putSerializable("selectList", (Serializable)((Object)selectedImages));
            bundle.putBoolean("bottom_preview", true);
            this.startActivity(PicturePreviewActivity.class, bundle, this.config.selectionMode == 1 ? 69 : 609);
            this.overridePendingTransition(R.anim.a5, 0);
        }
        if (id2 == R.id.id_ll_ok) {
            List<LocalMedia> images = this.adapter.getSelectedImages();
            LocalMedia image = images.size() > 0 ? images.get(0) : null;
            String pictureType = image != null ? image.getPictureType() : "";
            int size = images.size();
            boolean eqImg = pictureType.startsWith("image");
            if (this.config.minSelectNum > 0 && this.config.selectionMode == 2 && size < this.config.minSelectNum) {
                String str = eqImg ? this.getString(R.string.picture_min_img_num, new Object[]{this.config.minSelectNum}) : this.getString(R.string.picture_min_video_num, new Object[]{this.config.minSelectNum});
                this.showToast(str);
                return;
            }
            if (this.config.enableCrop && eqImg) {
                if (this.config.selectionMode == 1) {
                    this.originalPath = image.getPath();
                    this.startCrop(this.originalPath);
                } else {
                    ArrayList<String> medias = new ArrayList<String>();
                    for (LocalMedia media : images) {
                        medias.add(media.getPath());
                    }
                    this.startCrop(medias);
                }
            } else if (this.config.isCompress && eqImg) {
                this.compressImage(images);
            } else {
                this.onResult(images);
            }
        }
    }

    private void audioDialog(final String path) {
        this.audioDialog = new CustomDialog(this.mContext, -1, this.audioH, R.layout.picture_audio_dialog, R.style.Theme_dialog);
        this.audioDialog.getWindow().setWindowAnimations(R.style.Dialog_Audio_StyleAnim);
        this.tv_musicStatus = (TextView)this.audioDialog.findViewById(R.id.tv_musicStatus);
        this.tv_musicTime = (TextView)this.audioDialog.findViewById(R.id.tv_musicTime);
        this.musicSeekBar = (SeekBar)this.audioDialog.findViewById(R.id.musicSeekBar);
        this.tv_musicTotal = (TextView)this.audioDialog.findViewById(R.id.tv_musicTotal);
        this.tv_PlayPause = (TextView)this.audioDialog.findViewById(R.id.tv_PlayPause);
        this.tv_Stop = (TextView)this.audioDialog.findViewById(R.id.tv_Stop);
        this.tv_Quit = (TextView)this.audioDialog.findViewById(R.id.tv_Quit);
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                PictureSelectorActivity.this.initPlayer(path);
            }
        }, 30L);
        this.tv_PlayPause.setOnClickListener((View.OnClickListener)new audioOnClick(path));
        this.tv_Stop.setOnClickListener((View.OnClickListener)new audioOnClick(path));
        this.tv_Quit.setOnClickListener((View.OnClickListener)new audioOnClick(path));
        this.musicSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (fromUser) {
                    PictureSelectorActivity.this.mediaPlayer.seekTo(progress);
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        this.audioDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                PictureSelectorActivity.this.handler.removeCallbacks(PictureSelectorActivity.this.runnable);
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        PictureSelectorActivity.this.stop(path);
                    }
                }, 30L);
                try {
                    if (PictureSelectorActivity.this.audioDialog != null && PictureSelectorActivity.this.audioDialog.isShowing()) {
                        PictureSelectorActivity.this.audioDialog.dismiss();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.handler.post(this.runnable);
        this.audioDialog.show();
    }

    private void initPlayer(String path) {
        this.mediaPlayer = new MediaPlayer();
        try {
            this.mediaPlayer.setDataSource(path);
            this.mediaPlayer.prepare();
            this.mediaPlayer.setLooping(true);
            this.playAudio();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void playAudio() {
        String ppStr;
        if (this.mediaPlayer != null) {
            this.musicSeekBar.setProgress(this.mediaPlayer.getCurrentPosition());
            this.musicSeekBar.setMax(this.mediaPlayer.getDuration());
        }
        if ((ppStr = this.tv_PlayPause.getText().toString()).equals(this.getString(R.string.picture_play_audio))) {
            this.tv_PlayPause.setText((CharSequence)this.getString(R.string.picture_pause_audio));
            this.tv_musicStatus.setText((CharSequence)this.getString(R.string.picture_play_audio));
            this.playOrPause();
        } else {
            this.tv_PlayPause.setText((CharSequence)this.getString(R.string.picture_play_audio));
            this.tv_musicStatus.setText((CharSequence)this.getString(R.string.picture_pause_audio));
            this.playOrPause();
        }
        if (!this.isPlayAudio) {
            this.handler.post(this.runnable);
            this.isPlayAudio = true;
        }
    }

    public void stop(String path) {
        if (this.mediaPlayer != null) {
            try {
                this.mediaPlayer.stop();
                this.mediaPlayer.reset();
                this.mediaPlayer.setDataSource(path);
                this.mediaPlayer.prepare();
                this.mediaPlayer.seekTo(0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void playOrPause() {
        try {
            if (this.mediaPlayer != null) {
                if (this.mediaPlayer.isPlaying()) {
                    this.mediaPlayer.pause();
                } else {
                    this.mediaPlayer.start();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onItemClick(String folderName, List<LocalMedia> images) {
        boolean camera = StringUtils.isCamera(folderName);
        camera = this.config.isCamera ? camera : false;
        this.adapter.setShowCamera(camera);
        this.picture_title.setText((CharSequence)folderName);
        this.adapter.bindImagesData(images);
        this.folderWindow.dismiss();
    }

    @Override
    public void onTakePhoto() {
        this.rxPermissions.request("android.permission.CAMERA").subscribe((Observer)new Observer<Boolean>(){

            public void onSubscribe(Disposable d) {
            }

            public void onNext(Boolean aBoolean) {
                if (aBoolean.booleanValue()) {
                    PictureSelectorActivity.this.startCamera();
                } else {
                    PictureSelectorActivity.this.showToast(PictureSelectorActivity.this.getString(R.string.picture_camera));
                    if (PictureSelectorActivity.this.config.camera) {
                        PictureSelectorActivity.this.closeActivity();
                    }
                }
            }

            public void onError(Throwable e) {
            }

            public void onComplete() {
            }
        });
    }

    @Override
    public void onChange(List<LocalMedia> selectImages) {
        this.changeImageNumber(selectImages);
    }

    @Override
    public void onPictureClick(LocalMedia media, int position) {
        List<LocalMedia> images = this.adapter.getImages();
        this.startPreview(images, position);
    }

    public void startPreview(List<LocalMedia> previewImages, int position) {
        LocalMedia media = previewImages.get(position);
        String pictureType = media.getPictureType();
        Bundle bundle = new Bundle();
        ArrayList<LocalMedia> result = new ArrayList<LocalMedia>();
        int mediaType = PictureMimeType.isPictureType(pictureType);
        switch (mediaType) {
            case 1: {
                List<LocalMedia> selectedImages = this.adapter.getSelectedImages();
                ImagesObservable.getInstance().saveLocalMedia(previewImages);
                bundle.putSerializable("selectList", (Serializable)((Object)selectedImages));
                bundle.putInt("position", position);
                this.startActivity(PicturePreviewActivity.class, bundle, this.config.selectionMode == 1 ? 69 : 609);
                this.overridePendingTransition(R.anim.a5, 0);
                break;
            }
            case 2: {
                if (this.config.selectionMode == 1) {
                    result.add(media);
                    this.onResult(result);
                    break;
                }
                bundle.putString("video_path", media.getPath());
                this.startActivity(PictureVideoPlayActivity.class, bundle);
                break;
            }
            case 3: {
                if (this.config.selectionMode == 1) {
                    result.add(media);
                    this.onResult(result);
                    break;
                }
                this.audioDialog(media.getPath());
            }
        }
    }

    public void changeImageNumber(List<LocalMedia> selectImages) {
        boolean enable;
        String pictureType;
        String string2 = pictureType = selectImages.size() > 0 ? selectImages.get(0).getPictureType() : "";
        if (this.config.mimeType == PictureMimeType.ofAudio()) {
            this.picture_id_preview.setVisibility(8);
        } else {
            boolean isVideo = PictureMimeType.isVideo(pictureType);
            boolean eqVideo = this.config.mimeType == 2;
            this.picture_id_preview.setVisibility(isVideo || eqVideo ? 8 : 0);
        }
        boolean bl = enable = selectImages.size() != 0;
        if (enable) {
            this.id_ll_ok.setEnabled(true);
            this.picture_id_preview.setEnabled(true);
            this.picture_id_preview.setSelected(true);
            this.picture_tv_ok.setSelected(true);
            if (this.numComplete) {
                this.picture_tv_ok.setText((CharSequence)this.getString(R.string.picture_done_front_num, new Object[]{selectImages.size(), this.config.selectionMode == 1 ? 1 : this.config.maxSelectNum}));
            } else {
                if (!this.anim) {
                    this.picture_tv_img_num.startAnimation(this.animation);
                }
                this.picture_tv_img_num.setVisibility(0);
                this.picture_tv_img_num.setText((CharSequence)String.valueOf(selectImages.size()));
                this.picture_tv_ok.setText((CharSequence)this.getString(R.string.picture_completed));
                this.anim = false;
            }
        } else {
            this.id_ll_ok.setEnabled(false);
            this.picture_id_preview.setEnabled(false);
            this.picture_id_preview.setSelected(false);
            this.picture_tv_ok.setSelected(false);
            if (this.numComplete) {
                this.picture_tv_ok.setText((CharSequence)this.getString(R.string.picture_done_front_num, new Object[]{0, this.config.selectionMode == 1 ? 1 : this.config.maxSelectNum}));
            } else {
                this.picture_tv_img_num.setVisibility(4);
                this.picture_tv_ok.setText((CharSequence)this.getString(R.string.picture_please_select));
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        block26: {
            block25: {
                if (resultCode != -1) break block25;
                ArrayList<LocalMedia> medias = new ArrayList<LocalMedia>();
                switch (requestCode) {
                    case 69: {
                        LocalMedia image;
                        if (this.adapter == null) break;
                        List<LocalMedia> mediaList = this.adapter.getSelectedImages();
                        LocalMedia localMedia = image = mediaList != null && mediaList.size() > 0 ? mediaList.get(0) : null;
                        if (image != null) {
                            this.originalPath = image.getPath();
                            Uri resultUri = UCrop.getOutput((Intent)data);
                            String cutPath = resultUri.getPath();
                            LocalMedia media = new LocalMedia(this.originalPath, image.getDuration(), false, image.getPosition(), image.getNum(), this.config.mimeType);
                            media.setCutPath(cutPath);
                            media.setCut(true);
                            String imageType = PictureMimeType.createImageType(cutPath);
                            media.setPictureType(imageType);
                            medias.add(media);
                            this.handlerResult(medias);
                            break;
                        }
                        break block26;
                    }
                    case 609: {
                        List mCuts = UCropMulti.getOutput((Intent)data);
                        for (CutInfo c : mCuts) {
                            LocalMedia media = new LocalMedia();
                            String imageType = PictureMimeType.createImageType(c.getPath());
                            media.setCut(true);
                            media.setPath(c.getPath());
                            media.setCutPath(c.getCutPath());
                            media.setPictureType(imageType);
                            media.setMimeType(this.config.mimeType);
                            medias.add(media);
                        }
                        this.handlerResult(medias);
                        break;
                    }
                    case 909: {
                        int lastImageId;
                        this.isAudio(data);
                        File file = new File(this.cameraPath);
                        this.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.fromFile((File)file)));
                        String toType = PictureMimeType.fileToType(file);
                        if (this.config.mimeType != PictureMimeType.ofAudio()) {
                            int degree = PictureFileUtils.readPictureDegree(file.getAbsolutePath());
                            this.rotateImage(degree, file);
                        }
                        LocalMedia media = new LocalMedia();
                        media.setPath(this.cameraPath);
                        boolean eqVideo = toType.startsWith("video");
                        int duration = eqVideo ? PictureMimeType.getLocalVideoDuration(this.cameraPath) : 0;
                        String pictureType = "";
                        if (this.config.mimeType == PictureMimeType.ofAudio()) {
                            pictureType = "audio/mpeg";
                            duration = PictureMimeType.getLocalVideoDuration(this.cameraPath);
                        } else {
                            pictureType = eqVideo ? PictureMimeType.createVideoType(this.cameraPath) : PictureMimeType.createImageType(this.cameraPath);
                        }
                        media.setPictureType(pictureType);
                        media.setDuration(duration);
                        media.setMimeType(this.config.mimeType);
                        if (this.config.camera) {
                            boolean eqImg = toType.startsWith("image");
                            if (this.config.enableCrop && eqImg) {
                                this.originalPath = this.cameraPath;
                                this.startCrop(this.cameraPath);
                            } else if (this.config.isCompress && eqImg) {
                                medias.add(media);
                                this.compressImage(medias);
                                if (this.adapter != null) {
                                    this.images.add(0, media);
                                    this.adapter.notifyDataSetChanged();
                                }
                            } else {
                                medias.add(media);
                                this.onResult(medias);
                            }
                        } else {
                            this.images.add(0, media);
                            if (this.adapter != null) {
                                boolean toEqual;
                                List<LocalMedia> selectedImages = this.adapter.getSelectedImages();
                                if (selectedImages.size() < this.config.maxSelectNum && ((toEqual = PictureMimeType.mimeToEqual(pictureType = selectedImages.size() > 0 ? selectedImages.get(0).getPictureType() : "", media.getPictureType())) || selectedImages.size() == 0) && selectedImages.size() < this.config.maxSelectNum) {
                                    if (this.config.selectionMode == 1) {
                                        this.singleRadioMediaImage();
                                    }
                                    selectedImages.add(media);
                                    this.adapter.bindSelectImages(selectedImages);
                                }
                                this.adapter.notifyDataSetChanged();
                            }
                        }
                        if (this.adapter != null) {
                            this.manualSaveFolder(media);
                            this.tv_empty.setVisibility(this.images.size() > 0 ? 4 : 0);
                        }
                        if (this.config.mimeType == PictureMimeType.ofAudio() || (lastImageId = this.getLastImageId(eqVideo)) == -1) break;
                        this.removeImage(lastImageId, eqVideo);
                    }
                }
                break block26;
            }
            if (resultCode == 0) {
                if (this.config.camera) {
                    this.closeActivity();
                }
            } else if (resultCode == 96) {
                Throwable throwable = (Throwable)data.getSerializableExtra("com.yalantis.ucrop.Error");
                this.showToast(throwable.getMessage());
            }
        }
    }

    private void singleRadioMediaImage() {
        List<LocalMedia> selectImages;
        if (this.adapter != null && (selectImages = this.adapter.getSelectedImages()) != null && selectImages.size() > 0) {
            selectImages.clear();
        }
    }

    private void manualSaveFolder(LocalMedia media) {
        try {
            LocalMediaFolder cameraFolder;
            this.createNewFolder(this.foldersList);
            LocalMediaFolder folder = this.getImageFolder(media.getPath(), this.foldersList);
            LocalMediaFolder localMediaFolder = cameraFolder = this.foldersList.size() > 0 ? this.foldersList.get(0) : null;
            if (cameraFolder != null && folder != null) {
                cameraFolder.setFirstImagePath(media.getPath());
                cameraFolder.setImages(this.images);
                cameraFolder.setImageNum(cameraFolder.getImageNum() + 1);
                int num = folder.getImageNum() + 1;
                folder.setImageNum(num);
                folder.getImages().add(0, media);
                folder.setFirstImagePath(this.cameraPath);
                this.folderWindow.bindFolder(this.foldersList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.closeActivity();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (RxBus.getDefault().isRegistered(this)) {
            RxBus.getDefault().unregister(this);
        }
        ImagesObservable.getInstance().clearLocalMedia();
        if (this.animation != null) {
            this.animation.cancel();
            this.animation = null;
        }
        if (this.mediaPlayer != null && this.handler != null) {
            this.handler.removeCallbacks(this.runnable);
            this.mediaPlayer.release();
            this.mediaPlayer = null;
        }
    }

    @Override
    public void onItemClick(int position) {
        switch (position) {
            case 0: {
                this.startOpenCamera();
                break;
            }
            case 1: {
                this.startOpenCameraVideo();
            }
        }
    }

    public class audioOnClick
    implements View.OnClickListener {
        private String path;

        public audioOnClick(String path) {
            this.path = path;
        }

        public void onClick(View v) {
            int id2 = v.getId();
            if (id2 == R.id.tv_PlayPause) {
                PictureSelectorActivity.this.playAudio();
            }
            if (id2 == R.id.tv_Stop) {
                PictureSelectorActivity.this.tv_musicStatus.setText((CharSequence)PictureSelectorActivity.this.getString(R.string.picture_stop_audio));
                PictureSelectorActivity.this.tv_PlayPause.setText((CharSequence)PictureSelectorActivity.this.getString(R.string.picture_play_audio));
                PictureSelectorActivity.this.stop(this.path);
            }
            if (id2 == R.id.tv_Quit) {
                PictureSelectorActivity.this.handler.removeCallbacks(PictureSelectorActivity.this.runnable);
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        PictureSelectorActivity.this.stop(audioOnClick.this.path);
                    }
                }, 30L);
                try {
                    if (PictureSelectorActivity.this.audioDialog != null && PictureSelectorActivity.this.audioDialog.isShowing()) {
                        PictureSelectorActivity.this.audioDialog.dismiss();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

