/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.util;

import com.palmergames.bukkit.towny.TownySettings;
import java.util.ArrayList;
import java.util.List;

public class TimeMgmt {
    public static final long[][] defaultCountdownDelays = new long[][]{{10L, 1L}, {30L, 5L}, {60L, 10L}, {300L, 60L}, {1800L, 300L}, {3600L, 600L}, {86400L, 3600L}, {Integer.MAX_VALUE, 86400L}};

    public static List<Long> getCountdownDelays(int start) {
        return TimeMgmt.getCountdownDelays(start, defaultCountdownDelays);
    }

    public static List<Long> getCountdownDelays(int start, long[][] delays) {
        ArrayList<Long> out = new ArrayList<Long>();
        for (long[] delay : delays) {
            if (delay.length == 2) continue;
            return null;
        }
        Integer lastDelayIndex = null;
        long nextWarningAt = Integer.MAX_VALUE;
        block1: for (long t = (long)start; t > 0L; --t) {
            for (int d = 0; d < delays.length; ++d) {
                if (t > delays[d][0] || lastDelayIndex != null && t > nextWarningAt && d >= lastDelayIndex) continue;
                lastDelayIndex = d;
                nextWarningAt = t - delays[d][1];
                out.add(t);
                continue block1;
            }
        }
        return out;
    }

    public static String formatCountdownTime(long l) {
        String out = "";
        if (l >= 3600L) {
            int h = (int)Math.floor(l / 3600L);
            out = h + TownySettings.getLangString("msg_hours");
            l -= (long)(h * 3600);
        }
        if (l >= 60L) {
            int m = (int)Math.floor(l / 60L);
            out = out + (out.length() > 0 ? ", " : "") + m + TownySettings.getLangString("msg_minutes");
            l -= (long)(m * 60);
        }
        if (out.length() == 0 || l > 0L) {
            out = out + (out.length() > 0 ? ", " : "") + l + TownySettings.getLangString("msg_seconds");
        }
        return out;
    }
}

