/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class KeyValueFile {
    private static final String newLine = System.getProperty("line.separator");
    private Map<String, String> keys = new HashMap<String, String>();
    private String fileName;

    public KeyValueFile(String fileName) {
        this.fileName = fileName;
        File file = new File(fileName);
        if (file.exists()) {
            this.load();
        } else {
            this.save();
        }
    }

    public void load() {
        try {
            BufferedReader fin = new BufferedReader(new FileReader(this.fileName));
            try {
                String line;
                while ((line = fin.readLine()) != null) {
                    String lineBeforeComment;
                    String[] tokens = line.split("#");
                    if (tokens.length <= 0 || (tokens = (lineBeforeComment = tokens[0]).split("=")).length < 2) continue;
                    this.keys.put(tokens[0], tokens[1]);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            fin.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        TreeMap<String, String> sortedKeys = new TreeMap<String, String>(this.keys);
        try {
            BufferedWriter output = new BufferedWriter(new FileWriter(this.fileName));
            try {
                for (String key : sortedKeys.keySet()) {
                    output.write(key.toLowerCase() + "=" + (String)sortedKeys.get(key) + newLine);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setMap(Map<String, String> keys) {
        this.keys = keys;
        this.save();
    }

    public String get(String key) {
        return this.keys.get(key);
    }

    public Map<String, String> returnMap() throws Exception {
        return new HashMap<String, String>(this.keys);
    }

    public boolean containsKey(String var) {
        return this.keys.containsKey(var);
    }

    public String getProperty(String var) {
        return this.keys.get(var);
    }

    public void removeKey(String var) {
        if (this.keys.containsKey(var)) {
            this.keys.remove(var);
            this.save();
        }
    }

    public boolean keyExists(String key) {
        return this.containsKey(key);
    }

    public String getString(String key) {
        if (this.containsKey(key)) {
            return this.getProperty(key);
        }
        return "";
    }

    public String getString(String key, String value) {
        if (this.containsKey(key)) {
            return this.getProperty(key);
        }
        this.setString(key, value);
        return value;
    }

    public void setString(String key, String value) {
        this.keys.put(key, value);
        this.save();
    }

    public int getInt(String key) {
        if (this.containsKey(key)) {
            return Integer.parseInt(this.getProperty(key));
        }
        return 0;
    }

    public int getInt(String key, int value) {
        if (this.containsKey(key)) {
            return Integer.parseInt(this.getProperty(key));
        }
        this.setInt(key, value);
        return value;
    }

    public void setInt(String key, int value) {
        this.keys.put(key, String.valueOf(value));
        this.save();
    }

    public double getDouble(String key) {
        if (this.containsKey(key)) {
            return Double.parseDouble(this.getProperty(key));
        }
        return 0.0;
    }

    public double getDouble(String key, double value) {
        if (this.containsKey(key)) {
            return Double.parseDouble(this.getProperty(key));
        }
        this.setDouble(key, value);
        return value;
    }

    public void setDouble(String key, double value) {
        this.keys.put(key, String.valueOf(value));
        this.save();
    }

    public long getLong(String key) {
        if (this.containsKey(key)) {
            return Long.parseLong(this.getProperty(key));
        }
        return 0L;
    }

    public long getLong(String key, long value) {
        if (this.containsKey(key)) {
            return Long.parseLong(this.getProperty(key));
        }
        this.setLong(key, value);
        return value;
    }

    public void setLong(String key, long value) {
        this.keys.put(key, String.valueOf(value));
        this.save();
    }

    public boolean getBoolean(String key) {
        if (this.containsKey(key)) {
            return Boolean.parseBoolean(this.getProperty(key));
        }
        return false;
    }

    public boolean getBoolean(String key, boolean value) {
        if (this.containsKey(key)) {
            return Boolean.parseBoolean(this.getProperty(key));
        }
        this.setBoolean(key, value);
        return value;
    }

    public void setBoolean(String key, boolean value) {
        this.keys.put(key, String.valueOf(value));
        this.save();
    }
}

