/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.util;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import de.themoep.idconverter.IdMappings;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitScheduler;

public class BukkitTools {
    private static Towny plugin = null;
    private static Server server = null;

    public static void initialize(Towny plugin) {
        BukkitTools.plugin = plugin;
        server = plugin.getServer();
    }

    public static Collection<? extends Player> getOnlinePlayers() {
        return BukkitTools.getServer().getOnlinePlayers();
    }

    public static List<Player> matchPlayer(String name) {
        return BukkitTools.getServer().matchPlayer(name);
    }

    public static Player getPlayerExact(String name) {
        return BukkitTools.getServer().getPlayerExact(name);
    }

    public static Player getPlayer(String playerId) {
        return BukkitTools.getServer().getPlayer(playerId);
    }

    public static boolean isOnline(String playerId) {
        return BukkitTools.getServer().getPlayer(playerId) != null;
    }

    public static List<World> getWorlds() {
        return BukkitTools.getServer().getWorlds();
    }

    public static World getWorld(String name) {
        return BukkitTools.getServer().getWorld(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Server getServer() {
        Server server = BukkitTools.server;
        synchronized (server) {
            return BukkitTools.server;
        }
    }

    public static PluginManager getPluginManager() {
        return BukkitTools.getServer().getPluginManager();
    }

    public static BukkitScheduler getScheduler() {
        return BukkitTools.getServer().getScheduler();
    }

    public static boolean isPrimaryThread() {
        return Bukkit.isPrimaryThread();
    }

    public static int scheduleSyncDelayedTask(Runnable task, long delay) {
        return BukkitTools.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, task, delay);
    }

    public static int scheduleAsyncDelayedTask(Runnable task, long delay) {
        return BukkitTools.getScheduler().runTaskLaterAsynchronously((Plugin)plugin, task, delay).getTaskId();
    }

    public static int scheduleSyncRepeatingTask(Runnable task, long delay, long repeat) {
        return BukkitTools.getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, task, delay, repeat);
    }

    public static int scheduleAsyncRepeatingTask(Runnable task, long delay, long repeat) {
        return BukkitTools.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, task, delay, repeat).getTaskId();
    }

    public static HashMap<String, Integer> getPlayersPerWorld() {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        for (World world : BukkitTools.getServer().getWorlds()) {
            m.put(world.getName(), 0);
        }
        for (Player player : BukkitTools.getServer().getOnlinePlayers()) {
            m.put(player.getWorld().getName(), m.get(player.getWorld().getName()) + 1);
        }
        return m;
    }

    public static Block getBlockOffset(Block block, int xOffset, int yOffset, int zOffset) {
        return block.getWorld().getBlockAt(block.getX() + xOffset, block.getY() + yOffset, block.getZ() + zOffset);
    }

    public static String getTypeKey(Block block) {
        return block.getType().getKey().toString();
    }

    @Deprecated
    public static int getTypeId(Block block) {
        return block.getType().getId();
    }

    @Deprecated
    public static byte getData(Block block) {
        return block.getData();
    }

    @Deprecated
    public static void setTypeIdAndData(Block block, int type, byte data, boolean applyPhysics) {
        Material mat = Material.getMaterial((String)IdMappings.getById(String.format("%s:%s", type, data)).getFlatteningType());
        block.setType(mat, applyPhysics);
    }

    @Deprecated
    public static void setTypeId(Block block, int type, boolean applyPhysics) {
        Material mat = Material.getMaterial((String)IdMappings.getById(String.valueOf(type)).getFlatteningType());
        block.setType(mat, applyPhysics);
    }

    public static Material getType(BlockState state) {
        return state.getType();
    }

    public static MaterialData getData(BlockState state) {
        return state.getData();
    }

    public static byte getDataData(BlockState state) {
        return BukkitTools.getData(state).getData();
    }

    public static MaterialData getData(ItemStack stack) {
        return stack.getData();
    }

    public static byte getDataData(ItemStack stack) {
        return BukkitTools.getData(stack).getData();
    }

    public static Material getMaterial(int id) {
        return Material.getMaterial((String)IdMappings.getById(String.valueOf(id)).getFlatteningType());
    }

    public static Material getMaterial(String name) {
        return Material.getMaterial((String)name);
    }

    @Deprecated
    public static int getMaterialId(Material material) {
        return material.getId();
    }

    public static List<String> getWhiteListedUsers() {
        ArrayList<String> names = new ArrayList<String>();
        try {
            BufferedReader fin = new BufferedReader(new FileReader("white-list.txt"));
            try {
                String line;
                while ((line = fin.readLine()) != null) {
                    names.add(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                fin.close();
            }
            catch (IOException iOException) {}
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return names;
    }

    public static int calcChunk(int value) {
        return value * TownySettings.getTownBlockSize() / 16;
    }
}

