/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.war.flagwar;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.utils.AreaSelectionUtil;
import com.palmergames.bukkit.towny.war.flagwar.Cell;
import com.palmergames.bukkit.towny.war.flagwar.CellUnderAttack;
import com.palmergames.bukkit.towny.war.flagwar.TownyWarConfig;
import com.palmergames.bukkit.towny.war.flagwar.events.CellAttackCanceledEvent;
import com.palmergames.bukkit.towny.war.flagwar.events.CellAttackEvent;
import com.palmergames.bukkit.towny.war.flagwar.events.CellDefendedEvent;
import com.palmergames.bukkit.towny.war.flagwar.events.CellWonEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;

public class TownyWar {
    private static Map<Cell, CellUnderAttack> cellsUnderAttack;
    private static Map<String, List<CellUnderAttack>> cellsUnderAttackByPlayer;

    public static void onEnable() {
        cellsUnderAttack = new HashMap<Cell, CellUnderAttack>();
        cellsUnderAttackByPlayer = new HashMap<String, List<CellUnderAttack>>();
    }

    public static void onDisable() {
        for (CellUnderAttack cell : new ArrayList<CellUnderAttack>(cellsUnderAttack.values())) {
            TownyWar.attackCanceled(cell);
        }
    }

    public static void registerAttack(CellUnderAttack cell) throws Exception {
        CellUnderAttack currentData = cellsUnderAttack.get(cell);
        if (currentData != null) {
            throw new Exception(String.format(TownySettings.getLangString("msg_err_enemy_war_cell_already_under_attack"), currentData.getNameOfFlagOwner()));
        }
        String playerName = cell.getNameOfFlagOwner();
        int futureActiveFlagCount = TownyWar.getNumActiveFlags(playerName) + 1;
        if (futureActiveFlagCount > TownyWarConfig.getMaxActiveFlagsPerPerson()) {
            throw new Exception(String.format(TownySettings.getLangString("msg_err_enemy_war_reached_max_active_flags"), TownyWarConfig.getMaxActiveFlagsPerPerson()));
        }
        TownyWar.addFlagToPlayerCount(playerName, cell);
        cellsUnderAttack.put(cell, cell);
        cell.begin();
    }

    public static int getNumActiveFlags(String playerName) {
        List<CellUnderAttack> activeFlags = cellsUnderAttackByPlayer.get(playerName);
        return activeFlags == null ? 0 : activeFlags.size();
    }

    public static boolean isUnderAttack(Town town) {
        for (CellUnderAttack cua : cellsUnderAttack.values()) {
            try {
                Town townUnderAttack = TownyUniverse.getTownBlock(cua.getFlagBaseBlock().getLocation()).getTown();
                if (townUnderAttack != town) continue;
                return true;
            }
            catch (NotRegisteredException notRegisteredException) {
            }
        }
        return false;
    }

    public static boolean isUnderAttack(Cell cell) {
        return cellsUnderAttack.containsKey(cell);
    }

    public static CellUnderAttack getAttackData(Cell cell) {
        return cellsUnderAttack.get(cell);
    }

    public static void removeCellUnderAttack(CellUnderAttack cell) {
        TownyWar.removeFlagFromPlayerCount(cell.getNameOfFlagOwner(), cell);
        cellsUnderAttack.remove(cell);
    }

    public static void attackWon(CellUnderAttack cell) {
        CellWonEvent cellWonEvent = new CellWonEvent(cell);
        Bukkit.getServer().getPluginManager().callEvent((Event)cellWonEvent);
        cell.cancel();
        TownyWar.removeCellUnderAttack(cell);
    }

    public static void attackDefended(Player player, CellUnderAttack cell) {
        CellDefendedEvent cellDefendedEvent = new CellDefendedEvent(player, cell);
        Bukkit.getServer().getPluginManager().callEvent((Event)cellDefendedEvent);
        cell.cancel();
        TownyWar.removeCellUnderAttack(cell);
    }

    public static void attackCanceled(CellUnderAttack cell) {
        CellAttackCanceledEvent cellAttackCanceledEvent = new CellAttackCanceledEvent(cell);
        Bukkit.getServer().getPluginManager().callEvent((Event)cellAttackCanceledEvent);
        cell.cancel();
        TownyWar.removeCellUnderAttack(cell);
    }

    public static void removeAttackerFlags(String playerName) {
        List<CellUnderAttack> cells = cellsUnderAttackByPlayer.get(playerName);
        if (cells != null) {
            for (CellUnderAttack cell : cells) {
                TownyWar.attackCanceled(cell);
            }
        }
    }

    public static List<CellUnderAttack> getCellsUnderAttackByPlayer(String playerName) {
        List<CellUnderAttack> cells = cellsUnderAttackByPlayer.get(playerName);
        if (cells == null) {
            return null;
        }
        return new ArrayList<CellUnderAttack>(cells);
    }

    private static void addFlagToPlayerCount(String playerName, CellUnderAttack cell) {
        List<CellUnderAttack> activeFlags = TownyWar.getCellsUnderAttackByPlayer(playerName);
        if (activeFlags == null) {
            activeFlags = new ArrayList<CellUnderAttack>();
        }
        activeFlags.add(cell);
        cellsUnderAttackByPlayer.put(playerName, activeFlags);
    }

    private static void removeFlagFromPlayerCount(String playerName, Cell cell) {
        List<CellUnderAttack> activeFlags = cellsUnderAttackByPlayer.get(playerName);
        if (activeFlags != null) {
            if (activeFlags.size() <= 1) {
                cellsUnderAttackByPlayer.remove(playerName);
            } else {
                activeFlags.remove(cell);
                cellsUnderAttackByPlayer.put(playerName, activeFlags);
            }
        }
    }

    public static void checkBlock(Player player, Block block, Cancellable event) {
        Cell cell;
        if (TownyWarConfig.isAffectedMaterial(block.getType()) && (cell = Cell.parse(block.getLocation())).isUnderAttack()) {
            CellUnderAttack cellAttackData = cell.getAttackData();
            if (cellAttackData.isFlag(block)) {
                TownyWar.attackDefended(player, cellAttackData);
                event.setCancelled(true);
            } else if (cellAttackData.isUneditableBlock(block)) {
                event.setCancelled(true);
            }
        }
    }

    public static boolean callAttackCellEvent(Towny plugin, Player player, Block block, WorldCoord worldCoord) throws TownyException {
        Nation landOwnerNation;
        TownBlock townBlock;
        Town landOwnerTown;
        Nation attackingNation;
        Town attackingTown;
        Resident attackingResident;
        int topY = block.getWorld().getHighestBlockYAt(block.getX(), block.getZ()) - 1;
        if (block.getY() < topY) {
            throw new TownyException(TownySettings.getLangString("msg_err_enemy_war_must_be_placed_above_ground"));
        }
        TownyUniverse universe = plugin.getTownyUniverse();
        try {
            attackingResident = TownyUniverse.getDataSource().getResident(player.getName());
            attackingTown = attackingResident.getTown();
            attackingNation = attackingTown.getNation();
        }
        catch (NotRegisteredException e) {
            throw new TownyException(TownySettings.getLangString("msg_err_dont_belong_nation"));
        }
        if (attackingTown.getTownBlocks().size() < 1) {
            throw new TownyException(TownySettings.getLangString("msg_err_enemy_war_your_town_has_no_claims"));
        }
        try {
            landOwnerTown = worldCoord.getTownBlock().getTown();
            townBlock = worldCoord.getTownBlock();
            landOwnerNation = landOwnerTown.getNation();
        }
        catch (NotRegisteredException e) {
            throw new TownyException(TownySettings.getLangString("msg_err_enemy_war_not_part_of_nation"));
        }
        if (landOwnerNation.isNeutral()) {
            throw new TownyException(String.format(TownySettings.getLangString("msg_err_enemy_war_is_peaceful"), landOwnerNation.getFormattedName()));
        }
        if (!TownyUniverse.getPermissionSource().isTownyAdmin(player) && attackingNation.isNeutral()) {
            throw new TownyException(String.format(TownySettings.getLangString("msg_err_enemy_war_is_peaceful"), attackingNation.getFormattedName()));
        }
        TownyWar.checkIfTownHasMinOnlineForWar(landOwnerTown);
        TownyWar.checkIfNationHasMinOnlineForWar(landOwnerNation);
        TownyWar.checkIfTownHasMinOnlineForWar(attackingTown);
        TownyWar.checkIfNationHasMinOnlineForWar(attackingNation);
        if (TownyWarConfig.isAttackingBordersOnly() && !AreaSelectionUtil.isOnEdgeOfOwnership(landOwnerTown, worldCoord)) {
            throw new TownyException(TownySettings.getLangString("msg_err_enemy_war_not_on_edge_of_town"));
        }
        double costToPlaceWarFlag = TownyWarConfig.getCostToPlaceWarFlag();
        if (TownySettings.isUsingEconomy()) {
            try {
                double requiredAmount = costToPlaceWarFlag;
                double balance = attackingResident.getHoldingBalance();
                if (balance < costToPlaceWarFlag) {
                    throw new TownyException(String.format(TownySettings.getLangString("msg_err_insuficient_funds_warflag"), TownyEconomyHandler.getFormattedBalance(costToPlaceWarFlag)));
                }
                int activeFlagCount = TownyWar.getNumActiveFlags(attackingResident.getName());
                double defendedAttackCost = TownyWarConfig.getDefendedAttackReward() * (double)(activeFlagCount + 1);
                double attackWinCost = 0.0;
                double amount = TownyWarConfig.getWonHomeblockReward();
                double homeBlockFine = amount < 0.0 ? -amount : 0.0;
                amount = TownyWarConfig.getWonTownblockReward();
                double townBlockFine = amount < 0.0 ? -amount : 0.0;
                attackWinCost = townBlock.isHomeBlock() ? homeBlockFine + (double)activeFlagCount * townBlockFine : (double)(activeFlagCount + 1) * townBlockFine;
                if (defendedAttackCost > 0.0 && attackWinCost > 0.0) {
                    String reason;
                    double cost;
                    if (defendedAttackCost > attackWinCost) {
                        requiredAmount += defendedAttackCost;
                        cost = defendedAttackCost;
                        reason = TownySettings.getLangString("name_defended_attack");
                    } else {
                        requiredAmount += attackWinCost;
                        cost = attackWinCost;
                        reason = TownySettings.getLangString("name_rebuilding");
                    }
                    if (balance < requiredAmount) {
                        throw new TownyException(String.format(TownySettings.getLangString("msg_err_insuficient_funds_future"), TownyEconomyHandler.getFormattedBalance(cost), String.format("%d %s", activeFlagCount + 1, reason + "(s)")));
                    }
                }
            }
            catch (EconomyException e) {
                throw new TownyException(e.getError());
            }
        }
        CellAttackEvent cellAttackEvent = new CellAttackEvent(plugin, player, block);
        plugin.getServer().getPluginManager().callEvent((Event)cellAttackEvent);
        if (cellAttackEvent.isCancelled()) {
            if (cellAttackEvent.hasReason()) {
                throw new TownyException(cellAttackEvent.getReason());
            }
            return false;
        }
        if (TownySettings.isUsingEconomy() && costToPlaceWarFlag > 0.0) {
            try {
                attackingResident.pay(costToPlaceWarFlag, "War - WarFlag Cost");
                TownyMessaging.sendResidentMessage(attackingResident, String.format(TownySettings.getLangString("msg_enemy_war_purchased_warflag"), TownyEconomyHandler.getFormattedBalance(costToPlaceWarFlag)));
            }
            catch (EconomyException e) {
                e.printStackTrace();
            }
        }
        if (!landOwnerNation.hasEnemy(attackingNation)) {
            landOwnerNation.addEnemy(attackingNation);
            plugin.getTownyUniverse();
            TownyUniverse.getDataSource().saveNation(landOwnerNation);
        }
        universe.addWarZone(worldCoord);
        plugin.updateCache(worldCoord);
        TownyMessaging.sendGlobalMessage(String.format(TownySettings.getLangString("msg_enemy_war_area_under_attack"), landOwnerTown.getFormattedName(), worldCoord.toString(), attackingResident.getFormattedName()));
        return true;
    }

    public static void checkIfTownHasMinOnlineForWar(Town town) throws TownyException {
        int requiredOnline = TownyWarConfig.getMinPlayersOnlineInTownForWar();
        int onlinePlayerCount = TownyUniverse.getOnlinePlayers(town).size();
        if (onlinePlayerCount < requiredOnline) {
            throw new TownyException(String.format(TownySettings.getLangString("msg_err_enemy_war_require_online"), requiredOnline, town.getFormattedName()));
        }
    }

    public static void checkIfNationHasMinOnlineForWar(Nation nation) throws TownyException {
        int requiredOnline = TownyWarConfig.getMinPlayersOnlineInNationForWar();
        int onlinePlayerCount = TownyUniverse.getOnlinePlayers(nation).size();
        if (onlinePlayerCount < requiredOnline) {
            throw new TownyException(String.format(TownySettings.getLangString("msg_err_enemy_war_require_online"), requiredOnline, nation.getFormattedName()));
        }
    }

    public static WorldCoord cellToWorldCoord(Cell cell) throws NotRegisteredException {
        return new WorldCoord(cell.getWorldName(), cell.getX(), cell.getZ());
    }
}

