/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.war.eventwar;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyEconomyObject;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.war.eventwar.PlotAttackedEvent;
import com.palmergames.bukkit.towny.war.eventwar.StartWarTimerTask;
import com.palmergames.bukkit.towny.war.eventwar.TownScoredEvent;
import com.palmergames.bukkit.towny.war.eventwar.WarSpoils;
import com.palmergames.bukkit.towny.war.eventwar.WarTimerTask;
import com.palmergames.bukkit.towny.war.eventwar.WarZoneData;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.ServerBroadCastTimerTask;
import com.palmergames.util.KeyValue;
import com.palmergames.util.KeyValueTable;
import com.palmergames.util.TimeMgmt;
import com.palmergames.util.TimeTools;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitScheduler;

public class War {
    private static Hashtable<WorldCoord, Integer> warZone = new Hashtable();
    private Hashtable<Town, Integer> townScores = new Hashtable();
    public static List<Town> warringTowns = new ArrayList<Town>();
    public static List<Nation> warringNations = new ArrayList<Nation>();
    private WarSpoils warSpoils = new WarSpoils();
    private Towny plugin;
    private TownyUniverse universe;
    private boolean warTime = false;
    private List<Integer> warTaskIds = new ArrayList<Integer>();

    public War(Towny plugin, int startDelay) {
        this.plugin = plugin;
        this.universe = plugin.getTownyUniverse();
        this.setupDelay(startDelay);
    }

    public void addTaskId(int id) {
        this.warTaskIds.add(id);
    }

    public void clearTaskIds() {
        this.warTaskIds.clear();
    }

    public void cancelTasks(BukkitScheduler scheduler) {
        for (Integer id : this.getTaskIds()) {
            scheduler.cancelTask(id.intValue());
        }
        this.clearTaskIds();
    }

    public void setPlugin(Towny plugin) {
        this.plugin = plugin;
    }

    public List<Integer> getTaskIds() {
        return new ArrayList<Integer>(this.warTaskIds);
    }

    public Towny getPlugin() {
        return this.plugin;
    }

    public boolean isWarTime() {
        return this.warTime;
    }

    public TownyUniverse getTownyUniverse() {
        return this.universe;
    }

    public WarSpoils getWarSpoils() {
        return this.warSpoils;
    }

    public Hashtable<Town, Integer> getTownScores() {
        return this.townScores;
    }

    public Hashtable<WorldCoord, Integer> getWarZone() {
        return warZone;
    }

    public List<Town> getWarringTowns() {
        return warringTowns;
    }

    public static boolean isWarZone(WorldCoord worldCoord) {
        return warZone.containsKey(worldCoord);
    }

    public boolean isWarringNation(Nation nation) {
        return warringNations.contains(nation);
    }

    public static boolean isWarringTown(Town town) {
        return warringTowns.contains(town);
    }

    public void toggleEnd() {
        this.warTime = false;
    }

    public void setupDelay(int delay) {
        if (delay <= 0) {
            this.start();
        } else {
            for (Long t : TimeMgmt.getCountdownDelays(delay, TimeMgmt.defaultCountdownDelays)) {
                int id = BukkitTools.scheduleAsyncDelayedTask(new ServerBroadCastTimerTask(this.plugin, String.format("War starts in %s", TimeMgmt.formatCountdownTime(t))), TimeTools.convertToTicks((long)delay - t));
                if (id == -1) {
                    TownyMessaging.sendErrorMsg("Could not schedule a countdown message for war event.");
                    this.end();
                    continue;
                }
                this.addTaskId(id);
            }
            int id = BukkitTools.scheduleAsyncDelayedTask(new StartWarTimerTask(this.plugin), TimeTools.convertToTicks(delay));
            if (id == -1) {
                TownyMessaging.sendErrorMsg("Could not schedule setup delay for war event.");
                this.end();
            } else {
                this.addTaskId(id);
            }
        }
    }

    public void start() {
        this.warTime = true;
        try {
            this.warSpoils.collect(TownySettings.getBaseSpoilsOfWar(), "Start of War - Base Spoils");
            TownyMessaging.sendGlobalMessage(String.format(TownySettings.getLangString("msg_war_seeding_spoils_with"), TownySettings.getBaseSpoilsOfWar()));
            TownyMessaging.sendGlobalMessage(String.format(TownySettings.getLangString("msg_war_total_seeding_spoils"), this.warSpoils.getHoldingBalance()));
            TownyMessaging.sendGlobalMessage(String.format(TownySettings.getLangString("msg_war_activate_war_hud_tip"), new Object[0]));
        }
        catch (EconomyException e) {
            TownyMessaging.sendErrorMsg("[War] Could not seed spoils of war.");
        }
        for (Nation nation : TownyUniverse.getDataSource().getNations()) {
            if (!nation.isNeutral()) {
                this.add(nation);
                TownyMessaging.sendGlobalMessage(String.format(TownySettings.getLangString("msg_war_join_nation"), nation.getName()));
                continue;
            }
            if (TownySettings.isDeclaringNeutral()) continue;
            try {
                nation.setNeutral(false);
                this.add(nation);
                TownyMessaging.sendGlobalMessage(String.format(TownySettings.getLangString("msg_war_join_forced"), nation.getName()));
            }
            catch (TownyException e) {
                e.printStackTrace();
            }
        }
        int id = BukkitTools.scheduleAsyncRepeatingTask(new WarTimerTask(this.plugin, this), 0L, TimeTools.convertToTicks(5L));
        if (id == -1) {
            TownyMessaging.sendErrorMsg("Could not schedule war event loop.");
            this.end();
        } else {
            this.addTaskId(id);
        }
        this.checkEnd();
    }

    public void end() {
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null) continue;
            this.sendStats(player);
        }
        new BukkitRunnable(){

            public void run() {
                War.this.plugin.getHUDManager().toggleAllWarHUD();
            }
        }.runTask((Plugin)this.plugin);
        try {
            double halfWinnings = this.getWarSpoils().getHoldingBalance() / 2.0;
            try {
                double nationWinnings = halfWinnings / (double)warringNations.size();
                for (Nation winningNation : warringNations) {
                    this.getWarSpoils().payTo(nationWinnings, winningNation, "War - Nation Winnings");
                    TownyMessaging.sendGlobalMessage(TownySettings.getWarTimeWinningNationSpoilsMsg(winningNation, TownyEconomyHandler.getFormattedBalance(nationWinnings)));
                }
            }
            catch (ArithmeticException e) {
                TownyMessaging.sendDebugMsg("[War]   War ended with 0 nations.");
            }
            try {
                KeyValue<Town, Integer> winningTownScore = this.getWinningTownScore();
                this.getWarSpoils().payTo(halfWinnings, (TownyEconomyObject)winningTownScore.key, "War - Town Winnings");
                TownyMessaging.sendGlobalMessage(TownySettings.getWarTimeWinningTownSpoilsMsg((Town)winningTownScore.key, TownyEconomyHandler.getFormattedBalance(halfWinnings), (Integer)winningTownScore.value));
            }
            catch (TownyException townyException) {}
        }
        catch (EconomyException economyException) {
            // empty catch block
        }
    }

    private void add(Nation nation) {
        for (Town town : nation.getTowns()) {
            if (town.getTownBlocks().size() <= 0) continue;
            this.add(town);
        }
        warringNations.add(nation);
    }

    private void add(Town town) {
        TownyMessaging.sendTownMessage(town, TownySettings.getJoinWarMsg(town));
        this.townScores.put(town, 0);
        warringTowns.add(town);
        for (TownBlock townBlock : town.getTownBlocks()) {
            if (town.isHomeBlock(townBlock)) {
                warZone.put(townBlock.getWorldCoord(), TownySettings.getWarzoneHomeBlockHealth());
                continue;
            }
            warZone.put(townBlock.getWorldCoord(), TownySettings.getWarzoneTownBlockHealth());
        }
    }

    public void townScored(Town town, int n, Object fallenObject, int townBlocksFallen) {
        String[] pointMessage = new String[]{"error"};
        if (fallenObject instanceof Nation) {
            pointMessage = TownySettings.getWarTimeScoreNationEliminatedMsg(town, n, (Nation)fallenObject);
        } else if (fallenObject instanceof Town) {
            pointMessage = TownySettings.getWarTimeScoreTownEliminatedMsg(town, n, (Town)fallenObject, townBlocksFallen);
        } else if (fallenObject instanceof TownBlock) {
            pointMessage = TownySettings.getWarTimeScoreTownBlockEliminatedMsg(town, n, (TownBlock)fallenObject);
        }
        this.townScores.put(town, this.townScores.get(town) + n);
        TownyMessaging.sendGlobalMessage(pointMessage);
        TownScoredEvent event = new TownScoredEvent(town, this.townScores.get(town));
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
    }

    public void townScored(Town defenderTown, Town attackerTown, Player defenderPlayer, Player attackerPlayer, int n) {
        String[] pointMessage = new String[]{"error"};
        TownBlock deathLoc = TownyUniverse.getTownBlock(defenderPlayer.getLocation());
        pointMessage = deathLoc == null ? TownySettings.getWarTimeScorePlayerKillMsg(attackerPlayer, defenderPlayer, n, attackerTown) : (warZone.containsKey(deathLoc.getWorldCoord()) && attackerTown.getTownBlocks().contains(deathLoc) ? TownySettings.getWarTimeScorePlayerKillMsg(attackerPlayer, defenderPlayer, attackerPlayer, n, attackerTown) : (warZone.containsKey(deathLoc.getWorldCoord()) && defenderTown.getTownBlocks().contains(deathLoc) ? TownySettings.getWarTimeScorePlayerKillMsg(attackerPlayer, defenderPlayer, defenderPlayer, n, attackerTown) : TownySettings.getWarTimeScorePlayerKillMsg(attackerPlayer, defenderPlayer, n, attackerTown)));
        this.townScores.put(attackerTown, this.townScores.get(attackerTown) + n);
        TownyMessaging.sendGlobalMessage(pointMessage);
        TownScoredEvent event = new TownScoredEvent(attackerTown, this.townScores.get(attackerTown));
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
    }

    public void updateWarZone(TownBlock townBlock, WarZoneData wzd) throws NotRegisteredException {
        if (!wzd.hasAttackers()) {
            this.healPlot(townBlock, wzd);
        } else {
            this.attackPlot(townBlock, wzd);
        }
    }

    private void healPlot(TownBlock townBlock, WarZoneData wzd) throws NotRegisteredException {
        int hp;
        WorldCoord worldCoord = townBlock.getWorldCoord();
        int healthChange = wzd.getHealthChange();
        int oldHP = warZone.get(worldCoord);
        if (oldHP == (hp = this.getHealth(townBlock, healthChange))) {
            return;
        }
        warZone.put(worldCoord, hp);
        String healString = "\u00a78[Heal](" + townBlock.getCoord().toString() + ") HP: " + hp + " (" + "\u00a7a" + "+" + healthChange + "\u00a78" + ")";
        TownyMessaging.sendMessageToMode(townBlock.getTown(), healString, "");
        for (Player p : wzd.getDefenders()) {
            if (TownyUniverse.getDataSource().getResident(p.getName()).getTown() == townBlock.getTown()) continue;
            TownyMessaging.sendMessage((Object)p, healString);
        }
        this.launchFireworkAtPlot(townBlock, wzd.getRandomDefender(), FireworkEffect.Type.BALL, Color.LIME);
        PlotAttackedEvent event = new PlotAttackedEvent(townBlock, wzd.getAllPlayers(), hp);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
    }

    private void attackPlot(TownBlock townBlock, WarZoneData wzd) throws NotRegisteredException {
        Color fwc;
        Player attackerPlayer = wzd.getRandomAttacker();
        Resident attackerResident = TownyUniverse.getDataSource().getResident(attackerPlayer.getName());
        Town attacker = attackerResident.getTown();
        WorldCoord worldCoord = townBlock.getWorldCoord();
        int healthChange = wzd.getHealthChange();
        int hp = this.getHealth(townBlock, healthChange);
        Color color = healthChange < 0 ? Color.RED : (fwc = healthChange > 0 ? Color.LIME : Color.GRAY);
        if (hp > 0) {
            String healthChangeStringAtk;
            String healthChangeStringDef;
            warZone.put(worldCoord, hp);
            if (healthChange > 0) {
                healthChangeStringDef = "(\u00a7a+" + healthChange + "\u00a78" + ")";
                healthChangeStringAtk = "(\u00a74+" + healthChange + "\u00a78" + ")";
            } else if (healthChange < 0) {
                healthChangeStringDef = "(\u00a74" + healthChange + "\u00a78" + ")";
                healthChangeStringAtk = "(\u00a7a" + healthChange + "\u00a78" + ")";
            } else {
                healthChangeStringDef = "(+0)";
                healthChangeStringAtk = "(+0)";
            }
            if (!townBlock.isHomeBlock()) {
                TownyMessaging.sendMessageToMode(townBlock.getTown(), "\u00a78" + TownySettings.getLangString("msg_war_town_under_attack") + " (" + townBlock.getCoord().toString() + ") HP: " + hp + " " + healthChangeStringDef, "");
                if (hp >= 10 && hp % 10 == 0 || hp <= 5) {
                    this.launchFireworkAtPlot(townBlock, attackerPlayer, FireworkEffect.Type.BALL_LARGE, fwc);
                    for (Town town : townBlock.getTown().getNation().getTowns()) {
                        if (town == townBlock.getTown()) continue;
                        TownyMessaging.sendMessageToMode(town, "\u00a78" + TownySettings.getLangString("msg_war_nation_under_attack") + " [" + townBlock.getTown().getName() + "](" + townBlock.getCoord().toString() + ") HP: " + hp + " " + healthChangeStringDef, "");
                    }
                    for (Nation nation : townBlock.getTown().getNation().getAllies()) {
                        if (nation == townBlock.getTown().getNation()) continue;
                        TownyMessaging.sendMessageToMode(nation, "\u00a78" + String.format(TownySettings.getLangString("msg_war_nations_ally_under_attack"), townBlock.getTown().getName()) + " [" + townBlock.getTown().getName() + "](" + townBlock.getCoord().toString() + ") HP: " + hp + " " + healthChangeStringDef, "");
                    }
                } else {
                    this.launchFireworkAtPlot(townBlock, attackerPlayer, FireworkEffect.Type.BALL, fwc);
                }
                for (Town attackingTown : wzd.getAttackerTowns()) {
                    TownyMessaging.sendMessageToMode(attackingTown, "\u00a78[" + townBlock.getTown().getName() + "](" + townBlock.getCoord().toString() + ") HP: " + hp + " " + healthChangeStringAtk, "");
                }
            } else {
                TownyMessaging.sendMessageToMode(townBlock.getTown(), "\u00a78" + TownySettings.getLangString("msg_war_homeblock_under_attack") + " (" + townBlock.getCoord().toString() + ") HP: " + hp + " " + healthChangeStringDef, "");
                if (hp >= 10 && hp % 10 == 0 || hp <= 5) {
                    this.launchFireworkAtPlot(townBlock, attackerPlayer, FireworkEffect.Type.BALL_LARGE, fwc);
                    for (Town town : townBlock.getTown().getNation().getTowns()) {
                        if (town == townBlock.getTown()) continue;
                        TownyMessaging.sendMessageToMode(town, "\u00a78" + String.format(TownySettings.getLangString("msg_war_nation_member_homeblock_under_attack"), townBlock.getTown().getName()) + " [" + townBlock.getTown().getName() + "](" + townBlock.getCoord().toString() + ") HP: " + hp + " " + healthChangeStringDef, "");
                    }
                    for (Nation nation : townBlock.getTown().getNation().getAllies()) {
                        if (nation == townBlock.getTown().getNation()) continue;
                        TownyMessaging.sendMessageToMode(nation, "\u00a78" + String.format(TownySettings.getLangString("msg_war_nation_ally_homeblock_under_attack"), townBlock.getTown().getName()) + " [" + townBlock.getTown().getName() + "](" + townBlock.getCoord().toString() + ") HP: " + hp + " " + healthChangeStringDef, "");
                    }
                } else {
                    this.launchFireworkAtPlot(townBlock, attackerPlayer, FireworkEffect.Type.BALL, fwc);
                }
                for (Town attackingTown : wzd.getAttackerTowns()) {
                    TownyMessaging.sendMessageToMode(attackingTown, "\u00a78[" + townBlock.getTown().getName() + "](" + townBlock.getCoord().toString() + ") HP: " + hp + " " + healthChangeStringAtk, "");
                }
            }
        } else {
            this.launchFireworkAtPlot(townBlock, attackerPlayer, FireworkEffect.Type.CREEPER, fwc);
            this.remove(attacker, townBlock);
        }
        PlotAttackedEvent event = new PlotAttackedEvent(townBlock, wzd.getAllPlayers(), hp);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
    }

    private int getHealth(TownBlock townBlock, int healthChange) {
        WorldCoord worldCoord = townBlock.getWorldCoord();
        int hp = warZone.get(worldCoord) + healthChange;
        boolean isHomeBlock = townBlock.isHomeBlock();
        if (isHomeBlock && hp > TownySettings.getWarzoneHomeBlockHealth()) {
            return TownySettings.getWarzoneHomeBlockHealth();
        }
        if (!isHomeBlock && hp > TownySettings.getWarzoneTownBlockHealth()) {
            return TownySettings.getWarzoneTownBlockHealth();
        }
        return hp;
    }

    private void launchFireworkAtPlot(final TownBlock townblock, final Player atPlayer, final FireworkEffect.Type type, final Color c) {
        if (!TownySettings.getPlotsFireworkOnAttacked()) {
            return;
        }
        BukkitTools.scheduleSyncDelayedTask(new Runnable(){

            @Override
            public void run() {
                double x = (double)townblock.getX() * (double)Coord.getCellSize() + (double)Coord.getCellSize() / 2.0;
                double z = (double)townblock.getZ() * (double)Coord.getCellSize() + (double)Coord.getCellSize() / 2.0;
                double y = atPlayer.getLocation().getY() + 20.0;
                Firework firework = (Firework)atPlayer.getWorld().spawn(new Location(atPlayer.getWorld(), x, y, z), Firework.class);
                FireworkMeta data = firework.getFireworkMeta();
                data.addEffects(new FireworkEffect[]{FireworkEffect.builder().withColor(c).with(type).trail(false).build()});
                firework.setFireworkMeta(data);
                firework.detonate();
            }
        }, 0L);
    }

    private void remove(Town attacker, TownBlock townBlock) throws NotRegisteredException {
        if (TownySettings.getWarEventCostsTownblocks()) {
            townBlock.getTown().addBonusBlocks(-1);
            attacker.addBonusBlocks(1);
        }
        try {
            if (!townBlock.getTown().payTo(TownySettings.getWartimeTownBlockLossPrice(), attacker, "War - TownBlock Loss")) {
                TownyMessaging.sendTownMessage(townBlock.getTown(), TownySettings.getLangString("msg_war_town_ran_out_of_money"));
                TownyMessaging.sendTitleMessageToTown(townBlock.getTown(), TownySettings.getLangString("msg_war_town_removed_from_war_titlemsg"), "");
                if (townBlock.getTown().isCapital()) {
                    this.remove(attacker, townBlock.getTown().getNation());
                } else {
                    this.remove(attacker, townBlock.getTown());
                }
                TownyUniverse.getDataSource().saveTown(townBlock.getTown());
                TownyUniverse.getDataSource().saveTown(attacker);
                return;
            }
            TownyMessaging.sendTownMessage(townBlock.getTown(), String.format(TownySettings.getLangString("msg_war_town_lost_money_townblock"), TownyEconomyHandler.getFormattedBalance(TownySettings.getWartimeTownBlockLossPrice())));
        }
        catch (EconomyException economyException) {
            // empty catch block
        }
        if (townBlock.getTown().isHomeBlock(townBlock) && townBlock.getTown().isCapital()) {
            this.remove(attacker, townBlock.getTown().getNation());
        } else if (townBlock.getTown().isHomeBlock(townBlock)) {
            this.remove(attacker, townBlock.getTown());
        } else {
            this.townScored(attacker, TownySettings.getWarPointsForTownBlock(), townBlock, 0);
            this.remove(townBlock.getWorldCoord());
            if (townBlock.getType().equals((Object)TownBlockType.JAIL)) {
                Town town = townBlock.getTown();
                int count = 0;
                for (Resident resident : TownyUniverse.getDataSource().getResidents()) {
                    try {
                        if (!resident.isJailed() || !resident.getJailTown().equals(town.toString()) || !Coord.parseCoord(town.getJailSpawn(resident.getJailSpawn())).toString().equals(townBlock.getCoord().toString())) continue;
                        resident.setJailed(false);
                        TownyUniverse.getDataSource().saveResident(resident);
                        ++count;
                    }
                    catch (TownyException townyException) {}
                }
                if (count > 0) {
                    TownyMessaging.sendGlobalMessage(String.format(TownySettings.getLangString("msg_war_jailbreak"), town, count));
                }
            }
        }
        TownyUniverse.getDataSource().saveTown(townBlock.getTown());
        TownyUniverse.getDataSource().saveTown(attacker);
    }

    public void remove(Town attacker, Nation nation) throws NotRegisteredException {
        this.townScored(attacker, TownySettings.getWarPointsForNation(), nation, 0);
        warringNations.remove(nation);
        for (Town town : nation.getTowns()) {
            if (!warringTowns.contains(town)) continue;
            this.remove(attacker, town);
        }
        this.checkEnd();
    }

    public void remove(Town attacker, Town town) throws NotRegisteredException {
        int fallenTownBlocks = 0;
        warringTowns.remove(town);
        for (TownBlock townBlock : town.getTownBlocks()) {
            if (!warZone.containsKey(townBlock.getWorldCoord())) continue;
            ++fallenTownBlocks;
            this.remove(townBlock.getWorldCoord());
        }
        this.townScored(attacker, TownySettings.getWarPointsForTown(), town, fallenTownBlocks);
    }

    private void remove(Nation nation) {
        warringNations.remove(nation);
        this.sendEliminateMessage(nation.getFormattedName());
        TownyMessaging.sendTitleMessageToNation(nation, TownySettings.getLangString("msg_war_nation_removed_from_war_titlemsg"), "");
        for (Town town : nation.getTowns()) {
            this.remove(town);
        }
        this.checkEnd();
    }

    public void remove(Town town) {
        try {
            if (town.isCapital() && warringNations.contains(town.getNation())) {
                this.remove(town.getNation());
                return;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        int fallenTownBlocks = 0;
        warringTowns.remove(town);
        for (TownBlock townBlock : town.getTownBlocks()) {
            if (!warZone.containsKey(townBlock.getWorldCoord())) continue;
            ++fallenTownBlocks;
            this.remove(townBlock.getWorldCoord());
        }
        StringBuilder sb = new StringBuilder(town.getFormattedName()).append(" (").append(fallenTownBlocks).append(TownySettings.getLangString("msg_war_append_townblocks_fallen"));
        this.sendEliminateMessage(sb.toString());
    }

    private void remove(WorldCoord worldCoord) {
        warZone.remove(worldCoord);
    }

    private void sendEliminateMessage(String name) {
        TownyMessaging.sendGlobalMessage(TownySettings.getWarTimeEliminatedMsg(name));
    }

    public void nationLeave(Nation nation) {
        this.remove(nation);
        TownyMessaging.sendGlobalMessage(TownySettings.getWarTimeForfeitMsg(nation.getName()));
        this.checkEnd();
    }

    public void townLeave(Town town) {
        this.remove(town);
        TownyMessaging.sendGlobalMessage(TownySettings.getWarTimeForfeitMsg(town.getName()));
        this.checkEnd();
    }

    public boolean townsLeft(Nation nation) {
        return this.countActiveTowns(nation) > 0;
    }

    public void checkEnd() {
        if (warringNations.size() <= 1) {
            this.toggleEnd();
        } else if (CombatUtil.areAllAllies(warringNations)) {
            this.toggleEnd();
        }
    }

    public int countActiveWarBlocks(Town town) {
        int n = 0;
        for (TownBlock townBlock : town.getTownBlocks()) {
            if (!warZone.containsKey(townBlock.getWorldCoord())) continue;
            ++n;
        }
        return n;
    }

    public int countActiveTowns(Nation nation) {
        int n = 0;
        for (Town town : nation.getTowns()) {
            if (!warringTowns.contains(town)) continue;
            ++n;
        }
        return n;
    }

    public List<String> getStats() {
        ArrayList<String> output = new ArrayList<String>();
        output.add(ChatTools.formatTitle("War Stats"));
        output.add("\u00a72  Nations: \u00a7a" + warringNations.size());
        output.add("\u00a72  Towns: \u00a7a" + warringTowns.size() + " / " + this.townScores.size());
        output.add("\u00a72  WarZone: \u00a7a" + warZone.size() + " Town blocks");
        try {
            output.add("\u00a72  Spoils of War: \u00a7a" + TownyEconomyHandler.getFormattedBalance(this.warSpoils.getHoldingBalance()));
            return output;
        }
        catch (EconomyException economyException) {
            return null;
        }
    }

    public void sendStats(Player player) {
        for (String line : this.getStats()) {
            player.sendMessage(line);
        }
    }

    public List<String> getScores(int maxListing) {
        ArrayList<String> output = new ArrayList<String>();
        output.add(ChatTools.formatTitle("War - Top Scores"));
        KeyValueTable<Town, Integer> kvTable = new KeyValueTable<Town, Integer>(this.townScores);
        kvTable.sortByValue();
        kvTable.reverse();
        int n = 0;
        for (KeyValue<Town, Integer> kv : kvTable.getKeyValues()) {
            if (maxListing != -1 && ++n > maxListing) break;
            Town town = (Town)kv.key;
            int score = (Integer)kv.value;
            if (score <= 0) continue;
            output.add(String.format("\u00a73%40s \u00a76|\u00a77 %4d", TownyFormatter.getFormattedName(town), score));
        }
        return output;
    }

    public String[] getTopThree() {
        KeyValueTable<Town, Integer> kvTable = new KeyValueTable<Town, Integer>(this.townScores);
        kvTable.sortByValue();
        kvTable.reverse();
        String[] top = new String[]{kvTable.getKeyValues().size() >= 1 ? kvTable.getKeyValues().get((int)0).value + "-" + kvTable.getKeyValues().get((int)0).key : "", kvTable.getKeyValues().size() >= 2 ? kvTable.getKeyValues().get((int)1).value + "-" + kvTable.getKeyValues().get((int)1).key : "", kvTable.getKeyValues().size() >= 3 ? kvTable.getKeyValues().get((int)2).value + "-" + kvTable.getKeyValues().get((int)2).key : ""};
        return top;
    }

    public KeyValue<Town, Integer> getWinningTownScore() throws TownyException {
        KeyValueTable<Town, Integer> kvTable = new KeyValueTable<Town, Integer>(this.townScores);
        kvTable.sortByValue();
        kvTable.reverse();
        if (kvTable.getKeyValues().size() > 0) {
            return kvTable.getKeyValues().get(0);
        }
        throw new TownyException();
    }

    public void sendScores(Player player) {
        this.sendScores(player, 10);
    }

    public void sendScores(Player player, int maxListing) {
        for (String line : this.getScores(maxListing)) {
            player.sendMessage(line);
        }
    }
}

