/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.event.DisallowedPVPEvent;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.utils.EntityTypeUtil;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Wolf;
import org.bukkit.event.Event;
import org.bukkit.projectiles.ProjectileSource;

public class CombatUtil {
    public static boolean preventDamageCall(Towny plugin, Entity attacker, Entity defender) {
        try {
            TownyWorld world = TownyUniverse.getDataSource().getWorld(defender.getWorld().getName());
            if (!world.isUsingTowny()) {
                return false;
            }
            Player a = null;
            Player b = null;
            if (attacker instanceof Projectile) {
                Projectile projectile = (Projectile)attacker;
                ProjectileSource source = projectile.getShooter();
                if (source instanceof Entity) {
                    attacker = (Entity)source;
                } else {
                    return false;
                }
            }
            if (attacker instanceof Player) {
                a = (Player)attacker;
            }
            if (defender instanceof Player) {
                b = (Player)defender;
            }
            if (a == b) {
                return false;
            }
            return CombatUtil.preventDamageCall(plugin, world, attacker, defender, a, b);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean preventDamageCall(Towny plugin, TownyWorld world, Entity attackingEntity, Entity defendingEntity, Player attackingPlayer, Player defendingPlayer) throws NotRegisteredException {
        if (!world.isUsingTowny()) {
            return false;
        }
        Coord coord = Coord.parseCoord(defendingEntity);
        TownBlock defenderTB = null;
        TownBlock attackerTB = null;
        try {
            attackerTB = world.getTownBlock(Coord.parseCoord(attackingEntity));
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        try {
            defenderTB = world.getTownBlock(coord);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        if (attackingPlayer != null) {
            if (defendingPlayer != null || defenderTB != null && defendingEntity instanceof Wolf && ((Wolf)defendingEntity).isTamed() && !((Wolf)defendingEntity).getOwner().equals((AnimalTamer)attackingEntity)) {
                if (world.isWarZone(coord)) {
                    return false;
                }
                if (CombatUtil.isPvPPlot(attackingPlayer, defendingPlayer)) {
                    return false;
                }
                if (CombatUtil.preventFriendlyFire(attackingPlayer, defendingPlayer) || CombatUtil.preventPvP(world, attackerTB) || CombatUtil.preventPvP(world, defenderTB)) {
                    DisallowedPVPEvent event = new DisallowedPVPEvent(attackingPlayer, defendingPlayer);
                    plugin.getServer().getPluginManager().callEvent((Event)event);
                    return !event.isCancelled();
                }
            } else {
                boolean bDestroy;
                if (defenderTB != null) {
                    List<Class<?>> prots;
                    Resident AttackingResident = null;
                    if (defenderTB.getType() == TownBlockType.FARM) {
                        AttackingResident = TownyUniverse.getDataSource().getResident(attackingPlayer.getName());
                        if (!AttackingResident.hasTown()) {
                            return true;
                        }
                        if (TownySettings.getFarmAnimals().contains(defendingEntity.getType().toString()) && defenderTB.getTown() == AttackingResident.getTown()) {
                            return false;
                        }
                    }
                    if (EntityTypeUtil.isInstanceOfAny(prots = EntityTypeUtil.parseLivingEntityClassNames(TownySettings.getEntityTypes(), "TownMobPVM:"), defendingEntity) && !PlayerCacheUtil.getCachePermission(attackingPlayer, attackingPlayer.getLocation(), Material.DIRT, TownyPermission.ActionType.DESTROY)) {
                        return true;
                    }
                }
                Material block = null;
                switch (defendingEntity.getType()) {
                    case ITEM_FRAME: {
                        block = Material.ITEM_FRAME;
                        break;
                    }
                    case PAINTING: {
                        block = Material.PAINTING;
                        break;
                    }
                    case MINECART: {
                        block = Material.MINECART;
                        break;
                    }
                    case MINECART_CHEST: {
                        block = Material.CHEST_MINECART;
                        break;
                    }
                    case MINECART_FURNACE: {
                        block = Material.FURNACE_MINECART;
                        break;
                    }
                    case MINECART_COMMAND: {
                        block = Material.COMMAND_BLOCK_MINECART;
                        break;
                    }
                    case MINECART_HOPPER: {
                        block = Material.HOPPER_MINECART;
                        break;
                    }
                }
                if (block != null && !(bDestroy = PlayerCacheUtil.getCachePermission(attackingPlayer, defendingEntity.getLocation(), block, TownyPermission.ActionType.DESTROY))) {
                    PlayerCache cache = plugin.getCache(attackingPlayer);
                    if (cache.hasBlockErrMsg()) {
                        TownyMessaging.sendErrorMsg((Object)attackingPlayer, cache.getBlockErrMsg());
                    }
                    return true;
                }
            }
        }
        if (attackingEntity instanceof Wolf && ((Wolf)attackingEntity).isTamed() && defendingPlayer != null && (CombatUtil.preventPvP(world, attackerTB) || CombatUtil.preventPvP(world, defenderTB))) {
            ((Wolf)attackingEntity).setTarget(null);
            return true;
        }
        return false;
    }

    public static boolean preventPvP(TownyWorld world, TownBlock townBlock) {
        block8: {
            if (townBlock != null) {
                try {
                    if (townBlock.getTown().isAdminDisabledPVP()) {
                        return true;
                    }
                    if (!(townBlock.getTown().isPVP() || townBlock.getPermissions().pvp || world.isForcePVP())) {
                        return true;
                    }
                    if (townBlock.isHomeBlock() && world.isForcePVP() && TownySettings.isForcePvpNotAffectingHomeblocks()) {
                        return true;
                    }
                    break block8;
                }
                catch (NotRegisteredException ex) {
                    if (!CombatUtil.isWorldPvP(world)) {
                        return true;
                    }
                    break block8;
                }
            }
            if (!CombatUtil.isWorldPvP(world)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isWorldPvP(TownyWorld world) {
        return world.isForcePVP() || world.isPVP();
    }

    public static boolean preventFriendlyFire(Player attacker, Player defender) {
        if (attacker == defender) {
            return false;
        }
        if (attacker != null && defender != null && !TownySettings.getFriendlyFire() && CombatUtil.isAlly(attacker.getName(), defender.getName())) {
            try {
                TownBlock townBlock = new WorldCoord(defender.getWorld().getName(), Coord.parseCoord((Entity)defender)).getTownBlock();
                if (!townBlock.getType().equals((Object)TownBlockType.ARENA)) {
                    attacker.sendMessage(TownySettings.getLangString("msg_err_friendly_fire_disable"));
                }
                return true;
            }
            catch (TownyException x) {
                attacker.sendMessage(TownySettings.getLangString("msg_err_friendly_fire_disable"));
                return true;
            }
        }
        return false;
    }

    public static boolean isPvPPlot(Player attacker, Player defender) {
        if (attacker != null && defender != null) {
            try {
                TownBlock attackerTB = new WorldCoord(attacker.getWorld().getName(), Coord.parseCoord((Entity)attacker)).getTownBlock();
                TownBlock defenderTB = new WorldCoord(defender.getWorld().getName(), Coord.parseCoord((Entity)defender)).getTownBlock();
                if (defenderTB.getType().equals((Object)TownBlockType.ARENA) && attackerTB.getType().equals((Object)TownBlockType.ARENA)) {
                    return true;
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isAlly(String attackingResident, String defendingResident) {
        try {
            Resident residentA = TownyUniverse.getDataSource().getResident(attackingResident);
            Resident residentB = TownyUniverse.getDataSource().getResident(defendingResident);
            if (residentA.getTown() == residentB.getTown()) {
                return true;
            }
            if (residentA.getTown().getNation() == residentB.getTown().getNation()) {
                return true;
            }
            if (residentA.getTown().getNation().hasAlly(residentB.getTown().getNation())) {
                return true;
            }
        }
        catch (NotRegisteredException e) {
            return false;
        }
        return false;
    }

    public static boolean isAlly(Town a, Town b) {
        try {
            if (a == b) {
                return true;
            }
            if (a.getNation() == b.getNation()) {
                return true;
            }
            if (a.getNation().hasAlly(b.getNation())) {
                return true;
            }
        }
        catch (NotRegisteredException e) {
            return false;
        }
        return false;
    }

    public static boolean canAttackEnemy(String a, String b) {
        try {
            Resident residentA = TownyUniverse.getDataSource().getResident(a);
            Resident residentB = TownyUniverse.getDataSource().getResident(b);
            if (residentA.getTown() == residentB.getTown()) {
                return false;
            }
            if (residentA.getTown().getNation() == residentB.getTown().getNation()) {
                return false;
            }
            Nation nationA = residentA.getTown().getNation();
            Nation nationB = residentB.getTown().getNation();
            if (nationA.isNeutral() || nationB.isNeutral()) {
                return false;
            }
            if (nationA.hasEnemy(nationB)) {
                return true;
            }
        }
        catch (NotRegisteredException e) {
            return false;
        }
        return false;
    }

    public static boolean areAllAllies(List<Nation> possibleAllies) {
        if (possibleAllies.size() <= 1) {
            return true;
        }
        for (int i = 0; i < possibleAllies.size() - 1; ++i) {
            if (possibleAllies.get(i).hasAlly(possibleAllies.get(i + 1))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEnemy(String a, String b) {
        try {
            Resident residentA = TownyUniverse.getDataSource().getResident(a);
            Resident residentB = TownyUniverse.getDataSource().getResident(b);
            if (residentA.getTown() == residentB.getTown()) {
                return false;
            }
            if (residentA.getTown().getNation() == residentB.getTown().getNation()) {
                return false;
            }
            if (residentA.getTown().getNation().hasEnemy(residentB.getTown().getNation())) {
                return true;
            }
        }
        catch (NotRegisteredException e) {
            return false;
        }
        return false;
    }

    public static boolean isEnemy(Town a, Town b) {
        try {
            if (a == b) {
                return false;
            }
            if (a.getNation() == b.getNation()) {
                return false;
            }
            if (a.getNation().hasEnemy(b.getNation())) {
                return true;
            }
        }
        catch (NotRegisteredException e) {
            return false;
        }
        return false;
    }

    public boolean isEnemyTownBlock(Player player, WorldCoord worldCoord) {
        try {
            return CombatUtil.isEnemy(TownyUniverse.getDataSource().getResident(player.getName()).getTown(), worldCoord.getTownBlock().getTown());
        }
        catch (NotRegisteredException e) {
            return false;
        }
    }
}

