/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.List;

public class AreaSelectionUtil {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<WorldCoord> selectWorldCoordArea(TownBlockOwner owner, WorldCoord pos, String[] args) throws TownyException {
        List<WorldCoord> out = new ArrayList<WorldCoord>();
        if (args.length == 0) {
            if (!pos.getTownyWorld().isClaimable()) throw new TownyException(TownySettings.getLangString("msg_not_claimable"));
            out.add(pos);
            return out;
        } else {
            if (args.length > 1) {
                if (args[0].equalsIgnoreCase("rect")) {
                    return AreaSelectionUtil.selectWorldCoordAreaRect(owner, pos, StringMgmt.remFirstArg(args));
                }
                if (!args[0].equalsIgnoreCase("circle")) throw new TownyException(String.format(TownySettings.getLangString("msg_err_invalid_property"), StringMgmt.join(args, " ")));
                return AreaSelectionUtil.selectWorldCoordAreaCircle(owner, pos, StringMgmt.remFirstArg(args));
            }
            if (args[0].equalsIgnoreCase("auto")) {
                return AreaSelectionUtil.selectWorldCoordAreaRect(owner, pos, args);
            }
            if (args[0].equalsIgnoreCase("outpost")) {
                TownBlock tb = pos.getTownBlock();
                if (!tb.isOutpost() && tb.hasTown()) {
                    Town town = tb.getTown();
                    if (!TownyUniverse.isTownBlockLocContainedInTownOutposts(town.getAllOutpostSpawns(), tb)) throw new TownyException(TownySettings.getLangString("msg_err_unclaim_not_outpost"));
                    tb.setOutpost(true);
                    out.add(pos);
                }
                if (!tb.isOutpost()) return out;
                out.add(pos);
                return out;
            } else {
                try {
                    Integer.parseInt(args[0]);
                    return AreaSelectionUtil.selectWorldCoordAreaRect(owner, pos, args);
                }
                catch (NumberFormatException e) {
                    throw new TownyException(String.format(TownySettings.getLangString("msg_err_invalid_property"), args[0]));
                }
            }
        }
    }

    public static List<WorldCoord> selectWorldCoordAreaRect(TownBlockOwner owner, WorldCoord pos, String[] args) throws TownyException {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        if (pos.getTownyWorld().isClaimable()) {
            if (args.length > 0) {
                int r = 0;
                int available = 1000;
                if (owner instanceof Town) {
                    Town town = (Town)owner;
                    available = TownySettings.getMaxTownBlocks(town) - town.getTownBlocks().size();
                } else if (owner instanceof Resident) {
                    available = TownySettings.getMaxResidentPlots((Resident)owner);
                }
                if (args[0].equalsIgnoreCase("auto")) {
                    while ((double)available - Math.pow((r + 1) * 2 - 1, 2.0) >= 0.0) {
                        ++r;
                    }
                } else {
                    try {
                        r = Integer.parseInt(args[0]);
                    }
                    catch (NumberFormatException e) {
                        throw new TownyException(TownySettings.getLangString("msg_err_invalid_radius"));
                    }
                }
                if (r > TownySettings.getMaxClaimRadiusValue() && TownySettings.getMaxClaimRadiusValue() > 0) {
                    throw new TownyException(String.format(TownySettings.getLangString("msg_err_invalid_radius_number"), TownySettings.getMaxClaimRadiusValue()));
                }
                if (r > 1000) {
                    r = 1000;
                }
                for (int z = -r; z <= r; ++z) {
                    for (int x = -r; x <= r; ++x) {
                        if (out.size() >= available) continue;
                        out.add(new WorldCoord(pos.getWorldName(), pos.getX() + x, pos.getZ() + z));
                    }
                }
            } else {
                throw new TownyException(TownySettings.getLangString("msg_err_invalid_radius"));
            }
        }
        return out;
    }

    public static List<WorldCoord> selectWorldCoordAreaCircle(TownBlockOwner owner, WorldCoord pos, String[] args) throws TownyException {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        if (pos.getTownyWorld().isClaimable()) {
            if (args.length > 0) {
                int r = 0;
                int available = 0;
                if (owner instanceof Town) {
                    Town town = (Town)owner;
                    available = TownySettings.getMaxTownBlocks(town) - town.getTownBlocks().size();
                } else if (owner instanceof Resident) {
                    available = TownySettings.getMaxResidentPlots((Resident)owner);
                }
                if (args[0].equalsIgnoreCase("auto")) {
                    if (available > 0) {
                        while ((double)available - Math.ceil(Math.PI * (double)r * (double)r) >= 0.0) {
                            ++r;
                        }
                    }
                } else {
                    try {
                        r = Integer.parseInt(args[0]);
                    }
                    catch (NumberFormatException e) {
                        throw new TownyException(TownySettings.getLangString("msg_err_invalid_radius"));
                    }
                }
                if (r > TownySettings.getMaxClaimRadiusValue() && TownySettings.getMaxClaimRadiusValue() > 0) {
                    throw new TownyException(String.format(TownySettings.getLangString("msg_err_invalid_radius_number"), TownySettings.getMaxClaimRadiusValue()));
                }
                if (r > 1000) {
                    r = 1000;
                }
                for (int z = -r; z <= r; ++z) {
                    for (int x = -r; x <= r; ++x) {
                        if (x * x + z * z > r * r || out.size() >= available) continue;
                        out.add(new WorldCoord(pos.getWorldName(), pos.getX() + x, pos.getZ() + z));
                    }
                }
            } else {
                throw new TownyException(TownySettings.getLangString("msg_err_invalid_radius"));
            }
        }
        return out;
    }

    public static List<WorldCoord> filterInvalidProximityTownBlocks(List<WorldCoord> selection, Town town) {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : selection) {
            try {
                if (worldCoord.getTownyWorld().getMinDistanceFromOtherTownsPlots(worldCoord, town) >= TownySettings.getMinDistanceFromTownPlotblocks()) {
                    out.add(worldCoord);
                    continue;
                }
                TownyMessaging.sendDebugMsg("AreaSelectionUtil:filterInvalidProximity - Coord: " + worldCoord + " too close to another town.");
            }
            catch (NotRegisteredException notRegisteredException) {}
        }
        return out;
    }

    public static List<WorldCoord> filterTownOwnedBlocks(List<WorldCoord> selection) {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : selection) {
            try {
                if (worldCoord.getTownBlock().hasTown()) continue;
                out.add(worldCoord);
            }
            catch (NotRegisteredException e) {
                out.add(worldCoord);
            }
        }
        return out;
    }

    public static List<WorldCoord> filterWildernessBlocks(List<WorldCoord> selection) {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : selection) {
            try {
                if (!worldCoord.getTownBlock().hasTown()) continue;
                out.add(worldCoord);
            }
            catch (NotRegisteredException notRegisteredException) {}
        }
        return out;
    }

    public static List<WorldCoord> filterOwnedBlocks(TownBlockOwner owner, List<WorldCoord> selection) {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : selection) {
            try {
                if (!worldCoord.getTownBlock().isOwner(owner)) continue;
                out.add(worldCoord);
            }
            catch (NotRegisteredException notRegisteredException) {}
        }
        return out;
    }

    public static List<WorldCoord> filterPlotsForSale(List<WorldCoord> selection) {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : selection) {
            try {
                if (!worldCoord.getTownBlock().isForSale()) continue;
                out.add(worldCoord);
            }
            catch (NotRegisteredException notRegisteredException) {}
        }
        return out;
    }

    public static List<WorldCoord> filterPlotsNotForSale(List<WorldCoord> selection) {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : selection) {
            try {
                if (!worldCoord.getTownBlock().isForSale()) continue;
                out.add(worldCoord);
            }
            catch (NotRegisteredException notRegisteredException) {}
        }
        return out;
    }

    public static List<WorldCoord> filterUnownedPlots(List<WorldCoord> selection) {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : selection) {
            try {
                if (!(worldCoord.getTownBlock().getPlotPrice() > -1.0)) continue;
                out.add(worldCoord);
            }
            catch (NotRegisteredException notRegisteredException) {}
        }
        return out;
    }

    public static int getAreaSelectPivot(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase("within")) continue;
            return i;
        }
        return -1;
    }

    public static boolean isOnEdgeOfOwnership(TownBlockOwner owner, WorldCoord worldCoord) {
        int[][] offset = new int[][]{{-1, 0}, {1, 0}, {0, -1}, {0, 1}};
        for (int i = 0; i < 4; ++i) {
            try {
                TownBlock edgeTownBlock = worldCoord.getTownyWorld().getTownBlock(new Coord(worldCoord.getX() + offset[i][0], worldCoord.getZ() + offset[i][1]));
                if (edgeTownBlock.isOwner(owner)) continue;
                return true;
            }
            catch (NotRegisteredException e) {
                return true;
            }
        }
        return false;
    }
}

