/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.confirmations.ConfirmationHandler;
import com.palmergames.bukkit.towny.confirmations.ConfirmationType;
import com.palmergames.bukkit.towny.event.TownClaimEvent;
import com.palmergames.bukkit.towny.event.TownUnclaimEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.regen.PlotBlockData;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class TownClaim
extends Thread {
    Towny plugin;
    volatile Player player;
    protected Location outpostLocation;
    volatile Town town;
    List<WorldCoord> selection;
    boolean outpost;
    boolean claim;
    boolean forced;

    public TownClaim(Towny plugin, Player player, Town town, List<WorldCoord> selection, boolean isOutpost, boolean claim, boolean forced) {
        this.plugin = plugin;
        this.player = player;
        if (this.player != null) {
            this.outpostLocation = player.getLocation();
        }
        this.town = town;
        this.selection = selection;
        this.outpost = isOutpost;
        this.claim = claim;
        this.forced = forced;
        this.setPriority(1);
    }

    @Override
    public void run() {
        ArrayList<TownyWorld> worlds = new ArrayList<TownyWorld>();
        ArrayList<Town> towns = new ArrayList<Town>();
        if (this.player != null) {
            TownyMessaging.sendMsg((Object)this.player, "Processing " + (this.claim ? "Town Claim..." : "Town unclaim..."));
        }
        if (this.selection != null) {
            for (WorldCoord worldCoord : this.selection) {
                try {
                    TownyWorld world = worldCoord.getTownyWorld();
                    if (!worlds.contains(world)) {
                        worlds.add(world);
                    }
                    if (this.claim) {
                        this.townClaim(this.town, worldCoord, this.outpost);
                        this.outpost = false;
                    } else {
                        this.town = worldCoord.getTownBlock().getTown();
                        this.townUnclaim(this.town, worldCoord, this.forced);
                    }
                    if (towns.contains(this.town)) continue;
                    towns.add(this.town);
                }
                catch (NotRegisteredException e) {
                    TownyMessaging.sendMsg((Object)this.player, TownySettings.getLangString("msg_err_not_configured"));
                }
                catch (TownyException x) {
                    TownyMessaging.sendErrorMsg((Object)this.player, x.getMessage());
                }
            }
        } else if (!this.claim) {
            if (this.town == null) {
                TownyMessaging.sendMsg((Object)this.player, "Nothing to unclaim!");
                return;
            }
            Resident resident = null;
            try {
                resident = TownyUniverse.getDataSource().getResident(this.player.getName());
            }
            catch (TownyException townyException) {
                // empty catch block
            }
            if (resident == null) {
                return;
            }
            try {
                ConfirmationHandler.addConfirmation(resident, ConfirmationType.UNCLAIMALL, null);
                TownyMessaging.sendConfirmationMessage(this.player, null, null, null, null);
            }
            catch (TownyException townyException) {
                townyException.printStackTrace();
            }
        }
        if (!towns.isEmpty()) {
            for (Town town : towns) {
                TownyUniverse.getDataSource().saveTown(town);
            }
        }
        if (!worlds.isEmpty()) {
            for (TownyWorld townyWorld : worlds) {
                TownyUniverse.getDataSource().saveWorld(townyWorld);
            }
        }
        this.plugin.resetCache();
        if (this.player != null) {
            if (this.claim) {
                TownyMessaging.sendMsg((Object)this.player, String.format(TownySettings.getLangString("msg_annexed_area"), this.selection.size() > 5 ? "Total TownBlocks: " + this.selection.size() : Arrays.toString(this.selection.toArray(new WorldCoord[0]))));
                if (this.town.getWorld().isUsingPlotManagementRevert()) {
                    TownyMessaging.sendMsg((Object)this.player, TownySettings.getLangString("msg_wait_locked"));
                }
            } else if (this.forced) {
                TownyMessaging.sendMsg((Object)this.player, String.format(TownySettings.getLangString("msg_admin_unclaim_area"), this.selection.size() > 5 ? "Total TownBlocks: " + this.selection.size() : Arrays.toString(this.selection.toArray(new WorldCoord[0]))));
                if (this.town != null && this.town.getWorld().isUsingPlotManagementRevert()) {
                    TownyMessaging.sendMsg((Object)this.player, TownySettings.getLangString("msg_wait_locked"));
                }
            }
        }
    }

    private void townClaim(Town town, WorldCoord worldCoord, boolean isOutpost) throws TownyException {
        try {
            TownBlock townBlock = worldCoord.getTownBlock();
            try {
                throw new AlreadyRegisteredException(String.format(TownySettings.getLangString("msg_already_claimed"), townBlock.getTown().getName()));
            }
            catch (NotRegisteredException e) {
                throw new AlreadyRegisteredException(TownySettings.getLangString("msg_already_claimed_2"));
            }
        }
        catch (NotRegisteredException e) {
            TownBlock townBlock = worldCoord.getTownyWorld().newTownBlock(worldCoord);
            townBlock.setTown(town);
            if (!town.hasHomeBlock()) {
                town.setHomeBlock(townBlock);
            }
            townBlock.setType(townBlock.getType());
            if (isOutpost) {
                townBlock.setOutpost(true);
                town.addOutpostSpawn(this.outpostLocation);
            }
            if (town.getWorld().isUsingPlotManagementRevert() && TownySettings.getPlotManagementSpeed() > 0L) {
                PlotBlockData plotChunk = TownyRegenAPI.getPlotChunk(townBlock);
                if (plotChunk != null) {
                    TownyRegenAPI.deletePlotChunk(plotChunk);
                    townBlock.setLocked(false);
                } else {
                    TownyRegenAPI.addWorldCoord(townBlock.getWorldCoord());
                    townBlock.setLocked(true);
                }
                plotChunk = null;
            }
            TownyUniverse.getDataSource().saveTownBlock(townBlock);
            TownyUniverse.getDataSource().saveTownBlockList();
            BukkitTools.getPluginManager().callEvent((Event)new TownClaimEvent(townBlock));
            return;
        }
    }

    private void townUnclaim(Town town, WorldCoord worldCoord, boolean force) throws TownyException {
        try {
            final TownBlock townBlock = worldCoord.getTownBlock();
            if (town != townBlock.getTown() && !force) {
                throw new TownyException(TownySettings.getLangString("msg_area_not_own"));
            }
            if (!townBlock.isOutpost() && townBlock.hasTown() && TownyUniverse.isTownBlockLocContainedInTownOutposts(townBlock.getTown().getAllOutpostSpawns(), townBlock)) {
                townBlock.setOutpost(true);
            }
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    TownyUniverse.getDataSource().removeTownBlock(townBlock);
                }
            }, 1L);
        }
        catch (NotRegisteredException e) {
            throw new TownyException(TownySettings.getLangString("msg_not_claimed_1"));
        }
    }

    public static void townUnclaimAll(Towny plugin, final Town town) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                TownyUniverse.getDataSource().removeTownBlocks(town);
                TownyMessaging.sendTownMessage(town, TownySettings.getLangString("msg_abandoned_area_1"));
                BukkitTools.getPluginManager().callEvent((Event)new TownUnclaimEvent(town, null));
            }
        }, 1L);
    }
}

