/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import java.util.ArrayDeque;
import java.util.Queue;
import org.bukkit.Chunk;
import org.bukkit.Location;

public class TeleportWarmupTimerTask
extends TownyTimerTask {
    private static Queue<Resident> teleportQueue;

    public TeleportWarmupTimerTask(Towny plugin) {
        super(plugin);
        teleportQueue = new ArrayDeque<Resident>();
    }

    @Override
    public void run() {
        Resident resident;
        long currentTime = System.currentTimeMillis();
        while ((resident = teleportQueue.peek()) != null && currentTime > resident.getTeleportRequestTime() + (long)(TownySettings.getTeleportWarmupTime() * 1000)) {
            resident.clearTeleportRequest();
            try {
                Chunk chunk = resident.getTeleportDestination().getWorld().getChunkAt(resident.getTeleportDestination().getBlock());
                if (!chunk.isLoaded()) {
                    chunk.load();
                }
                TownyUniverse.getPlayer(resident).teleport(resident.getTeleportDestination());
            }
            catch (TownyException townyException) {
                // empty catch block
            }
            teleportQueue.poll();
        }
    }

    public static void requestTeleport(Resident resident, Location spawnLoc) {
        resident.setTeleportRequestTime();
        resident.setTeleportDestination(spawnLoc);
        try {
            teleportQueue.add(resident);
        }
        catch (NullPointerException e) {
            System.out.println("[Towny] Error: Null returned from teleport queue.");
            System.out.println(e.getStackTrace());
        }
    }

    public static void abortTeleportRequest(Resident resident) {
        if (resident != null && teleportQueue.contains(resident)) {
            teleportQueue.remove(resident);
            if (resident.getTeleportCost() != 0.0 && TownySettings.isUsingEconomy()) {
                try {
                    resident.collect(resident.getTeleportCost(), TownySettings.getLangString("msg_cost_spawn_refund"));
                    resident.setTeleportCost(0.0);
                    TownyMessaging.sendResidentMessage(resident, TownySettings.getLangString("msg_cost_spawn_refund"));
                }
                catch (EconomyException e) {
                    e.printStackTrace();
                }
                catch (TownyException townyException) {
                    // empty catch block
                }
            }
        }
    }
}

