/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.ArrayList;
import org.bukkit.command.CommandSender;

public class ResidentPurge
extends Thread {
    Towny plugin;
    private CommandSender sender = null;
    long deleteTime;

    public ResidentPurge(Towny plugin, CommandSender sender, long deleteTime) {
        this.plugin = plugin;
        this.deleteTime = deleteTime;
        this.setPriority(5);
    }

    @Override
    public void run() {
        int count = 0;
        this.message("Scanning for old residents...");
        for (Resident resident : new ArrayList<Resident>(TownyUniverse.getDataSource().getResidents())) {
            if (resident.isNPC() || System.currentTimeMillis() - resident.getLastOnline() <= this.deleteTime || BukkitTools.isOnline(resident.getName())) continue;
            ++count;
            this.message("Deleting resident: " + resident.getName());
            TownyUniverse.getDataSource().removeResident(resident);
            TownyUniverse.getDataSource().removeResidentList(resident);
        }
        this.message("Resident purge complete: " + count + " deleted.");
    }

    private void message(String msg) {
        if (this.sender != null) {
            TownyMessaging.sendMessage((Object)this.sender, msg);
        } else {
            TownyMessaging.sendMsg(msg);
        }
    }
}

