/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class HealthRegenTimerTask
extends TownyTimerTask {
    private Server server;

    public HealthRegenTimerTask(Towny plugin, Server server) {
        super(plugin);
        this.server = server;
    }

    @Override
    public void run() {
        if (TownyUniverse.isWarTime()) {
            return;
        }
        for (Player player : this.server.getOnlinePlayers()) {
            if (player.getHealth() <= 0.0) continue;
            Coord coord = Coord.parseCoord((Entity)player);
            try {
                TownyWorld world = TownyUniverse.getDataSource().getWorld(player.getWorld().getName());
                TownBlock townBlock = world.getTownBlock(coord);
                if (!CombatUtil.isAlly(townBlock.getTown(), TownyUniverse.getDataSource().getResident(player.getName()).getTown()) || townBlock.getType().equals((Object)TownBlockType.ARENA)) continue;
                this.incHealth(player);
            }
            catch (TownyException townyException) {}
        }
    }

    public void incHealth(Player player) {
        double currentHP;
        float currentSat = player.getSaturation();
        if (currentSat == 0.0f) {
            player.setSaturation(1.0f);
        }
        if ((currentHP = player.getHealth()) < player.getMaxHealth()) {
            player.setHealth(Math.min(player.getMaxHealth(), currentHP += 1.0));
            EntityRegainHealthEvent event = new EntityRegainHealthEvent((Entity)player, currentHP, EntityRegainHealthEvent.RegainReason.REGEN);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
        }
    }
}

