/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.regen;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.regen.PlotBlockData;
import com.palmergames.bukkit.towny.regen.block.BlockLocation;
import com.palmergames.bukkit.towny.tasks.ProtectionRegenTask;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

public class TownyRegenAPI {
    private static Hashtable<String, PlotBlockData> PlotChunks = new Hashtable();
    private static List<WorldCoord> deleteTownBlockIdQueue = new ArrayList<WorldCoord>();
    private static List<WorldCoord> worldCoords = new ArrayList<WorldCoord>();
    private static Hashtable<BlockLocation, ProtectionRegenTask> protectionRegenTasks = new Hashtable();
    private static Set<Block> protectionPlaceholders = new HashSet<Block>();

    public static void initialize(Towny plugin) {
    }

    public static void addWorldCoord(WorldCoord worldCoord) {
        if (!worldCoords.contains(worldCoord)) {
            worldCoords.add(worldCoord);
        }
    }

    public static boolean hasWorldCoords() {
        return worldCoords.size() != 0;
    }

    public static boolean hasWorldCoord(WorldCoord worldCoord) {
        return worldCoords.contains(worldCoord);
    }

    public static WorldCoord getWorldCoord() {
        if (!worldCoords.isEmpty()) {
            WorldCoord wc = worldCoords.get(0);
            worldCoords.remove(0);
            return wc;
        }
        return null;
    }

    public static Hashtable<String, PlotBlockData> getPlotChunks() {
        return PlotChunks;
    }

    public static boolean hasPlotChunks() {
        return !PlotChunks.isEmpty();
    }

    public static void setPlotChunks(Hashtable<String, PlotBlockData> plotChunks) {
        PlotChunks = plotChunks;
    }

    public static void deletePlotChunk(PlotBlockData plotChunk) {
        if (PlotChunks.containsKey(TownyRegenAPI.getPlotKey(plotChunk))) {
            PlotChunks.remove(TownyRegenAPI.getPlotKey(plotChunk));
            TownyUniverse.getDataSource().saveRegenList();
        }
    }

    public static void addPlotChunk(PlotBlockData plotChunk, boolean save) {
        if (!PlotChunks.containsKey(TownyRegenAPI.getPlotKey(plotChunk))) {
            PlotChunks.put(TownyRegenAPI.getPlotKey(plotChunk), plotChunk);
            if (save) {
                TownyUniverse.getDataSource().saveRegenList();
            }
        }
    }

    public static void addPlotChunkSnapshot(PlotBlockData plotChunk) {
        if (TownyUniverse.getDataSource().loadPlotData(plotChunk.getWorldName(), plotChunk.getX(), plotChunk.getZ()) == null) {
            TownyUniverse.getDataSource().savePlotData(plotChunk);
        }
    }

    public static void deletePlotChunkSnapshot(PlotBlockData plotChunk) {
        TownyUniverse.getDataSource().deletePlotData(plotChunk);
    }

    public static PlotBlockData getPlotChunkSnapshot(TownBlock townBlock) {
        return TownyUniverse.getDataSource().loadPlotData(townBlock);
    }

    public static PlotBlockData getPlotChunk(TownBlock townBlock) {
        if (PlotChunks.containsKey(TownyRegenAPI.getPlotKey(townBlock))) {
            return PlotChunks.get(TownyRegenAPI.getPlotKey(townBlock));
        }
        return null;
    }

    private static String getPlotKey(PlotBlockData plotChunk) {
        return "[" + plotChunk.getWorldName() + "|" + plotChunk.getX() + "|" + plotChunk.getZ() + "]";
    }

    public static String getPlotKey(TownBlock townBlock) {
        return "[" + townBlock.getWorld().getName() + "|" + townBlock.getX() + "|" + townBlock.getZ() + "]";
    }

    public static boolean hasDeleteTownBlockIdQueue() {
        return !deleteTownBlockIdQueue.isEmpty();
    }

    public static boolean isDeleteTownBlockIdQueue(WorldCoord plot) {
        return deleteTownBlockIdQueue.contains(plot);
    }

    public static void addDeleteTownBlockIdQueue(WorldCoord plot) {
        if (!deleteTownBlockIdQueue.contains(plot)) {
            deleteTownBlockIdQueue.add(plot);
        }
    }

    public static WorldCoord getDeleteTownBlockIdQueue() {
        if (!deleteTownBlockIdQueue.isEmpty()) {
            WorldCoord wc = deleteTownBlockIdQueue.get(0);
            deleteTownBlockIdQueue.remove(0);
            return wc;
        }
        return null;
    }

    public static void doDeleteTownBlockIds(WorldCoord worldCoord) {
        World world = null;
        int plotSize = TownySettings.getTownBlockSize();
        world = worldCoord.getBukkitWorld();
        if (world != null) {
            int height = world.getMaxHeight() - 1;
            int worldx = worldCoord.getX() * plotSize;
            int worldz = worldCoord.getZ() * plotSize;
            for (int z = 0; z < plotSize; ++z) {
                for (int x = 0; x < plotSize; ++x) {
                    for (int y = height; y > 0; --y) {
                        Block block = world.getBlockAt(worldx + x, y, worldz + z);
                        try {
                            if (worldCoord.getTownyWorld().isPlotManagementDeleteIds(block.getType().name())) {
                                block.setType(Material.AIR);
                            }
                        }
                        catch (NotRegisteredException notRegisteredException) {
                            // empty catch block
                        }
                        block = null;
                    }
                }
            }
        }
    }

    public static void deleteTownBlockMaterial(TownBlock townBlock, Material material) {
        int plotSize = TownySettings.getTownBlockSize();
        TownyMessaging.sendDebugMsg("Processing deleteTownBlockMaterial");
        World world = BukkitTools.getServer().getWorld(townBlock.getWorld().getName());
        if (world != null) {
            int height = world.getMaxHeight() - 1;
            int worldx = townBlock.getX() * plotSize;
            int worldz = townBlock.getZ() * plotSize;
            for (int z = 0; z < plotSize; ++z) {
                for (int x = 0; x < plotSize; ++x) {
                    for (int y = height; y > 0; --y) {
                        Block block = world.getBlockAt(worldx + x, y, worldz + z);
                        if (block.getType() == material) {
                            block.setType(Material.AIR);
                        }
                        block = null;
                    }
                }
            }
        }
    }

    public static boolean hasProtectionRegenTask(BlockLocation blockLocation) {
        return protectionRegenTasks.containsKey(blockLocation);
    }

    public static ProtectionRegenTask GetProtectionRegenTask(BlockLocation blockLocation) {
        if (protectionRegenTasks.containsKey(blockLocation)) {
            return protectionRegenTasks.get(blockLocation);
        }
        return null;
    }

    public static void addProtectionRegenTask(ProtectionRegenTask task) {
        protectionRegenTasks.put(task.getBlockLocation(), task);
    }

    public static void removeProtectionRegenTask(ProtectionRegenTask task) {
        protectionRegenTasks.remove(task.getBlockLocation());
        if (protectionRegenTasks.isEmpty()) {
            protectionPlaceholders.clear();
        }
    }

    public static void cancelProtectionRegenTasks() {
        for (ProtectionRegenTask task : protectionRegenTasks.values()) {
            BukkitTools.getServer().getScheduler().cancelTask(task.getTaskId());
            task.replaceProtections();
        }
        protectionRegenTasks.clear();
        protectionPlaceholders.clear();
    }

    public static boolean isPlaceholder(Block block) {
        return protectionPlaceholders.contains(block);
    }

    public static void addPlaceholder(Block block) {
        protectionPlaceholders.add(block);
    }

    public static void removePlaceholder(Block block) {
        protectionPlaceholders.remove(block);
    }
}

