/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.permissions;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.util.BukkitTools;
import org.anjocaido.groupmanager.GroupManager;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;
import ru.tehkode.permissions.bukkit.PermissionsEx;

public abstract class TownyPermissionSource {
    protected TownySettings settings;
    protected Towny plugin;
    protected GroupManager groupManager = null;
    protected PermissionsEx pex = null;

    public abstract String getPrefixSuffix(Resident var1, String var2);

    public abstract int getGroupPermissionIntNode(String var1, String var2);

    public abstract int getPlayerPermissionIntNode(String var1, String var2);

    public abstract String getPlayerGroup(Player var1);

    public abstract String getPlayerPermissionStringNode(String var1, String var2);

    protected int getEffectivePermIntNode(String playerName, String node) {
        Player player = BukkitTools.getPlayer(playerName);
        for (PermissionAttachmentInfo test : player.getEffectivePermissions()) {
            if (!test.getPermission().startsWith(node + ".")) continue;
            String[] split = test.getPermission().split("\\.");
            try {
                return Integer.parseInt(split[split.length - 1]);
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return -1;
    }

    public boolean hasWildOverride(TownyWorld world, Player player, Material material, TownyPermission.ActionType action) {
        if (this.plugin.isPermissions()) {
            String blockPerm = PermissionNodes.TOWNY_WILD_ALL.getNode(action.toString().toLowerCase() + "." + material);
            boolean hasBlock = this.has(player, blockPerm);
            if (hasBlock) {
                return true;
            }
            switch (action) {
                case BUILD: {
                    return world.getUnclaimedZoneBuild();
                }
                case DESTROY: {
                    return world.getUnclaimedZoneDestroy();
                }
                case SWITCH: {
                    return world.getUnclaimedZoneSwitch();
                }
                case ITEM_USE: {
                    return world.getUnclaimedZoneItemUse();
                }
            }
        } else {
            if (this.isTownyAdmin(player)) {
                return true;
            }
            switch (action) {
                case BUILD: {
                    return world.getUnclaimedZoneBuild() != false || world.isUnclaimedZoneIgnoreMaterial(material);
                }
                case DESTROY: {
                    return world.getUnclaimedZoneDestroy() != false || world.isUnclaimedZoneIgnoreMaterial(material);
                }
                case SWITCH: {
                    return world.getUnclaimedZoneSwitch() != false || world.isUnclaimedZoneIgnoreMaterial(material);
                }
                case ITEM_USE: {
                    return world.getUnclaimedZoneItemUse() != false || world.isUnclaimedZoneIgnoreMaterial(material);
                }
            }
        }
        return false;
    }

    public boolean unclaimedZoneAction(TownyWorld world, Material material, TownyPermission.ActionType action) {
        switch (action) {
            case BUILD: {
                return world.getUnclaimedZoneBuild() != false || world.isUnclaimedZoneIgnoreMaterial(material);
            }
            case DESTROY: {
                return world.getUnclaimedZoneDestroy() != false || world.isUnclaimedZoneIgnoreMaterial(material);
            }
            case SWITCH: {
                return world.getUnclaimedZoneSwitch() != false || world.isUnclaimedZoneIgnoreMaterial(material);
            }
            case ITEM_USE: {
                return world.getUnclaimedZoneItemUse() != false || world.isUnclaimedZoneIgnoreMaterial(material);
            }
        }
        return false;
    }

    public boolean hasOwnTownOverride(Player player, Material material, TownyPermission.ActionType action) {
        if (this.plugin.isPermissions()) {
            String blockPerm = PermissionNodes.TOWNY_CLAIMED_ALL.getNode("owntown." + action.toString().toLowerCase() + "." + material);
            boolean hasBlock = this.has(player, blockPerm);
            TownyMessaging.sendDebugMsg(player.getName() + " - owntown (Block: " + material);
            if (hasBlock || this.hasAllTownOverride(player, material, action)) {
                return true;
            }
        } else if (this.isTownyAdmin(player)) {
            return true;
        }
        return false;
    }

    public boolean hasTownOwnedOverride(Player player, Material material, TownyPermission.ActionType action) {
        if (this.plugin.isPermissions()) {
            String blockPerm = PermissionNodes.TOWNY_CLAIMED_ALL.getNode("townowned." + action.toString().toLowerCase() + "." + material);
            boolean hasBlock = this.has(player, blockPerm);
            TownyMessaging.sendDebugMsg(player.getName() + " - townowned (Block: " + hasBlock);
            if (hasBlock || this.hasOwnTownOverride(player, material, action) || this.hasAllTownOverride(player, material, action)) {
                return true;
            }
        } else if (this.isTownyAdmin(player)) {
            return true;
        }
        return false;
    }

    public boolean hasAllTownOverride(Player player, Material material, TownyPermission.ActionType action) {
        if (this.plugin.isPermissions()) {
            String blockPerm = PermissionNodes.TOWNY_CLAIMED_ALL.getNode("alltown." + action.toString().toLowerCase() + "." + material);
            boolean hasBlock = this.has(player, blockPerm);
            TownyMessaging.sendDebugMsg(player.getName() + " - alltown (Block: " + hasBlock);
            if (hasBlock) {
                return true;
            }
        } else if (this.isTownyAdmin(player)) {
            return true;
        }
        return false;
    }

    public boolean isTownyAdmin(Player player) {
        return player == null || player.isOp() || this.plugin.isPermissions() && this.has(player, PermissionNodes.TOWNY_ADMIN.getNode());
    }

    public boolean testPermission(Player player, String perm) {
        return TownyUniverse.getPermissionSource().isTownyAdmin(player) || this.has(player, perm);
    }

    public boolean has(Player player, String node) {
        if (player.isOp()) {
            return true;
        }
        if (player.isPermissionSet(node)) {
            return player.hasPermission(node);
        }
        String[] parts = node.split("\\.");
        StringBuilder builder = new StringBuilder(node.length());
        for (String part : parts) {
            builder.append('*');
            if (player.hasPermission("-" + builder.toString())) {
                return false;
            }
            if (player.hasPermission(builder.toString())) {
                return true;
            }
            builder.deleteCharAt(builder.length() - 1);
            builder.append(part).append('.');
        }
        return false;
    }

    @Deprecated
    public boolean hasWildOverride(TownyWorld world, Player player, int blockId, TownyPermission.ActionType action) {
        return this.hasWildOverride(world, player, blockId, (byte)0, action);
    }

    @Deprecated
    public boolean hasOwnTownOverride(Player player, int blockId, TownyPermission.ActionType action) {
        return this.hasOwnTownOverride(player, blockId, (byte)0, action);
    }

    @Deprecated
    public boolean hasAllTownOverride(Player player, int blockId, TownyPermission.ActionType action) {
        return this.hasAllTownOverride(player, blockId, (byte)0, action);
    }

    @Deprecated
    public boolean hasWildOverride(TownyWorld world, Player player, int blockId, byte data, TownyPermission.ActionType action) {
        if (this.plugin.isPermissions()) {
            String blockPerm = PermissionNodes.TOWNY_WILD_ALL.getNode(action.toString().toLowerCase() + "." + blockId);
            String dataPerm = PermissionNodes.TOWNY_WILD_ALL.getNode(action.toString().toLowerCase() + "." + blockId + ":" + data);
            boolean dataRegistered = player.isPermissionSet(dataPerm);
            boolean hasBlock = this.has(player, blockPerm);
            boolean hasData = this.has(player, dataPerm);
            if (hasData && dataRegistered || hasBlock && !dataRegistered) {
                return true;
            }
            switch (action) {
                case BUILD: {
                    return world.getUnclaimedZoneBuild();
                }
                case DESTROY: {
                    return world.getUnclaimedZoneDestroy();
                }
                case SWITCH: {
                    return world.getUnclaimedZoneSwitch();
                }
                case ITEM_USE: {
                    return world.getUnclaimedZoneItemUse();
                }
            }
        }
        return false;
    }

    @Deprecated
    public boolean unclaimedZoneAction(TownyWorld world, int blockId, TownyPermission.ActionType action) {
        String mat = BukkitTools.getMaterial(blockId).name();
        switch (action) {
            case BUILD: {
                return world.getUnclaimedZoneBuild() != false || world.isUnclaimedZoneIgnoreId(mat);
            }
            case DESTROY: {
                return world.getUnclaimedZoneDestroy() != false || world.isUnclaimedZoneIgnoreId(mat);
            }
            case SWITCH: {
                return world.getUnclaimedZoneSwitch() != false || world.isUnclaimedZoneIgnoreId(mat);
            }
            case ITEM_USE: {
                return world.getUnclaimedZoneItemUse() != false || world.isUnclaimedZoneIgnoreId(mat);
            }
        }
        return false;
    }

    @Deprecated
    public boolean hasOwnTownOverride(Player player, int blockId, byte data, TownyPermission.ActionType action) {
        if (this.plugin.isPermissions()) {
            String blockPerm = PermissionNodes.TOWNY_CLAIMED_ALL.getNode("owntown." + action.toString().toLowerCase() + "." + blockId);
            String dataPerm = PermissionNodes.TOWNY_CLAIMED_ALL.getNode("owntown." + action.toString().toLowerCase() + "." + blockId + ":" + data);
            boolean dataRegistered = player.isPermissionSet(dataPerm);
            boolean hasBlock = this.has(player, blockPerm);
            boolean hasData = this.has(player, dataPerm);
            TownyMessaging.sendDebugMsg(player.getName() + " - owntown (Block: " + hasBlock + " - Data: " + hasData + ":" + (dataRegistered ? "Registered" : "None"));
            if (hasData && dataRegistered || hasBlock && !dataRegistered || this.hasAllTownOverride(player, blockId, data, action)) {
                return true;
            }
        } else if (this.isTownyAdmin(player)) {
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean hasTownOwnedOverride(Player player, int blockId, byte data, TownyPermission.ActionType action) {
        if (this.plugin.isPermissions()) {
            String blockPerm = PermissionNodes.TOWNY_CLAIMED_ALL.getNode("townowned." + action.toString().toLowerCase() + "." + blockId);
            String dataPerm = PermissionNodes.TOWNY_CLAIMED_ALL.getNode("townowned." + action.toString().toLowerCase() + "." + blockId + ":" + data);
            boolean dataRegistered = player.isPermissionSet(dataPerm);
            boolean hasBlock = this.has(player, blockPerm);
            boolean hasData = this.has(player, dataPerm);
            TownyMessaging.sendDebugMsg(player.getName() + " - townowned (Block: " + hasBlock + " - Data: " + hasData + ":" + (dataRegistered ? "Registered" : "None"));
            if (hasData && dataRegistered || hasBlock && !dataRegistered || this.hasOwnTownOverride(player, blockId, data, action) || this.hasAllTownOverride(player, blockId, data, action)) {
                return true;
            }
        } else if (this.isTownyAdmin(player)) {
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean hasAllTownOverride(Player player, int blockId, byte data, TownyPermission.ActionType action) {
        if (this.plugin.isPermissions()) {
            String blockPerm = PermissionNodes.TOWNY_CLAIMED_ALL.getNode("alltown." + action.toString().toLowerCase() + "." + blockId);
            String dataPerm = PermissionNodes.TOWNY_CLAIMED_ALL.getNode("alltown." + action.toString().toLowerCase() + "." + blockId + ":" + data);
            boolean dataRegistered = player.isPermissionSet(dataPerm);
            boolean hasBlock = this.has(player, blockPerm);
            boolean hasData = this.has(player, dataPerm);
            TownyMessaging.sendDebugMsg(player.getName() + " - alltown (Block: " + hasBlock + " - Data: " + hasData + ":" + (dataRegistered ? "Registered" : "None"));
            if (hasData && dataRegistered || hasBlock && !dataRegistered) {
                return true;
            }
        } else if (this.isTownyAdmin(player)) {
            return true;
        }
        return false;
    }
}

