/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;

public class WorldCoord
extends Coord {
    private String worldName;

    public WorldCoord(String worldName, int x, int z) {
        super(x, z);
        this.worldName = worldName;
    }

    public WorldCoord(String worldName, Coord coord) {
        super(coord);
        this.worldName = worldName;
    }

    public WorldCoord(WorldCoord worldCoord) {
        super(worldCoord);
        this.worldName = worldCoord.getWorldName();
    }

    public String getWorldName() {
        return this.worldName;
    }

    public Coord getCoord() {
        return new Coord(this.x, this.z);
    }

    @Deprecated
    public TownyWorld getWorld() throws NotRegisteredException {
        return this.getTownyWorld();
    }

    @Deprecated
    public WorldCoord(TownyWorld world, int x, int z) {
        super(x, z);
        this.worldName = world.getName();
    }

    @Deprecated
    public WorldCoord(TownyWorld world, Coord coord) {
        super(coord);
        this.worldName = world.getName();
    }

    public static WorldCoord parseWorldCoord(Entity entity) {
        return WorldCoord.parseWorldCoord(entity.getLocation());
    }

    public static WorldCoord parseWorldCoord(Location loc) {
        return new WorldCoord(loc.getWorld().getName(), WorldCoord.parseCoord(loc));
    }

    public static WorldCoord parseWorldCoord(Block block) {
        return new WorldCoord(block.getWorld().getName(), WorldCoord.parseCoord(block.getX(), block.getZ()));
    }

    @Override
    public WorldCoord add(int xOffset, int zOffset) {
        return new WorldCoord(this.getWorldName(), this.getX() + xOffset, this.getZ() + zOffset);
    }

    @Override
    public int hashCode() {
        int hash = 17;
        hash = hash * 27 + (this.worldName == null ? 0 : this.worldName.hashCode());
        hash = hash * 27 + this.x;
        hash = hash * 27 + this.z;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Coord)) {
            return false;
        }
        if (!(obj instanceof WorldCoord)) {
            Coord that = (Coord)obj;
            return this.x == that.x && this.z == that.z;
        }
        WorldCoord that = (WorldCoord)obj;
        return this.x == that.x && this.z == that.z && (this.worldName == null ? that.worldName == null : this.worldName.equals(that.worldName));
    }

    @Override
    public String toString() {
        return this.worldName + "," + super.toString();
    }

    public World getBukkitWorld() {
        return Bukkit.getWorld((String)this.worldName);
    }

    public TownyWorld getTownyWorld() throws NotRegisteredException {
        return TownyUniverse.getDataSource().getWorld(this.worldName);
    }

    public TownBlock getTownBlock() throws NotRegisteredException {
        return this.getTownyWorld().getTownBlock(this.getCoord());
    }
}

