/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyPermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Entity;

public class TownyWorld
extends TownyObject {
    private List<Town> towns = new ArrayList<Town>();
    private boolean isClaimable = true;
    private boolean isPVP;
    private boolean isForcePVP;
    private boolean isExplosion;
    private boolean isForceExpl;
    private boolean isFire;
    private boolean isForceFire;
    private boolean isForceTownMobs;
    private boolean hasWorldMobs;
    private boolean isDisableCreatureTrample;
    private boolean isDisablePlayerTrample;
    private boolean isEndermanProtect;
    private boolean isUsingTowny;
    private boolean isUsingPlotManagementDelete = true;
    private boolean isUsingPlotManagementMayorDelete = true;
    private boolean isUsingPlotManagementRevert = true;
    private boolean isUsingPlotManagementWildRevert = true;
    private Long plotManagementRevertSpeed;
    private Long plotManagementWildRevertDelay;
    private List<String> unclaimedZoneIgnoreBlockMaterials = null;
    private List<String> plotManagementDeleteIds = null;
    private List<String> plotManagementMayorDelete = null;
    private List<String> plotManagementIgnoreIds = null;
    private Boolean unclaimedZoneBuild = null;
    private Boolean unclaimedZoneDestroy = null;
    private Boolean unclaimedZoneSwitch = null;
    private Boolean unclaimedZoneItemUse = null;
    private String unclaimedZoneName = null;
    private Hashtable<Coord, TownBlock> townBlocks = new Hashtable();
    private List<Coord> warZones = new ArrayList<Coord>();
    private List<String> entityExplosionProtection = null;

    public TownyWorld(String name) {
        this.setName(name);
        this.isUsingTowny = TownySettings.isUsingTowny();
        this.isPVP = TownySettings.isPvP();
        this.isForcePVP = TownySettings.isForcingPvP();
        this.isFire = TownySettings.isFire();
        this.isForceFire = TownySettings.isForcingFire();
        this.hasWorldMobs = TownySettings.isWorldMonstersOn();
        this.isForceTownMobs = TownySettings.isForcingMonsters();
        this.isExplosion = TownySettings.isExplosions();
        this.isForceExpl = TownySettings.isForcingExplosions();
        this.isEndermanProtect = TownySettings.getEndermanProtect();
        this.isDisablePlayerTrample = TownySettings.isPlayerTramplingCropsDisabled();
        this.isDisableCreatureTrample = TownySettings.isCreatureTramplingCropsDisabled();
        this.setUsingPlotManagementDelete(TownySettings.isUsingPlotManagementDelete());
        this.setUsingPlotManagementRevert(TownySettings.isUsingPlotManagementRevert());
        this.setPlotManagementRevertSpeed(TownySettings.getPlotManagementSpeed());
        this.setUsingPlotManagementWildRevert(TownySettings.isUsingPlotManagementWildRegen());
        this.setPlotManagementWildRevertDelay(TownySettings.getPlotManagementWildRegenDelay());
    }

    public List<Town> getTowns() {
        return this.towns;
    }

    public boolean hasTowns() {
        return !this.towns.isEmpty();
    }

    public boolean hasTown(String name) {
        for (Town town : this.towns) {
            if (!town.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasTown(Town town) {
        return this.towns.contains(town);
    }

    public void addTown(Town town) throws AlreadyRegisteredException {
        if (this.hasTown(town)) {
            throw new AlreadyRegisteredException();
        }
        this.towns.add(town);
        town.setWorld(this);
    }

    public TownBlock getTownBlock(Coord coord) throws NotRegisteredException {
        TownBlock townBlock = this.townBlocks.get(coord);
        if (townBlock == null) {
            throw new NotRegisteredException();
        }
        return townBlock;
    }

    public void newTownBlock(int x, int z) throws AlreadyRegisteredException {
        this.newTownBlock(new Coord(x, z));
    }

    public TownBlock newTownBlock(Coord key) throws AlreadyRegisteredException {
        if (this.hasTownBlock(key)) {
            throw new AlreadyRegisteredException();
        }
        this.townBlocks.put(new Coord(key.getX(), key.getZ()), new TownBlock(key.getX(), key.getZ(), this));
        return this.townBlocks.get(new Coord(key.getX(), key.getZ()));
    }

    public boolean hasTownBlock(Coord key) {
        return this.townBlocks.containsKey(key);
    }

    public TownBlock getTownBlock(int x, int z) throws NotRegisteredException {
        return this.getTownBlock(new Coord(x, z));
    }

    public List<TownBlock> getTownBlocks(Town town) {
        ArrayList<TownBlock> out = new ArrayList<TownBlock>();
        for (TownBlock townBlock : town.getTownBlocks()) {
            if (townBlock.getWorld() != this) continue;
            out.add(townBlock);
        }
        return out;
    }

    public Collection<TownBlock> getTownBlocks() {
        return this.townBlocks.values();
    }

    public void removeTown(Town town) throws NotRegisteredException {
        if (!this.hasTown(town)) {
            throw new NotRegisteredException();
        }
        this.towns.remove(town);
    }

    public void removeTownBlock(TownBlock townBlock) {
        try {
            if (townBlock.hasResident()) {
                townBlock.getResident().removeTownBlock(townBlock);
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        try {
            if (townBlock.hasTown()) {
                townBlock.getTown().removeTownBlock(townBlock);
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        this.removeTownBlock(townBlock.getCoord());
    }

    public void removeTownBlocks(List<TownBlock> townBlocks) {
        for (TownBlock townBlock : new ArrayList<TownBlock>(townBlocks)) {
            this.removeTownBlock(townBlock);
        }
    }

    public void removeTownBlock(Coord coord) {
        this.townBlocks.remove(coord);
    }

    @Override
    public List<String> getTreeString(int depth) {
        ArrayList<String> out = new ArrayList<String>();
        out.add(this.getTreeDepth(depth) + "World (" + this.getName() + ")");
        out.add(this.getTreeDepth(depth + 1) + "TownBlocks (" + this.getTownBlocks().size() + "): ");
        return out;
    }

    public void setPVP(boolean isPVP) {
        this.isPVP = isPVP;
    }

    public boolean isPVP() {
        return this.isPVP;
    }

    public void setForcePVP(boolean isPVP) {
        this.isForcePVP = isPVP;
    }

    public boolean isForcePVP() {
        return this.isForcePVP;
    }

    public void setExpl(boolean isExpl) {
        this.isExplosion = isExpl;
    }

    public boolean isExpl() {
        return this.isExplosion;
    }

    public void setForceExpl(boolean isExpl) {
        this.isForceExpl = isExpl;
    }

    public boolean isForceExpl() {
        return this.isForceExpl;
    }

    public void setFire(boolean isFire) {
        this.isFire = isFire;
    }

    public boolean isFire() {
        return this.isFire;
    }

    public void setForceFire(boolean isFire) {
        this.isForceFire = isFire;
    }

    public boolean isForceFire() {
        return this.isForceFire;
    }

    public void setDisablePlayerTrample(boolean isDisablePlayerTrample) {
        this.isDisablePlayerTrample = isDisablePlayerTrample;
    }

    public boolean isDisablePlayerTrample() {
        return this.isDisablePlayerTrample;
    }

    public void setDisableCreatureTrample(boolean isDisableCreatureTrample) {
        this.isDisableCreatureTrample = isDisableCreatureTrample;
    }

    public boolean isDisableCreatureTrample() {
        return this.isDisableCreatureTrample;
    }

    public void setWorldMobs(boolean hasMobs) {
        this.hasWorldMobs = hasMobs;
    }

    public boolean hasWorldMobs() {
        return this.hasWorldMobs;
    }

    public void setForceTownMobs(boolean setMobs) {
        this.isForceTownMobs = setMobs;
    }

    public boolean isForceTownMobs() {
        return this.isForceTownMobs;
    }

    public void setEndermanProtect(boolean setEnder) {
        this.isEndermanProtect = setEnder;
    }

    public boolean isEndermanProtect() {
        return this.isEndermanProtect;
    }

    public void setClaimable(boolean isClaimable) {
        this.isClaimable = isClaimable;
    }

    public boolean isClaimable() {
        if (!this.isUsingTowny()) {
            return false;
        }
        return this.isClaimable;
    }

    public void setUsingDefault() {
        this.setUnclaimedZoneBuild(null);
        this.setUnclaimedZoneDestroy(null);
        this.setUnclaimedZoneSwitch(null);
        this.setUnclaimedZoneItemUse(null);
        this.setUnclaimedZoneIgnore(null);
        this.setUnclaimedZoneName(null);
    }

    public void setUsingPlotManagementDelete(boolean using) {
        this.isUsingPlotManagementDelete = using;
    }

    public boolean isUsingPlotManagementDelete() {
        return this.isUsingPlotManagementDelete;
    }

    public void setUsingPlotManagementMayorDelete(boolean using) {
        this.isUsingPlotManagementMayorDelete = using;
    }

    public boolean isUsingPlotManagementMayorDelete() {
        return this.isUsingPlotManagementMayorDelete;
    }

    public void setUsingPlotManagementRevert(boolean using) {
        this.isUsingPlotManagementRevert = using;
    }

    public boolean isUsingPlotManagementRevert() {
        return this.isUsingPlotManagementRevert;
    }

    public List<String> getPlotManagementDeleteIds() {
        if (this.plotManagementDeleteIds == null) {
            return TownySettings.getPlotManagementDeleteIds();
        }
        return this.plotManagementDeleteIds;
    }

    public boolean isPlotManagementDeleteIds(String id) {
        return this.getPlotManagementDeleteIds().contains(id);
    }

    public void setPlotManagementDeleteIds(List<String> plotManagementDeleteIds) {
        this.plotManagementDeleteIds = plotManagementDeleteIds;
    }

    public List<String> getPlotManagementMayorDelete() {
        if (this.plotManagementMayorDelete == null) {
            return TownySettings.getPlotManagementMayorDelete();
        }
        return this.plotManagementMayorDelete;
    }

    public boolean isPlotManagementMayorDelete(String material) {
        return this.getPlotManagementMayorDelete().contains(material.toUpperCase());
    }

    public void setPlotManagementMayorDelete(List<String> plotManagementMayorDelete) {
        this.plotManagementMayorDelete = plotManagementMayorDelete;
    }

    public List<String> getPlotManagementIgnoreIds() {
        if (this.plotManagementIgnoreIds == null) {
            return TownySettings.getPlotManagementIgnoreIds();
        }
        return this.plotManagementIgnoreIds;
    }

    public boolean isPlotManagementIgnoreIds(String id, Byte data) {
        if (this.getPlotManagementIgnoreIds().contains(id + ":" + Byte.toString(data))) {
            return true;
        }
        return this.getPlotManagementIgnoreIds().contains(id);
    }

    public void setPlotManagementIgnoreIds(List<String> plotManagementIgnoreIds) {
        this.plotManagementIgnoreIds = plotManagementIgnoreIds;
    }

    public boolean isUsingPlotManagementWildRevert() {
        return this.isUsingPlotManagementWildRevert;
    }

    public void setUsingPlotManagementWildRevert(boolean isUsingPlotManagementWildRevert) {
        this.isUsingPlotManagementWildRevert = isUsingPlotManagementWildRevert;
    }

    public long getPlotManagementRevertSpeed() {
        return this.plotManagementRevertSpeed;
    }

    public void setPlotManagementRevertSpeed(long plotManagementRevertSpeed) {
        this.plotManagementRevertSpeed = plotManagementRevertSpeed;
    }

    public long getPlotManagementWildRevertDelay() {
        return this.plotManagementWildRevertDelay;
    }

    public void setPlotManagementWildRevertDelay(long plotManagementWildRevertDelay) {
        this.plotManagementWildRevertDelay = plotManagementWildRevertDelay;
    }

    public void setPlotManagementWildRevertEntities(List<String> entities) {
        this.entityExplosionProtection = new ArrayList<String>();
        for (String mob : entities) {
            if (mob.equals("")) continue;
            this.entityExplosionProtection.add(mob.toLowerCase());
        }
    }

    public List<String> getPlotManagementWildRevertEntities() {
        if (this.entityExplosionProtection == null) {
            this.setPlotManagementWildRevertEntities(TownySettings.getWildExplosionProtectionEntities());
        }
        return this.entityExplosionProtection;
    }

    public boolean isProtectingExplosionEntity(Entity entity) {
        if (this.entityExplosionProtection == null) {
            this.setPlotManagementWildRevertEntities(TownySettings.getWildExplosionProtectionEntities());
        }
        return this.entityExplosionProtection.contains(entity.getType().getEntityClass().getSimpleName().toLowerCase());
    }

    @Deprecated
    public List<String> getUnclaimedZoneIgnoreIds() {
        if (this.unclaimedZoneIgnoreBlockMaterials == null) {
            return TownySettings.getUnclaimedZoneIgnoreMaterials();
        }
        return this.unclaimedZoneIgnoreBlockMaterials;
    }

    @Deprecated
    public boolean isUnclaimedZoneIgnoreId(String id) {
        return this.getUnclaimedZoneIgnoreMaterials().contains(id);
    }

    public void setUnclaimedZoneIgnore(List<String> unclaimedZoneIgnoreIds) {
        this.unclaimedZoneIgnoreBlockMaterials = unclaimedZoneIgnoreIds;
    }

    public List<String> getUnclaimedZoneIgnoreMaterials() {
        if (this.unclaimedZoneIgnoreBlockMaterials == null) {
            return TownySettings.getUnclaimedZoneIgnoreMaterials();
        }
        return this.unclaimedZoneIgnoreBlockMaterials;
    }

    public boolean isUnclaimedZoneIgnoreMaterial(Material mat) {
        return this.getUnclaimedZoneIgnoreMaterials().contains(mat);
    }

    public boolean getUnclaimedZonePerm(TownyPermission.ActionType type) {
        switch (type) {
            case BUILD: {
                return this.getUnclaimedZoneBuild();
            }
            case DESTROY: {
                return this.getUnclaimedZoneDestroy();
            }
            case SWITCH: {
                return this.getUnclaimedZoneSwitch();
            }
            case ITEM_USE: {
                return this.getUnclaimedZoneItemUse();
            }
        }
        throw new UnsupportedOperationException();
    }

    public Boolean getUnclaimedZoneBuild() {
        if (this.unclaimedZoneBuild == null) {
            return TownySettings.getUnclaimedZoneBuildRights();
        }
        return this.unclaimedZoneBuild;
    }

    public void setUnclaimedZoneBuild(Boolean unclaimedZoneBuild) {
        this.unclaimedZoneBuild = unclaimedZoneBuild;
    }

    public Boolean getUnclaimedZoneDestroy() {
        if (this.unclaimedZoneDestroy == null) {
            return TownySettings.getUnclaimedZoneDestroyRights();
        }
        return this.unclaimedZoneDestroy;
    }

    public void setUnclaimedZoneDestroy(Boolean unclaimedZoneDestroy) {
        this.unclaimedZoneDestroy = unclaimedZoneDestroy;
    }

    public Boolean getUnclaimedZoneSwitch() {
        if (this.unclaimedZoneSwitch == null) {
            return TownySettings.getUnclaimedZoneSwitchRights();
        }
        return this.unclaimedZoneSwitch;
    }

    public void setUnclaimedZoneSwitch(Boolean unclaimedZoneSwitch) {
        this.unclaimedZoneSwitch = unclaimedZoneSwitch;
    }

    public String getUnclaimedZoneName() {
        if (this.unclaimedZoneName == null) {
            return TownySettings.getUnclaimedZoneName();
        }
        return this.unclaimedZoneName;
    }

    public void setUnclaimedZoneName(String unclaimedZoneName) {
        this.unclaimedZoneName = unclaimedZoneName;
    }

    public void setUsingTowny(boolean isUsingTowny) {
        this.isUsingTowny = isUsingTowny;
    }

    public boolean isUsingTowny() {
        return this.isUsingTowny;
    }

    public void setUnclaimedZoneItemUse(Boolean unclaimedZoneItemUse) {
        this.unclaimedZoneItemUse = unclaimedZoneItemUse;
    }

    public Boolean getUnclaimedZoneItemUse() {
        if (this.unclaimedZoneItemUse == null) {
            return TownySettings.getUnclaimedZoneItemUseRights();
        }
        return this.unclaimedZoneItemUse;
    }

    public int getMinDistanceFromOtherTowns(Coord key) {
        return this.getMinDistanceFromOtherTowns(key, null);
    }

    public int getMinDistanceFromOtherTowns(Coord key, Town homeTown) {
        double min = 2.147483647E9;
        for (Town town : this.getTowns()) {
            try {
                double dist;
                Coord townCoord = town.getHomeBlock().getCoord();
                if (homeTown != null && homeTown.getHomeBlock().equals(town.getHomeBlock()) || !town.getWorld().equals(this) || !((dist = Math.sqrt(Math.pow(townCoord.getX() - key.getX(), 2.0) + Math.pow(townCoord.getZ() - key.getZ(), 2.0))) < min)) continue;
                min = dist;
            }
            catch (TownyException townyException) {}
        }
        return (int)Math.ceil(min);
    }

    public int getMinDistanceFromOtherTownsPlots(Coord key) {
        return this.getMinDistanceFromOtherTownsPlots(key, null);
    }

    public int getMinDistanceFromOtherTownsPlots(Coord key, Town homeTown) {
        double min = 2.147483647E9;
        for (Town town : this.getTowns()) {
            try {
                if (homeTown != null && homeTown.getHomeBlock().equals(town.getHomeBlock())) continue;
                for (TownBlock b : town.getTownBlocks()) {
                    Coord townCoord;
                    double dist;
                    if (!b.getWorld().equals(this) || !((dist = Math.sqrt(Math.pow((townCoord = b.getCoord()).getX() - key.getX(), 2.0) + Math.pow(townCoord.getZ() - key.getZ(), 2.0))) < min)) continue;
                    min = dist;
                }
            }
            catch (TownyException townyException) {
            }
        }
        return (int)Math.ceil(min);
    }

    public Town getClosestTownFromCoord(Coord key, Town nearestTown) {
        double min = 2.147483647E9;
        for (Town town : this.getTowns()) {
            for (TownBlock b : town.getTownBlocks()) {
                Coord townCoord;
                double dist;
                if (!b.getWorld().equals(this) || !((dist = Math.sqrt(Math.pow((townCoord = b.getCoord()).getX() - key.getX(), 2.0) + Math.pow(townCoord.getZ() - key.getZ(), 2.0))) < min)) continue;
                min = dist;
                nearestTown = town;
            }
        }
        return nearestTown;
    }

    public Town getClosestTownWithNationFromCoord(Coord key, Town nearestTown) {
        double min = 2.147483647E9;
        for (Town town : this.getTowns()) {
            if (!town.hasNation()) continue;
            for (TownBlock b : town.getTownBlocks()) {
                Coord townCoord;
                double dist;
                if (!b.getWorld().equals(this) || !((dist = Math.sqrt(Math.pow((townCoord = b.getCoord()).getX() - key.getX(), 2.0) + Math.pow(townCoord.getZ() - key.getZ(), 2.0))) < min)) continue;
                min = dist;
                nearestTown = town;
            }
        }
        return nearestTown;
    }

    public void addWarZone(Coord coord) {
        if (!this.isWarZone(coord)) {
            this.warZones.add(coord);
        }
    }

    public void removeWarZone(Coord coord) {
        this.warZones.remove(coord);
    }

    public boolean isWarZone(Coord coord) {
        return this.warZones.contains(coord);
    }
}

