/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.db.TownyDataSource;
import com.palmergames.bukkit.towny.db.TownyFlatFileSource;
import com.palmergames.bukkit.towny.db.TownySQLSource;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyObservableType;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.permissions.TownyPermissionSource;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.tasks.OnPlayerLogin;
import com.palmergames.bukkit.towny.tasks.TeleportWarmupTimerTask;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.war.eventwar.War;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.NameValidation;
import com.palmergames.util.FileMgmt;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.naming.InvalidNameException;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class TownyUniverse
extends TownyObject {
    private static Towny plugin;
    protected Hashtable<String, Resident> residents = new Hashtable();
    protected Hashtable<String, Town> towns = new Hashtable();
    protected Hashtable<String, Nation> nations = new Hashtable();
    protected Hashtable<String, TownyWorld> worlds = new Hashtable();
    private static TownyDataSource dataSource;
    private static TownyPermissionSource permissionSource;
    private static War warEvent;
    private String rootFolder;

    public TownyUniverse(Towny plugin) {
        this.setName("");
        TownyUniverse.plugin = plugin;
    }

    public void onLogin(Player player) throws AlreadyRegisteredException, NotRegisteredException {
        if (!player.isOnline()) {
            return;
        }
        if (player.getName().trim() == null || player.getName().contains(" ")) {
            player.kickPlayer("Invalid name!");
            return;
        }
        if (BukkitTools.scheduleSyncDelayedTask(new OnPlayerLogin(plugin, player), 0L) == -1) {
            TownyMessaging.sendErrorMsg("Could not schedule OnLogin.");
        }
    }

    public void onLogout(Player player) {
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            resident.setLastOnline(System.currentTimeMillis());
            TownyUniverse.getDataSource().saveResident(resident);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        this.setChangedNotify(TownyObservableType.PLAYER_LOGOUT);
    }

    public Location getTownSpawnLocation(Player player) throws TownyException {
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            Town town = resident.getTown();
            return town.getSpawn();
        }
        catch (TownyException x) {
            throw new TownyException("Unable to get spawn location");
        }
    }

    public Location getNationSpawnLocation(Player player) throws TownyException {
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            Nation nation = resident.getTown().getNation();
            return nation.getNationSpawn();
        }
        catch (TownyException x) {
            throw new TownyException("Unable to get nation spawn location");
        }
    }

    public static Player getPlayer(Resident resident) throws TownyException {
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null || !player.getName().equals(resident.getName())) continue;
            return player;
        }
        throw new TownyException(String.format("%s is not online", resident.getName()));
    }

    public static UUID getPlayerUUID(Resident resident) throws TownyException {
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null || !player.getName().equals(resident.getName())) continue;
            return player.getUniqueId();
        }
        throw new TownyException(String.format("%s is not online", resident.getName()));
    }

    public static List<Player> getOnlinePlayers(ResidentList residents) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null || !residents.hasResident(player.getName())) continue;
            players.add(player);
        }
        return players;
    }

    public static List<Player> getOnlinePlayers(Town town) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null || !town.hasResident(player.getName())) continue;
            players.add(player);
        }
        return players;
    }

    public static List<Player> getOnlinePlayers(Nation nation) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (Town town : nation.getTowns()) {
            players.addAll(TownyUniverse.getOnlinePlayers(town));
        }
        return players;
    }

    public static boolean isWilderness(Block block) {
        WorldCoord worldCoord;
        try {
            worldCoord = new WorldCoord(TownyUniverse.getDataSource().getWorld(block.getWorld().getName()).getName(), Coord.parseCoord(block));
        }
        catch (NotRegisteredException e) {
            return true;
        }
        try {
            return worldCoord.getTownBlock().getTown() == null;
        }
        catch (NotRegisteredException e) {
            return true;
        }
    }

    public static String getTownName(Location loc) {
        try {
            WorldCoord worldCoord = new WorldCoord(TownyUniverse.getDataSource().getWorld(loc.getWorld().getName()).getName(), Coord.parseCoord(loc));
            return worldCoord.getTownBlock().getTown().getName();
        }
        catch (NotRegisteredException e) {
            return null;
        }
    }

    public static UUID getTownUUID(Location loc) {
        try {
            WorldCoord worldCoord = new WorldCoord(TownyUniverse.getDataSource().getWorld(loc.getWorld().getName()).getName(), Coord.parseCoord(loc));
            return worldCoord.getTownBlock().getTown().getUuid();
        }
        catch (NotRegisteredException e) {
            return null;
        }
    }

    public static TownBlock getTownBlock(Location loc) {
        try {
            WorldCoord worldCoord = new WorldCoord(TownyUniverse.getDataSource().getWorld(loc.getWorld().getName()).getName(), Coord.parseCoord(loc));
            return worldCoord.getTownBlock();
        }
        catch (NotRegisteredException e) {
            return null;
        }
    }

    public List<Resident> getActiveResidents() {
        ArrayList<Resident> activeResidents = new ArrayList<Resident>();
        for (Resident resident : TownyUniverse.getDataSource().getResidents()) {
            if (!this.isActiveResident(resident)) continue;
            activeResidents.add(resident);
        }
        return activeResidents;
    }

    public boolean isActiveResident(Resident resident) {
        return System.currentTimeMillis() - resident.getLastOnline() < 20L * TownySettings.getInactiveAfter() || BukkitTools.isOnline(resident.getName());
    }

    public boolean loadSettings() {
        try {
            TownySettings.loadConfig(this.getRootFolder() + FileMgmt.fileSeparator() + "settings" + FileMgmt.fileSeparator() + "config.yml", plugin.getVersion());
            TownySettings.loadLanguage(this.getRootFolder() + FileMgmt.fileSeparator() + "settings", "english.yml");
            TownyPerms.loadPerms(this.getRootFolder() + FileMgmt.fileSeparator() + "settings", "townyperms.yml");
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        String save = TownySettings.getSaveDatabase();
        String load = TownySettings.getLoadDatabase();
        Coord.setCellSize(TownySettings.getTownBlockSize());
        System.out.println("[Towny] Database: [Load] " + load + " [Save] " + save);
        this.worlds.clear();
        this.nations.clear();
        this.towns.clear();
        this.residents.clear();
        if (!this.loadDatabase(load)) {
            System.out.println("[Towny] Error: Failed to load!");
            return false;
        }
        try {
            TownyUniverse.getDataSource().cleanupBackups();
            this.setDataSource(save);
            TownyUniverse.getDataSource().initialize(plugin, this);
            FileMgmt.checkFolders(new String[]{this.getRootFolder() + FileMgmt.fileSeparator() + "logs"});
            try {
                TownyUniverse.getDataSource().backup();
                if (load.equalsIgnoreCase("flatfile") || save.equalsIgnoreCase("flatfile")) {
                    TownyUniverse.getDataSource().deleteUnusedResidentFiles();
                }
            }
            catch (IOException e) {
                System.out.println("[Towny] Error: Could not create backup.");
                e.printStackTrace();
                return false;
            }
            if (load.equalsIgnoreCase(save)) {
                TownyUniverse.getDataSource().saveAllWorlds();
            } else {
                TownyUniverse.getDataSource().saveAll();
            }
        }
        catch (UnsupportedOperationException e) {
            System.out.println("[Towny] Error: Unsupported save format!");
            return false;
        }
        File f = new File(plugin.getDataFolder(), "outpostschecked.txt");
        if (!f.exists()) {
            for (Town town : TownyUniverse.getDataSource().getTowns()) {
                TownySQLSource.validateTownOutposts(town);
            }
            plugin.saveResource("outpostschecked.txt", false);
        }
        return true;
    }

    public boolean loadDatabase(String databaseType) {
        try {
            this.setDataSource(databaseType);
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
        TownyUniverse.getDataSource().initialize(plugin, this);
        return TownyUniverse.getDataSource().loadAll();
    }

    public String getRootFolder() {
        if (plugin != null) {
            return plugin.getDataFolder().getPath();
        }
        return this.rootFolder;
    }

    public void setDataSource(String databaseType) throws UnsupportedOperationException {
        if (databaseType.equalsIgnoreCase("flatfile")) {
            this.setDataSource(new TownyFlatFileSource());
        } else if (databaseType.equalsIgnoreCase("mysql") || databaseType.equalsIgnoreCase("sqlite") || databaseType.equalsIgnoreCase("h2")) {
            this.setDataSource(new TownySQLSource(databaseType));
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void setDataSource(TownyDataSource dataSource) {
        TownyUniverse.dataSource = dataSource;
    }

    public static TownyDataSource getDataSource() {
        return dataSource;
    }

    public void setPermissionSource(TownyPermissionSource permissionSource) {
        TownyUniverse.permissionSource = permissionSource;
    }

    public static TownyPermissionSource getPermissionSource() {
        return permissionSource;
    }

    public Hashtable<String, Resident> getResidentMap() {
        return this.residents;
    }

    public Hashtable<String, Town> getTownsMap() {
        return this.towns;
    }

    public Hashtable<String, Nation> getNationsMap() {
        return this.nations;
    }

    public Hashtable<String, TownyWorld> getWorldMap() {
        return this.worlds;
    }

    public static boolean isWarTime() {
        return warEvent != null ? warEvent.isWarTime() : false;
    }

    public void startWarEvent() {
        warEvent = new War(plugin, TownySettings.getWarTimeWarningDelay());
        this.setChangedNotify(TownyObservableType.WAR_START);
    }

    public void endWarEvent() {
        if (TownyUniverse.isWarTime()) {
            warEvent.toggleEnd();
        }
        this.setChangedNotify(TownyObservableType.WAR_END);
    }

    public void clearWarEvent() {
        this.getWarEvent().cancelTasks(BukkitTools.getScheduler());
        this.setWarEvent(null);
        this.setChangedNotify(TownyObservableType.WAR_CLEARED);
    }

    public War getWarEvent() {
        return warEvent;
    }

    public void setWarEvent(War event) {
        warEvent = event;
        this.setChangedNotify(TownyObservableType.WAR_SET);
    }

    public void sendUniverseTree(CommandSender sender) {
        for (String line : this.getTreeString(0)) {
            sender.sendMessage(line);
        }
    }

    @Override
    public List<String> getTreeString(int depth) {
        ArrayList<String> out = new ArrayList<String>();
        out.add(this.getTreeDepth(depth) + "Universe (" + this.getName() + ")");
        if (plugin != null) {
            out.add(this.getTreeDepth(depth + 1) + "Server (" + BukkitTools.getServer().getName() + ")");
            out.add(this.getTreeDepth(depth + 2) + "Version: " + BukkitTools.getServer().getVersion());
            out.add(this.getTreeDepth(depth + 2) + "Worlds (" + BukkitTools.getWorlds().size() + "): " + Arrays.toString(BukkitTools.getWorlds().toArray(new World[0])));
        }
        out.add(this.getTreeDepth(depth + 1) + "Worlds (" + TownyUniverse.getDataSource().getWorlds().size() + "):");
        for (TownyWorld townyWorld : TownyUniverse.getDataSource().getWorlds()) {
            out.addAll(townyWorld.getTreeString(depth + 2));
        }
        out.add(this.getTreeDepth(depth + 1) + "Nations (" + TownyUniverse.getDataSource().getNations().size() + "):");
        for (Nation nation : TownyUniverse.getDataSource().getNations()) {
            out.addAll(nation.getTreeString(depth + 2));
        }
        List<Town> townsWithoutNation = TownyUniverse.getDataSource().getTownsWithoutNation();
        out.add(this.getTreeDepth(depth + 1) + "Towns (" + townsWithoutNation.size() + "):");
        for (Town town : townsWithoutNation) {
            out.addAll(town.getTreeString(depth + 2));
        }
        List<Resident> list = TownyUniverse.getDataSource().getResidentsWithoutTown();
        out.add(this.getTreeDepth(depth + 1) + "Residents (" + list.size() + "):");
        for (Resident resident : list) {
            out.addAll(resident.getTreeString(depth + 2));
        }
        return out;
    }

    public static List<Resident> getValidatedResidents(Object sender, String[] names) {
        ArrayList<Resident> invited = new ArrayList<Resident>();
        for (String name : names) {
            Resident target;
            List<Player> matches = BukkitTools.matchPlayer(name);
            if (matches.size() > 1) {
                String line = "Multiple players selected";
                for (Player p : matches) {
                    line = line + ", " + p.getName();
                }
                TownyMessaging.sendErrorMsg(sender, line);
                continue;
            }
            if (matches.size() == 1) {
                try {
                    target = TownyUniverse.getDataSource().getResident(matches.get(0).getName());
                    invited.add(target);
                }
                catch (TownyException x) {
                    TownyMessaging.sendErrorMsg(sender, x.getMessage());
                }
                continue;
            }
            try {
                target = TownyUniverse.getDataSource().getResident(name);
                invited.add(target);
            }
            catch (NotRegisteredException x) {
                TownyMessaging.sendErrorMsg(sender, x.getMessage());
            }
        }
        return invited;
    }

    public static List<Resident> getOnlineResidents(Player player, String[] names) {
        ArrayList<Resident> invited = new ArrayList<Resident>();
        for (String name : names) {
            List<Player> matches = BukkitTools.matchPlayer(name);
            if (matches.size() > 1) {
                String line = "Multiple players selected";
                for (Player p : matches) {
                    line = line + ", " + p.getName();
                }
                TownyMessaging.sendErrorMsg((Object)player, line);
                continue;
            }
            if (matches.size() != 1) continue;
            try {
                Resident target = TownyUniverse.getDataSource().getResident(matches.get(0).getName());
                invited.add(target);
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            }
        }
        return invited;
    }

    public static List<Resident> getOnlineResidents(ResidentList residentList) {
        ArrayList<Resident> onlineResidents = new ArrayList<Resident>();
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null) continue;
            for (Resident resident : residentList.getResidents()) {
                if (!resident.getName().equalsIgnoreCase(player.getName())) continue;
                onlineResidents.add(resident);
            }
        }
        return onlineResidents;
    }

    public static List<Resident> getOnlineResidentsViewable(Player viewer, ResidentList residentList) {
        ArrayList<Resident> onlineResidents = new ArrayList<Resident>();
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null) continue;
            for (Resident resident : residentList.getResidents()) {
                if (!resident.getName().equalsIgnoreCase(player.getName()) || viewer != null && !viewer.canSee(BukkitTools.getPlayerExact(resident.getName()))) continue;
                onlineResidents.add(resident);
            }
        }
        return onlineResidents;
    }

    public void requestTeleport(Player player, Location spawnLoc, double cost) {
        try {
            TeleportWarmupTimerTask.requestTeleport(TownyUniverse.getDataSource().getResident(player.getName().toLowerCase()), spawnLoc);
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
        }
        this.setChangedNotify(TownyObservableType.TELEPORT_REQUEST);
    }

    public void abortTeleportRequest(Resident resident) {
        TeleportWarmupTimerTask.abortTeleportRequest(resident);
    }

    public static void jailTeleport(Player player, Location loc) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, () -> player.teleport(loc, PlayerTeleportEvent.TeleportCause.PLUGIN), (long)(TownySettings.getTeleportWarmupTime() * 20));
    }

    public void addWarZone(WorldCoord worldCoord) {
        try {
            worldCoord.getTownyWorld().addWarZone(worldCoord);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        plugin.updateCache(worldCoord);
    }

    public void removeWarZone(WorldCoord worldCoord) {
        try {
            worldCoord.getTownyWorld().removeWarZone(worldCoord);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        plugin.updateCache(worldCoord);
    }

    public void setChangedNotify(TownyObservableType type) {
        this.setChanged();
        this.notifyObservers((Object)type);
    }

    @Deprecated
    public boolean areAllAllies(List<Nation> possibleAllies) {
        if (possibleAllies.size() <= 1) {
            return true;
        }
        for (int i = 0; i < possibleAllies.size() - 1; ++i) {
            if (possibleAllies.get(i).hasAlly(possibleAllies.get(i + 1))) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public boolean isEnemyTownBlock(Player player, WorldCoord worldCoord) {
        try {
            return CombatUtil.isEnemy(TownyUniverse.getDataSource().getResident(player.getName()).getTown(), worldCoord.getTownBlock().getTown());
        }
        catch (NotRegisteredException e) {
            return false;
        }
    }

    @Deprecated
    public boolean isAlly(String a, String b) {
        try {
            Resident residentA = TownyUniverse.getDataSource().getResident(a);
            Resident residentB = TownyUniverse.getDataSource().getResident(b);
            if (residentA.getTown() == residentB.getTown()) {
                return true;
            }
            if (residentA.getTown().getNation() == residentB.getTown().getNation()) {
                return true;
            }
            if (residentA.getTown().getNation().hasAlly(residentB.getTown().getNation())) {
                return true;
            }
        }
        catch (NotRegisteredException e) {
            return false;
        }
        return false;
    }

    @Deprecated
    public boolean isAlly(Town a, Town b) {
        try {
            if (a == b) {
                return true;
            }
            if (a.getNation() == b.getNation()) {
                return true;
            }
            if (a.getNation().hasAlly(b.getNation())) {
                return true;
            }
        }
        catch (NotRegisteredException e) {
            return false;
        }
        return false;
    }

    @Deprecated
    public boolean canAttackEnemy(String a, String b) {
        try {
            Resident residentA = TownyUniverse.getDataSource().getResident(a);
            Resident residentB = TownyUniverse.getDataSource().getResident(b);
            if (residentA.getTown() == residentB.getTown()) {
                return false;
            }
            if (residentA.getTown().getNation() == residentB.getTown().getNation()) {
                return false;
            }
            Nation nationA = residentA.getTown().getNation();
            Nation nationB = residentB.getTown().getNation();
            if (nationA.isNeutral() || nationB.isNeutral()) {
                return false;
            }
            if (nationA.hasEnemy(nationB)) {
                return true;
            }
        }
        catch (NotRegisteredException e) {
            return false;
        }
        return false;
    }

    @Deprecated
    public boolean isEnemy(String a, String b) {
        try {
            Resident residentA = TownyUniverse.getDataSource().getResident(a);
            Resident residentB = TownyUniverse.getDataSource().getResident(b);
            if (residentA.getTown() == residentB.getTown()) {
                return false;
            }
            if (residentA.getTown().getNation() == residentB.getTown().getNation()) {
                return false;
            }
            if (residentA.getTown().getNation().hasEnemy(residentB.getTown().getNation())) {
                return true;
            }
        }
        catch (NotRegisteredException e) {
            return false;
        }
        return false;
    }

    @Deprecated
    public boolean isEnemy(Town a, Town b) {
        try {
            if (a == b) {
                return false;
            }
            if (a.getNation() == b.getNation()) {
                return false;
            }
            if (a.getNation().hasEnemy(b.getNation())) {
                return true;
            }
        }
        catch (NotRegisteredException e) {
            return false;
        }
        return false;
    }

    @Deprecated
    public void newResident(String name) throws AlreadyRegisteredException, NotRegisteredException {
        TownyUniverse.getDataSource().newResident(name);
    }

    @Deprecated
    public void newTown(String name) throws AlreadyRegisteredException, NotRegisteredException {
        TownyUniverse.getDataSource().newTown(name);
    }

    @Deprecated
    public static TownyWorld getTownWorld(String townName) {
        return TownyUniverse.getDataSource().getTownWorld(townName);
    }

    @Deprecated
    public void newNation(String name) throws AlreadyRegisteredException, NotRegisteredException {
        TownyUniverse.getDataSource().newNation(name);
    }

    @Deprecated
    public void newWorld(String name) throws AlreadyRegisteredException, NotRegisteredException {
        TownyUniverse.getDataSource().newWorld(name);
    }

    @Deprecated
    public boolean hasResident(String name) {
        return TownyUniverse.getDataSource().hasResident(name);
    }

    @Deprecated
    public boolean hasTown(String name) {
        return TownyUniverse.getDataSource().hasTown(name);
    }

    @Deprecated
    public boolean hasNation(String name) {
        return TownyUniverse.getDataSource().hasNation(name);
    }

    @Deprecated
    public void renameTown(Town town, String newName) throws AlreadyRegisteredException, NotRegisteredException {
        TownyUniverse.getDataSource().renameTown(town, newName);
    }

    @Deprecated
    public void renameNation(Nation nation, String newName) throws AlreadyRegisteredException, NotRegisteredException {
        TownyUniverse.getDataSource().renameNation(nation, newName);
    }

    @Deprecated
    public Resident getResident(String name) throws NotRegisteredException {
        return TownyUniverse.getDataSource().getResident(name);
    }

    @Deprecated
    public List<Resident> getResidents() {
        return TownyUniverse.getDataSource().getResidents();
    }

    @Deprecated
    public Set<String> getResidentKeys() {
        return TownyUniverse.getDataSource().getResidentKeys();
    }

    @Deprecated
    public Set<String> getTownsKeys() {
        return TownyUniverse.getDataSource().getTownsKeys();
    }

    @Deprecated
    public Set<String> getNationsKeys() {
        return TownyUniverse.getDataSource().getNationsKeys();
    }

    @Deprecated
    public List<Town> getTowns() {
        return TownyUniverse.getDataSource().getTowns();
    }

    @Deprecated
    public List<Nation> getNations() {
        return TownyUniverse.getDataSource().getNations();
    }

    @Deprecated
    public List<TownyWorld> getWorlds() {
        return TownyUniverse.getDataSource().getWorlds();
    }

    @Deprecated
    public List<Town> getTownsWithoutNation() {
        return TownyUniverse.getDataSource().getTownsWithoutNation();
    }

    @Deprecated
    public List<Resident> getResidentsWithoutTown() {
        return TownyUniverse.getDataSource().getResidentsWithoutTown();
    }

    @Deprecated
    public List<Resident> getResidents(String[] names) {
        return TownyUniverse.getDataSource().getResidents(names);
    }

    @Deprecated
    public List<Town> getTowns(String[] names) {
        return TownyUniverse.getDataSource().getTowns(names);
    }

    @Deprecated
    public List<Nation> getNations(String[] names) {
        return TownyUniverse.getDataSource().getNations(names);
    }

    @Deprecated
    public Town getTown(String name) throws NotRegisteredException {
        return TownyUniverse.getDataSource().getTown(name);
    }

    @Deprecated
    public Nation getNation(String name) throws NotRegisteredException {
        return TownyUniverse.getDataSource().getNation(name);
    }

    @Deprecated
    public static TownyWorld getWorld(String name) throws NotRegisteredException {
        return TownyUniverse.getDataSource().getWorld(name);
    }

    @Deprecated
    public void removeWorld(TownyWorld world) throws UnsupportedOperationException {
        TownyUniverse.getDataSource().removeWorld(world);
    }

    @Deprecated
    public void removeNation(Nation nation) {
        TownyUniverse.getDataSource().removeNation(nation);
    }

    @Deprecated
    public void removeTown(Town town) {
        TownyUniverse.getDataSource().removeTown(town);
    }

    @Deprecated
    public void removeResident(Resident resident) {
        TownyUniverse.getDataSource().removeResident(resident);
    }

    @Deprecated
    public void removeResidentList(Resident resident) {
        TownyUniverse.getDataSource().removeResidentList(resident);
    }

    @Deprecated
    public void removeTownBlock(TownBlock townBlock) {
        TownyUniverse.getDataSource().removeTownBlock(townBlock);
    }

    @Deprecated
    public void removeTownBlocks(Town town) {
        TownyUniverse.getDataSource().removeTownBlocks(town);
    }

    @Deprecated
    public List<TownBlock> getAllTownBlocks() {
        return TownyUniverse.getDataSource().getAllTownBlocks();
    }

    @Deprecated
    public List<Resident> getResidents(Player player, String[] names) {
        return TownyUniverse.getDataSource().getResidents(player, names);
    }

    @Deprecated
    public void deleteTownBlockIds(TownBlock townBlock) {
        WorldCoord worldCoord = townBlock.getWorldCoord();
        TownyRegenAPI.addDeleteTownBlockIdQueue(worldCoord);
    }

    @Deprecated
    public String checkAndFilterName(String name) throws InvalidNameException {
        return NameValidation.checkAndFilterPlayerName(name);
    }

    @Deprecated
    public String[] checkAndFilterArray(String[] arr) {
        return NameValidation.checkAndFilterArray(arr);
    }

    public static boolean isTownBlockLocContainedInTownOutposts(List<Location> minecraftcoordinates, TownBlock tb) {
        if (minecraftcoordinates != null && tb != null) {
            for (Location minecraftcoordinate : minecraftcoordinates) {
                if (!Coord.parseCoord(minecraftcoordinate).equals(tb.getCoord())) continue;
                return true;
            }
        }
        return false;
    }
}

