/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyLogger;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.util.BukkitTools;
import org.bukkit.World;

public class TownyEconomyObject
extends TownyObject {
    public static final TownyServerAccount SERVER_ACCOUNT = new TownyServerAccount();

    public boolean pay(double amount, String reason) throws EconomyException {
        if (TownySettings.getBoolean(ConfigNodes.ECO_CLOSED_ECONOMY_ENABLED)) {
            return this.payTo(amount, SERVER_ACCOUNT, reason);
        }
        boolean payed = this._pay(amount);
        if (payed) {
            TownyLogger.logMoneyTransaction(this, amount, null, reason);
        }
        return payed;
    }

    private boolean _pay(double amount) throws EconomyException {
        if (this.canPayFromHoldings(amount) && TownyEconomyHandler.isActive()) {
            if (amount > 0.0) {
                return TownyEconomyHandler.subtract(this.getEconomyName(), amount, this.getBukkitWorld());
            }
            return TownyEconomyHandler.add(this.getEconomyName(), Math.abs(amount), this.getBukkitWorld());
        }
        return false;
    }

    public boolean collect(double amount, String reason) throws EconomyException {
        if (TownySettings.getBoolean(ConfigNodes.ECO_CLOSED_ECONOMY_ENABLED)) {
            return SERVER_ACCOUNT.payTo(amount, this, reason);
        }
        boolean collected = this._collect(amount);
        if (collected) {
            TownyLogger.logMoneyTransaction(null, amount, this, reason);
        }
        return collected;
    }

    private boolean _collect(double amount) throws EconomyException {
        return TownyEconomyHandler.add(this.getEconomyName(), amount, this.getBukkitWorld());
    }

    public boolean payTo(double amount, TownyEconomyObject collector, String reason) throws EconomyException {
        boolean payed = this._payTo(amount, collector);
        if (payed) {
            TownyLogger.logMoneyTransaction(this, amount, collector, reason);
        }
        return payed;
    }

    private boolean _payTo(double amount, TownyEconomyObject collector) throws EconomyException {
        if (this._pay(amount)) {
            if (!collector._collect(amount)) {
                this._collect(amount);
                return false;
            }
            return true;
        }
        return false;
    }

    public String getEconomyName() {
        return this.getName();
    }

    protected World getBukkitWorld() {
        return BukkitTools.getWorlds().get(0);
    }

    public boolean setBalance(double amount, String reason) throws EconomyException {
        double balance = this.getHoldingBalance();
        double diff = amount - balance;
        if (diff > 0.0) {
            return this.collect(diff, reason);
        }
        if (balance > amount) {
            diff = -diff;
            return this.pay(diff, reason);
        }
        return true;
    }

    public double getHoldingBalance() throws EconomyException {
        try {
            return TownyEconomyHandler.getBalance(this.getEconomyName(), this.getBukkitWorld());
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
            throw new EconomyException("Economy error getting holdings for " + this.getEconomyName());
        }
    }

    public boolean canPayFromHoldings(double amount) throws EconomyException {
        return TownyEconomyHandler.hasEnough(this.getEconomyName(), amount, this.getBukkitWorld());
    }

    public String getHoldingFormattedBalance() {
        try {
            return TownyEconomyHandler.getFormattedBalance(this.getHoldingBalance());
        }
        catch (EconomyException e) {
            return "Error Accessing Bank Account";
        }
    }

    public void removeAccount() {
        TownyEconomyHandler.removeAccount(this.getEconomyName());
    }

    private static final class TownyServerAccount
    extends TownyEconomyObject {
        private TownyServerAccount() {
        }

        @Override
        public String getName() {
            return TownySettings.getString(ConfigNodes.ECO_CLOSED_ECONOMY_SERVER_ACCOUNT);
        }
    }
}

