/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.event.PlotChangeOwnerEvent;
import com.palmergames.bukkit.towny.event.PlotChangeTypeEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class TownBlock {
    private TownyWorld world;
    private Town town;
    private Resident resident;
    private TownBlockType type;
    private String name;
    private int x;
    private int z;
    private double plotPrice = -1.0;
    private boolean locked = false;
    private boolean outpost = false;
    protected TownyPermission permissions = new TownyPermission();
    protected boolean isChanged;

    public TownBlock(int x, int z, TownyWorld world) {
        this.x = x;
        this.z = z;
        this.setWorld(world);
        this.resident = null;
        this.type = TownBlockType.RESIDENTIAL;
        this.isChanged = false;
        this.name = "";
    }

    public void setTown(Town town) {
        try {
            if (this.hasTown()) {
                this.town.removeTownBlock(this);
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        this.town = town;
        try {
            town.addTownBlock(this);
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public Town getTown() throws NotRegisteredException {
        if (!this.hasTown()) {
            throw new NotRegisteredException(String.format("The TownBlock at (%s, %d, %d) is not registered to a town.", this.world.getName(), this.x, this.z));
        }
        return this.town;
    }

    public boolean hasTown() {
        return this.town != null;
    }

    public void setResident(Resident resident) {
        boolean successful;
        try {
            if (this.hasResident()) {
                this.resident.removeTownBlock(this);
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        this.resident = resident;
        try {
            resident.addTownBlock(this);
            successful = true;
        }
        catch (AlreadyRegisteredException | NullPointerException e) {
            successful = false;
        }
        if (successful && resident != null) {
            Bukkit.getPluginManager().callEvent((Event)new PlotChangeOwnerEvent(this.resident, resident, this, !Bukkit.getServer().isPrimaryThread()));
        }
        this.resident = resident;
    }

    public Resident getResident() throws NotRegisteredException {
        if (!this.hasResident()) {
            throw new NotRegisteredException(String.format("The TownBlock at (%s, %d, %d) is not registered to a resident.", this.world.getName(), this.x, this.z));
        }
        return this.resident;
    }

    public boolean hasResident() {
        return this.resident != null;
    }

    public boolean isOwner(TownBlockOwner owner) {
        try {
            if (owner == this.getTown()) {
                return true;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        try {
            if (owner == this.getResident()) {
                return true;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        return false;
    }

    public void setPlotPrice(double ForSale) {
        this.plotPrice = ForSale;
    }

    public double getPlotPrice() {
        return this.plotPrice;
    }

    public boolean isForSale() {
        return this.getPlotPrice() != -1.0;
    }

    public void setPermissions(String line) {
        this.permissions.load(line);
    }

    public TownyPermission getPermissions() {
        return this.permissions;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    public boolean isOutpost() {
        return this.outpost;
    }

    public void setOutpost(boolean outpost) {
        this.outpost = outpost;
    }

    public TownBlockType getType() {
        return this.type;
    }

    public void setType(TownBlockType type) {
        if (type != this.type) {
            this.permissions.reset();
        }
        if (type != null) {
            Bukkit.getPluginManager().callEvent((Event)new PlotChangeTypeEvent(this.type, type, this, !Bukkit.getServer().isPrimaryThread()));
        }
        this.type = type;
        switch (type) {
            case RESIDENTIAL: {
                if (this.hasResident()) {
                    this.setPermissions(this.resident.permissions.toString());
                    break;
                }
                this.setPermissions(this.town.permissions.toString());
                break;
            }
            case COMMERCIAL: {
                if (this.hasResident()) {
                    this.setPermissions(this.resident.permissions.toString());
                    break;
                }
                this.setPermissions(this.town.permissions.toString());
                break;
            }
            case ARENA: {
                this.setPermissions("pvp");
                break;
            }
            case EMBASSY: {
                if (this.hasResident()) {
                    this.setPermissions(this.resident.permissions.toString());
                    break;
                }
                this.setPermissions(this.town.permissions.toString());
                break;
            }
            case WILDS: {
                if (this.hasResident()) {
                    this.setPermissions(this.resident.permissions.toString());
                    break;
                }
                this.setPermissions(this.town.permissions.toString());
                break;
            }
            case SPLEEF: {
                this.setPermissions("denyAll");
                break;
            }
            case INN: {
                this.setPermissions("residentSwitch,allySwitch,outsiderSwitch");
                break;
            }
            case JAIL: {
                this.setPermissions("denyAll");
                break;
            }
            case FARM: {
                if (this.hasResident()) {
                    this.setPermissions(this.resident.permissions.toString());
                    break;
                }
                this.setPermissions(this.town.permissions.toString());
                break;
            }
            case BANK: {
                if (this.hasResident()) {
                    this.setPermissions(this.resident.permissions.toString());
                    break;
                }
                this.setPermissions(this.town.permissions.toString());
            }
        }
        this.setChanged(false);
    }

    public void setType(int typeId) {
        this.setType(TownBlockType.lookup(typeId));
    }

    public void setType(String typeName) throws TownyException {
        TownBlockType type;
        if (typeName.equalsIgnoreCase("reset")) {
            typeName = "default";
        }
        if ((type = TownBlockType.lookup(typeName)) == null) {
            throw new TownyException(TownySettings.getLangString("msg_err_not_block_type"));
        }
        if (this.isJail()) {
            this.getTown().removeJailSpawn(this.getCoord());
        }
        this.setType(type);
    }

    public boolean isHomeBlock() {
        try {
            return this.getTown().isHomeBlock(this);
        }
        catch (NotRegisteredException e) {
            return false;
        }
    }

    public void setName(String newName) {
        this.name = newName.replace("_", " ");
    }

    public String getName() {
        return this.name;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getX() {
        return this.x;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public int getZ() {
        return this.z;
    }

    public Coord getCoord() {
        return new Coord(this.x, this.z);
    }

    public WorldCoord getWorldCoord() {
        return new WorldCoord(this.world.getName(), this.x, this.z);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setWorld(TownyWorld world) {
        this.world = world;
    }

    public TownyWorld getWorld() {
        return this.world;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TownBlock)) {
            return false;
        }
        TownBlock o = (TownBlock)obj;
        return this.getX() == o.getX() && this.getZ() == o.getZ() && this.getWorld() == o.getWorld();
    }

    public void clear() {
        this.setTown(null);
        this.setResident(null);
        this.setWorld(null);
    }

    public String toString() {
        return this.getWorld().getName() + " (" + this.getCoord() + ")";
    }

    public boolean isWarZone() {
        return this.getWorld().isWarZone(this.getCoord());
    }

    public boolean isJail() {
        return this.getType() == TownBlockType.JAIL;
    }
}

