/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.regen.block.BlockLocation;
import com.palmergames.bukkit.towny.tasks.ProtectionRegenTask;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import com.palmergames.bukkit.towny.war.eventwar.War;
import com.palmergames.bukkit.towny.war.flagwar.TownyWar;
import com.palmergames.bukkit.towny.war.flagwar.TownyWarConfig;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.plugin.Plugin;

public class TownyBlockListener
implements Listener {
    private final Towny plugin;

    public TownyBlockListener(Towny instance) {
        this.plugin = instance;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Block block;
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        Player player = event.getPlayer();
        boolean bDestroy = PlayerCacheUtil.getCachePermission(player, (block = event.getBlock()).getLocation(), block.getType(), TownyPermission.ActionType.DESTROY);
        if (bDestroy) {
            return;
        }
        PlayerCache cache = this.plugin.getCache(player);
        boolean playerNeutral = false;
        if (TownyUniverse.isWarTime()) {
            try {
                Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                if (resident.isJailed()) {
                    playerNeutral = true;
                }
                if (resident.hasTown() && !War.isWarringTown(resident.getTown())) {
                    playerNeutral = true;
                }
            }
            catch (NotRegisteredException resident) {
                // empty catch block
            }
        }
        try {
            if (cache.getStatus() == PlayerCache.TownBlockStatus.WARZONE || TownyUniverse.isWarTime() && cache.getStatus() == PlayerCache.TownBlockStatus.ENEMY && !playerNeutral && War.isWarringTown(cache.getLastTownBlock().getTownBlock().getTown())) {
                if (!TownyWarConfig.isEditableMaterialInWarZone(block.getType())) {
                    event.setCancelled(true);
                    TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_warzone_cannot_edit_material"), "destroy", block.getType().toString().toLowerCase()));
                }
                return;
            }
        }
        catch (NotRegisteredException e) {
            e.printStackTrace();
        }
        event.setCancelled(true);
        if (cache.hasBlockErrMsg() && event.isCancelled()) {
            TownyMessaging.sendErrorMsg((Object)player, cache.getBlockErrMsg());
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlock();
        try {
            TownyWorld world = TownyUniverse.getDataSource().getWorld(block.getWorld().getName());
            WorldCoord worldCoord = new WorldCoord(world.getName(), Coord.parseCoord(block));
            boolean bBuild = PlayerCacheUtil.getCachePermission(player, block.getLocation(), block.getType(), TownyPermission.ActionType.BUILD);
            if (bBuild) {
                return;
            }
            PlayerCache cache = this.plugin.getCache(player);
            PlayerCache.TownBlockStatus status = cache.getStatus();
            boolean playerNeutral = false;
            if (TownyUniverse.isWarTime()) {
                try {
                    Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                    if (resident.isJailed()) {
                        playerNeutral = true;
                    }
                    if (resident.hasTown() && !War.isWarringTown(resident.getTown())) {
                        playerNeutral = true;
                    }
                }
                catch (NotRegisteredException resident) {
                    // empty catch block
                }
            }
            if (status == PlayerCache.TownBlockStatus.ENEMY && TownyWarConfig.isAllowingAttacks() && event.getBlock().getType() == TownyWarConfig.getFlagBaseMaterial()) {
                try {
                    if (TownyWar.callAttackCellEvent(this.plugin, player, block, worldCoord)) {
                        return;
                    }
                }
                catch (TownyException e) {
                    TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                }
                event.setBuild(false);
                event.setCancelled(true);
            } else {
                if (status == PlayerCache.TownBlockStatus.WARZONE || TownyUniverse.isWarTime() && cache.getStatus() == PlayerCache.TownBlockStatus.ENEMY && !playerNeutral && War.isWarringTown(cache.getLastTownBlock().getTownBlock().getTown())) {
                    if (!TownyWarConfig.isEditableMaterialInWarZone(block.getType())) {
                        event.setBuild(false);
                        event.setCancelled(true);
                        TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_warzone_cannot_edit_material"), "build", block.getType().toString().toLowerCase()));
                    }
                    return;
                }
                event.setBuild(false);
                event.setCancelled(true);
            }
            if (cache.hasBlockErrMsg() && event.isCancelled()) {
                TownyMessaging.sendErrorMsg((Object)player, cache.getBlockErrMsg());
            }
        }
        catch (NotRegisteredException e1) {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_not_configured"));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (this.onBurn(event.getBlock())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockIgnite(BlockIgniteEvent event) {
        if (event.isCancelled() || this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (this.onBurn(event.getBlock())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        List blocks = event.getBlocks();
        if (this.testBlockMove(event.getBlock(), event.getDirection(), true)) {
            event.setCancelled(true);
        }
        if (!blocks.isEmpty()) {
            for (Block block : blocks) {
                if (!this.testBlockMove(block, event.getDirection(), false)) continue;
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        List blocks;
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (this.testBlockMove(event.getBlock(), event.getDirection(), false)) {
            event.setCancelled(true);
        }
        if (!(blocks = event.getBlocks()).isEmpty()) {
            for (Block block : blocks) {
                if (!this.testBlockMove(block, event.getDirection(), false)) continue;
                event.setCancelled(true);
            }
        }
    }

    private boolean testBlockMove(Block block, BlockFace direction, boolean pistonBlock) {
        Block blockTo = null;
        blockTo = !pistonBlock ? block.getRelative(direction) : block.getRelative(direction.getOppositeFace());
        Location loc = block.getLocation();
        Location locTo = blockTo.getLocation();
        Coord coord = Coord.parseCoord(loc);
        Coord coordTo = Coord.parseCoord(locTo);
        TownyWorld townyWorld = null;
        TownBlock currentTownBlock = null;
        TownBlock destinationTownBlock = null;
        try {
            townyWorld = TownyUniverse.getDataSource().getWorld(loc.getWorld().getName());
            currentTownBlock = townyWorld.getTownBlock(coord);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        try {
            destinationTownBlock = townyWorld.getTownBlock(coordTo);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        if (currentTownBlock != destinationTownBlock) {
            if (currentTownBlock == null && destinationTownBlock != null || currentTownBlock != null && destinationTownBlock == null) {
                return true;
            }
            if (!currentTownBlock.hasResident() && !destinationTownBlock.hasResident()) {
                return false;
            }
            try {
                if (!currentTownBlock.hasResident() && destinationTownBlock.hasResident() || currentTownBlock.hasResident() && !destinationTownBlock.hasResident() || currentTownBlock.getResident() != destinationTownBlock.getResident() || currentTownBlock.getPlotPrice() != -1.0 || destinationTownBlock.getPlotPrice() != -1.0) {
                    return true;
                }
            }
            catch (NotRegisteredException e) {
                return true;
            }
        }
        return false;
    }

    private boolean onBurn(Block block) {
        Location loc = block.getLocation();
        Coord coord = Coord.parseCoord(loc);
        try {
            TownyWorld townyWorld = TownyUniverse.getDataSource().getWorld(loc.getWorld().getName());
            if (!townyWorld.isUsingTowny()) {
                return false;
            }
            TownBlock townBlock = TownyUniverse.getTownBlock(loc);
            if (block.getRelative(BlockFace.DOWN).getType() != Material.OBSIDIAN && townBlock == null && !townyWorld.isForceFire() && !townyWorld.isFire()) {
                TownyMessaging.sendDebugMsg("onBlockIgnite: Canceled " + block.getType().name() + " from igniting within " + coord.toString() + ".");
                return true;
            }
            try {
                boolean inWarringTown = false;
                if (TownyUniverse.isWarTime() && townyWorld.hasTownBlock(coord) && War.isWarringTown(townBlock.getTown())) {
                    inWarringTown = true;
                }
                if (townyWorld.isWarZone(coord) || TownyUniverse.isWarTime() && inWarringTown) {
                    if (TownyWarConfig.isAllowingFireInWarZone()) {
                        return false;
                    }
                    TownyMessaging.sendDebugMsg("onBlockIgnite: Canceled " + block.getType().name() + " from igniting within " + coord.toString() + ".");
                    return true;
                }
                if (townBlock != null && block.getRelative(BlockFace.DOWN).getType() != Material.OBSIDIAN && (!townBlock.getTown().isFire() && !townyWorld.isForceFire() && !townBlock.getPermissions().fire || TownyUniverse.isWarTime() && TownySettings.isAllowWarBlockGriefing() && !townBlock.getTown().hasNation())) {
                    TownyMessaging.sendDebugMsg("onBlockIgnite: Canceled " + block.getType().name() + " from igniting within " + coord.toString() + ".");
                    return true;
                }
            }
            catch (TownyException x) {
                if (!townyWorld.isFire()) {
                    TownyMessaging.sendDebugMsg("onBlockIgnite: Canceled " + block.getType().name() + " from igniting within " + coord.toString() + ".");
                    return true;
                }
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        return false;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onCreateExplosion(BlockExplodeEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        TownyWorld townyWorld = null;
        List blocks = event.blockList();
        int count = 0;
        try {
            townyWorld = TownyUniverse.getDataSource().getWorld(event.getBlock().getLocation().getWorld().getName());
        }
        catch (NotRegisteredException e) {
            e.printStackTrace();
        }
        for (Block block : blocks) {
            ++count;
            if (!this.locationCanExplode(townyWorld, block.getLocation())) {
                event.setCancelled(true);
                return;
            }
            if (!TownyUniverse.isWilderness(block) || !townyWorld.isUsingTowny() || !townyWorld.isExpl() || !townyWorld.isUsingPlotManagementWildRevert() || TownyRegenAPI.hasProtectionRegenTask(new BlockLocation(block.getLocation())) || block.getType() == Material.TNT) continue;
            ProtectionRegenTask task = new ProtectionRegenTask(this.plugin, block);
            task.setTaskId(this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)task, (TownySettings.getPlotManagementWildRegenDelay() + (long)count) * 20L));
            TownyRegenAPI.addProtectionRegenTask(task);
            event.setYield(0.0f);
            block.getDrops().clear();
        }
    }

    public boolean locationCanExplode(TownyWorld world, Location target) {
        boolean isNeutral;
        TownBlock townBlock;
        block10: {
            Coord coord = Coord.parseCoord(target);
            if (world.isWarZone(coord) && !TownyWarConfig.isAllowingExplosionsInWarZone()) {
                return false;
            }
            townBlock = null;
            isNeutral = false;
            try {
                townBlock = world.getTownBlock(coord);
                if (townBlock.hasTown() && !War.isWarZone(townBlock.getWorldCoord())) {
                    isNeutral = true;
                }
            }
            catch (NotRegisteredException e1) {
                if (!TownyUniverse.isWilderness(target.getBlock())) break block10;
                boolean bl = isNeutral = !world.isExpl();
                if (!world.isExpl() && !TownyUniverse.isWarTime()) {
                    return false;
                }
                if (!world.isExpl() || TownyUniverse.isWarTime()) break block10;
                return true;
            }
        }
        try {
            if (world.isUsingTowny() && !world.isForceExpl()) {
                if (TownyUniverse.isWarTime() && TownyWarConfig.explosionsBreakBlocksInWarZone() && !isNeutral) {
                    return true;
                }
                if (!townBlock.getPermissions().explosion || TownyUniverse.isWarTime() && TownyWarConfig.isAllowingExplosionsInWarZone() && !townBlock.getTown().hasNation() && !townBlock.getTown().isBANG()) {
                    return false;
                }
            }
        }
        catch (NotRegisteredException e) {
            return world.isExpl();
        }
        return true;
    }
}

