/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.invites;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.command.NationCommand;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.invites.Invite;
import com.palmergames.bukkit.towny.invites.TownyAllySender;
import com.palmergames.bukkit.towny.invites.TownyInviteReceiver;
import com.palmergames.bukkit.towny.invites.TownyInviteSender;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.inviteobjects.NationAllyNationInvite;
import com.palmergames.bukkit.towny.object.inviteobjects.PlayerJoinTownInvite;
import com.palmergames.bukkit.towny.object.inviteobjects.TownJoinNationInvite;
import com.palmergames.bukkit.util.ChatTools;
import java.io.InvalidObjectException;
import java.util.ArrayList;
import java.util.List;

public class InviteHandler {
    private static Towny plugin;
    private static ListMultimap<Town, Resident> towntoresidentinvites;
    private static ListMultimap<Nation, Town> nationtotowninvites;
    private static ListMultimap<Nation, Nation> nationtonationinvites;

    public static void initialize(Towny plugin) {
        InviteHandler.plugin = plugin;
    }

    public static void acceptInvite(Invite invite) throws InvalidObjectException, TownyException {
        TownyInviteSender sender = invite.getSender();
        TownyInviteReceiver receiver = invite.getReceiver();
        if (receiver instanceof Resident && sender instanceof Town) {
            Resident resident = (Resident)invite.getReceiver();
            Town town = (Town)invite.getSender();
            TownCommand.townAddResident(town, resident);
            TownyMessaging.sendTownMessage(town, ChatTools.color(String.format(TownySettings.getLangString("msg_join_town"), resident.getName())));
            InviteHandler.getTowntoresidentinvites().remove((Object)town, (Object)resident);
            resident.deleteReceivedInvite(invite);
            town.deleteSentInvite(invite);
            return;
        }
        if (receiver instanceof Town && sender instanceof Nation) {
            Town town = (Town)invite.getReceiver();
            ArrayList<Town> towns = new ArrayList<Town>();
            towns.add(town);
            Nation nation = (Nation)invite.getSender();
            NationCommand.nationAdd(nation, towns);
            InviteHandler.getNationtotowninvites().remove((Object)nation, (Object)town);
            town.deleteReceivedInvite(invite);
            nation.deleteSentInvite(invite);
            return;
        }
        if (receiver instanceof Nation && sender instanceof Nation) {
            Nation receivernation = (Nation)invite.getReceiver();
            Nation sendernation = (Nation)invite.getSender();
            receivernation.addAlly(sendernation);
            sendernation.addAlly(receivernation);
            TownyMessaging.sendNationMessage(receivernation, String.format(TownySettings.getLangString("msg_added_ally"), sendernation.getName()));
            TownyMessaging.sendNationMessage(sendernation, String.format(TownySettings.getLangString("msg_accept_ally"), receivernation.getName()));
            InviteHandler.getNationtonationinvites().remove((Object)sendernation, (Object)receivernation);
            receivernation.deleteReceivedInvite(invite);
            sendernation.deleteSentAllyInvite(invite);
            return;
        }
        throw new InvalidObjectException("Invite not valid!");
    }

    public static void declineInvite(Invite invite, boolean fromSender) throws InvalidObjectException {
        TownyInviteSender sender = invite.getSender();
        TownyInviteReceiver receiver = invite.getReceiver();
        if (receiver instanceof Resident && sender instanceof Town) {
            Resident resident = (Resident)invite.getReceiver();
            Town town = (Town)invite.getSender();
            InviteHandler.getTowntoresidentinvites().remove((Object)town, (Object)resident);
            resident.deleteReceivedInvite(invite);
            town.deleteSentInvite(invite);
            if (!fromSender) {
                TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_deny_invite"), resident.getName()));
                TownyMessaging.sendMessage((Object)invite.getReceiver(), TownySettings.getLangString("successful_deny"));
            } else {
                TownyMessaging.sendMessage((Object)resident, String.format(TownySettings.getLangString("town_revoke_invite"), town.getName()));
            }
            return;
        }
        if (receiver instanceof Town && sender instanceof Nation) {
            Town town = (Town)invite.getReceiver();
            Nation nation = (Nation)invite.getSender();
            InviteHandler.getNationtotowninvites().remove((Object)nation, (Object)town);
            town.deleteReceivedInvite(invite);
            nation.deleteSentInvite(invite);
            if (!fromSender) {
                TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_deny_invite"), town.getName()));
            } else {
                TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("nation_revoke_invite"), nation.getName()));
            }
            return;
        }
        if (receiver instanceof Nation && sender instanceof Nation) {
            Nation receivernation = (Nation)invite.getReceiver();
            Nation sendernation = (Nation)invite.getSender();
            InviteHandler.getNationtonationinvites().remove((Object)sendernation, (Object)receivernation);
            receivernation.deleteReceivedInvite(invite);
            sendernation.deleteSentAllyInvite(invite);
            if (!fromSender) {
                TownyMessaging.sendNationMessage(sendernation, String.format(TownySettings.getLangString("msg_deny_ally"), TownySettings.getLangString("nation_sing") + ": " + receivernation.getName()));
            } else {
                TownyMessaging.sendNationMessage(receivernation, String.format(TownySettings.getLangString("nation_revoke_ally"), sendernation.getName()));
            }
            return;
        }
        throw new InvalidObjectException("Invite not valid!");
    }

    public static ListMultimap<Nation, Nation> getNationtonationinvites() {
        return nationtonationinvites;
    }

    public static ListMultimap<Nation, Town> getNationtotowninvites() {
        return nationtotowninvites;
    }

    public static ListMultimap<Town, Resident> getTowntoresidentinvites() {
        return towntoresidentinvites;
    }

    public static void addInviteToList(PlayerJoinTownInvite invite) {
        towntoresidentinvites.put((Object)((Town)invite.getSender()), (Object)((Resident)invite.getReceiver()));
    }

    public static void addInviteToList(TownJoinNationInvite invite) {
        nationtotowninvites.put((Object)((Nation)invite.getSender()), (Object)((Town)invite.getReceiver()));
    }

    public static void addInviteToList(NationAllyNationInvite invite) {
        nationtonationinvites.put((Object)((Nation)invite.getSender()), (Object)((Nation)invite.getReceiver()));
    }

    public static int getReceivedInvitesAmount(TownyInviteReceiver receiver) {
        List<Invite> invites = receiver.getReceivedInvites();
        return invites.size();
    }

    public static int getSentInvitesAmount(TownyInviteSender sender) {
        List<Invite> invites = sender.getSentInvites();
        return invites.size();
    }

    public static int getSentAllyRequestsAmount(TownyAllySender sender) {
        List<Invite> invites = sender.getSentAllyInvites();
        return invites.size();
    }

    public static int getSentAllyRequestsMaxAmount(TownyAllySender sender) {
        int amount = 0;
        if (sender instanceof Nation) {
            amount = TownySettings.getMaximumRequestsSentNation() == 0 ? 100 : TownySettings.getMaximumRequestsSentNation();
        }
        return amount;
    }

    public static int getReceivedInvitesMaxAmount(TownyInviteReceiver receiver) {
        int amount = 0;
        if (receiver instanceof Resident) {
            amount = TownySettings.getMaximumInvitesReceivedResident() == 0 ? 100 : TownySettings.getMaximumInvitesReceivedResident();
        }
        if (receiver instanceof Town) {
            amount = TownySettings.getMaximumInvitesReceivedTown() == 0 ? 100 : TownySettings.getMaximumInvitesReceivedTown();
        }
        if (receiver instanceof Nation) {
            amount = TownySettings.getMaximumRequestsReceivedNation() == 0 ? 100 : TownySettings.getMaximumRequestsReceivedNation();
        }
        return amount;
    }

    public static int getSentInvitesMaxAmount(TownyInviteSender sender) {
        int amount = 0;
        if (sender instanceof Town) {
            amount = TownySettings.getMaximumInvitesSentTown() == 0 ? 100 : TownySettings.getMaximumInvitesSentTown();
        }
        if (sender instanceof Nation) {
            amount = TownySettings.getMaximumInvitesSentNation() == 0 ? 100 : TownySettings.getMaximumInvitesSentNation();
        }
        return amount;
    }

    static {
        towntoresidentinvites = ArrayListMultimap.create();
        nationtotowninvites = ArrayListMultimap.create();
        nationtonationinvites = ArrayListMultimap.create();
    }
}

