/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.db;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyLogger;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.db.SQL_Schema;
import com.palmergames.bukkit.towny.db.SQL_Task;
import com.palmergames.bukkit.towny.db.TownyFlatFileSource;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.FileMgmt;
import com.palmergames.util.StringMgmt;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class TownySQLSource
extends TownyFlatFileSource {
    private Queue<SQL_Task> queryQueue = new ConcurrentLinkedQueue<SQL_Task>();
    private BukkitTask task = null;
    protected String driver = "";
    protected String dsn = "";
    protected String hostname = "";
    protected String port = "";
    protected String db_name = "";
    protected String username = "";
    protected String password = "";
    protected String tb_prefix = "";
    private Connection cntx = null;
    private String type = "";

    public TownySQLSource(String type) {
        this.type = type.toLowerCase();
    }

    @Override
    public void initialize(Towny plugin, TownyUniverse universe) {
        this.universe = universe;
        this.plugin = plugin;
        this.rootFolder = universe.getRootFolder();
        try {
            FileMgmt.checkFolders(new String[]{this.rootFolder, this.rootFolder + this.dataFolder, this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "plot-block-data"});
            FileMgmt.checkFiles(new String[]{this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "regen.txt", this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "snapshot_queue.txt"});
        }
        catch (IOException e) {
            TownyMessaging.sendErrorMsg("Could not create flatfile default files and folders.");
        }
        this.hostname = TownySettings.getSQLHostName();
        this.port = TownySettings.getSQLPort();
        this.db_name = TownySettings.getSQLDBName();
        this.tb_prefix = TownySettings.getSQLTablePrefix().toUpperCase();
        if (this.type.equals("h2")) {
            this.driver = "org.h2.Driver";
            this.dsn = "jdbc:h2:" + this.rootFolder + this.dataFolder + File.separator + this.db_name + ".h2db;AUTO_RECONNECT=TRUE";
            this.username = "sa";
            this.password = "sa";
        } else if (this.type.equals("mysql")) {
            this.driver = "com.mysql.jdbc.Driver";
            this.dsn = TownySettings.getSQLUsingSSL() ? "jdbc:mysql://" + this.hostname + ":" + this.port + "/" + this.db_name + "?useUnicode=true&characterEncoding=utf-8" : "jdbc:mysql://" + this.hostname + ":" + this.port + "/" + this.db_name + "?verifyServerCertificate=false&useSSL=false&useUnicode=true&characterEncoding=utf-8";
            this.username = TownySettings.getSQLUsername();
            this.password = TownySettings.getSQLPassword();
        } else {
            this.driver = "org.sqlite.JDBC";
            this.dsn = "jdbc:sqlite:" + this.rootFolder + this.dataFolder + File.separator + this.db_name + ".sqldb";
            this.username = "";
            this.password = "";
        }
        try {
            Driver driver = (Driver)Class.forName(this.driver).newInstance();
            DriverManager.registerDriver(driver);
        }
        catch (Exception e) {
            System.out.println("[Towny] Driver error: " + e);
        }
        if (!this.getContext()) {
            TownyMessaging.sendErrorMsg("Failed when connecting to Database");
            return;
        }
        TownyMessaging.sendDebugMsg("[Towny] Connected to Database");
        SQL_Schema.initTables(this.cntx, this.db_name);
        this.task = BukkitTools.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, () -> {
            while (!this.queryQueue.isEmpty()) {
                SQL_Task query = this.queryQueue.poll();
                if (query.update) {
                    this.QueueUpdateDB(query.tb_name, query.args, query.keys);
                    continue;
                }
                this.QueueDeleteDB(query.tb_name, query.args);
            }
        }, 5L, 5L);
    }

    @Override
    public void cancelTask() {
        this.task.cancel();
    }

    public boolean getContext() {
        try {
            if (this.cntx == null || this.cntx.isClosed() || !this.type.equals("sqlite") && !this.cntx.isValid(1)) {
                if (this.cntx != null && !this.cntx.isClosed()) {
                    try {
                        this.cntx.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    this.cntx = null;
                }
                this.cntx = this.username.equalsIgnoreCase("") && this.password.equalsIgnoreCase("") ? DriverManager.getConnection(this.dsn) : DriverManager.getConnection(this.dsn, this.username, this.password);
                if (this.cntx == null || this.cntx.isClosed()) {
                    return false;
                }
            }
            return true;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("Error could not Connect to db " + this.dsn + ": " + e.getMessage());
            return false;
        }
    }

    public boolean UpdateDB(String tb_name, HashMap<String, Object> args, List<String> keys) {
        this.queryQueue.add(new SQL_Task(tb_name, args, keys));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean QueueUpdateDB(String tb_name, HashMap<String, Object> args, List<String> keys) {
        if (!this.getContext()) {
            return false;
        }
        String code = null;
        Statement stmt = null;
        ArrayList<Object> parameters = new ArrayList<Object>();
        int rs = 0;
        try {
            String[] aKeys;
            if (keys == null) {
                parameters.addAll(args.values());
                aKeys = args.keySet().toArray(new String[args.keySet().size()]);
                code = "REPLACE INTO " + this.tb_prefix + tb_name.toUpperCase() + " ";
                String keycode = "(";
                String valuecode = " VALUES (";
                for (int count = 0; count < args.size(); ++count) {
                    keycode = keycode + "`" + aKeys[count] + "`";
                    valuecode = valuecode + "?";
                    if (count < args.size() - 1) {
                        keycode = keycode + ", ";
                        valuecode = valuecode + ",";
                        continue;
                    }
                    keycode = keycode + ")";
                    valuecode = valuecode + ")";
                }
                code = code + keycode;
                code = code + valuecode;
            } else {
                int count;
                aKeys = args.keySet().toArray(new String[args.keySet().size()]);
                code = "UPDATE " + this.tb_prefix + tb_name.toUpperCase() + " SET ";
                for (count = 0; count < args.size(); ++count) {
                    code = code + "`" + aKeys[count] + "` = ?";
                    parameters.add(args.get(aKeys[count]));
                    if (count >= args.size() - 1) continue;
                    code = code + ",";
                }
                code = code + " WHERE ";
                for (count = 0; count < keys.size(); ++count) {
                    code = code + "`" + keys.get(count) + "` = ?";
                    parameters.add(args.get(keys.get(count)));
                    if (count >= keys.size() - 1) continue;
                    code = code + " AND ";
                }
            }
            stmt = this.cntx.prepareStatement(code);
            for (int count = 0; count < parameters.size(); ++count) {
                Object element = parameters.get(count);
                if (element instanceof String) {
                    stmt.setString(count + 1, (String)element);
                    continue;
                }
                if (element instanceof Boolean) {
                    stmt.setString(count + 1, (Boolean)element != false ? "1" : "0");
                    continue;
                }
                stmt.setObject(count + 1, element.toString());
            }
            rs = stmt.executeUpdate();
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: " + e.getMessage() + " --> " + stmt.toString());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (rs == 0) {
                    return this.UpdateDB(tb_name, args, null);
                }
            }
            catch (SQLException e) {
                TownyMessaging.sendErrorMsg("SQL closing: " + e.getMessage() + " --> " + stmt.toString());
            }
        }
        return rs != 0;
    }

    public boolean DeleteDB(String tb_name, HashMap<String, Object> args) {
        this.queryQueue.add(new SQL_Task(tb_name, args));
        return true;
    }

    public boolean QueueDeleteDB(String tb_name, HashMap<String, Object> args) {
        if (!this.getContext()) {
            return false;
        }
        try {
            String wherecode = "DELETE FROM " + this.tb_prefix + tb_name.toUpperCase() + " WHERE ";
            Set<Map.Entry<String, Object>> set = args.entrySet();
            Iterator<Map.Entry<String, Object>> i = set.iterator();
            while (i.hasNext()) {
                Map.Entry<String, Object> me = i.next();
                wherecode = wherecode + "`" + me.getKey() + "` = ";
                wherecode = me.getValue() instanceof String ? wherecode + "'" + ((String)me.getValue()).replace("'", "''") + "'" : (me.getValue() instanceof Boolean ? wherecode + "'" + ((Boolean)me.getValue() != false ? "1" : "0") + "'" : wherecode + "'" + me.getValue() + "'");
                wherecode = wherecode + (i.hasNext() ? " AND " : "");
            }
            Statement s = this.cntx.createStatement();
            int rs = s.executeUpdate(wherecode);
            s.close();
            if (rs == 0) {
                TownyMessaging.sendDebugMsg("SQL: delete returned 0: " + wherecode);
            }
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Error delete : " + e.getMessage());
        }
        return false;
    }

    @Override
    public boolean loadTownBlockList() {
        TownyMessaging.sendDebugMsg("Loading TownBlock List");
        if (!this.getContext()) {
            return false;
        }
        try {
            Statement s = this.cntx.createStatement();
            ResultSet rs = s.executeQuery("SELECT world,x,z FROM " + this.tb_prefix + "TOWNBLOCKS");
            while (rs.next()) {
                TownyWorld world = this.getWorld(rs.getString("world"));
                int x = Integer.parseInt(rs.getString("x"));
                int z = Integer.parseInt(rs.getString("z"));
                try {
                    world.newTownBlock(x, z);
                }
                catch (AlreadyRegisteredException alreadyRegisteredException) {}
            }
            s.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean loadResidentList() {
        TownyMessaging.sendDebugMsg("Loading Resident List");
        if (!this.getContext()) {
            return false;
        }
        try {
            Statement s = this.cntx.createStatement();
            ResultSet rs = s.executeQuery("SELECT name FROM " + this.tb_prefix + "RESIDENTS");
            while (rs.next()) {
                try {
                    this.newResident(rs.getString("name"));
                }
                catch (AlreadyRegisteredException alreadyRegisteredException) {}
            }
            s.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean loadTownList() {
        TownyMessaging.sendDebugMsg("Loading Town List");
        if (!this.getContext()) {
            return false;
        }
        try {
            Statement s = this.cntx.createStatement();
            ResultSet rs = s.executeQuery("SELECT name FROM " + this.tb_prefix + "TOWNS");
            while (rs.next()) {
                try {
                    this.newTown(rs.getString("name"));
                }
                catch (AlreadyRegisteredException alreadyRegisteredException) {}
            }
            s.close();
            return true;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: town list sql error : " + e.getMessage());
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: town list unknown error: ");
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean loadNationList() {
        TownyMessaging.sendDebugMsg("Loading Nation List");
        if (!this.getContext()) {
            return false;
        }
        try {
            Statement s = this.cntx.createStatement();
            ResultSet rs = s.executeQuery("SELECT name FROM " + this.tb_prefix + "NATIONS");
            while (rs.next()) {
                try {
                    this.newNation(rs.getString("name"));
                }
                catch (AlreadyRegisteredException alreadyRegisteredException) {}
            }
            s.close();
            return true;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: nation list sql error : " + e.getMessage());
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: nation list unknown error : ");
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean loadWorldList() {
        TownyMessaging.sendDebugMsg("Loading World List");
        if (!this.getContext()) {
            return false;
        }
        try {
            Statement s = this.cntx.createStatement();
            ResultSet rs = s.executeQuery("SELECT name FROM " + this.tb_prefix + "WORLDS");
            while (rs.next()) {
                try {
                    this.newWorld(rs.getString("name"));
                }
                catch (AlreadyRegisteredException alreadyRegisteredException) {}
            }
            s.close();
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: world list sql error : " + e.getMessage());
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: world list unknown error : ");
            e.printStackTrace();
        }
        if (this.plugin != null) {
            for (World world : this.plugin.getServer().getWorlds()) {
                try {
                    this.newWorld(world.getName());
                }
                catch (AlreadyRegisteredException | NotRegisteredException townyException) {}
            }
        }
        return true;
    }

    @Override
    public boolean loadResident(Resident resident) {
        TownyMessaging.sendDebugMsg("Loading resident " + resident.getName());
        if (!this.getContext()) {
            return false;
        }
        try {
            Statement s = this.cntx.createStatement();
            ResultSet rs = s.executeQuery("SELECT * FROM " + this.tb_prefix + "RESIDENTS  WHERE name='" + resident.getName() + "'");
            if (rs.next()) {
                String search;
                try {
                    resident.setLastOnline(rs.getLong("lastOnline"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    resident.setRegistered(rs.getLong("registered"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    resident.setNPC(rs.getBoolean("isNPC"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    resident.setJailed(rs.getBoolean("isJailed"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    resident.setJailSpawn(rs.getInt("JailSpawn"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    resident.setJailTown(rs.getString("JailTown"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    resident.setTitle(rs.getString("title"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    resident.setSurname(rs.getString("surname"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String line = rs.getString("town");
                if (line != null && !line.isEmpty()) {
                    resident.setTown(this.getTown(line));
                    TownyMessaging.sendDebugMsg("Resident " + resident.getName() + " set to Town " + line);
                }
                if ((line = rs.getString("town-ranks")) != null && !line.isEmpty()) {
                    search = line.contains("#") ? "#" : ",";
                    resident.setTownRanks(new ArrayList<String>(Arrays.asList(line.split(search))));
                    TownyMessaging.sendDebugMsg("Resident " + resident.getName() + " set Town-ranks " + line);
                }
                if ((line = rs.getString("nation-ranks")) != null && !line.isEmpty()) {
                    search = line.contains("#") ? "#" : ",";
                    resident.setNationRanks(new ArrayList<String>(Arrays.asList(line.split(search))));
                    TownyMessaging.sendDebugMsg("Resident " + resident.getName() + " set Nation-ranks " + line);
                }
                try {
                    line = rs.getString("friends");
                    if (line != null) {
                        String[] tokens;
                        search = line.contains("#") ? "#" : ",";
                        for (String token : tokens = line.split(search)) {
                            Resident friend;
                            if (token.isEmpty() || (friend = this.getResident(token)) == null) continue;
                            resident.addFriend(friend);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    resident.setPermissions(rs.getString("protectionStatus").replaceAll("#", ","));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    line = rs.getString("townBlocks");
                    if (line != null && !line.isEmpty()) {
                        this.utilLoadTownBlocks(line, null, resident);
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                s.close();
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Load resident sql error : " + e.getMessage());
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Load resident unknown error");
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean loadTown(Town town) {
        TownyMessaging.sendDebugMsg("Loading town " + town.getName());
        if (!this.getContext()) {
            return false;
        }
        try {
            Statement s = this.cntx.createStatement();
            ResultSet rs = s.executeQuery("SELECT * FROM " + this.tb_prefix + "TOWNS  WHERE name='" + town.getName() + "'");
            if (rs.next()) {
                Location loc;
                double z;
                double y;
                double x;
                String spawn;
                int n;
                TownyWorld world;
                Resident resident;
                String[] tokens;
                String search;
                String line = rs.getString("residents");
                if (line != null) {
                    search = line.contains("#") ? "#" : ",";
                    for (String token : tokens = line.split(search)) {
                        if (token.isEmpty() || (resident = this.getResident(token)) == null) continue;
                        town.addResident(resident);
                    }
                }
                town.setMayor(this.getResident(rs.getString("mayor")));
                town.setTownBoard(rs.getString("townBoard"));
                line = rs.getString("tag");
                if (line != null) {
                    try {
                        town.setTag(line);
                    }
                    catch (TownyException e) {
                        town.setTag("");
                    }
                }
                town.setPermissions(rs.getString("protectionStatus").replaceAll("#", ","));
                town.setBonusBlocks(rs.getInt("bonus"));
                town.setTaxPercentage(rs.getBoolean("taxpercent"));
                town.setTaxes(rs.getFloat("taxes"));
                town.setHasUpkeep(rs.getBoolean("hasUpkeep"));
                town.setPlotPrice(rs.getFloat("plotPrice"));
                town.setPlotTax(rs.getFloat("plotTax"));
                town.setEmbassyPlotPrice(rs.getFloat("embassyPlotPrice"));
                town.setEmbassyPlotTax(rs.getFloat("embassyPlotTax"));
                town.setCommercialPlotPrice(rs.getFloat("commercialPlotPrice"));
                town.setCommercialPlotTax(rs.getFloat("commercialPlotTax"));
                town.setSpawnCost(rs.getFloat("spawnCost"));
                town.setOpen(rs.getBoolean("open"));
                town.setPublic(rs.getBoolean("public"));
                town.setAdminDisabledPVP(rs.getBoolean("admindisabledpvp"));
                town.setPurchasedBlocks(rs.getInt("purchased"));
                line = rs.getString("homeBlock");
                if (line != null && (tokens = line.split(search = line.contains("#") ? "#" : ",")).length == 3) {
                    try {
                        world = this.getWorld(tokens[0]);
                        try {
                            int x2 = Integer.parseInt(tokens[1]);
                            int z2 = Integer.parseInt(tokens[2]);
                            TownBlock homeBlock = world.getTownBlock(x2, z2);
                            town.forceSetHomeBlock(homeBlock);
                        }
                        catch (NumberFormatException e) {
                            TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " homeBlock tried to load invalid location.");
                        }
                        catch (NotRegisteredException e) {
                            TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " homeBlock tried to load invalid TownBlock.");
                        }
                        catch (TownyException e) {
                            TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " does not have a home block.");
                        }
                    }
                    catch (NotRegisteredException e) {
                        TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " homeBlock tried to load invalid world.");
                    }
                }
                if ((line = rs.getString("spawn")) != null && (tokens = line.split(search = line.contains("#") ? "#" : ",")).length >= 4) {
                    try {
                        world = this.plugin.getServerWorld(tokens[0]);
                        double x3 = Double.parseDouble(tokens[1]);
                        double y2 = Double.parseDouble(tokens[2]);
                        double z3 = Double.parseDouble(tokens[3]);
                        Location loc2 = new Location((World)world, x3, y2, z3);
                        if (tokens.length == 6) {
                            loc2.setPitch(Float.parseFloat(tokens[4]));
                            loc2.setYaw(Float.parseFloat(tokens[5]));
                        }
                        town.forceSetSpawn(loc2);
                    }
                    catch (NotRegisteredException | NullPointerException | NumberFormatException world2) {
                        // empty catch block
                    }
                }
                if ((line = rs.getString("outpostSpawns")) != null) {
                    String[] outposts;
                    String[] stringArray = outposts = line.split(";");
                    n = stringArray.length;
                    for (int y2 = 0; y2 < n; ++y2) {
                        spawn = stringArray[y2];
                        search = line.contains("#") ? "#" : ",";
                        tokens = spawn.split(search);
                        if (tokens.length < 4) continue;
                        try {
                            World world3 = this.plugin.getServerWorld(tokens[0]);
                            x = Double.parseDouble(tokens[1]);
                            y = Double.parseDouble(tokens[2]);
                            z = Double.parseDouble(tokens[3]);
                            loc = new Location(world3, x, y, z);
                            if (tokens.length == 6) {
                                loc.setPitch(Float.parseFloat(tokens[4]));
                                loc.setYaw(Float.parseFloat(tokens[5]));
                            }
                            town.forceAddOutpostSpawn(loc);
                            continue;
                        }
                        catch (NotRegisteredException | NullPointerException | NumberFormatException world3) {
                            // empty catch block
                        }
                    }
                }
                if ((line = rs.getString("jailSpawns")) != null) {
                    String[] jails;
                    String[] stringArray = jails = line.split(";");
                    n = stringArray.length;
                    for (int y2 = 0; y2 < n; ++y2) {
                        spawn = stringArray[y2];
                        search = line.contains("#") ? "#" : ",";
                        tokens = spawn.split(search);
                        if (tokens.length < 4) continue;
                        try {
                            World world4 = this.plugin.getServerWorld(tokens[0]);
                            x = Double.parseDouble(tokens[1]);
                            y = Double.parseDouble(tokens[2]);
                            z = Double.parseDouble(tokens[3]);
                            loc = new Location(world4, x, y, z);
                            if (tokens.length == 6) {
                                loc.setPitch(Float.parseFloat(tokens[4]));
                                loc.setYaw(Float.parseFloat(tokens[5]));
                            }
                            town.forceAddJailSpawn(loc);
                            continue;
                        }
                        catch (NotRegisteredException | NullPointerException | NumberFormatException exception) {
                            // empty catch block
                        }
                    }
                }
                if ((line = rs.getString("outlaws")) != null) {
                    search = line.contains("#") ? "#" : ",";
                    for (String token : tokens = line.split(search)) {
                        if (token.isEmpty() || (resident = this.getResident(token)) == null) continue;
                        town.addOutlaw(resident);
                    }
                }
                try {
                    town.setUuid(UUID.fromString(rs.getString("uuid")));
                }
                catch (IllegalArgumentException | NullPointerException ee) {
                    town.setUuid(UUID.randomUUID());
                }
                try {
                    line = rs.getString("townBlocks");
                    if (line != null) {
                        this.utilLoadTownBlocks(line, town, null);
                    }
                }
                catch (SQLException ee) {
                    // empty catch block
                }
                try {
                    line = rs.getString("registered");
                    if (line != null) {
                        town.setRegistered(Long.valueOf(line));
                    } else {
                        town.setRegistered(0L);
                    }
                }
                catch (SQLException ee) {
                }
                catch (NullPointerException | NumberFormatException e) {
                    town.setRegistered(0L);
                }
                s.close();
                return true;
            }
            s.close();
            return false;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Load Town sql Error - " + e.getMessage());
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Load Town unknown Error - ");
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean loadNation(Nation nation) {
        String line = "";
        TownyMessaging.sendDebugMsg("Loading nation " + nation.getName());
        if (!this.getContext()) {
            return false;
        }
        try {
            Statement s = this.cntx.createStatement();
            ResultSet rs = s.executeQuery("SELECT * FROM " + this.tb_prefix + "NATIONS WHERE name='" + nation.getName() + "'");
            while (rs.next()) {
                String[] tokens;
                String search;
                line = rs.getString("towns");
                if (line != null) {
                    search = line.contains("#") ? "#" : ",";
                    for (String token : tokens = line.split(search)) {
                        Town town;
                        if (token.isEmpty() || (town = this.getTown(token)) == null) continue;
                        nation.addTown(town);
                    }
                }
                nation.setCapital(this.getTown(rs.getString("capital")));
                line = rs.getString("nationBoard");
                if (line != null) {
                    nation.setNationBoard(rs.getString("nationBoard"));
                } else {
                    nation.setNationBoard("");
                }
                nation.setTag(rs.getString("tag"));
                line = rs.getString("allies");
                if (line != null) {
                    search = line.contains("#") ? "#" : ",";
                    for (String token : tokens = line.split(search)) {
                        Nation friend;
                        if (token.isEmpty() || (friend = this.getNation(token)) == null) continue;
                        nation.addAlly(friend);
                    }
                }
                if ((line = rs.getString("enemies")) != null) {
                    search = line.contains("#") ? "#" : ",";
                    for (String token : tokens = line.split(search)) {
                        Nation enemy;
                        if (token.isEmpty() || (enemy = this.getNation(token)) == null) continue;
                        nation.addEnemy(enemy);
                    }
                }
                nation.setTaxes(rs.getDouble("taxes"));
                nation.setSpawnCost(rs.getFloat("spawnCost"));
                nation.setNeutral(rs.getBoolean("neutral"));
                try {
                    nation.setUuid(UUID.fromString(rs.getString("uuid")));
                }
                catch (IllegalArgumentException | NullPointerException ee) {
                    nation.setUuid(UUID.randomUUID());
                }
                line = rs.getString("nationSpawn");
                if (line != null && (tokens = line.split(search = line.contains("#") ? "#" : ",")).length >= 4) {
                    try {
                        World world = this.plugin.getServerWorld(tokens[0]);
                        double x = Double.parseDouble(tokens[1]);
                        double y = Double.parseDouble(tokens[2]);
                        double z = Double.parseDouble(tokens[3]);
                        Location loc = new Location(world, x, y, z);
                        if (tokens.length == 6) {
                            loc.setPitch(Float.parseFloat(tokens[4]));
                            loc.setYaw(Float.parseFloat(tokens[5]));
                        }
                        nation.forceSetNationSpawn(loc);
                    }
                    catch (NotRegisteredException | NullPointerException | NumberFormatException world) {
                        // empty catch block
                    }
                }
                nation.setPublic(rs.getBoolean("isPublic"));
            }
            try {
                line = rs.getString("registered");
                if (line != null) {
                    nation.setRegistered(Long.valueOf(line));
                } else {
                    nation.setRegistered(0L);
                }
            }
            catch (SQLException world) {
            }
            catch (NullPointerException | NumberFormatException e) {
                nation.setRegistered(0L);
            }
            s.close();
            return true;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Load Nation sql error " + e.getMessage());
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Load Nation unknown error - ");
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean loadWorld(TownyWorld world) {
        String line = "";
        Boolean result = false;
        TownyMessaging.sendDebugMsg("Loading world " + world.getName());
        if (!this.getContext()) {
            return false;
        }
        try {
            Statement s = this.cntx.createStatement();
            ResultSet rs = s.executeQuery("SELECT * FROM " + this.tb_prefix + "WORLDS WHERE name='" + world.getName() + "'");
            while (rs.next()) {
                Long resultLong;
                ArrayList<String> mats2;
                String search;
                line = rs.getString("towns");
                if (line != null) {
                    String[] tokens;
                    search = line.contains("#") ? "#" : ",";
                    for (String token : tokens = line.split(search)) {
                        Town town;
                        if (token.isEmpty() || (town = this.getTown(token)) == null) continue;
                        town.setWorld(world);
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("claimable"))) != null) {
                    try {
                        world.setClaimable(result);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("pvp"))) != null) {
                    try {
                        world.setPVP(result);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("forcepvp"))) != null) {
                    try {
                        world.setForcePVP(result);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("forcetownmobs"))) != null) {
                    try {
                        world.setForceTownMobs(result);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("worldmobs"))) != null) {
                    try {
                        world.setWorldMobs(result);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("firespread"))) != null) {
                    try {
                        world.setFire(result);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("forcefirespread"))) != null) {
                    try {
                        world.setForceFire(result);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("explosions"))) != null) {
                    try {
                        world.setExpl(result);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("forceexplosions"))) != null) {
                    try {
                        world.setForceExpl(result);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("endermanprotect"))) != null) {
                    try {
                        world.setEndermanProtect(result);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("disableplayertrample"))) != null) {
                    try {
                        world.setDisablePlayerTrample(result);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("disablecreaturetrample"))) != null) {
                    try {
                        world.setDisableCreatureTrample(result);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("unclaimedZoneBuild"))) != null) {
                    try {
                        world.setUnclaimedZoneBuild(result);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("unclaimedZoneDestroy"))) != null) {
                    try {
                        world.setUnclaimedZoneDestroy(result);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("unclaimedZoneSwitch"))) != null) {
                    try {
                        world.setUnclaimedZoneSwitch(result);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("unclaimedZoneItemUse"))) != null) {
                    try {
                        world.setUnclaimedZoneItemUse(result);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                line = rs.getString("unclaimedZoneName");
                if (result != null) {
                    try {
                        world.setUnclaimedZoneName(line);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = rs.getString("unclaimedZoneIgnoreIds")) != null) {
                    try {
                        mats2 = new ArrayList<String>();
                        search = line.contains("#") ? "#" : ",";
                        for (String split : line.split(search)) {
                            if (split.isEmpty()) continue;
                            try {
                                int id = Integer.parseInt(split);
                                mats2.add(BukkitTools.getMaterial(id).name());
                            }
                            catch (NumberFormatException e) {
                                mats2.add(split);
                            }
                        }
                        world.setUnclaimedZoneIgnore(mats2);
                    }
                    catch (Exception mats2) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("usingPlotManagementDelete"))) != null) {
                    try {
                        world.setUsingPlotManagementDelete(result);
                    }
                    catch (Exception mats2) {
                        // empty catch block
                    }
                }
                if ((line = rs.getString("plotManagementDeleteIds")) != null) {
                    try {
                        mats2 = new ArrayList();
                        search = line.contains("#") ? "#" : ",";
                        for (String split : line.split(search)) {
                            if (split.isEmpty()) continue;
                            try {
                                int id = Integer.parseInt(split);
                                mats2.add(BukkitTools.getMaterial(id).name());
                            }
                            catch (NumberFormatException e) {
                                mats2.add(split);
                            }
                        }
                        world.setPlotManagementDeleteIds(mats2);
                    }
                    catch (Exception mats3) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("usingPlotManagementMayorDelete"))) != null) {
                    try {
                        world.setUsingPlotManagementMayorDelete(result);
                    }
                    catch (Exception mats3) {
                        // empty catch block
                    }
                }
                if ((line = rs.getString("plotManagementMayorDelete")) != null) {
                    try {
                        ArrayList<String> materials = new ArrayList<String>();
                        search = line.contains("#") ? "#" : ",";
                        for (String split : line.split(search)) {
                            if (split.isEmpty()) continue;
                            try {
                                materials.add(split.toUpperCase().trim());
                            }
                            catch (NumberFormatException e) {
                                // empty catch block
                            }
                        }
                        world.setPlotManagementMayorDelete(materials);
                    }
                    catch (Exception materials) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("usingPlotManagementRevert"))) != null) {
                    try {
                        world.setUsingPlotManagementRevert(result);
                    }
                    catch (Exception materials) {
                        // empty catch block
                    }
                }
                if ((resultLong = Long.valueOf(rs.getLong("PlotManagementRevertSpeed"))) != null) {
                    try {
                        world.setPlotManagementRevertSpeed(resultLong);
                    }
                    catch (Exception materials) {
                        // empty catch block
                    }
                }
                if ((line = rs.getString("plotManagementIgnoreIds")) != null) {
                    try {
                        mats2 = new ArrayList();
                        search = line.contains("#") ? "#" : ",";
                        for (String split : line.split(search)) {
                            if (split.isEmpty()) continue;
                            try {
                                int id = Integer.parseInt(split);
                                mats2.add(BukkitTools.getMaterial(id).name());
                            }
                            catch (NumberFormatException e) {
                                mats2.add(split);
                            }
                        }
                        world.setPlotManagementIgnoreIds(mats2);
                    }
                    catch (Exception mats4) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("usingPlotManagementWildRegen"))) != null) {
                    try {
                        world.setUsingPlotManagementWildRevert(result);
                    }
                    catch (Exception mats4) {
                        // empty catch block
                    }
                }
                if ((line = rs.getString("plotManagementWildRegenEntities")) != null) {
                    try {
                        ArrayList<String> entities = new ArrayList<String>();
                        search = line.contains("#") ? "#" : ",";
                        for (String split : line.split(search)) {
                            if (split.isEmpty()) continue;
                            try {
                                entities.add(split.trim());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        world.setPlotManagementWildRevertEntities(entities);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((resultLong = Long.valueOf(rs.getLong("plotManagementWildRegenSpeed"))) != null) {
                    try {
                        world.setPlotManagementWildRevertDelay(resultLong);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("usingTowny"))) == null) continue;
                try {
                    world.setUsingTowny(result);
                }
                catch (Exception exception) {}
            }
            s.close();
            return true;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Load world sql error (" + world.getName() + ")" + e.getMessage());
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Load world unknown error - ");
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean loadTownBlocks() {
        String line = "";
        Boolean result = false;
        TownyMessaging.sendDebugMsg("Loading Town Blocks.");
        if (!this.getContext()) {
            return false;
        }
        for (TownBlock townBlock : this.getAllTownBlocks()) {
            try {
                Statement s = this.cntx.createStatement();
                ResultSet rs = s.executeQuery("SELECT * FROM " + this.tb_prefix + "TOWNBLOCKS WHERE world='" + townBlock.getWorld().getName() + "' AND x='" + townBlock.getX() + "' AND z='" + townBlock.getZ() + "'");
                while (rs.next()) {
                    line = rs.getString("name");
                    if (line != null) {
                        try {
                            townBlock.setName(line.trim());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if ((line = rs.getString("price")) != null) {
                        try {
                            townBlock.setPlotPrice(Float.parseFloat(line.trim()));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if ((line = rs.getString("town")) != null) {
                        try {
                            Town town = this.getTown(line.trim());
                            townBlock.setTown(town);
                        }
                        catch (Exception town) {
                            // empty catch block
                        }
                    }
                    if ((line = rs.getString("resident")) != null && !line.isEmpty()) {
                        try {
                            Resident res = this.getResident(line.trim());
                            townBlock.setResident(res);
                        }
                        catch (Exception res) {
                            // empty catch block
                        }
                    }
                    if ((line = rs.getString("type")) != null) {
                        try {
                            townBlock.setType(Integer.parseInt(line));
                        }
                        catch (Exception res) {
                            // empty catch block
                        }
                    }
                    boolean outpost = rs.getBoolean("outpost");
                    if (line != null) {
                        try {
                            townBlock.setOutpost(outpost);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if ((line = rs.getString("permissions")) != null && !line.isEmpty()) {
                        try {
                            townBlock.setPermissions(line.trim().replaceAll("#", ","));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if ((result = Boolean.valueOf(rs.getBoolean("changed"))) != null) {
                        try {
                            townBlock.setChanged(result);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if ((result = Boolean.valueOf(rs.getBoolean("locked"))) == null) continue;
                    try {
                        townBlock.setLocked(result);
                    }
                    catch (Exception exception) {}
                }
                s.close();
            }
            catch (SQLException e) {
                TownyMessaging.sendErrorMsg("Loading Error: Exception while reading TownBlock: " + townBlock + " at line: " + line + " in the sql database");
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized boolean saveResident(Resident resident) {
        TownyMessaging.sendDebugMsg("Saving Resident");
        try {
            HashMap<String, Object> res_hm = new HashMap<String, Object>();
            res_hm.put("name", resident.getName());
            res_hm.put("lastOnline", resident.getLastOnline());
            res_hm.put("registered", resident.getRegistered());
            res_hm.put("isNPC", resident.isNPC());
            res_hm.put("isJailed", resident.isJailed());
            res_hm.put("JailSpawn", resident.getJailSpawn());
            res_hm.put("JailTown", resident.getJailTown());
            res_hm.put("title", resident.getTitle());
            res_hm.put("surname", resident.getSurname());
            res_hm.put("town", resident.hasTown() ? resident.getTown().getName() : "");
            res_hm.put("town-ranks", resident.hasTown() ? StringMgmt.join(resident.getTownRanks(), "#") : "");
            res_hm.put("nation-ranks", resident.hasTown() ? StringMgmt.join(resident.getNationRanks(), "#") : "");
            res_hm.put("friends", StringMgmt.join(resident.getFriends(), "#"));
            res_hm.put("protectionStatus", resident.getPermissions().toString().replaceAll(",", "#"));
            this.UpdateDB("RESIDENTS", res_hm, Arrays.asList("name"));
            return true;
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Save Resident unknown error " + e.getMessage());
            return false;
        }
    }

    @Override
    public synchronized boolean saveTown(Town town) {
        TownyMessaging.sendDebugMsg("Saving town " + town.getName());
        try {
            HashMap<String, Object> twn_hm = new HashMap<String, Object>();
            twn_hm.put("name", town.getName());
            twn_hm.put("residents", StringMgmt.join(town.getResidents(), "#"));
            twn_hm.put("outlaws", StringMgmt.join(town.getOutlaws(), "#"));
            twn_hm.put("mayor", town.hasMayor() ? town.getMayor().getName() : "");
            twn_hm.put("nation", town.hasNation() ? town.getNation().getName() : "");
            twn_hm.put("assistants", StringMgmt.join(town.getAssistants(), "#"));
            twn_hm.put("townBoard", town.getTownBoard());
            twn_hm.put("tag", town.getTag());
            twn_hm.put("protectionStatus", town.getPermissions().toString().replaceAll(",", "#"));
            twn_hm.put("bonus", town.getBonusBlocks());
            twn_hm.put("purchased", town.getPurchasedBlocks());
            twn_hm.put("commercialPlotPrice", town.getCommercialPlotPrice());
            twn_hm.put("commercialPlotTax", town.getCommercialPlotTax());
            twn_hm.put("embassyPlotPrice", town.getEmbassyPlotPrice());
            twn_hm.put("embassyPlotTax", town.getEmbassyPlotTax());
            twn_hm.put("spawnCost", town.getSpawnCost());
            twn_hm.put("plotPrice", town.getPlotPrice());
            twn_hm.put("plotTax", town.getPlotTax());
            twn_hm.put("taxes", town.getTaxes());
            twn_hm.put("hasUpkeep", town.hasUpkeep());
            twn_hm.put("taxpercent", town.isTaxPercentage());
            twn_hm.put("open", town.isOpen());
            twn_hm.put("public", town.isPublic());
            twn_hm.put("admindisabledpvp", town.isAdminDisabledPVP());
            twn_hm.put("homeblock", town.hasHomeBlock() ? town.getHomeBlock().getWorld().getName() + "#" + Integer.toString(town.getHomeBlock().getX()) + "#" + Integer.toString(town.getHomeBlock().getZ()) : "");
            twn_hm.put("spawn", town.hasSpawn() ? town.getSpawn().getWorld().getName() + "#" + Double.toString(town.getSpawn().getX()) + "#" + Double.toString(town.getSpawn().getY()) + "#" + Double.toString(town.getSpawn().getZ()) + "#" + Float.toString(town.getSpawn().getPitch()) + "#" + Float.toString(town.getSpawn().getYaw()) : "");
            String outpostArray = "";
            if (town.hasOutpostSpawn()) {
                for (Location location : new ArrayList<Location>(town.getAllOutpostSpawns())) {
                    outpostArray = outpostArray + location.getWorld().getName() + "#" + Double.toString(location.getX()) + "#" + Double.toString(location.getY()) + "#" + Double.toString(location.getZ()) + "#" + Float.toString(location.getPitch()) + "#" + Float.toString(location.getYaw()) + ";";
                }
            }
            twn_hm.put("outpostSpawns", outpostArray);
            String jailArray = "";
            if (town.hasJailSpawn()) {
                for (Location spawn : new ArrayList<Location>(town.getAllJailSpawns())) {
                    jailArray = jailArray + spawn.getWorld().getName() + "#" + Double.toString(spawn.getX()) + "#" + Double.toString(spawn.getY()) + "#" + Double.toString(spawn.getZ()) + "#" + Float.toString(spawn.getPitch()) + "#" + Float.toString(spawn.getYaw()) + ";";
                }
            }
            twn_hm.put("jailSpawns", jailArray);
            if (town.hasValidUUID()) {
                twn_hm.put("uuid", town.getUuid());
            } else {
                twn_hm.put("uuid", UUID.randomUUID());
            }
            Long l = town.getRegistered();
            if (l != null) {
                twn_hm.put("registered", town.getRegistered());
            } else {
                twn_hm.put("registered", 0);
            }
            this.UpdateDB("TOWNS", twn_hm, Arrays.asList("name"));
            return true;
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Save Town unknown error");
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public synchronized boolean saveNation(Nation nation) {
        TownyMessaging.sendDebugMsg("Saving nation " + nation.getName());
        try {
            HashMap<String, Object> nat_hm = new HashMap<String, Object>();
            nat_hm.put("name", nation.getName());
            nat_hm.put("towns", StringMgmt.join(nation.getTowns(), "#"));
            nat_hm.put("capital", nation.hasCapital() ? nation.getCapital().getName() : "");
            nat_hm.put("nationBoard", nation.getNationBoard());
            nat_hm.put("tag", nation.hasTag() ? nation.getTag() : "");
            nat_hm.put("assistants", StringMgmt.join(nation.getAssistants(), "#"));
            nat_hm.put("allies", StringMgmt.join(nation.getAllies(), "#"));
            nat_hm.put("enemies", StringMgmt.join(nation.getEnemies(), "#"));
            nat_hm.put("taxes", nation.getTaxes());
            nat_hm.put("spawnCost", nation.getSpawnCost());
            nat_hm.put("neutral", nation.isNeutral());
            nat_hm.put("nationSpawn", nation.hasNationSpawn() ? nation.getNationSpawn().getWorld().getName() + "#" + Double.toString(nation.getNationSpawn().getX()) + "#" + Double.toString(nation.getNationSpawn().getY()) + "#" + Double.toString(nation.getNationSpawn().getZ()) + "#" + Float.toString(nation.getNationSpawn().getPitch()) + "#" + Float.toString(nation.getNationSpawn().getYaw()) : "");
            if (nation.hasValidUUID()) {
                nat_hm.put("uuid", nation.getUuid());
            } else {
                nat_hm.put("uuid", UUID.randomUUID());
            }
            Long value = nation.getRegistered();
            if (value != null) {
                nat_hm.put("registered", nation.getRegistered());
            } else {
                nat_hm.put("registered", 0);
            }
            nat_hm.put("isPublic", nation.isPublic());
            this.UpdateDB("NATIONS", nat_hm, Arrays.asList("name"));
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Save Nation unknown error");
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public synchronized boolean saveWorld(TownyWorld world) {
        TownyMessaging.sendDebugMsg("Saving world " + world.getName());
        try {
            HashMap<String, Object> nat_hm = new HashMap<String, Object>();
            nat_hm.put("name", world.getName());
            nat_hm.put("towns", StringMgmt.join(world.getTowns(), "#"));
            nat_hm.put("pvp", world.isPVP());
            nat_hm.put("forcepvp", world.isForcePVP());
            nat_hm.put("claimable", world.isClaimable());
            nat_hm.put("worldmobs", world.hasWorldMobs());
            nat_hm.put("forcetownmobs", world.isForceTownMobs());
            nat_hm.put("firespread", world.isFire());
            nat_hm.put("forcefirespread", world.isForceFire());
            nat_hm.put("explosions", world.isExpl());
            nat_hm.put("forceexplosions", world.isForceExpl());
            nat_hm.put("endermanprotect", world.isEndermanProtect());
            nat_hm.put("disableplayertrample", world.isDisablePlayerTrample());
            nat_hm.put("disablecreaturetrample", world.isDisableCreatureTrample());
            nat_hm.put("unclaimedZoneBuild", world.getUnclaimedZoneBuild());
            nat_hm.put("unclaimedZoneDestroy", world.getUnclaimedZoneDestroy());
            nat_hm.put("unclaimedZoneSwitch", world.getUnclaimedZoneSwitch());
            nat_hm.put("unclaimedZoneItemUse", world.getUnclaimedZoneItemUse());
            if (world.getUnclaimedZoneName() != null) {
                nat_hm.put("unclaimedZoneName", world.getUnclaimedZoneName());
            }
            if (world.getUnclaimedZoneIgnoreMaterials() != null) {
                nat_hm.put("unclaimedZoneIgnoreIds", StringMgmt.join(world.getUnclaimedZoneIgnoreMaterials(), "#"));
            }
            nat_hm.put("usingPlotManagementDelete", world.isUsingPlotManagementDelete());
            if (world.getPlotManagementDeleteIds() != null) {
                nat_hm.put("plotManagementDeleteIds", StringMgmt.join(world.getPlotManagementDeleteIds(), "#"));
            }
            nat_hm.put("usingPlotManagementMayorDelete", world.isUsingPlotManagementMayorDelete());
            if (world.getPlotManagementMayorDelete() != null) {
                nat_hm.put("plotManagementMayorDelete", StringMgmt.join(world.getPlotManagementMayorDelete(), "#"));
            }
            nat_hm.put("usingPlotManagementRevert", world.isUsingPlotManagementRevert());
            nat_hm.put("plotManagementRevertSpeed", world.getPlotManagementRevertSpeed());
            if (world.getPlotManagementIgnoreIds() != null) {
                nat_hm.put("plotManagementIgnoreIds", StringMgmt.join(world.getPlotManagementIgnoreIds(), "#"));
            }
            nat_hm.put("usingPlotManagementWildRegen", world.isUsingPlotManagementWildRevert());
            if (world.getPlotManagementWildRevertEntities() != null) {
                nat_hm.put("PlotManagementWildRegenEntities", StringMgmt.join(world.getPlotManagementWildRevertEntities(), "#"));
            }
            nat_hm.put("plotManagementWildRegenSpeed", world.getPlotManagementWildRevertDelay());
            nat_hm.put("usingTowny", world.isUsingTowny());
            this.UpdateDB("WORLDS", nat_hm, Arrays.asList("name"));
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Save world unknown error (" + world.getName() + ")");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean saveTownBlock(TownBlock townBlock) {
        TownyMessaging.sendDebugMsg("Saving town block " + townBlock.getWorld().getName() + ":" + townBlock.getX() + "x" + townBlock.getZ());
        try {
            HashMap<String, Object> tb_hm = new HashMap<String, Object>();
            tb_hm.put("world", townBlock.getWorld().getName());
            tb_hm.put("x", townBlock.getX());
            tb_hm.put("z", townBlock.getZ());
            tb_hm.put("name", townBlock.getName());
            tb_hm.put("price", townBlock.getPlotPrice());
            tb_hm.put("town", townBlock.getTown().getName());
            tb_hm.put("resident", townBlock.hasResident() ? townBlock.getResident().getName() : "");
            tb_hm.put("type", townBlock.getType().getId());
            tb_hm.put("outpost", townBlock.isOutpost());
            tb_hm.put("permissions", townBlock.isChanged() ? townBlock.getPermissions().toString().replaceAll(",", "#") : "");
            tb_hm.put("locked", townBlock.isLocked());
            tb_hm.put("changed", townBlock.isChanged());
            this.UpdateDB("TOWNBLOCKS", tb_hm, Arrays.asList("world", "x", "z"));
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Save TownBlock unknown error");
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public void deleteResident(Resident resident) {
        HashMap<String, Object> res_hm = new HashMap<String, Object>();
        res_hm.put("name", resident.getName());
        this.DeleteDB("RESIDENTS", res_hm);
    }

    @Override
    public void deleteTown(Town town) {
        HashMap<String, Object> twn_hm = new HashMap<String, Object>();
        twn_hm.put("name", town.getName());
        this.DeleteDB("TOWNS", twn_hm);
    }

    @Override
    public void deleteNation(Nation nation) {
        HashMap<String, Object> nat_hm = new HashMap<String, Object>();
        nat_hm.put("name", nation.getName());
        this.DeleteDB("NATIONS", nat_hm);
    }

    @Override
    public void deleteTownBlock(TownBlock townBlock) {
        HashMap<String, Object> twn_hm = new HashMap<String, Object>();
        twn_hm.put("world", townBlock.getWorld().getName());
        twn_hm.put("x", townBlock.getX());
        twn_hm.put("z", townBlock.getZ());
        this.DeleteDB("TOWNBLOCKS", twn_hm);
    }

    @Override
    public synchronized void backup() throws IOException {
        TownyMessaging.sendMsg("Performing backup");
        TownyMessaging.sendMsg("***** Warning *****");
        TownyMessaging.sendMsg("***** Only Snapshots and Regen files will be backed up");
        TownyMessaging.sendMsg("***** Make sure you schedule a backup in MySQL too!!!");
        String backupType = TownySettings.getFlatFileBackupType();
        if (!backupType.equalsIgnoreCase("none")) {
            TownyLogger.shutDown();
            long t = System.currentTimeMillis();
            String newBackupFolder = this.rootFolder + FileMgmt.fileSeparator() + "backup" + FileMgmt.fileSeparator() + new SimpleDateFormat("yyyy-MM-dd HH-mm").format(t) + " - " + Long.toString(t);
            FileMgmt.checkFolders(new String[]{this.rootFolder, this.rootFolder + FileMgmt.fileSeparator() + "backup"});
            if (backupType.equalsIgnoreCase("folder")) {
                FileMgmt.checkFolders(new String[]{newBackupFolder});
                FileMgmt.copyDirectory(new File(this.rootFolder + this.dataFolder), new File(newBackupFolder));
                FileMgmt.copyDirectory(new File(this.rootFolder + this.logFolder), new File(newBackupFolder));
                FileMgmt.copyDirectory(new File(this.rootFolder + this.settingsFolder), new File(newBackupFolder));
            } else if (backupType.equalsIgnoreCase("zip")) {
                FileMgmt.zipDirectories(new File[]{new File(this.rootFolder + this.dataFolder), new File(this.rootFolder + this.logFolder), new File(this.rootFolder + this.settingsFolder)}, new File(newBackupFolder + ".zip"));
            } else {
                this.plugin.setupLogger();
                throw new IOException("[Towny] Unsupported flatfile backup type (" + backupType + ")");
            }
            this.plugin.setupLogger();
        }
    }

    @Override
    public boolean cleanup() {
        if (!this.getContext()) {
            return false;
        }
        SQL_Schema.cleanup(this.cntx, this.db_name);
        return true;
    }

    @Override
    public boolean saveTownBlockList() {
        return true;
    }

    @Override
    public boolean saveResidentList() {
        return true;
    }

    @Override
    public boolean saveTownList() {
        return true;
    }

    @Override
    public boolean saveNationList() {
        return true;
    }

    @Override
    public boolean saveWorldList() {
        return true;
    }

    public static void validateTownOutposts(Town town) {
        ArrayList<Location> validoutpostspawns = new ArrayList<Location>();
        if (town != null && town.hasOutpostSpawn()) {
            for (Location outpostSpawn : town.getAllOutpostSpawns()) {
                TownBlock outpostSpawnTB = TownyUniverse.getTownBlock(outpostSpawn);
                if (outpostSpawnTB == null) continue;
                validoutpostspawns.add(outpostSpawn);
            }
            town.setOutpostSpawns(validoutpostspawns);
        }
    }
}

