/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.confirmations;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.confirmations.ConfirmationType;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.tasks.ResidentPurge;
import com.palmergames.bukkit.towny.tasks.TownClaim;
import com.palmergames.util.TimeTools;
import java.util.HashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ConfirmationHandler {
    private static Towny plugin;
    private static HashMap<Resident, Town> towndeleteconfirmations;
    private static HashMap<Resident, Town> townunclaimallconfirmations;
    private static HashMap<Resident, Nation> nationdeleteconfirmations;
    private static HashMap<Resident, Integer> townypurgeconfirmations;

    public static void initialize(Towny plugin) {
        ConfirmationHandler.plugin = plugin;
    }

    public static void addConfirmation(final Resident r, final ConfirmationType type, Object extra) throws TownyException {
        if (type == ConfirmationType.TOWNDELETE) {
            r.setConfirmationType(type);
            towndeleteconfirmations.put(r, r.getTown());
            new BukkitRunnable(){

                public void run() {
                    ConfirmationHandler.removeConfirmation(r, type, false);
                }
            }.runTaskLater((Plugin)plugin, 400L);
        }
        if (type == ConfirmationType.PURGE) {
            r.setConfirmationType(type);
            townypurgeconfirmations.put(r, (Integer)extra);
            new BukkitRunnable(){

                public void run() {
                    ConfirmationHandler.removeConfirmation(r, type, false);
                }
            }.runTaskLater((Plugin)plugin, 400L);
        }
        if (type == ConfirmationType.UNCLAIMALL) {
            r.setConfirmationType(type);
            townunclaimallconfirmations.put(r, r.getTown());
            new BukkitRunnable(){

                public void run() {
                    ConfirmationHandler.removeConfirmation(r, type, false);
                }
            }.runTaskLater((Plugin)plugin, 400L);
        }
        if (type == ConfirmationType.NATIONDELETE) {
            r.setConfirmationType(type);
            nationdeleteconfirmations.put(r, r.getTown().getNation());
            new BukkitRunnable(){

                public void run() {
                    ConfirmationHandler.removeConfirmation(r, type, false);
                }
            }.runTaskLater((Plugin)plugin, 400L);
        }
    }

    public static void removeConfirmation(Resident r, ConfirmationType type, boolean successful) {
        boolean sendmessage = false;
        if (type == ConfirmationType.TOWNDELETE) {
            if (towndeleteconfirmations.containsKey(r) && !successful) {
                sendmessage = true;
            }
            towndeleteconfirmations.remove(r);
            r.setConfirmationType(null);
        }
        if (type == ConfirmationType.PURGE) {
            if (townypurgeconfirmations.containsKey(r) && !successful) {
                sendmessage = true;
            }
            townypurgeconfirmations.remove(r);
            r.setConfirmationType(null);
        }
        if (type == ConfirmationType.UNCLAIMALL) {
            if (townunclaimallconfirmations.containsKey(r) && !successful) {
                sendmessage = true;
            }
            townunclaimallconfirmations.remove(r);
            r.setConfirmationType(null);
        }
        if (type == ConfirmationType.NATIONDELETE) {
            if (nationdeleteconfirmations.containsKey(r) && !successful) {
                sendmessage = true;
            }
            nationdeleteconfirmations.remove(r);
            r.setConfirmationType(null);
        }
        if (sendmessage) {
            TownyMessaging.sendMsg(r, TownySettings.getLangString("successful_cancel"));
        }
    }

    public static void handleConfirmation(Resident r, ConfirmationType type) throws TownyException {
        if (type == ConfirmationType.TOWNDELETE && towndeleteconfirmations.containsKey(r) && towndeleteconfirmations.get(r).equals(r.getTown())) {
            TownyMessaging.sendGlobalMessage(TownySettings.getDelTownMsg(towndeleteconfirmations.get(r)));
            TownyUniverse.getDataSource().removeTown(towndeleteconfirmations.get(r));
            ConfirmationHandler.removeConfirmation(r, type, true);
            return;
        }
        if (type == ConfirmationType.PURGE && townypurgeconfirmations.containsKey(r)) {
            if (!TownyUniverse.getPermissionSource().testPermission(TownyUniverse.getPlayer(r), PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_PURGE.getNode())) {
                throw new TownyException(TownySettings.getLangString("msg_err_admin_only"));
            }
            int days = townypurgeconfirmations.get(r);
            Player player = TownyUniverse.getPlayer(r);
            new ResidentPurge(plugin, (CommandSender)player, TimeTools.getMillis(days + "d")).start();
            ConfirmationHandler.removeConfirmation(r, type, true);
        }
        if (type == ConfirmationType.UNCLAIMALL && townunclaimallconfirmations.containsKey(r) && townunclaimallconfirmations.get(r).equals(r.getTown())) {
            TownClaim.townUnclaimAll(plugin, townunclaimallconfirmations.get(r));
            ConfirmationHandler.removeConfirmation(r, type, true);
            return;
        }
        if (type == ConfirmationType.NATIONDELETE && nationdeleteconfirmations.containsKey(r) && nationdeleteconfirmations.get(r).equals(r.getTown().getNation())) {
            TownyUniverse.getDataSource().removeNation(nationdeleteconfirmations.get(r));
            TownyMessaging.sendGlobalMessage(TownySettings.getDelNationMsg(nationdeleteconfirmations.get(r)));
            ConfirmationHandler.removeConfirmation(r, type, true);
            return;
        }
    }

    static {
        towndeleteconfirmations = new HashMap();
        townunclaimallconfirmations = new HashMap();
        nationdeleteconfirmations = new HashMap();
        townypurgeconfirmations = new HashMap();
    }
}

