/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command.commandobjects;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.confirmations.ConfirmationHandler;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.entity.Player;

public class CancelCommand
extends BukkitCommand {
    public CancelCommand(String name) {
        super(name);
        this.description = "Cancel command for Towny";
        this.usageMessage = "/" + name;
    }

    public boolean execute(CommandSender commandSender, String s, String[] strings) {
        if (commandSender instanceof Player) {
            Resident resident;
            Player player = (Player)commandSender;
            try {
                resident = TownyUniverse.getDataSource().getResident(player.getName());
            }
            catch (TownyException e) {
                return true;
            }
            if (resident != null) {
                if (resident.getConfirmationType() != null) {
                    ConfirmationHandler.removeConfirmation(resident, resident.getConfirmationType(), false);
                    return true;
                }
                TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("no_confirmations_open"));
                return true;
            }
        }
        return true;
    }
}

